/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\b\u0010\u0001QAQa\u0007\u0001\u0005\u0002qAQa\b\u0001\u0005R\u0001Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u00042\u0001\u0001\u0006I!\u000b\u0005\be\u0001\u0011\r\u0011\"\u0003!\u0011\u0019\u0019\u0004\u0001)A\u0005C!9A\u0007\u0001b\u0001\n\u0013\u0001\u0003BB\u001b\u0001A\u0003%\u0011\u0005C\u00047\u0001\t\u0007I\u0011B\u001c\t\r\t\u0003\u0001\u0015!\u00039\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015y\u0006\u0001\"\u0001a\u0005\u0001\"\u0016.\u001a:U_BL7\rR3mKRLwN\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005A\t\u0012\u0001\u0002;jKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqC\u0003\u0002\u0019#\u0005\u0019\u0011\r]5\n\u0005i9\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005y\u0011a\u00032s_.,'oQ8v]R,\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0004\u0013:$\u0018!\u0002;pa&\u001cW#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u00179,XNU3qY&\u001c\u0017m]\u0001\r]Vl'+\u001a9mS\u000e\f7\u000fI\u0001\u0007KbLG/\u001a3\u0016\u0003a\u0002\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\r\u0005$x.\\5d\u0015\tid(\u0001\u0006d_:\u001cWO\u001d:f]RT!aP\u0017\u0002\tU$\u0018\u000e\\\u0005\u0003\u0003j\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u000b\"\u0003\"A\t$\n\u0005\u001d\u001b#\u0001B+oSRDQ!S\u0006A\u0002)\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003\u0017Nk\u0011\u0001\u0014\u0006\u000315S!AT(\u0002\u000f),\b/\u001b;fe*\u0011\u0001+U\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002%\u0006\u0019qN]4\n\u0005Qc%\u0001\u0003+fgRLeNZ8)\u0005-1\u0006CA&X\u0013\tAFJ\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u000b\"\u0012A\u0002\u0018\t\u0003\u0017vK!A\u0018'\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0005;fgR$v\u000e]5d\t\u0016dW\r^5p]R\u0011Q)\u0019\u0005\u0006E6\u0001\raY\u0001\u0007cV|'/^7\u0011\u0005\u0011\\gBA3j!\t17%D\u0001h\u0015\tA7#\u0001\u0004=e>|GOP\u0005\u0003U\u000e\na\u0001\u0015:fI\u00164\u0017B\u0001\u0019m\u0015\tQ7\u0005\u000b\u0003\u000e]Z<\bCA8u\u001b\u0005\u0001(BA9s\u0003!\u0001(o\u001c<jI\u0016\u0014(BA:N\u0003\u0019\u0001\u0018M]1ng&\u0011Q\u000f\u001d\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005aT\u0018%A=\u0002\u0005i\\\u0017%A>\u0002\u000b-\u0014\u0018M\u001a;)\r5i\u00181AA\u0003!\tqx0D\u0001s\u0013\r\t\tA\u001d\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!a\u0002\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T\u0010")
public class TierTopicDeletionIntegrationTest
extends IntegrationTestHarness {
    private final String topic;
    private final int numPartitions;
    private final int numReplicas;
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public int brokerCount() {
        return 3;
    }

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int numReplicas() {
        return this.numReplicas;
    }

    private AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.createTopic(this.topic(), this.numPartitions(), this.numReplicas(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)i -> TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$1(this, BoxesRunTime.unboxToInt((Object)i)));
        int recordSize = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records.head()).key())) + ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records.head()).value()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        for (int bytesSent = 0; bytesSent < 200; bytesSent += recordSize) {
            records.foreach((Function1 & Serializable)record -> (RecordMetadata)producer.send(record).get());
        }
        MockInMemoryTierObjectStore mockObjectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        ObjectRef topicId = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TopicPartition topicPartition = new TopicPartition(this.topic(), i);
            int leaderBrokerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$4(i, x$3))).get()).leader().id();
            LogManager qual$1 = ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$5(leaderBrokerId, x$4))).get()).logManager();
            boolean x$2 = qual$1.getLog$default$2();
            TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(topicPartition, x$2).get()).tierPartitionState();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$6(tierPartitionState)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for segments to be tiered");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$8(tierPartitionState)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for tier partition state to be flushed");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            topicId$1.elem = CoreUtils$.MODULE$.uuidToBase64(((TopicIdPartition)tierPartitionState.topicIdPartition().get()).topicId());
        });
        Assertions.assertTrue((CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore.getStoredKeys()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((String)topicId$1.elem))) >= this.numPartitions() ? 1 : 0) != 0);
        this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()).deleteTopics(Collections.singleton(this.topic())).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 20000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore.getStoredKeys()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((String)topicId$1.elem))) == 0)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for all objects to be deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testTopicDeletion$1(TierTopicDeletionIntegrationTest $this, int i) {
        return new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(i), (Object)"key".getBytes(), (Object)"value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$4(int i$1, PartitionInfo x$3) {
        return x$3.partition() == i$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$5(int leaderBrokerId$1, KafkaBroker x$4) {
        return x$4.config().brokerId() == leaderBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$6(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$7() {
        return "Timed out waiting for segments to be tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$8(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.committedEndOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$9() {
        return "Timed out waiting for tier partition state to be flushed";
    }

    private static final int numObjects$1(MockInMemoryTierObjectStore mockObjectStore$1, ObjectRef topicId$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore$1.getStoredKeys()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((String)topicId$1.elem)));
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$11(MockInMemoryTierObjectStore mockObjectStore$1, ObjectRef topicId$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore$1.getStoredKeys()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((String)topicId$1.elem))) == 0;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$12() {
        return "Timed out waiting for all objects to be deleted";
    }

    public TierTopicDeletionIntegrationTest() {
        this.topic = "foo";
        this.numPartitions = 4;
        this.numReplicas = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicDeleteBackoffMsProp(), "15000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "10000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        Predef$.MODULE$.locally(this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10"));
    }
}

