/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.storage.blob.models.BlobStorageException;
import com.google.cloud.storage.StorageException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupObjectLifecycle.ObjectStoreUtils;
import kafka.tier.backupObjectLifecycle.ObjectStoreUtilsContext;
import kafka.tier.backupObjectLifecycle.RetryPolicy;
import kafka.tier.backupObjectLifecycle.TierObjectStoreBatchOperationException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u0015*\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0011\u0019a\u0005\u0001)A\u0005\u0011\"9Q\n\u0001b\u0001\n\u0003q\u0005BB-\u0001A\u0003%q\nC\u0004[\u0001\t\u0007I\u0011A.\t\r}\u0003\u0001\u0015!\u0003]\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005Da\u0001\u001d\u0001!\u0002\u0013\u0011\u0007bB9\u0001\u0005\u0004%\tA\u001d\u0005\u0007s\u0002\u0001\u000b\u0011B:\t\u000fi\u0004!\u0019!C\u0001w\"9\u00111\u0003\u0001!\u0002\u0013a\b\"CA\u000b\u0001\t\u0007I\u0011AA\f\u0011!\ty\u0002\u0001Q\u0001\n\u0005e\u0001\"CA\u0011\u0001\t\u0007I\u0011AA\u0012\u0011!\tY\u0003\u0001Q\u0001\n\u0005\u0015\u0002\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0011!\t9\u0004\u0001Q\u0001\n\u0005E\u0002\"CA\u001d\u0001\u0001\u0007I\u0011AA\u001e\u0011%\tI\u0005\u0001a\u0001\n\u0003\tY\u0005\u0003\u0005\u0002X\u0001\u0001\u000b\u0015BA\u001f\u0011%\tI\u0006\u0001b\u0001\n\u0003\tY\u0006\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA/\u0011!\t9\b\u0001b\u0001\n\u0003\t\u0007bBA=\u0001\u0001\u0006IA\u0019\u0005\n\u0003w\u0002!\u0019!C\u0001\u0003{B\u0001\"!\"\u0001A\u0003%\u0011q\u0010\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t)\u000b\u0001C\u0001\u0003\u0013Cq!!+\u0001\t\u0003\tI\tC\u0004\u0002.\u0002!\t!!#\t\u000f\u0005E\u0006\u0001\"\u0001\u0002\n\"9\u0011Q\u0017\u0001\u0005\u0002\u0005%\u0005bBA]\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003{\u0003A\u0011AAE\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0013\u0013Ac\u00142kK\u000e$8\u000b^8sKV#\u0018\u000e\\:UKN$(B\u0001\u0016,\u0003U\u0011\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016T!\u0001L\u0017\u0002\tQLWM\u001d\u0006\u0002]\u0005)1.\u00194lC\u000e\u00011C\u0001\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011!K\u0001\u0005kVLG-F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003vi&d'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012A!V+J\t\u0006)Q/^5eA\u0005!A\u000f]%e+\u0005A\u0005CA%K\u001b\u0005Y\u0013BA&,\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\u0003ua&#\u0007%\u0001\u0005nKR\fG-\u0019;b+\u0005y\u0005C\u0001)W\u001d\t\tF+D\u0001S\u0015\t\u00196&A\u0003ti>\u0014X-\u0003\u0002V%\u0006yA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0003\u0002X1\niB*\u001b4fGf\u001cG.Z'b]\u0006<WM]*uCR,W*\u001a;bI\u0006$\u0018M\u0003\u0002V%\u0006IQ.\u001a;bI\u0006$\u0018\rI\u0001\f_\nTWm\u0019;Ti>\u0014X-F\u0001]!\t\tV,\u0003\u0002_%\nyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0001\u0007pE*,7\r^*u_J,\u0007%A\u0003qe>\u00048/F\u0001c!\u0011q4-Z3\n\u0005\u0011|$a\u0002%bg\"l\u0015\r\u001d\t\u0003M6t!aZ6\u0011\u0005!\u001cT\"A5\u000b\u0005)|\u0013A\u0002\u001fs_>$h(\u0003\u0002mg\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\ta7'\u0001\u0004qe>\u00048\u000fI\u0001\u0007EV4g-\u001a:\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A^!\u0002\u00079Lw.\u0003\u0002yk\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u000f\t,hMZ3sA\u0005a1.Z=t)>$U\r\\3uKV\tA\u0010E\u0002?{~L!A` \u0003\u0013\u0005\u0013(/Y=MSN$\b\u0003BA\u0001\u0003\u001fq1!a\u0001U\u001d\u0011\t)!!\u0004\u000f\t\u0005\u001d\u00111\u0002\b\u0004Q\u0006%\u0011\"\u0001\u0018\n\u00051j\u0013BA*,\u0013\r\t\t\u0002\u0017\u0002\u000e\u0017\u0016L\u0018I\u001c3WKJ\u001c\u0018n\u001c8\u0002\u001b-,\u0017p\u001d+p\t\u0016dW\r^3!\u0003-y'M['fi\u0006$\u0017\r^1\u0016\u0005\u0005e\u0001c\u0001)\u0002\u001c%\u0019\u0011Q\u0004-\u0003'=\u0013'.Z2u'R|'/Z'fi\u0006$\u0017\r^1\u0002\u0019=\u0014'.T3uC\u0012\fG/\u0019\u0011\u0002\u0011I,7\u000f]8og\u0016,\"!!\n\u0011\u0007E\u000b9#C\u0002\u0002*I\u0013q\u0003V5fe>\u0013'.Z2u'R|'/\u001a*fgB|gn]3\u0002\u0013I,7\u000f]8og\u0016\u0004\u0013aA2uqV\u0011\u0011\u0011\u0007\t\u0004u\u0005M\u0012bAA\u001bS\t9rJ\u00196fGR\u001cFo\u001c:f+RLGn]\"p]R,\u0007\u0010^\u0001\u0005GRD\b%\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019eP\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA$\u0003\u0003\u0012!\u0003\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe\u0006aQ\r_3dkR|'o\u0018\u0013fcR!\u0011QJA*!\r\u0011\u0014qJ\u0005\u0004\u0003#\u001a$\u0001B+oSRD\u0011\"!\u0016\u0018\u0003\u0003\u0005\r!!\u0010\u0002\u0007a$\u0013'A\u0005fq\u0016\u001cW\u000f^8sA\u0005a\u0001\u000e\u001e;q%\u0016\u001c\bo\u001c8tKV\u0011\u0011Q\f\t\u0005\u0003?\n\t(\u0004\u0002\u0002b)!\u00111MA3\u0003\u0011AG\u000f\u001e9\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0005G>\u0014XM\u0003\u0003\u0002l\u00055\u0014!B1{kJ,'BAA8\u0003\r\u0019w.\\\u0005\u0005\u0003g\n\tG\u0001\u0007IiR\u0004(+Z:q_:\u001cX-A\u0007iiR\u0004(+Z:q_:\u001cX\rI\u0001\bQ\u0016\fG-\u001a:t\u0003!AW-\u00193feN\u0004\u0013a\u0003:fiJL\bk\u001c7jGf,\"!a \u0011\u0007i\n\t)C\u0002\u0002\u0004&\u00121BU3uef\u0004v\u000e\\5ds\u0006a!/\u001a;ssB{G.[2zA\u0005QC/Z:u\u0003j,(/\u001a#fY\u0016$\u0018n\u001c8M_>\u0004hi\u001c:SKR\u0014\u00180\u00192mK\u0016C8-\u001a9uS>tGCAA'Q\ry\u0012Q\u0012\t\u0005\u0003\u001f\u000b\t+\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\r\t\u0007/\u001b\u0006\u0005\u0003/\u000bI*A\u0004kkBLG/\u001a:\u000b\t\u0005m\u0015QT\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003?\u000b1a\u001c:h\u0013\u0011\t\u0019+!%\u0003\tQ+7\u000f^\u0001$i\u0016\u001cH/\u0011>ve\u0016$U\r\\3uS>tGj\\8q\r>\u0014hj\\#yG\u0016\u0004H/[8oQ\r\u0001\u0013QR\u0001+i\u0016\u001cH/\u0011>ve\u0016$U\r\\3uS>tGj\\8q\u000bbLGo](o\r\u0006$\u0018\r\\#yG\u0016\u0004H/[8oQ\r\t\u0013QR\u0001/i\u0016\u001cH/\u0011>ve\u0016$U\r\\3uS>tGj\\8q\u000bbLGo](o%\u0016$(/_1cY\u0016,\u0005pY3qi&|g\u000eK\u0002#\u0003\u001b\u000b\u0001\u0004^3ti\u0006SXO]3CCR\u001c\u0007.\u001a3EK2,G/[8oQ\r\u0019\u0013QR\u0001\u001ai\u0016\u001cH\u000fT5ti\u000e\u000bG\u000e\u001c*fiJLHj\\8q\u000b:$7\u000fK\u0002%\u0003\u001b\u000b1\u0005^3ti2K7\u000f^\"bY2\u0014V\r\u001e:z\u0019>|\u0007/\u0012=jiN|enU;dG\u0016\u001c8\u000fK\u0002&\u0003\u001b\u000b\u0001\u0007^3ti>\u0013'.Z2u'R|'/Z\"bY2\u0014V\r\u001e:z\u0019>|\u0007/\u0012=jiN\fe\r^3s\u001b\u0006D(+\u001a;sS\u0016\u001c\bf\u0001\u0014\u0002\u000e\u0006QC/Z:u\u001f\nTWm\u0019;Ti>\u0014XmQ1mYJ+GO]=M_>\u0004X\t_5ug>s7+^2dKN\u001c\bfA\u0014\u0002\u000e\u0002")
public class ObjectStoreUtilsTest {
    private final UUID uuid = UUID.randomUUID();
    private final TopicIdPartition tpId = new TopicIdPartition("foo", this.uuid(), 0);
    private final TierObjectStore.LifecycleManagerStateMetadata metadata = new TierObjectStore.LifecycleManagerStateMetadata("clusterId");
    private final TierObjectStore objectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final HashMap<String, String> props;
    private final ByteBuffer buffer;
    private final ArrayList<TierObjectStore.KeyAndVersion> keysToDelete;
    private final TierObjectStore.ObjectStoreMetadata objMetadata;
    private final TierObjectStoreResponse response;
    private final ObjectStoreUtilsContext ctx;
    private ThreadPoolExecutor executor;
    private final HttpResponse httpResponse;
    private final HashMap<String, String> headers;
    private final RetryPolicy retryPolicy;

    public UUID uuid() {
        return this.uuid;
    }

    public TopicIdPartition tpId() {
        return this.tpId;
    }

    public TierObjectStore.LifecycleManagerStateMetadata metadata() {
        return this.metadata;
    }

    public TierObjectStore objectStore() {
        return this.objectStore;
    }

    public HashMap<String, String> props() {
        return this.props;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public ArrayList<TierObjectStore.KeyAndVersion> keysToDelete() {
        return this.keysToDelete;
    }

    public TierObjectStore.ObjectStoreMetadata objMetadata() {
        return this.objMetadata;
    }

    public TierObjectStoreResponse response() {
        return this.response;
    }

    public ObjectStoreUtilsContext ctx() {
        return this.ctx;
    }

    public ThreadPoolExecutor executor() {
        return this.executor;
    }

    public void executor_$eq(ThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public HashMap<String, String> headers() {
        return this.headers;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    @Test
    public void testAzureDeletionLoopForRetryableException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("blah", (Throwable)new RuntimeException("meh"));
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)(this.retryPolicy().maxRetries() * keys.size())))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopForNoException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            ((TierObjectStore)Mockito.doNothing().when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)keys.size()))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopExitsOnFatalException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreFatalException fatalException = new TierObjectStoreFatalException("blah-blah");
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{fatalException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), (List)keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy()));
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)keys.size()))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopExitsOnRetryableException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("meh", (Throwable)new RuntimeException("meh"));
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)(keys.size() * this.retryPolicy().maxRetries())))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureBatchedDeletion() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        keys.add(new TierObjectStore.KeyAndVersion("k3", "v3"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            this.headers().put("x-ms-error-code", "BlobNotFound");
            HttpHeaders httpHeaders = new HttpHeaders(this.headers());
            Mockito.when((Object)this.httpResponse().getHeaders()).thenReturn((Object)httpHeaders);
            BlobStorageException blobStorageException = new BlobStorageException("blah", this.httpResponse(), new Object());
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("blah", (Throwable)blobStorageException);
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor());
            this.headers().put("x-ms-error-code", "SomeError");
            httpHeaders = new HttpHeaders(this.headers());
            Mockito.when((Object)this.httpResponse().getHeaders()).thenReturn((Object)httpHeaders);
            blobStorageException = new BlobStorageException("blah", this.httpResponse(), new Object());
            retryableException = new TierObjectStoreRetriableException("blah", (Throwable)blobStorageException);
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            Assertions.assertThrows(TierObjectStoreBatchOperationException.class, () -> ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), (List)keys, (ThreadPoolExecutor)this.executor()));
            ((TierObjectStore)Mockito.doNothing().when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testListCallRetryLoopEnds() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid(), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testListCallRetryLoopExitsOnSuccess() {
        HashMap listResponse = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(listResponse);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid(), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)3))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsAfterMaxRetries() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean()), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        this.objectStore().putBuffer((TierObjectStore.ObjectStoreMetadata)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any(), (TierObjectStore.FileType)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new StorageException(100, "retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.putBuffer((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.metadata(), (ByteBuffer)this.buffer(), (TierObjectStore.FileType)TierObjectStore.FileType.LIFECYCLE_MANAGER_STATE, (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).putBuffer((TierObjectStore.ObjectStoreMetadata)this.metadata(), this.buffer(), TierObjectStore.FileType.LIFECYCLE_MANAGER_STATE);
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete(), (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.getObject((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.objMetadata(), (TierObjectStore.FileType)TierObjectStore.FileType.BACKUP_OBJECTS_LIST, (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsOnSuccess() {
        HashMap returnValue = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(returnValue);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean()), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        this.objectStore().putBuffer((TierObjectStore.ObjectStoreMetadata)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any(), (TierObjectStore.FileType)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new StorageException(100, "retry")}).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
            }
        });
        ObjectStoreUtils.putBuffer((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.metadata(), (ByteBuffer)this.buffer(), (TierObjectStore.FileType)TierObjectStore.FileType.LIFECYCLE_MANAGER_STATE, (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).putBuffer((TierObjectStore.ObjectStoreMetadata)this.metadata(), this.buffer(), TierObjectStore.FileType.LIFECYCLE_MANAGER_STATE);
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
            }
        });
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete(), (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<TierObjectStoreResponse>(this){
            private final /* synthetic */ ObjectStoreUtilsTest $outer;

            public TierObjectStoreResponse answer(InvocationOnMock invocation) {
                return this.$outer.response();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ObjectStoreUtils.getObject((ObjectStoreUtilsContext)this.ctx(), (TierObjectStore.ObjectStoreMetadata)this.objMetadata(), (TierObjectStore.FileType)TierObjectStore.FileType.BACKUP_OBJECTS_LIST, (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).getObject(this.objMetadata(), TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
    }

    public ObjectStoreUtilsTest() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.GCS);
        this.props = new HashMap();
        this.buffer = (ByteBuffer)Mockito.mock(ByteBuffer.class);
        this.keysToDelete = new ArrayList();
        this.keysToDelete().add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        this.objMetadata = (TierObjectStore.ObjectStoreMetadata)Mockito.mock(TierObjectStore.ObjectStoreMetadata.class);
        this.response = (TierObjectStoreResponse)Mockito.mock(TierObjectStoreResponse.class);
        this.ctx = new ObjectStoreUtilsContext(this.objectStore(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false));
        this.executor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        this.httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.headers = new HashMap();
        this.retryPolicy = new RetryPolicy(10, 10L, 5L);
    }
}

