/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import kafka.backupRestore.objectLifecycle.serdes.BackupObjectsMetadata;
import kafka.backupRestore.objectLifecycle.serdes.BlobMetadata;
import kafka.backupRestore.objectLifecycle.serdes.LifecycleManagerState;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupObjectLifecycle.LifecycleManager;
import kafka.tier.backupObjectLifecycle.NameAndId;
import kafka.tier.backupObjectLifecycle.StateManager;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StateManagerTest {
    @Test
    public void serializeDeserializeBackupObjectsList() {
        int i;
        long deletionTime = System.currentTimeMillis() + 86400000L;
        UUID id = UUID.randomUUID();
        ArrayList<TopicIdPartition> tpIds = new ArrayList<TopicIdPartition>();
        tpIds.add(new TopicIdPartition("foo", id, 0));
        tpIds.add(new TopicIdPartition("bar", id, 1));
        tpIds.add(new TopicIdPartition("baz", id, 2));
        HashMap tpIdToBlobs = new HashMap();
        for (TopicIdPartition tpId : tpIds) {
            ArrayList<LifecycleManager.BlobMetadata> blobs = new ArrayList<LifecycleManager.BlobMetadata>();
            for (int i2 = 0; i2 < 3; ++i2) {
                blobs.add(new LifecycleManager.BlobMetadata(tpId.topic() + "-obj-" + i2, Long.valueOf(deletionTime), Integer.valueOf(7)));
            }
            tpIdToBlobs.put(tpId, blobs);
        }
        ByteBuffer buf = StateManager.serializeBackupObjectsList(tpIdToBlobs);
        ByteBuffer buf2 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        buf.get(buf2.array(), 0, 4);
        int size = buf2.getInt();
        assert (size == buf.remaining());
        BackupObjectsMetadata metadata = BackupObjectsMetadata.getRootAsBackupObjectsMetadata((ByteBuffer)buf);
        assert (metadata.topicsLength() == 3);
        block12: for (i = 0; i < 3; ++i) {
            assert (id.toString().equals(metadata.topics(i).id()));
            switch (metadata.topics(i).name()) {
                case "foo": {
                    assert (0 == metadata.topics(i).partition());
                    continue block12;
                }
                case "bar": {
                    assert (1 == metadata.topics(i).partition());
                    continue block12;
                }
                case "baz": {
                    assert (2 == metadata.topics(i).partition());
                    continue block12;
                }
                default: {
                    Assertions.fail((String)"topic name not as expected");
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            assert (metadata.topics(i).blobsLength() == 3);
            for (int j = 0; j < 3; ++j) {
                BlobMetadata blob = metadata.topics(i).blobs(j);
                String objectId = metadata.topics(i).name() + "-obj-" + j;
                assert (objectId.equals(blob.id()));
                assert (blob.timeForDeletionInMs() == deletionTime);
                assert (blob.retentionInDays() == 7);
            }
        }
    }

    @Test
    public void serializeDeserializeLifecycleManagerState() {
        int i;
        long currTimeMs = System.currentTimeMillis();
        long[] tierOffsets = new long[50];
        for (int i2 = 0; i2 < 50; ++i2) {
            tierOffsets[i2] = i2;
        }
        HashMap<NameAndId, Integer> backupRetentionConfigs = new HashMap<NameAndId, Integer>();
        NameAndId foo = new NameAndId("foo", Uuid.randomUuid());
        NameAndId bar = new NameAndId("bar", Uuid.randomUuid());
        NameAndId baz = new NameAndId("baz", Uuid.randomUuid());
        backupRetentionConfigs.put(foo, 0);
        backupRetentionConfigs.put(bar, 7);
        backupRetentionConfigs.put(baz, 7);
        HashMap retentionChanges = new HashMap();
        HashMap dateToObjectsList = new HashMap();
        ByteBuffer buf = StateManager.serializeState((Long)currTimeMs, (long[])tierOffsets, backupRetentionConfigs, retentionChanges, dateToObjectsList);
        LifecycleManagerState state = null;
        try {
            state = StateManager.deserializeState((ByteBuffer)buf);
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
        assert (state.retentionDataLength() == 3);
        block13: for (i = 0; i < state.retentionDataLength(); ++i) {
            switch (state.retentionData(i).topic()) {
                case "foo": {
                    assert (state.retentionData(i).currentRetentionInDays() == 0);
                    assert (state.retentionData(i).topicId().equals(foo.id().toString()));
                    continue block13;
                }
                case "bar": {
                    assert (state.retentionData(i).currentRetentionInDays() == 7);
                    assert (state.retentionData(i).topicId().equals(bar.id().toString()));
                    continue block13;
                }
                case "baz": {
                    assert (state.retentionData(i).currentRetentionInDays() == 7);
                    assert (state.retentionData(i).topicId().equals(baz.id().toString()));
                    continue block13;
                }
                default: {
                    Assertions.fail((String)"Unknown topic");
                }
            }
        }
        assert (state.tierOffsetsLength() == 50);
        for (i = 0; i < state.tierOffsetsLength(); ++i) {
            assert (state.tierOffsets(i) == (long)i);
        }
    }
}

