/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.store.TierObjectStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TierObjectMetadataTest {
    TierObjectMetadataTest() {
    }

    @Test
    public void testTierObjectMetadataSize() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TierObjectMetadata metadataWithoutOpaqueData = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 100L, 100L, 32L, 2000, TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE, true, false, true, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, -1L);
        Assertions.assertEquals((int)96, (int)metadataWithoutOpaqueData.payloadBuffer().remaining());
        TierObjectMetadata metadataWithoutOpaqueData2 = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 1000L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, 500L);
        Assertions.assertEquals((int)96, (int)metadataWithoutOpaqueData2.payloadBuffer().remaining());
    }

    @Test
    public void testMigration() {
        long currentTimeMs = 1000L;
        boolean cleanupFeatureFlag = true;
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TierObjectMetadata metadata = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 1000L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, true, false, 500L);
        TierObjectMetadata metadataToCompare = metadata.migrateFormat(currentTimeMs, false, cleanupFeatureFlag);
        Assertions.assertTrue((boolean)metadata.equalsExcludingStateAndChangeTimestamp(metadataToCompare));
        Assertions.assertEquals((Object)metadata.state(), (Object)metadataToCompare.state());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)metadataToCompare.stateChangeTimestamp());
        metadata = metadataToCompare.migrateFormat(currentTimeMs, true, cleanupFeatureFlag);
        Assertions.assertEquals((Object)metadata, (Object)metadataToCompare);
        Assertions.assertFalse((boolean)metadata.isEligibleForCleanup(Long.MAX_VALUE, cleanupFeatureFlag));
        metadata = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 1000L, 100, TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, true, false, 500L);
        Assertions.assertFalse((boolean)metadata.isEligibleForCleanup(currentTimeMs, cleanupFeatureFlag));
        metadataToCompare = metadata.migrateFormat(currentTimeMs, true, cleanupFeatureFlag);
        Assertions.assertTrue((boolean)metadata.equalsExcludingStateAndChangeTimestamp(metadataToCompare));
        Assertions.assertEquals((long)currentTimeMs, (long)metadataToCompare.stateChangeTimestamp());
        Assertions.assertTrue((boolean)metadataToCompare.isEligibleForCleanup(currentTimeMs, cleanupFeatureFlag));
        Assertions.assertFalse((boolean)metadataToCompare.isEligibleForCleanup(currentTimeMs - 1L, cleanupFeatureFlag));
    }

    @Test
    public void testMutateStateChangeTimestamp() {
        long currentTimeMs = 1000L;
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TierObjectMetadata metadata = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 1000L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, true, false, Long.MAX_VALUE);
        long payloadSize = metadata.payloadSize();
        Assertions.assertEquals((long)-1L, (long)metadata.stateChangeTimestamp());
        Assertions.assertFalse((boolean)metadata.mutateStateChangeTimestamp(currentTimeMs));
        Assertions.assertEquals((long)-1L, (long)metadata.stateChangeTimestamp());
        Assertions.assertEquals((long)payloadSize, (long)metadata.payloadSize());
        metadata = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 1000L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, true, true, Long.MAX_VALUE);
        payloadSize = metadata.payloadSize();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)metadata.stateChangeTimestamp());
        Assertions.assertTrue((boolean)metadata.mutateStateChangeTimestamp(currentTimeMs));
        Assertions.assertEquals((long)currentTimeMs, (long)metadata.stateChangeTimestamp());
        Assertions.assertEquals((long)payloadSize, (long)metadata.payloadSize());
    }

    @Test
    public void testMutateStateBeforeDeletion() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TierObjectMetadata metadata = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 1000L, 100, TierObjectMetadata.State.SEGMENT_DELETE_INITIATE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, false, false, Long.MAX_VALUE);
        long payloadSize = metadata.payloadSize();
        Assertions.assertEquals((Object)TierObjectMetadata.State.INVALID, (Object)metadata.stateBeforeDeletion());
        Assertions.assertFalse((boolean)metadata.mutateStateBeforeDeletion(TierObjectMetadata.State.SEGMENT_COMPACTED));
        Assertions.assertEquals((Object)TierObjectMetadata.State.INVALID, (Object)metadata.stateBeforeDeletion());
        Assertions.assertEquals((long)payloadSize, (long)metadata.payloadSize());
        metadata = new TierObjectMetadata(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 1000L, 100, TierObjectMetadata.State.SEGMENT_DELETE_INITIATE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, true, false, Long.MAX_VALUE);
        payloadSize = metadata.payloadSize();
        Assertions.assertEquals((Object)TierObjectMetadata.State.INVALID, (Object)metadata.stateBeforeDeletion());
        Assertions.assertTrue((boolean)metadata.mutateStateBeforeDeletion(TierObjectMetadata.State.SEGMENT_COMPACTED));
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_COMPACTED, (Object)metadata.stateBeforeDeletion());
        Assertions.assertEquals((long)payloadSize, (long)metadata.payloadSize());
    }
}

