/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierAbortedTxnReader;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I3A\u0001C\u0005\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00059!)Q\b\u0001C\u0001}!)!\n\u0001C\u0001}!)A\n\u0001C\u0001}!)a\n\u0001C\u0001}!)\u0001\u000b\u0001C\u0001}\tAB+[3s\u0003\n|'\u000f^3e)bt'+Z1eKJ$Vm\u001d;\u000b\u0005)Y\u0011a\u00024fi\u000eDWM\u001d\u0006\u0003\u00195\tA\u0001^5fe*\ta\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0013\u0005I!o\\;oIR\u0013\u0018\u000e\u001d\u000b\u0003;\u0001\u0002\"A\u0005\u0010\n\u0005}\u0019\"\u0001B+oSRDQ!\t\u0002A\u0002\t\n1\"\u00192peR,G\r\u0016=ogB\u00191e\u000b\u0018\u000f\u0005\u0011JcBA\u0013)\u001b\u00051#BA\u0014\u0010\u0003\u0019a$o\\8u}%\tA#\u0003\u0002+'\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0017.\u0005\r\u0019V-\u001d\u0006\u0003UM\u0001\"aL\u001e\u000e\u0003AR!!\r\u001a\u0002\u00071|wM\u0003\u00024i\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003kY\nqa\u001d;pe\u0006<WM\u0003\u0002\u000fo)\u0011\u0001(O\u0001\u0007CB\f7\r[3\u000b\u0003i\n1a\u001c:h\u0013\ta\u0004G\u0001\u0006BE>\u0014H/\u001a3Uq:\f\u0001\u0004^3tiJ{WO\u001c3Ue&\u0004\u0018IY8si\u0016$G\u000b\u001f8t)\u0005i\u0002FA\u0002A!\t\t\u0005*D\u0001C\u0015\t\u0019E)A\u0002ba&T!!\u0012$\u0002\u000f),\b/\u001b;fe*\u0011q)O\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0013\n\u0013A\u0001V3ti\u0006\u0019B/Z:u'\u0016,7n\u00144gg\u0016$(+\u00198hK\"\u0012A\u0001Q\u0001%i\u0016\u001cHoU3fW>3gm]3u%\u0006tw-Z(wKJd\u0017\r\u001d9j]\u001e\f%m\u001c:ug\"\u0012Q\u0001Q\u0001\u0015i\u0016\u001cH/\u00112peR,G\r\u0016=ogJ\u000bgnZ3)\u0005\u0019\u0001\u0015\u0001\u0007;fgR\u001c\u0015M\\2fY2\fG/[8o\u0011\u0006tG\r\\5oO\"\u0012q\u0001\u0011")
public class TierAbortedTxnReaderTest {
    private void roundTrip(Seq<AbortedTxn> abortedTxns) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(AbortedTxn.serialize((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(abortedTxns).asJava())));
        if (option instanceof Some) {
            ByteBuffer serialized = (ByteBuffer)((Some)option).value();
            ByteBufferInputStream inputStream = new ByteBufferInputStream(serialized);
            java.util.List parsedAbortedTxns = TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)0L, (long)Long.MAX_VALUE);
            Assertions.assertEquals(abortedTxns, (Object)CollectionConverters$.MODULE$.ListHasAsScala(parsedAbortedTxns).asScala());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (abortedTxns.nonEmpty()) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"expected some aborted transactions to be deserialized");
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    @Test
    public void testRoundTripAbortedTxns() {
        this.roundTrip((Seq<AbortedTxn>)Nil$.MODULE$);
        this.roundTrip((Seq<AbortedTxn>)new .colon.colon((Object)new AbortedTxn(1L, 2L, 3L, 4L), (List)Nil$.MODULE$));
        this.roundTrip((Seq<AbortedTxn>)new .colon.colon((Object)new AbortedTxn(0L, 0L, 0L, 0L), (List)Nil$.MODULE$));
        this.roundTrip((Seq<AbortedTxn>)new .colon.colon((Object)new AbortedTxn(0L, 0L, 0L, 0L), (List)new .colon.colon((Object)new AbortedTxn(1L, 1L, 1L, 1L), (List)Nil$.MODULE$)));
    }

    @Test
    public void testSeekOffsetRange() {
        CancellationContext ctx = CancellationContext.newContext();
        ByteBuffer serialized = (ByteBuffer)AbortedTxn.serialize(Arrays.asList(new AbortedTxn(0L, 3L, 10L, 0L), new AbortedTxn(0L, 15L, 20L, 0L), new AbortedTxn(0L, 30L, 50L, 0L))).get();
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)5L)).asScala(), (String)"expected to find a single aborted transaction marker");
        serialized.position(0);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)1L)).asScala(), (String)"expected to find zero aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 15L, 20L, 0L), (List)new .colon.colon((Object)new AbortedTxn(0L, 30L, 50L, 0L), (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)11L, (long)35L)).asScala(), (String)"expected to find two aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)new .colon.colon((Object)new AbortedTxn(0L, 15L, 20L, 0L), (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)16L)).asScala(), (String)"expected to find two aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)3L)).asScala(), (String)"expected to find adjacent aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)3L, (long)10L)).asScala(), (String)"expected to find fully overlapped aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)100L, (long)150L)).asScala(), (String)"expected to find zero aborted transaction markers");
    }

    @Test
    public void testSeekOffsetRangeOverlappingAborts() {
        CancellationContext ctx = CancellationContext.newContext();
        ByteBuffer serialized = (ByteBuffer)AbortedTxn.serialize(Arrays.asList(new AbortedTxn(3L, 1999L, 2000L, 0L), new AbortedTxn(1L, 1246L, 2000L, 0L))).get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(1L, 1246L, 2000L, 0L)})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)1776L)).asScala().toSet());
        ByteBuffer serialized2 = (ByteBuffer)AbortedTxn.serialize(Arrays.asList(new AbortedTxn(1L, 1L, 1180L, 0L))).get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(1L, 1L, 1180L, 0L)})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized2), (long)0L, (long)1L)).asScala().toSet());
    }

    @Test
    public void testAbortedTxnsRange() {
        Assertions.assertTrue((boolean)TierAbortedTxnReader.abortedTxnInRange((long)0L, (long)10L, (AbortedTxn)new AbortedTxn(0L, 0L, 5L, 0L)));
        Assertions.assertTrue((boolean)TierAbortedTxnReader.abortedTxnInRange((long)5L, (long)10L, (AbortedTxn)new AbortedTxn(0L, 0L, 25L, 0L)));
        Assertions.assertFalse((boolean)TierAbortedTxnReader.abortedTxnInRange((long)0L, (long)2L, (AbortedTxn)new AbortedTxn(0L, 3L, 5L, 0L)));
        Assertions.assertFalse((boolean)TierAbortedTxnReader.abortedTxnInRange((long)20L, (long)30L, (AbortedTxn)new AbortedTxn(0L, 3L, 5L, 0L)));
    }

    @Test
    public void testCancellationHandling() {
        CancellationContext ctx = CancellationContext.newContext();
        ByteBuffer serialized = (ByteBuffer)AbortedTxn.serialize(Arrays.asList(new AbortedTxn(3L, 1999L, 2000L, 0L), new AbortedTxn(1L, 1246L, 2000L, 0L))).get();
        ByteBufferInputStream inputStream = new ByteBufferInputStream(serialized);
        ctx.cancel();
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)inputStream, (long)0L, (long)10000L), ClassTag$.MODULE$.apply(CancellationException.class), new Position("TierAbortedTxnReaderTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }
}

