/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class KRaftSnapshotObjectTest {
    @ParameterizedTest
    @ValueSource(strings={"", "random-prefix", "randomPrefix"})
    public void testEncodeDecodePath(String keyPrefix) {
        Uuid topicId = Uuid.randomUuid();
        int partition = 0;
        String clusterId = "pkc-abc";
        int nodeId = 1;
        long appendTimeMs = 234L;
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(567L, 89);
        int version = 0;
        KRaftSnapshotObject snapshotObject = new KRaftSnapshotObject(topicId, partition, clusterId, nodeId, appendTimeMs, offsetAndEpoch);
        String expectedPath = keyPrefix + TierObjectStore.DataTypePathPrefix.KRAFT_SNAPSHOT.prefix() + "/" + topicId.toString() + "/" + partition + "/" + clusterId + "/" + nodeId + "/" + appendTimeMs + "-" + Snapshots.filenameFromSnapshotId((OffsetAndEpoch)offsetAndEpoch) + "_v" + version + "." + TierObjectStore.FileType.KRAFT_SNAPSHOT.suffix();
        Assertions.assertEquals((Object)expectedPath, (Object)snapshotObject.encodePath(keyPrefix, version));
        KRaftSnapshotObject decodedObject = KRaftSnapshotObject.decodePath((String)keyPrefix, (String)expectedPath);
        Assertions.assertEquals((Object)expectedPath, (Object)decodedObject.encodePath(keyPrefix, version));
        Assertions.assertEquals((Object)topicId, (Object)decodedObject.topicId());
        Assertions.assertEquals((int)partition, (int)decodedObject.partition());
        Assertions.assertEquals((Object)clusterId, (Object)decodedObject.clusterId());
        Assertions.assertEquals((int)nodeId, (int)decodedObject.nodeId());
        Assertions.assertEquals((long)appendTimeMs, (long)decodedObject.appendTimeStampMs());
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)decodedObject.snapshotId());
        Assertions.assertEquals((Object)snapshotObject, (Object)decodedObject);
        Assertions.assertEquals((Object)new TierObjectStore.KRaftSnapshotMetadata(snapshotObject), (Object)new TierObjectStore.KRaftSnapshotMetadata(decodedObject));
    }

    @Test
    public void testInvalidPaths() {
        String invalidSuffix = "7/DuwvKw1zQwaI3GhBHYrKog/0/pkc-abc/1/234-00000000000000000567-0000000089_v0.checkpoint";
        Assertions.assertThrows(IllegalArgumentException.class, () -> KRaftSnapshotObject.decodePath((String)"", (String)invalidSuffix));
        String missingSuffix = "7/DuwvKw1zQwaI3GhBHYrKog/0/pkc-abc/1/234-00000000000000000567-0000000089";
        Assertions.assertThrows(IllegalArgumentException.class, () -> KRaftSnapshotObject.decodePath((String)"", (String)missingSuffix));
        String invalidPrefix = "5/DuwvKw1zQwaI3GhBHYrKog/0/pkc-abc/1/234-00000000000000000567-0000000089_v0.kraft-checkpoint";
        Assertions.assertThrows(IllegalArgumentException.class, () -> KRaftSnapshotObject.decodePath((String)"", (String)invalidPrefix));
        String missingPrefix = "DuwvKw1zQwaI3GhBHYrKog/0/pkc-abc/1/234-00000000000000000567-0000000089_v0.kraft-checkpoint";
        Assertions.assertThrows(IllegalArgumentException.class, () -> KRaftSnapshotObject.decodePath((String)"", (String)missingPrefix));
        String invalidKeyPrefix = "7/DuwvKw1zQwaI3GhBHYrKog/0/pkc-abc/1/234-00000000000000000567-0000000089_v0.kraft-checkpoint";
        Assertions.assertThrows(IllegalArgumentException.class, () -> KRaftSnapshotObject.decodePath((String)"random", (String)invalidKeyPrefix));
        String missingClusterId = "7/DuwvKw1zQwaI3GhBHYrKog/0/1/234-00000000000000000567-0000000089_v0.kraft-checkpoint";
        Assertions.assertThrows(IllegalArgumentException.class, () -> KRaftSnapshotObject.decodePath((String)"random", (String)missingClusterId));
    }

    @Test
    public void testOrderByTimeStampMs() {
        Uuid topicId = Uuid.randomUuid();
        int partition = 0;
        String clusterId = "pkc-abc";
        int nodeId0 = 0;
        int nodeId1 = 1;
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(567L, 89);
        KRaftSnapshotObject snapshotObject0 = new KRaftSnapshotObject(topicId, partition, clusterId, nodeId0, 56L, offsetAndEpoch);
        KRaftSnapshotObject snapshotObject1 = new KRaftSnapshotObject(topicId, partition, clusterId, nodeId0, 34L, offsetAndEpoch);
        KRaftSnapshotObject snapshotObject2 = new KRaftSnapshotObject(topicId, partition, clusterId, nodeId1, 12L, offsetAndEpoch);
        List<KRaftSnapshotObject> objects = Arrays.asList(snapshotObject2, snapshotObject1, snapshotObject0);
        Collections.sort(objects);
        Assertions.assertEquals(Arrays.asList(snapshotObject1, snapshotObject0, snapshotObject2), objects);
    }
}

