/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.log.LocalLog$;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.CompactStats;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.FileTierPartitionStateTest;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001\u0002\u0010 \u0001\u0019BQa\u000b\u0001\u0005\u00021BQA\f\u0001\u0005B=BQA\u000e\u0001\u0005B=BQa\u000e\u0001\u0005B=BQ\u0001\u000f\u0001\u0005B=BQ!\u000f\u0001\u0005\niBQA\u0017\u0001\u0005\u0002mCQ!\u001b\u0001\u0005\u0002mCQa\u001b\u0001\u0005\n1Da!!\u0002\u0001\t\u0003Y\u0006BBA\u0005\u0001\u0011\u00051\f\u0003\u0004\u0002\u000e\u0001!\ta\u0017\u0005\u0007\u0003#\u0001A\u0011A.\t\r\u0005U\u0001\u0001\"\u0001\\\u0011\u0019\tI\u0002\u0001C\u00017\"1\u0011Q\u0004\u0001\u0005\u0002mCa!!\t\u0001\t\u0003Y\u0006BBA\u0013\u0001\u0011\u00051\f\u0003\u0004\u0002*\u0001!\ta\u0017\u0005\u0007\u0003[\u0001A\u0011A.\t\r\u0005E\u0002\u0001\"\u0001\\\u0011\u0019\t)\u0004\u0001C\u00017\"1\u0011\u0011\b\u0001\u0005\u0002mCa!!\u0010\u0001\t\u0003Y\u0006BBA!\u0001\u0011\u00051\f\u0003\u0004\u0002F\u0001!\ta\u0017\u0005\u0007\u0003\u0013\u0002A\u0011A.\t\r\u00055\u0003\u0001\"\u0001\\\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'\u0012\u0001FR5mKRKWM\u001d)beRLG/[8o'R\fG/Z\"p[B\f7\r^#oC\ndW\r\u001a+fgRT!\u0001I\u0011\u0002\u000bM$\u0018\r^3\u000b\u0005\t\u001a\u0013\u0001\u0002;jKJT\u0011\u0001J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0005\u0005\u0002)S5\tq$\u0003\u0002+?\tQb)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rV3ti\u00061A(\u001b8jiz\"\u0012!\f\t\u0003Q\u0001\tqb\u00195fG.\u001cX/\\#oC\ndW\rZ\u000b\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t9!i\\8mK\u0006t\u0017AD2p[B\f7\r^#oC\ndW\rZ\u0001\u000fG2,\u0017M\\;q\u000b:\f'\r\\3e\u0003\u0005\"\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3T]\u0006\u00048\u000f[8u\u000b:\f'\r\\3e\u0003m\u0019w.\u001c9be\u0016$\u0016.\u001a:Ti\u0006$XMR5mKNDU\r\u001c9feRA1H\u0010%N%R3\u0006\f\u0005\u00022y%\u0011QH\r\u0002\u0005+:LG\u000fC\u0003@\r\u0001\u0007\u0001)\u0001\u0007pY\u0012\fEnZ8sSRDW\u000e\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006A1\r[3dWN,XN\u0003\u0002FG\u0005)Q\u000f^5mg&\u0011qI\u0011\u0002\n\u00032<wN]5uQ6DQ!\u0013\u0004A\u0002)\u000bAb\u001c7e)&,'/\u00129pG\"\u0004\"!M&\n\u00051\u0013$aA%oi\")aJ\u0002a\u0001\u001f\u0006aq\u000e\u001c3F]\u0012|eMZ:fiB\u0011\u0011\u0007U\u0005\u0003#J\u0012A\u0001T8oO\")1K\u0002a\u0001\u0001\u0006aa.Z<BY\u001e|'/\u001b;i[\")QK\u0002a\u0001\u0015\u0006aa.Z<US\u0016\u0014X\t]8dQ\")qK\u0002a\u0001\u001f\u0006aa.Z<F]\u0012|eMZ:fi\")\u0011L\u0002a\u0001a\u00051!/Z:vYR\f\u0011\u0004^3ti\u000e{W\u000e]1sKRKWM]*uCR,g)\u001b7fgR\t1\b\u000b\u0002\b;B\u0011alZ\u0007\u0002?*\u0011\u0001-Y\u0001\u0004CBL'B\u00012d\u0003\u001dQW\u000f]5uKJT!\u0001Z3\u0002\u000b),h.\u001b;\u000b\u0003\u0019\f1a\u001c:h\u0013\tAwL\u0001\u0003UKN$\u0018A\u0004;fgR\u0004&o\u001c9feRLWm\u001d\u0015\u0003\u0011u\u000b!\u0002\u001d:pa\u0016\u0014H/[3t)\tiW\u000f\u0005\u0002og6\tqN\u0003\u0002qc\u0006!Q\u000f^5m\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003w\u0013\u0001\u0007q/\u0001\bdQ\u0016\u001c7n];n\u0007>tg-[4\u0011\u0005a|hBA=~!\tQ('D\u0001|\u0015\taX%\u0001\u0004=e>|GOP\u0005\u0003}J\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@3\u0003\u0011\"Xm\u001d;SK\u0006$wK]5uK\"+\u0017\rZ3s\u001f:d\u0017pV5uQ6KwM]1uS>t\u0007F\u0001\u0006^\u0003Q!Xm\u001d;WC2LG-\u0019;f\u0007\",7m[:v[\"\u00121\"X\u0001\u000ei\u0016\u001cHoQ8na\u0006\u001cG/\u001a3)\u00051i\u0016!\u0006;fgR\u001cu.\u001c9bGRLwN\u001c$f]\u000eLgn\u001a\u0015\u0003\u001bu\u000b\u0011\u0005^3ti\u000e{W\u000e]1di&|gnQ8oGV\u0014(/\u001a8u\t\u0016dW\r^5p]ND#AD/\u0002SQ,7\u000f\u001e$f]\u000e,\u0007K]5pe\u000e{W\u000e]1di\u0016$\u0017J\\5uS\u0006$XmV5uQ\u000e{W.\\5uQ\tyQ,A\u0016uKN$8i\\7qC\u000e$\u0018n\u001c8Va2|\u0017\rZ%oSRL\u0017\r^3DQ\u0006Lg.\u001b8h'V\u001c7-Z:tQ\t\u0001R,A uKN$8i\\7qC\u000e$\u0018n\u001c8Va2|\u0017\rZ%oSRL\u0017\r^3DQ\u0006Lg.\u001b8h!J,g/[8vg>\u0013'.Z2u\u0013\u0012tu\u000e^#ya\u0016\u001cG/\u001a3)\u0005Ei\u0016a\u0010;fgR\u001cu.\u001c9bGRLwN\\+qY>\fG-\u00138ji&\fG/Z\"iC&t\u0017N\\4Qe\u00164\u0018n\\;t\u001f\nTWm\u0019;JI:{G/T1uG\"Lgn\u001a\u0015\u0003%u\u000bq\u0006^3tiV\u0003Hn\\1e\u0013:LG/[1uK\u000eC\u0017-\u001b8j]\u001e,\u0006\u000f\\8bIRK\b/\u001a(pi6\u000bGo\u00195j]\u001eD#aE/\u0002mQ,7\u000f^\"p[B\f7\r^5p]V\u0003Hn\\1e\u0007>lW.\u001b;B]\u0012\u001cv/\u00199GK:\u001c\u0017N\\4Va2|\u0017\rZ%oSRL\u0017\r^3)\u0005Qi\u0016!\u0010;fgR\u001cu.\u001c9bGRLwN\\+qY>\fGmQ8n[&$\u0018I\u001c3To\u0006\u0004x+\u001b;i\u001d>tW\t_5ti&twmU8ve\u000e,wJ\u00196fGR\u001c\bFA\u000b^\u0003}\"Xm\u001d;D_6\u0004\u0018m\u0019;j_:,\u0006\u000f\\8bI\u000e{W.\\5u\u0003:$7k^1q/&$\bNT8o\u0007>tG/[4v_V\u001c8k\\;sG\u0016|%M[3diND#AF/\u0002mQ,7\u000f^\"p[B\f7\r^5p]V\u0003Hn\\1e\u0007>lW.\u001b;B]\u0012\u001cv/\u00199XSRD\u0017*\u001c9pgNL'\r\\3PM\u001a\u001cX\r^:)\u0005]i\u0016a\f;fgR\u001cu.\u001c9bGRLwN\\\"p[6LG/\u00118e'^\f\u0007oV5uQNk\u0017\r\u001c7fe\u0016sGm\u00144gg\u0016$\bF\u0001\r^\u0003%\"Xm\u001d;SK2|\u0017\rZ5oO\u001a#\u0006kU,ji\"l\u0015n]:j]\u001e\u001cu.\u001c9bGR4\u0015.\u001a7eg\"\u0012\u0011$X\u0001\u0018i\u0016\u001cHo\u0015;bi\u0016\u0014UMZ8sK\u0012+G.\u001a;j_:D#AG/\u0002UQ,7\u000f\u001e*fY>\fG-\u001b8h\rR\u00036kV5uQ6K7o]5oONs\u0017\r]:i_R4\u0015.\u001a7eg\"\u00121$X\u0001\u0015i\u0016\u001cH/T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;)\u0005qi\u0016aD2iK\u000e\\\u0017J\u001c<be&\fg\u000e^:\u0015\u0007m\n)\u0006\u0003\u0004!;\u0001\u0007\u0011q\u000b\t\u0004Q\u0005e\u0013bAA.?\t\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0001")
public class FileTierPartitionStateCompactEnabledTest
extends FileTierPartitionStateTest {
    @Override
    public boolean checksumEnabled() {
        return true;
    }

    @Override
    public boolean compactEnabled() {
        return true;
    }

    @Override
    public boolean cleanupEnabled() {
        return true;
    }

    @Override
    public boolean tierPartitionStateSnapshotEnabled() {
        return true;
    }

    private void compareTierStateFilesHelper(Algorithm oldAlgorithm, int oldTierEpoch, long oldEndOffset, Algorithm newAlgorithm, int newTierEpoch, long newEndOffset, boolean result) {
        Path oldPath = new File(new StringBuilder(8).append("testFile").append(oldAlgorithm.suffix).toString()).toPath();
        Path newPath = new File(new StringBuilder(8).append("testFile").append(newAlgorithm.suffix).toString()).toPath();
        this.writeHeader$1(oldPath, oldAlgorithm, oldTierEpoch, oldEndOffset);
        this.writeHeader$1(newPath, newAlgorithm, newTierEpoch, newEndOffset);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)result), (Object)BoxesRunTime.boxToBoolean((boolean)ChecksumUtils.compareTierStateFiles((Path)oldPath, (Path)newPath)));
        Files.delete(oldPath);
        Files.delete(newPath);
    }

    @Test
    public void testCompareTierStateFiles() {
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 5, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 3, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(5, 30L, 3, 20L, false);
    }

    @Test
    public void testProperties() {
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("none, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, none")));
        java.util.List checksumFiles = KafkaConfig$.MODULE$.fromProps(this.properties("tierstate")).confluentConfig().checksumEnabledFiles();
        Assertions.assertEquals((int)1, (int)checksumFiles.size());
        Assertions.assertTrue((boolean)checksumFiles.contains("tierstate"));
    }

    private Properties properties(String checksumConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "somewhere", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("confluent.checksum.enabled.files", checksumConfig);
        return props;
    }

    @Test
    public void testReadWriteHeaderOnlyWithMigration() {
        Path flushedPath = Paths.get(this.state().flushedPath(), new String[0]);
        Path adlerChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.ADLER, (Path)flushedPath);
        Path nonChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.NO_CHECKSUM, (Path)flushedPath);
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 9, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)9, (int)this.state().tierEpoch());
        this.state().close();
        FileTierPartitionState reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(false), (Time)this.time());
        Assertions.assertTrue((boolean)Files.notExists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
    }

    @Test
    public void testValidateChecksum() {
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        int numSegments = 200;
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.uploadInitateAndComplete(epoch, UUID.randomUUID(), i * 2, i * 2 + 1, 100);
            size$1.elem += i;
        });
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
    }

    @Test
    public void testCompacted() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        File parentDir = TestUtils.tempDirectory(null, null);
        File dir = TestUtils$.MODULE$.randomPartitionLogDir(parentDir);
        TopicPartition tp = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        TopicIdPartition tpid = new TopicIdPartition(tp.topic(), UUID.randomUUID(), tp.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        FileTierPartitionState state = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        state.setTopicId(tpid.topicId());
        state.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ debug_this = TestUtils$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$2(op, state);
                Object var3_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)debug_this, (String)msgWithLogIdent_msg));
                return;
            }
        });
        state.beginCatchup();
        state.onCatchUpComplete();
        ListBuffer rawObjectIds = new ListBuffer();
        state.append((AbstractTierMetadata)new TierTopicInitLeader(tpid, epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(tpid, epoch, (UUID)rawObjectIds.last(), (long)offset$1.elem, (long)(offset$1.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadComplete(tpid, epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$1.elem += 2;
        });
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsToCompact = 3;
        List segmentsToClean = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)20, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().size());
        java.util.Set compactedObjectIds = CollectionConverters$.MODULE$.SetHasAsJava((Set)segmentsToClean.map((Function1 & Serializable)x$1 -> x$1.metadata().objectId()).toSet()).asJava();
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)segmentsToClean.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(tpid, epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, compactedObjectIds, newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsAfter = numSegments - numSegmentsToCompact + 1;
        Assertions.assertEquals((int)numSegmentsAfter, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().size());
        Assertions.assertEquals((long)50L, (long)((TierLogSegment)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().next()).firstBatchTimestamp());
        Assertions.assertEquals((Object)compactInitiate.messageId(), (Object)((TierLogSegment)state.metadata(0L).get()).objectId());
        Assertions.assertEquals((Object)compactInitiate.messageId(), (Object)((TierLogSegment)state.metadata(3L).get()).objectId());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala(compactedObjectIds).asScala().toSet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(state.compactedSegments()).asScala().map((Function1 & Serializable)x$4 -> x$4.objectId())).toSet());
        this.checkInvariants((TierPartitionState)state);
        CollectionConverters$.MODULE$.CollectionHasAsScala(state.compactedSegments()).asScala().foreach((Function1 & Serializable)deletableSegment -> {
            FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$8(this, state, tpid, epoch, deletableSegment);
            return BoxedUnit.UNIT;
        });
        List segmentsToClean2 = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().slice(numSegmentsToCompact, numSegmentsToCompact + 2).toList();
        long firstBatchTimestamp2 = 50L;
        UUID newObjectId2 = UUID.randomUUID();
        long newBaseOffset2 = ((TierLogSegment)segmentsToClean2.head()).baseOffset();
        long newEndOffset2 = ((TierLogSegment)segmentsToClean2.last()).endOffset();
        long newMaxTimestamp2 = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize2 = BoxesRunTime.unboxToInt((Object)segmentsToClean2.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset2 = state.lastLocalMaterializedSrcOffsetAndEpoch();
        TierSegmentUploadInitiate compactInitiate2 = new TierSegmentUploadInitiate(tpid, epoch, newObjectId2, newBaseOffset2, newEndOffset2, newMaxTimestamp2, firstBatchTimestamp2, newSize2, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset2, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        TierTestUtils$.MODULE$.verifyFtpsEntries(state, null, null, this.cleanupEnabled(), this.time().milliseconds());
        List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().toList();
        scala.collection.immutable.Set segmentsDeleted = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(state, -1L)).asScala().toSet();
        state.close();
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, (List<TierLogSegment>)segments, (scala.collection.immutable.Set<UUID>)segmentsDeleted, this.cleanupEnabled(), this.time().milliseconds());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler(), false, this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());){
            reopenedState.checkInvariants();
            Assertions.assertEquals((int)numSegmentsAfter, (int)reopenedState.numSegments());
            Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(reopenedState.segments()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)reopenedState.totalSize());
            Assertions.assertEquals((long)50L, (long)((TierLogSegment)CollectionConverters$.MODULE$.IteratorHasAsScala(reopenedState.segments()).asScala().next()).firstBatchTimestamp());
            Assertions.assertEquals((long)6L, (long)reopenedState.compactDirtyStartOffset());
            java.util.Set compactedObjectIds2 = CollectionConverters$.MODULE$.SetHasAsJava((Set)segmentsToClean2.map((Function1 & Serializable)x$8 -> x$8.metadata().objectId()).toSet()).asJava();
            UUID completeMessageId2 = UUID.randomUUID();
            TierCompactionCommitAndSwap compactComplete2 = new TierCompactionCommitAndSwap(compactInitiate2, completeMessageId2, compactedObjectIds2, newEndOffset2, new CompactStats((long)newSize2, (long)newSize2, (long)newSize2));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)compactComplete2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.cleanupEnabled(), this.time().milliseconds());
            reopenedState.checkInvariants();
            Assertions.assertEquals((long)14L, (long)reopenedState.compactDirtyStartOffset());
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala(compactedObjectIds2).asScala().toSet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(reopenedState.compactedSegments()).asScala().map((Function1 & Serializable)x$9 -> x$9.objectId())).toSet());
        }
        state.close();
        dir.delete();
        parentDir.delete();
    }

    @Test
    public void testCompactionFencing() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$2.elem, (long)(offset$2.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$2.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)segmentsToClean.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 1, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertTrue((boolean)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.state().fencedSegments()).asScala().map((Function1 & Serializable)x$12 -> x$12.objectId())).toSet().contains((Object)compactInitiate.messageId()), (String)"compact initial segment should have been fenced");
        Assertions.assertEquals((int)numSegments, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().size());
    }

    @Test
    public void testCompactionConcurrentDeletions() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$3.elem, (long)(offset$3.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$3.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)segmentsToClean.map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        TierLogSegment deletableSegment = (TierLogSegment)segmentsToClean.head();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.checkInvariants((TierPartitionState)this.state());
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, CollectionConverters$.MODULE$.SetHasAsJava((Set)segmentsToClean.map((Function1 & Serializable)x$15 -> x$15.objectId()).toSet()).asJava(), newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testFencePriorCompactedInitiateWithCommit() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 50L, 10);
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 20);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)30L, (long)this.state().totalSize());
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        HashSet<UUID> compactedObjects = new HashSet<UUID>();
        compactedObjects.add(objectId1);
        compactedObjects.add(objectId2);
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        UUID objectIdCompacted = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectIdCompacted, 0L, 50L, 100L, 100L, 10, false, false, false, TierUploadType.Compaction, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, stateOffset, UUID.randomUUID(), compactedObjects, new HashSet(), 150L, new CompactStats(30L, 10L, 30L)), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)objectIdCompacted, (Object)((TierLogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(this.state().fencedSegments()).asScala().head()).objectId());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)151L, (long)this.state().compactDirtyStartOffset());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        this.deleteInitiateAndComplete(0, objectId1, this.time().milliseconds());
        this.deleteInitiateAndComplete(0, objectId2, this.time().milliseconds());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testCompactionUploadInitiateChainingSuccess() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 9L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.of(objectId4), 6L, 10L, 100L, 100L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotExpected() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, Optional.of(objectId4), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testUploadInitiateChainingUploadTypeNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)0, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapFencingUploadInitiate() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        new HashSet<UUID>().add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        HashSet<UUID> destObjects2 = new HashSet<UUID>();
        destObjects2.add(objectId5);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects2, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)3, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonExistingSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 20L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().appendUnhandled((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)2, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)2, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonContiguousSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId4);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 40L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithImpossibleOffsets() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        this.uploadInitateAndComplete(0, objectId5, 41L, 50L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId3);
        sourceObjects.add(objectId4);
        UUID objectId6 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId6);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId6, Optional.empty(), 0L, 41L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)5, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionCommitAndSwapWithSmallerEndOffset() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        UUID objectId3 = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, Optional.empty(), 0L, 15L, 100L, 100L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().flush();
        this.state().close();
        FileTierPartitionState reopenedState1 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertEquals((int)2, (int)reopenedState1.numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId3);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1.append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects, 100L, CompactStats.EMPTY), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        SegmentState segment3 = (SegmentState)CollectionConverters$.MODULE$.ListHasAsScala(reopenedState1.segmentInMemoryMetadataRange(0L, 250L)).asScala().last();
        Assertions.assertEquals((Object)objectId3, (Object)segment3.objectId());
        Assertions.assertEquals((long)15L, (long)segment3.endOffset());
        CollectionConverters$.MODULE$.CollectionHasAsScala(reopenedState1.compactedSegments()).asScala().foreach((Function1 & Serializable)deletableSegment -> {
            FileTierPartitionStateCompactEnabledTest.$anonfun$testCompactionCommitAndSwapWithSmallerEndOffset$1(this, reopenedState1, deletableSegment);
            return BoxedUnit.UNIT;
        });
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(reopenedState1, 0, objectId4, 18L, 30L, 100, this.compactEnabled());
        reopenedState1.flush();
        reopenedState1.close();
        FileTierPartitionState reopenedState2 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertEquals((int)2, (int)reopenedState2.numSegments());
        Assertions.assertEquals((long)30L, (long)reopenedState2.endOffset());
        Assertions.assertEquals((long)30L, (long)reopenedState2.dataEndOffset());
        SegmentState segment4 = (SegmentState)CollectionConverters$.MODULE$.ListHasAsScala(reopenedState2.segmentInMemoryMetadataRange(0L, 30L)).asScala().last();
        Assertions.assertEquals((Object)objectId4, (Object)segment4.objectId());
        Assertions.assertEquals((long)21L, (long)segment4.baseOffset());
        Assertions.assertEquals((long)18L, (long)segment4.keyBaseOffset());
        Assertions.assertEquals((long)30L, (long)segment4.endOffset());
        HashSet<UUID> sourceObjects2 = new HashSet<UUID>();
        sourceObjects2.add(objectId3);
        sourceObjects2.add(objectId4);
        UUID objectId5 = UUID.randomUUID();
        this.compactionInitiateCommitAndSwap(reopenedState2, 0, UUID.randomUUID(), objectId5, sourceObjects2, 0L, 30L, 60, CompactStats.EMPTY);
        Assertions.assertTrue((boolean)reopenedState2.flush());
        Assertions.assertEquals((int)1, (int)reopenedState2.numSegments());
        reopenedState2.close();
        FileTierPartitionState reopenedState3 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertEquals((int)1, (int)reopenedState3.numSegments());
        reopenedState3.close();
    }

    @Test
    public void testReloadingFTPSWithMissingCompactFields() {
        File dir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
        TopicPartition tp2 = LocalLog$.MODULE$.parseTopicPartitionName(dir2);
        TopicIdPartition tpid2 = new TopicIdPartition(tp2.topic(), UUID.randomUUID(), tp2.partition());
        byte fileVersion = 8;
        FileTierPartitionState ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler(), this.checksumEnabled(), false, (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        ftps.setTopicId(tpid2.topicId());
        ftps.beginCatchup();
        ftps.onCatchUpComplete();
        ftps.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 123L, this.snapshotInitiateAndComplete$default$5());
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 0L, 10L, 100, false);
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 11L, 20L, 100, false);
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 456L, this.snapshotInitiateAndComplete$default$5());
        ftps.flush();
        Optional header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        FileTierPartitionIterator iterator = new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size());
        TierObjectMetadata metadata1 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)0L, (long)metadata1.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata1.endOffset());
        Assertions.assertFalse((boolean)metadata1.hasVirtualOffset());
        Assertions.assertFalse((boolean)metadata1.hasStateBeforeDeletion());
        TierObjectMetadata metadata2 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)11L, (long)metadata2.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata2.endOffset());
        Assertions.assertFalse((boolean)metadata2.hasVirtualOffset());
        Assertions.assertFalse((boolean)metadata2.hasStateBeforeDeletion());
        Assertions.assertFalse((boolean)iterator.hasNext());
        ftps.close();
        FileTierPartitionState ftps2 = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        ftps2.flush();
        Optional header2 = FileTierPartitionState.readHeader((CheckedFileIO)ftps2.checkedFileIO());
        FileTierPartitionIterator iterator2 = new FileTierPartitionIterator(tpid2, ftps2.checkedFileIO(), ((Header)header2.get()).size());
        TierObjectMetadata metadata3 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)0L, (long)metadata3.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata3.endOffset());
        Assertions.assertTrue((boolean)metadata3.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata3.hasStateBeforeDeletion());
        TierObjectMetadata metadata4 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)11L, (long)metadata4.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata4.endOffset());
        Assertions.assertTrue((boolean)metadata4.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata4.hasStateBeforeDeletion());
        Assertions.assertFalse((boolean)iterator2.hasNext());
        ftps2.close();
    }

    @Test
    public void testStateBeforeDeletion() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        int tierEpoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), tierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectUploadComplete = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), tierEpoch, objectUploadComplete, 0L, 1L, 100L, 10L, 10, false, false, false, TierUploadType.Archive, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Optional segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)TierObjectMetadata.State.INVALID, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)objectUploadComplete, (Object)((SegmentState)segmentState.get()).objectId());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), 100L), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        UUID objectFenced = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), tierEpoch, objectFenced, 2L, 3L, 100L, 10L, 10, false, false, false, TierUploadType.Archive, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++tierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), tierEpoch, objectFenced, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)objectFenced, (Object)((SegmentState)segmentState.get()).objectId());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_FENCED, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), tierEpoch, objectFenced, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), 100L), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    @Test
    public void testReloadingFTPSWithMissingSnapshotFields() {
        File dir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
        TopicPartition tp2 = LocalLog$.MODULE$.parseTopicPartitionName(dir2);
        TopicIdPartition tpid2 = new TopicIdPartition(tp2.topic(), UUID.randomUUID(), tp2.partition());
        byte fileVersion = 8;
        FileTierPartitionState ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), false, this.brokerId());
        ftps.setTopicId(tpid2.topicId());
        ftps.beginCatchup();
        ftps.onCatchUpComplete();
        ftps.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 0L, 10L, 100, true);
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 11L, 20L, 100, true);
        ftps.flush();
        Optional header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)Header.SNAPSHOT_ID_EMPTY, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)-1L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        UUID snapshotId = UUID.randomUUID();
        ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), true, this.brokerId());
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 123L, this.snapshotInitiateAndComplete$default$5());
        this.snapshotInitiateAndComplete(ftps, 0, snapshotId, 456L, this.snapshotInitiateAndComplete$default$5());
        ftps.flush();
        header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)snapshotId, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)456L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        ftps.close();
        ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), false, this.brokerId());
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 789L, false);
        ftps.flush();
        header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)snapshotId, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)456L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        ftps.close();
        ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler(), this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), false, this.brokerId());
        ftps.flush();
        header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)Header.SNAPSHOT_ID_EMPTY, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)-1L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        ftps.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataSnapshot() {
        void var7_7;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        UUID snapshotId = UUID.randomUUID();
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        TierMetadataSnapshotUploadInitiate snapshotUploadInitiate = new TierMetadataSnapshotUploadInitiate(this.tpid(), 0, snapshotId, stateOffset, 0);
        UUID segmentId = UUID.randomUUID();
        TierSegmentUploadInitiate segmentUploadInitiate = new TierSegmentUploadInitiate(this.tpid(), 0, segmentId, Optional.empty(), 0L, 100L, this.time().milliseconds(), 0L, 100, true, false, false, TierUploadType.Archive, stateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)segmentUploadInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)snapshotUploadInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Tuple2 tuple2 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata = (FileTierPartitionStateSnapshotObject)tuple2._2();
        TierMetadataSnapshotUploadComplete snapshotUploadComplete = new TierMetadataSnapshotUploadComplete(snapshotUploadInitiate, (FileTierPartitionStateSnapshotObject)var7_7);
        OffsetAndEpoch expectedLastLocalMaterializedOffsetAndEpochBeforeSnapshot = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)snapshotUploadComplete, expectedLastLocalMaterializedOffsetAndEpochBeforeSnapshot));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        File tmpProducerSnapshotFile = LogFileUtils.producerSnapshotFile((File)this.snapshotsDir().toFile(), (long)0L);
        File tmpTierStateFile = MergedLog$.MODULE$.tierStateFile(this.snapshotsDir().toFile(), 0L, "");
        Files.createFile(tmpProducerSnapshotFile.toPath(), new FileAttribute[0]);
        Files.createFile(tmpTierStateFile.toPath(), new FileAttribute[0]);
        this.state().close();
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), (Time)this.time());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)reopenedState.status());
        Assertions.assertEquals((int)0, (int)reopenedState.tierEpoch());
        Assertions.assertEquals((Object)expectedLastLocalMaterializedOffsetAndEpochBeforeSnapshot, (Object)reopenedState.lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((long)var7_7.snapshotTimestampMs(), (long)reopenedState.lastSnapshotTimestampMs());
        Assertions.assertEquals((Object)snapshotId, (Object)reopenedState.lastSnapshotId());
        reopenedState.close();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()));
        Assertions.assertTrue((boolean)tmpProducerSnapshotFile.exists());
        Assertions.assertTrue((boolean)tmpTierStateFile.exists());
    }

    public void checkInvariants(TierPartitionState state) {
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)state.totalSize());
        List objectIds = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().map((Function1 & Serializable)x$17 -> x$17.objectId()).toList();
        Assertions.assertTrue((boolean)objectIds.toSet().intersect((Set)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(state.compactedSegments()).asScala().map((Function1 & Serializable)x$18 -> x$18.objectId())).toSet()).isEmpty(), (String)"No compacted segment should be in segments list");
        Assertions.assertEquals((int)objectIds.size(), (int)objectIds.toSet().size(), (String)"segments should not be contained in log view twice");
    }

    private static final short superBlockLen$1(Algorithm algorithm) {
        Algorithm algorithm2 = algorithm;
        Algorithm algorithm3 = Algorithm.ADLER;
        if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
            return 512;
        }
        return 0;
    }

    private final Header header$1(int tierEpoch, long endOffset) {
        return new Header(this.tpid().topicId(), this.state().version(), tierEpoch, TierPartitionStatus.INIT, -1L, endOffset, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, this.cleanupEnabled(), false, -1L, Header.SNAPSHOT_ID_EMPTY);
    }

    private final void writeHeader$1(Path path, Algorithm algorithm, int tierEpoch, long endOffset) {
        short superBlockLength = FileTierPartitionStateCompactEnabledTest.superBlockLen$1(algorithm);
        Files.deleteIfExists(path);
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        CheckedFileIO channel = CheckedFileIO.open((Path)path, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        FileTierPartitionState.writeHeader((CheckedFileIO)channel, (Header)this.header$1(tierEpoch, endOffset));
        channel.flush();
        Assertions.assertEquals((int)tierEpoch, (int)((Header)FileTierPartitionState.readHeader((CheckedFileIO)channel).get()).tierEpoch());
        channel.close();
    }

    private final void checkDifferentAlgorithmCombinations$1(int oldTierEpoch, long oldEndOffset, int newTierEpoch, long newEndOffset, boolean result) {
        new .colon.colon((Object)new Tuple2((Object)Algorithm.ADLER, (Object)Algorithm.NO_CHECKSUM), (List)new .colon.colon((Object)new Tuple2((Object)Algorithm.NO_CHECKSUM, (Object)Algorithm.ADLER), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)algo -> {
            this.compareTierStateFilesHelper((Algorithm)algo._1(), oldTierEpoch, oldEndOffset, (Algorithm)algo._2(), newTierEpoch, newEndOffset, result);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCompacted$2(TierPartitionState.RecoveryOperation op$1, FileTierPartitionState state$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append(state$1.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompacted$8(FileTierPartitionStateCompactEnabledTest $this, FileTierPartitionState state$1, TopicIdPartition tpid$1, int epoch$2, TierLogSegment deletableSegment) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteInitiate(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteComplete(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch(), $this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
    }

    public static final /* synthetic */ void $anonfun$testCompactionCommitAndSwapWithSmallerEndOffset$1(FileTierPartitionStateCompactEnabledTest $this, FileTierPartitionState reopenedState1$1, TierLogSegment deletableSegment) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1$1.append((AbstractTierMetadata)new TierSegmentDeleteInitiate($this.tpid(), 0, deletableSegment.objectId(), reopenedState1$1.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)reopenedState1$1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1$1.append((AbstractTierMetadata)new TierSegmentDeleteComplete($this.tpid(), 0, deletableSegment.objectId(), reopenedState1$1.lastLocalMaterializedSrcOffsetAndEpoch(), $this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)reopenedState1$1);
    }

    private static final void verifyEntries$1(FileTierPartitionIterator iterator) {
        TierObjectMetadata metadata = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)0L, (long)metadata.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata.endOffset());
        metadata = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)11L, (long)metadata.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata.endOffset());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

