/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.TierLogSegment;
import kafka.tier.state.FileTierPartitionState;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000553Aa\u0002\u0005\u0001\u001f!A\u0011\u0002\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0001\u0003A\u0011A!\t\u000b\u001d\u0003A\u0011\u0001%\u0003\u0013M#\u0018\r^3TK\u0016\\'BA\u0005\u000b\u0003\u0015\u0019H/\u0019;f\u0015\tYA\"\u0001\u0003uS\u0016\u0014(\"A\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0005\r\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!E\r\n\u0005i\u0011\"\u0001\u0003*v]:\f'\r\\3\u0011\u0005qiR\"\u0001\u0005\n\u0005yA!A\u0006$jY\u0016$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0002\u0011MDW\u000f\u001e3po:\u0004\"!\t\u0015\u000e\u0003\tR!a\t\u0013\u0002\r\u0005$x.\\5d\u0015\t)c%\u0001\u0006d_:\u001cWO\u001d:f]RT!a\n\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003S\t\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!B3se>\u0014\bcA\u0011-]%\u0011QF\t\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0011q&\u000f\b\u0003aYr!!\r\u001b\u000e\u0003IR!a\r\b\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014!B:dC2\f\u0017BA\u001c9\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!N\u0005\u0003um\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005]B\u0014!\u00057bi\u0016\u001cHo\u0015;beR|eMZ:fiB\u0011\u0011EP\u0005\u0003\u007f\t\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0003\u0019a\u0014N\\5u}Q)!i\u0011#F\rB\u0011A\u0004\u0001\u0005\u0006\u0013\u0015\u0001\ra\u0007\u0005\u0006?\u0015\u0001\r\u0001\t\u0005\u0006U\u0015\u0001\ra\u000b\u0005\u0006y\u0015\u0001\r!P\u0001\u0004eVtG#A%\u0011\u0005)[U\"\u0001\u001d\n\u00051C$\u0001B+oSR\u0004")
public class StateSeek
implements Runnable {
    private final FileTierPartitionState state;
    private final AtomicBoolean shutdown;
    private final AtomicReference<Throwable> error;
    private final AtomicLong latestStartOffset;

    @Override
    public void run() {
        while (!this.shutdown.get()) {
            try {
                long offset = this.latestStartOffset.get();
                if (offset < 0L) continue;
                while (!this.state.metadata(offset).isPresent()) {
                }
                long found = ((TierLogSegment)this.state.metadata(offset).get()).baseOffset();
                if (offset == found) continue;
                this.error.set(new Exception(new StringBuilder(42).append("Unexpected offset found expected: ").append(offset).append(" found: ").append(found).toString()));
            }
            catch (Throwable e) {
                this.shutdown.set(true);
                this.error.set(e);
            }
        }
    }

    public StateSeek(FileTierPartitionState state, AtomicBoolean shutdown, AtomicReference<Throwable> error, AtomicLong latestStartOffset) {
        this.state = state;
        this.shutdown = shutdown;
        this.error = error;
        this.latestStartOffset = latestStartOffset;
    }
}

