/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import kafka.tier.store.AutoAbortingGenericInputStream;
import kafka.tier.store.AzureBlockBlobAutoAbortingInputStream;
import kafka.tier.store.S3AutoAbortingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AutoAbortingGenericInputStreamTest {
    @Test
    public void drainTest() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any())).thenReturn((Object)10);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)90, (Object[])new Integer[]{0});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read2);
        autoAborting.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any());
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    @Test
    public void excessiveDrainTest() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any())).thenReturn((Object)10);
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 300L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read2);
        autoAborting.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any());
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.never())).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    @Test
    public void readBufferNoBytesRemaininingTest() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any())).thenReturn((Object)9, (Object[])new Integer[]{-1});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 10L, 20L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)9, (int)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)-1, (int)read2);
        Assertions.assertEquals((long)11L, (long)autoAborting.remainingBytes());
        autoAborting.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any());
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.never())).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    @Test
    public void readSingleNoBytesRemaininingTest() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read()).thenReturn((Object)17, (Object[])new Integer[]{-1});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 10L, 20L);
        int read1 = autoAborting.read();
        Assertions.assertEquals((int)17, (int)read1);
        int read2 = autoAborting.read();
        Assertions.assertEquals((int)-1, (int)read2);
        Assertions.assertEquals((long)19L, (long)autoAborting.remainingBytes());
        autoAborting.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.never())).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    @Test
    public void exceptionOnReadAttemptReread() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any())).thenReturn((Object)10).thenThrow(new Throwable[]{new IOException("failed to read")});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 300L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        Assertions.assertThrows(IOException.class, () -> autoAborting.read(new byte[10]));
        Assertions.assertThrows(IllegalStateException.class, () -> autoAborting.read(new byte[10]));
        autoAborting.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any());
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.never())).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    @Test
    public void abortTest() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any())).thenReturn((Object)10).thenThrow(new Throwable[]{new IOException("failed to read")});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        Assertions.assertThrows(IOException.class, () -> autoAborting.read(new byte[10]));
        autoAborting.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any());
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.never())).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    @Test
    public void s3AbortTest() throws IOException {
        S3ObjectInputStream inputStream = (S3ObjectInputStream)Mockito.mock(S3ObjectInputStream.class);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any())).thenReturn((Object)10).thenThrow(new Throwable[]{new IOException("failed to read")});
        S3AutoAbortingInputStream autoAborting = new S3AutoAbortingInputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        Assertions.assertThrows(IOException.class, () -> AutoAbortingGenericInputStreamTest.lambda$s3AbortTest$3((AutoAbortingGenericInputStream)autoAborting));
        autoAborting.close();
        ((S3ObjectInputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any());
        ((S3ObjectInputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.never())).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((S3ObjectInputStream)Mockito.verify((Object)inputStream)).abort();
    }

    @Test
    public void azureBlockBlobReadThrowRuntimeExceptionTest() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)inputStream.read((byte[])ArgumentMatchers.any())).thenReturn((Object)10).thenThrow(new Throwable[]{new RuntimeException("KSTORAGE-2716")});
        AzureBlockBlobAutoAbortingInputStream autoAborting = new AzureBlockBlobAutoAbortingInputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        Assertions.assertThrows(IOException.class, () -> AutoAbortingGenericInputStreamTest.lambda$azureBlockBlobReadThrowRuntimeExceptionTest$4((AutoAbortingGenericInputStream)autoAborting));
        autoAborting.close();
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any());
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.never())).read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    private static /* synthetic */ void lambda$azureBlockBlobReadThrowRuntimeExceptionTest$4(AutoAbortingGenericInputStream autoAborting) throws Throwable {
        autoAborting.read(new byte[10]);
    }

    private static /* synthetic */ void lambda$s3AbortTest$3(AutoAbortingGenericInputStream autoAborting) throws Throwable {
        autoAborting.read(new byte[10]);
    }
}

