/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.store.AzureBlockBlobTierObjectStoreConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Y4A!\u0005\n\u00013!)\u0001\u0005\u0001C\u0001C!IA\u0005\u0001a\u0001\u0002\u0004%\t!\n\u0005\n]\u0001\u0001\r\u00111A\u0005\u0002=B\u0011\"\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0014\t\u0013Y\u0002\u0001\u0019!a\u0001\n\u00039\u0004\"\u0003 \u0001\u0001\u0004\u0005\r\u0011\"\u0001@\u0011%\t\u0005\u00011A\u0001B\u0003&\u0001\bC\u0003C\u0001\u0011\u00051\tC\u0003R\u0001\u0011\u00051\tC\u0003W\u0001\u0011\u00051\tC\u0003\\\u0001\u0011\u00051\tC\u0003^\u0001\u0011\u00051\tC\u0003`\u0001\u0011\u00051\tC\u0003b\u0001\u0011\u00051\tC\u0003d\u0001\u0011\u00051\tC\u0003f\u0001\u0011\u0005aMA\u0012BuV\u0014XM\u00117pG.\u0014En\u001c2PE*,7\r^*u_J,7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005M!\u0012!B:u_J,'BA\u000b\u0017\u0003\u0011!\u0018.\u001a:\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\n\u0002\u0011Q,7\u000f\u001e$jY\u0016,\u0012A\n\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\n!![8\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0005\r&dW-\u0001\u0007uKN$h)\u001b7f?\u0012*\u0017\u000f\u0006\u00021gA\u00111$M\u0005\u0003eq\u0011A!\u00168ji\"9AgAA\u0001\u0002\u00041\u0013a\u0001=%c\u0005IA/Z:u\r&dW\rI\u0001\u0006aJ|\u0007o]\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\u00111HK\u0001\u0005kRLG.\u0003\u0002>u\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0013A\u0014x\u000e]:`I\u0015\fHC\u0001\u0019A\u0011\u001d!d!!AA\u0002a\na\u0001\u001d:paN\u0004\u0013!B:fiV\u0004H#\u0001\u0019)\u0005!)\u0005C\u0001$P\u001b\u00059%B\u0001%J\u0003\r\t\u0007/\u001b\u0006\u0003\u0015.\u000bqA[;qSR,'O\u0003\u0002M\u001b\u0006)!.\u001e8ji*\ta*A\u0002pe\u001eL!\u0001U$\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0004dY\u0016\fg.\u001e9)\u0005%\u0019\u0006C\u0001$U\u0013\t)vIA\u0005BMR,'/R1dQ\u0006aB/Z:u\u0013:4\u0018\r\\5e\u0007>tg-[4O_\u000e{g\u000e^1j]\u0016\u0014\bF\u0001\u0006Y!\t1\u0015,\u0003\u0002[\u000f\n!A+Z:u\u0003%\"Xm\u001d;J]Z\fG.\u001b3D_:4\u0017n\u001a(p\u000b:$\u0007o\\5oi:{7I]3e\r&dW\rU1uQ\"\u00121\u0002W\u0001*i\u0016\u001cH/\u00138wC2LGm\u0011:fI\u0016tG/[1mg\u000e{gNZ5h)>|W*\u00198z\r&,G\u000eZ:)\u00051A\u0016!\n;fgRLeN^1mS\u0012\u001c%/\u001a3f]RL\u0017\r\\:D_:4\u0017nZ'bY\u001a|'/\\3eQ\ti\u0001,A\u001cuKN$\u0018J\u001c<bY&$7I]3eK:$\u0018.\u00197t\u0007>tg-[4Vg&twm\u0015)XSRD7+Z2sKRtu.\u00128ea>Lg\u000e\u001e\u0015\u0003\u001da\u000bq\u0006^3ti&sg/\u00197jI\u000e{gNZ5h+NLgnZ\"p]:,7\r^5p]N#(oV5uQ\u0016sG\r]8j]RD#a\u0004-\u0002\u0017]\u0014\u0018\u000e^3U_\u001aKG.\u001a\u000b\u0004a\u001dL\u0007\"\u00025\u0011\u0001\u00041\u0013\u0001\u00024jY\u0016DQA\u001b\tA\u0002-\fqaY8oi\u0016tG\u000f\u0005\u0002mg:\u0011Q.\u001d\t\u0003]ri\u0011a\u001c\u0006\u0003ab\ta\u0001\u0010:p_Rt\u0014B\u0001:\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Id\u0002")
public class AzureBlockBlobObjectStoreConfigTest {
    private File testFile;
    private Properties props;

    public File testFile() {
        return this.testFile;
    }

    public void testFile_$eq(File x$1) {
        this.testFile = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    @BeforeEach
    public void setup() {
        this.testFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var19_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var20_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var21_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        this.props_$eq(TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21));
    }

    @AfterEach
    public void cleanup() {
        this.testFile().deleteOnExit();
        this.props().clear();
    }

    @Test
    public void testInvalidConfigNoContainer() {
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobEndpointProp(), "endpoint");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props());
        IllegalArgumentException caught = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new AzureBlockBlobTierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("AzureBlockBlobObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        Assertions.assertEquals((Object)new StringBuilder(42).append(KafkaConfig$.MODULE$.TierAzureBlockBlobContainerProp()).append(" must be set if ").append(KafkaConfig$.MODULE$.TierBackendProp()).append(" property is set to Azure.").toString(), (Object)caught.getMessage());
    }

    @Test
    public void testInvalidConfigNoEndpointNoCredFilePath() {
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props());
        IllegalArgumentException caught = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new AzureBlockBlobTierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("AzureBlockBlobObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        Assertions.assertEquals((Object)new StringBuilder(62).append("At least one of ").append(KafkaConfig$.MODULE$.TierAzureBlockBlobCredFilePathProp()).append(" or ").append(KafkaConfig$.MODULE$.TierAzureBlockBlobEndpointProp()).append(" must be set if ").append(KafkaConfig$.MODULE$.TierBackendProp()).append(" property is set to Azure.").toString(), (Object)caught.getMessage());
    }

    @Test
    public void testInvalidCredentialsConfigTooManyFields() {
        String content = "{\"connectionString\" : \"connectionString\", \n\"azureClientId\" : \"azureClientId\", \n\"azureTenantId\" : \"azureTenantId\", \n\"azureClientSecret\" : \"azureClientSecret\" \n }\n";
        this.writeToFile(this.testFile(), content);
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobContainerProp(), "testcontainer");
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobCredFilePathProp(), this.testFile().getAbsolutePath());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props());
        IllegalArgumentException caught = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new AzureBlockBlobTierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("AzureBlockBlobObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        Assertions.assertEquals((Object)new StringBuilder(103).append("Only one of connectionString or (azureClientId + azureTenantId + azureClientSecret) can be set in file ").append(this.testFile().getAbsolutePath()).toString(), (Object)caught.getMessage());
    }

    @Test
    public void testInvalidCredentialsConfigMalformed() {
        String content = "{\"azureClientId\" : \"azureClientId\", \n\"azureClientSecret\" : \"azureClientSecret\" \n }\n";
        this.writeToFile(this.testFile(), content);
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobContainerProp(), "testcontainer");
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobCredFilePathProp(), this.testFile().getAbsolutePath());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props());
        IllegalArgumentException caught = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new AzureBlockBlobTierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("AzureBlockBlobObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        Assertions.assertEquals((Object)new StringBuilder(127).append("No credentials found in file: ").append(this.testFile().getAbsolutePath()).append(". ").append("One of connectionString or (azureClientId + azureTenantId + azureClientSecret) must be supplied").toString(), (Object)caught.getMessage());
    }

    @Test
    public void testInvalidCredentialsConfigUsingSPWithSecretNoEndpoint() {
        String content = "{\"azureClientId\" : \"azureClientId\", \n\"azureTenantId\" : \"azureTenantId\", \n\"azureClientSecret\" : \"azureClientSecret\" \n }\n";
        this.writeToFile(this.testFile(), content);
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobContainerProp(), "testcontainer");
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobCredFilePathProp(), this.testFile().getAbsolutePath());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props());
        IllegalArgumentException caught = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new AzureBlockBlobTierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("AzureBlockBlobObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        Assertions.assertEquals((Object)new StringBuilder(86).append(KafkaConfig$.MODULE$.TierAzureBlockBlobEndpointProp()).append(" must be specified when authenticating ").append("using a service principal with secret in file: ").append(this.testFile().getAbsolutePath()).toString(), (Object)caught.getMessage());
    }

    @Test
    public void testInvalidConfigUsingConnectionStrWithEndpoint() {
        String content = "{\"connectionString\" : \"connectionString\"}\n";
        this.writeToFile(this.testFile(), content);
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobContainerProp(), "testcontainer");
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobCredFilePathProp(), this.testFile().getAbsolutePath());
        this.props().put(KafkaConfig$.MODULE$.TierAzureBlockBlobEndpointProp(), "endpoint");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.props());
        IllegalArgumentException caught = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new AzureBlockBlobTierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("AzureBlockBlobObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        Assertions.assertEquals((Object)new StringBuilder(59).append(KafkaConfig$.MODULE$.TierAzureBlockBlobEndpointProp()).append(" should not be set when using a connection string").append(" in file: ").append(this.testFile().getAbsolutePath()).toString(), (Object)caught.getMessage());
    }

    public void writeToFile(File file, String content) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(content);
        bw.close();
    }
}

