/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobStorageException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.AzureBlockBlobTierObjectStore;
import kafka.tier.store.AzureBlockBlobTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import org.apache.directory.api.util.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0004\t\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003B\u0002\u001b\u0001A\u0003%A\u0005C\u00046\u0001\u0001\u0007I\u0011\u0001\u001c\t\u000fi\u0002\u0001\u0019!C\u0001w!1\u0011\t\u0001Q!\n]B\u0011B\u0011\u0001A\u0002\u0003\u0007I\u0011A\"\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0005\"\u0003&\u0001\u0001\u0004\u0005\t\u0015)\u0003E\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015Q\u0006\u0001\"\u0001M\u0011\u0015y\u0006\u0001\"\u0001M\u0011\u0015\t\u0007\u0001\"\u0001M\u0011\u0015\u0019\u0007\u0001\"\u0001M\u0005\u0005\n%0\u001e:f\u00052|7m\u001b\"m_\n$\u0016.\u001a:PE*,7\r^*u_J,G+Z:u\u0015\t\t\"#A\u0003ti>\u0014XM\u0003\u0002\u0014)\u0005!A/[3s\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0011\u0003!iW\r^1eCR\fW#\u0001\u0013\u0011\u0005\u0015\ndB\u0001\u00140\u001d\t9cF\u0004\u0002)[9\u0011\u0011\u0006L\u0007\u0002U)\u00111FF\u0001\u0007yI|w\u000e\u001e \n\u0003UI!a\u0005\u000b\n\u0005E\u0011\u0012B\u0001\u0019\u0011\u0003=!\u0016.\u001a:PE*,7\r^*u_J,\u0017B\u0001\u001a4\u00059y%M[3di6+G/\u00193bi\u0006T!\u0001\r\t\u0002\u00135,G/\u00193bi\u0006\u0004\u0013AB2p]\u001aLw-F\u00018!\t\t\u0003(\u0003\u0002:!\t\u0019\u0013I_;sK\ncwnY6CY>\u0014G+[3s\u001f\nTWm\u0019;Ti>\u0014XmQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0011Ah\u0010\t\u00033uJ!A\u0010\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u0016\t\t\u00111\u00018\u0003\rAH%M\u0001\bG>tg-[4!\u0003-y'M[3diN#xN]3\u0016\u0003\u0011\u0003\"!I#\n\u0005\u0019\u0003\"!H!{kJ,'\t\\8dW\ncwN\u0019+jKJ|%M[3diN#xN]3\u0002\u001f=\u0014'.Z2u'R|'/Z0%KF$\"\u0001P%\t\u000f\u0001C\u0011\u0011!a\u0001\t\u0006aqN\u00196fGR\u001cFo\u001c:fA\u0005)1/\u001a;vaR\tA\b\u000b\u0002\u000b\u001dB\u0011q\nW\u0007\u0002!*\u0011\u0011KU\u0001\u0004CBL'BA*U\u0003\u001dQW\u000f]5uKJT!!\u0016,\u0002\u000b),h.\u001b;\u000b\u0003]\u000b1a\u001c:h\u0013\tI\u0006K\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0002^3ti\u001e+Go\u00142kK\u000e$\bFA\u0006]!\tyU,\u0003\u0002_!\n!A+Z:u\u0003\u0019\"Xm\u001d;HKR|%M[3di\u001a\u000b\u0017\u000e\\:XQ\u0016twJ\u00196fGRL5OT8u\r>,h\u000e\u001a\u0015\u0003\u0019q\u000b\u0011\u0005^3ti\u001e+Go\u00142kK\u000e$(\t\\8c'R|'/Y4f\u000bb\u001cW\r\u001d;j_:D#!\u0004/\u0002;Q,7\u000f^$fi>\u0013'.Z2u%VtG/[7f\u000bb\u001cW\r\u001d;j_:D#A\u0004/")
public class AzureBlockBlobTierObjectStoreTest {
    private final TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    private AzureBlockBlobTierObjectStoreConfig config = AzureBlockBlobTierObjectStoreConfig.createWithEmptyClusterIdBrokerId(Optional.empty(), Optional.empty(), (String)"bucket", (String)"prefix", (int)0);
    private AzureBlockBlobTierObjectStore objectStore;

    public TierObjectStore.ObjectMetadata metadata() {
        return this.metadata;
    }

    public AzureBlockBlobTierObjectStoreConfig config() {
        return this.config;
    }

    public void config_$eq(AzureBlockBlobTierObjectStoreConfig x$1) {
        this.config = x$1;
    }

    public AzureBlockBlobTierObjectStore objectStore() {
        return this.objectStore;
    }

    public void objectStore_$eq(AzureBlockBlobTierObjectStore x$1) {
        this.objectStore = x$1;
    }

    @BeforeEach
    public void setup() {
        BlobServiceClient serviceClient = new BlobServiceClientBuilder().connectionString("DefaultEndpointsProtocol=https;AccountName=name;AccountKey=key").buildClient();
        BlobContainerClient containerClient = new BlobContainerClientBuilder().endpoint("https://azure-storage-non-existent.com").buildClient();
        this.objectStore_$eq((AzureBlockBlobTierObjectStore)Mockito.spy((Object)new AzureBlockBlobTierObjectStore(this.config(), serviceClient, containerClient)));
    }

    @Test
    public void testGetObject() {
        ((AzureBlockBlobTierObjectStore)Mockito.doAnswer(arg_0 -> AzureBlockBlobTierObjectStoreTest.$anonfun$testGetObject$1(new ByteArrayInputStream("test stream data".getBytes()), arg_0)).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        TierObjectStoreResponse response = this.objectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.SEGMENT);
        Assertions.assertEquals((Object)"test stream data", (Object)IOUtils.toString((InputStream)response.getInputStream(), (Charset)Charset.defaultCharset()));
    }

    @Test
    public void testGetObjectFailsWhenObjectIsNotFound() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("x-ms-error-code", BlobErrorCode.BLOB_NOT_FOUND.toString());
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BlobStorageException exception = new BlobStorageException("Blob not found", httpResponse, new Object());
        Mockito.when((Object)httpResponse.getHeaders()).thenReturn((Object)httpHeaders);
        ((AzureBlockBlobTierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> this.objectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.SEGMENT));
    }

    @Test
    public void testGetObjectBlobStorageException() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("x-ms-error-code", BlobErrorCode.INTERNAL_ERROR.toString());
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BlobStorageException exception = new BlobStorageException("Internal Error", httpResponse, new Object());
        Mockito.when((Object)httpResponse.getHeaders()).thenReturn((Object)httpHeaders);
        ((AzureBlockBlobTierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> this.objectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.SEGMENT));
    }

    @Test
    public void testGetObjectRuntimeException() {
        RuntimeException exception = new RuntimeException();
        ((AzureBlockBlobTierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> this.objectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.SEGMENT));
    }

    public static final /* synthetic */ ByteArrayInputStream $anonfun$testGetObject$1(ByteArrayInputStream inputStream$1, InvocationOnMock x$2) {
        return inputStream$1;
    }
}

