/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tMe\u0001B\u001c9\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%C\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011A'\t\u0013Q\u0003\u0001\u0019!a\u0001\n\u0003)\u0006\"C.\u0001\u0001\u0004\u0005\t\u0015)\u0003O\u0011\u001da\u0006A1A\u0005\u0002uCa\u0001\u001a\u0001!\u0002\u0013q\u0006bB3\u0001\u0005\u0004%\tA\u001a\u0005\u0007_\u0002\u0001\u000b\u0011B4\t\u000fA\u0004!\u0019!C\u0001c\"1Q\u000f\u0001Q\u0001\nIDqA\u001e\u0001C\u0002\u0013\u0005q\u000f\u0003\u0004\u007f\u0001\u0001\u0006I\u0001\u001f\u0005\t\u007f\u0002\u0011\r\u0011\"\u0001\u0002\u0002!A\u0011q\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001\u0002\u0014!A\u00111\u0004\u0001!\u0002\u0013\t)\u0002C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001\u0002 !A\u0011Q\u0006\u0001!\u0002\u0013\t\t\u0003C\u0005\u00020\u0001\u0011\r\u0011\"\u0001\u00022!A\u0011q\b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002B\u0001\u0001\r\u0011\"\u0001\u0002D!I\u0011\u0011\u000b\u0001A\u0002\u0013\u0005\u00111\u000b\u0005\t\u0003/\u0002\u0001\u0015)\u0003\u0002F!I\u0011\u0011\f\u0001C\u0002\u0013\u0005\u00111\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002^!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002p!I\u0011\u0011\u0010\u0001C\u0002\u0013\u0005\u00111\u0010\u0005\t\u0003\u0013\u0003\u0001\u0015!\u0003\u0002~!I\u00111\u0012\u0001C\u0002\u0013\u0005\u0011Q\u0012\u0005\t\u0003O\u0003\u0001\u0015!\u0003\u0002\u0010\"I\u0011\u0011\u0016\u0001C\u0002\u0013\u0005\u00111\u0016\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u0002.\"Y\u0011Q\u0018\u0001A\u0002\u0003\u0007I\u0011AA`\u0011-\tI\u000e\u0001a\u0001\u0002\u0004%\t!a7\t\u0017\u0005}\u0007\u00011A\u0001B\u0003&\u0011\u0011\u0019\u0005\n\u0003C\u0004!\u0019!C\u0001\u0003GD\u0001\"a;\u0001A\u0003%\u0011Q\u001d\u0005\n\u0003[\u0004!\u0019!C\u0001\u0003_D\u0001\"!?\u0001A\u0003%\u0011\u0011\u001f\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u0011)\u0002\u0001C\u0001\u0003{DqAa\b\u0001\t\u0003\ti\u0010C\u0004\u0003*\u0001!\t!!@\t\u000f\t5\u0002\u0001\"\u0001\u0002~\"9!\u0011\u0007\u0001\u0005\u0002\u0005u\bb\u0002B\u001b\u0001\u0011\u0005\u0011Q \u0005\b\u0005s\u0001A\u0011AA\u007f\u0011\u001d\u0011i\u0004\u0001C\u0001\u0003{DqA!\u0011\u0001\t\u0003\ti\u0010C\u0004\u0003F\u0001!\t!!@\t\u000f\t%\u0003\u0001\"\u0001\u0002~\"9!Q\n\u0001\u0005\u0002\u0005u\bb\u0002B)\u0001\u0011%!1\u000b\u0002\u0016)&,'/\u0011:dQ&4XM]*uCR,G+Z:u\u0015\tI$(A\u0004be\u000eD\u0017N^3\u000b\u0005mb\u0014!\u0002;bg.\u001c(BA\u001f?\u0003\u0011!\u0018.\u001a:\u000b\u0003}\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0005B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001&\u0011\u0005-\u0003Q\"\u0001\u001d\u0002\u0007\r$\b0F\u0001O!\ty%+D\u0001Q\u0015\t\tF(A\u0004gKR\u001c\u0007.\u001a:\n\u0005M\u0003&aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018aB2uq~#S-\u001d\u000b\u0003-f\u0003\"aQ,\n\u0005a#%\u0001B+oSRDqAW\u0002\u0002\u0002\u0003\u0007a*A\u0002yIE\nAa\u0019;yA\u0005AQn\\2l)&lW-F\u0001_!\ty&-D\u0001a\u0015\t\tg(A\u0003vi&d7/\u0003\u0002dA\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u0005iA/[3s)>\u0004\u0018n\u0019(b[\u0016,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA\u0001\\1oO*\tA.\u0001\u0003kCZ\f\u0017B\u00018j\u0005\u0019\u0019FO]5oO\u0006qA/[3s)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013A\u0006;jKJ$v\u000e]5d\u001dVl\u0007+\u0019:uSRLwN\\:\u0016\u0003I\u0004\"aQ:\n\u0005Q$%!B*i_J$\u0018a\u0006;jKJ$v\u000e]5d\u001dVl\u0007+\u0019:uSRLwN\\:!\u0003\u001dawn\u001a#jeN,\u0012\u0001\u001f\t\u0004sr<W\"\u0001>\u000b\u0005m\\\u0017\u0001B;uS2L!! >\u0003\u0013\u0005\u0013(/Y=MSN$\u0018\u0001\u00037pO\u0012K'o\u001d\u0011\u0002#=\u0014'.Z2u'R|'/Z\"p]\u001aLw-\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nq\nQa\u001d;pe\u0016LA!!\u0004\u0002\b\t\tSj\\2l\u0013:lU-\\8ssRKWM](cU\u0016\u001cGo\u0015;pe\u0016\u001cuN\u001c4jO\u0006\u0011rN\u00196fGR\u001cFo\u001c:f\u0007>tg-[4!\u0003=!\u0018.\u001a:PE*,7\r^*u_J,WCAA\u000b!\u0011\t)!a\u0006\n\t\u0005e\u0011q\u0001\u0002\u001c\u001b>\u001c7.\u00138NK6|'/\u001f+jKJ|%M[3diN#xN]3\u0002!QLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u001f\u0002\u000bQ|\u0007/[2\n\t\u0005-\u0012Q\u0005\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018A\u0005;jKJ$v\u000e]5d\u0007>t7/^7fe\u0002\n\u0011\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ssV\u0011\u00111\u0007\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u001f\u0002\u000bM$\u0018\r^3\n\t\u0005u\u0012q\u0007\u0002\u001a)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u00180\u0001\u000euS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)Y2u_JL\b%A\nuS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0002FA)1)a\u0012\u0002L%\u0019\u0011\u0011\n#\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005U\u0012QJ\u0005\u0005\u0003\u001f\n9D\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017a\u0006;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cx\fJ3r)\r1\u0016Q\u000b\u0005\t5Z\t\t\u00111\u0001\u0002F\u0005!B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\u0002\n\u0011\u0003^5fe2{wmQ8na>tWM\u001c;t+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019GP\u0001\u0004Y><\u0017\u0002BA4\u0003C\u0012\u0011\u0003V5fe2{wmQ8na>tWM\u001c;t\u0003I!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo\u001d\u0011\u0002%QLWM\u001d*fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003_\u0002B!!\u001d\u0002t5\tA(C\u0002\u0002vq\u0012!\u0003V5feJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0019B/[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005!\"\r\\8dW&tw\rV1tW\u0016CXmY;u_J,\"!! \u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!{\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u000f\u000b\tI\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fQC\u00197pG.Lgn\u001a+bg.,\u00050Z2vi>\u0014\b%\u0001\u0003uS6,WCAAH!\u0011\t\t*a)\u000e\u0005\u0005M%bA1\u0002\u0016*!\u0011qSAM\u0003\u0019\u0019w.\\7p]*\u0019q(a'\u000b\t\u0005u\u0015qT\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0016aA8sO&!\u0011QUAJ\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u00175\f\u0007pV1jiRKW.Z\u000b\u0003\u0003[\u0003B!a,\u000286\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0005ekJ\fG/[8o\u0015\r\t\u0019\tR\u0005\u0005\u0003s\u000b\tL\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u00195\f\u0007pV1jiRKW.\u001a\u0011\u0002\u0011\tLH/\u001a*bi\u0016,\"!!1\u0011\t\u0005\r\u0017Q[\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006!1m\u001c:f\u0015\u0011\tY-!4\u0002\u000f5,GO]5dg*!\u0011qZAi\u0003\u0019I\u0018-\\7fe*\u0011\u00111[\u0001\u0004G>l\u0017\u0002BAl\u0003\u000b\u0014Q!T3uKJ\fABY=uKJ\u000bG/Z0%KF$2AVAo\u0011!Q6%!AA\u0002\u0005\u0005\u0017!\u00032zi\u0016\u0014\u0016\r^3!\u0003!\u0011'o\\6fe&#WCAAs!\r\u0019\u0015q]\u0005\u0004\u0003S$%aA%oi\u0006I!M]8lKJLE\rI\u0001\u0010i&,'\u000fV1tWN\u001cuN\u001c4jOV\u0011\u0011\u0011\u001f\t\u0005\u0003g\f)0D\u0001;\u0013\r\t9P\u000f\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\u0006\u0001B/[3s)\u0006\u001c8n]\"p]\u001aLw\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002-\"\u001a\u0011F!\u0001\u0011\t\t\r!\u0011C\u0007\u0003\u0005\u000bQAAa\u0002\u0003\n\u0005\u0019\u0011\r]5\u000b\t\t-!QB\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011y!a(\u0002\u000b),h.\u001b;\n\t\tM!Q\u0001\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007)\u0012I\u0002\u0005\u0003\u0003\u0004\tm\u0011\u0002\u0002B\u000f\u0005\u000b\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00021Q,7\u000f^!xC&$\u0018N\\4MK\u0006$WM\u001d*fgVdG\u000fK\u0002,\u0005G\u0001BAa\u0001\u0003&%!!q\u0005B\u0003\u0005\u0011!Vm\u001d;\u0002uQ,7\u000f\u001e$bS2,G-\u00138ji2+\u0017\rZ3s%\u0016$(/\u001f+iK:\u0014Vm\u001d;pe\u0016$&/[4hKJLgn\u001a\"fM>\u0014X\rT3bI\u0016\u0014\bf\u0001\u0017\u0003$\u0005iC/Z:u\r\u0006LG.\u001a3MK\u0006$WM\u001d*fgVdGOR1jY\u0016$'+Z:u_J,g*Z<fe\u0016\u0003xn\u00195)\u00075\u0012\u0019#A\u0017uKN$h)Y5mK\u0012dU-\u00193feJ+7/\u001e7u\r\u0006LG.\u001a3SKN$xN]3FcV\fG.\u00129pG\"D3A\fB\u0012\u00035\"Xm\u001d;GC&dW\r\u001a'fC\u0012,'OU3tk2$h)Y5mK\u0012\u0014Vm\u001d;pe\u0016dun^3s\u000bB|7\r\u001b\u0015\u0004_\t\r\u0012A\b;fgR\fu/Y5uS:<G*Z1eKJ\u0014Vm];mi\u001a+gnY3eQ\r\u0001$1E\u0001\u001bi\u0016\u001cHOU3ti>\u0014XMR3oG\u0016$W\t_2faRLwN\u001c\u0015\u0004c\t\r\u0012A\u0006;fgR\u0014UMZ8sKV\u0003Hn\\1e\r\u0016t7-\u001a3)\u0007I\u0012\u0019#\u0001\u0012uKN$()\u001a4pe\u0016,\u0006\u000f\\8bIJ+GO]=XQ\u0016tgj\\*fO6,g\u000e\u001e\u0015\u0004g\t\r\u0012a\t;fgR\u0014UMZ8sKV\u0003Hn\\1e\u0003\u00124\u0018M\\2fgR{g*\u001a=u'R\fG/\u001a\u0015\u0004i\t\r\u0012A\t;fgR\u0014UMZ8sKV\u0003Hn\\1e\u001fZ,'\u000f\\1qa&twmU3h[\u0016tG\u000fK\u00026\u0005G\t\u0001d\u0019:fCR,G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)1\tYE!\u0016\u0003f\t=$Q\u0011BH\u0011\u001d\u00119F\u000ea\u0001\u00053\n1\u0001Z5s!\u0011\u0011YF!\u0019\u000e\u0005\tu#b\u0001B0W\u0006\u0011\u0011n\\\u0005\u0005\u0005G\u0012iF\u0001\u0003GS2,\u0007b\u0002B4m\u0001\u0007!\u0011N\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004B!!\u001d\u0003l%\u0019!Q\u000e\u001f\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007b\u0002B9m\u0001\u0007!1O\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\t\tU$\u0011Q\u0007\u0003\u0005oRA!a\u0019\u0003z)!!1\u0010B?\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0003\u0003\u0000\u0005e\u0015aB:u_J\fw-Z\u0005\u0005\u0005\u0007\u00139H\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0005\b\u0005\u000f3\u0004\u0019\u0001BE\u00039!\u0018.\u001a:j]\u001e,e.\u00192mK\u0012\u00042a\u0011BF\u0013\r\u0011i\t\u0012\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\tJ\u000ea\u0001\u0005\u0013\u000babY8na\u0006\u001cG/\u00128bE2,G\r")
public class TierArchiverStateTest {
    private CancellationContext ctx;
    private final MockTime mockTime = new MockTime();
    private final String tierTopicName;
    private final short tierTopicNumPartitions;
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(System.getProperty("java.io.tmpdir")));
    private final MockInMemoryTierObjectStoreConfig objectStoreConfig = new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1));
    private final MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), this.objectStoreConfig());
    private final TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private TierPartitionState[] tierPartitionStates = (TierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(TierPartitionState.class));
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), this.tierPartitionStateFactory(), (Option)None$.MODULE$);
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final ScheduledExecutorService blockingTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Time time = Time.SYSTEM;
    private final FiniteDuration maxWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private Meter byteRate;
    private final int brokerId;
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, this.brokerId(), 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public String tierTopicName() {
        return this.tierTopicName;
    }

    public short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public MockInMemoryTierObjectStoreConfig objectStoreConfig() {
        return this.objectStoreConfig;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierPartitionState[] tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public void tierPartitionStates_$eq(TierPartitionState[] x$1) {
        this.tierPartitionStates = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public Time time() {
        return this.time;
    }

    public FiniteDuration maxWaitTime() {
        return this.maxWaitTime;
    }

    public Meter byteRate() {
        return this.byteRate;
    }

    public void byteRate_$eq(Meter x$1) {
        this.byteRate = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    @BeforeEach
    public void setUp() {
        this.ctx_$eq(CancellationContext.newContext());
        new KafkaMetricsGroup(this.getClass()).removeMetric("TierArchiver.UploadRate");
        this.byteRate_$eq(new KafkaMetricsGroup(this.getClass()).newMeter("TierArchiver.UploadRate", "bytes", TimeUnit.SECONDS));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void tearDown() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates()), (Function1 & Serializable)x$3 -> {
            x$3.delete();
            return BoxedUnit.UNIT;
        });
        this.ctx().cancel();
    }

    @Test
    public void testAwaitingLeaderResult() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        new Properties().put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = this.createTierPartitionState(new File(this.logDirs().get(0)), topicIdPartition, logDirFailureChannel, true, false);
        this.tierReplicaManager().becomeLeader(tierPartitionState, 1);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 0, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testFailedInitLeaderRetryThenRestoreTriggeringBeforeLeader() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ERROR).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Future failedResultNextStage = failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResultAgain = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultNextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResultAgain.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED as status is still ERROR");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeLeader as correct epoch was never established in initial BeforeLeader");
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should correctly transition into BeforeUpload");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreNewerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        ArchiveTask resultCancelled = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)resultCancelled.ctx().isCancelled(), (String)"We are the stale leader and the task should be cancelled");
        Assertions.assertTrue((boolean)(resultCancelled.state() instanceof FailedState), (String)"We are the stale leader and the task should remain in FailedState");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreEqualEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreLowerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Future nextStage = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1).transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testAwaitingLeaderResultFenced() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrError((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), topicIdPartition, (TierTopicAppender)tierTopicManager, 1, replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testRestoreFencedException() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.RESTORE_FENCED));
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -1L;
        long x$8 = 0L;
        String x$9 = "delete";
        int x$10 = 0xA00000;
        String x$11 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$12 = 60000L;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 150, x$6, x$7, x$8, x$9, 65536, 1, x$10, x$11, x$12, true, x$13, x$14, x$15, x$16, x$17, x$18);
        File logDir = Paths.get(TestUtils.tempDirectory(null, null).getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MergedLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, new BrokerTopicStats(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), 0L, 0L, 300000, new ProducerStateManagerConfig(3600000), 600000, this.tierLogComponents(), logDirFailureChannel, LogOffsetsListener.NO_OP_OFFSETS_LISTENER, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertThrows(TierArchiverRestoreFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadFenced() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadRetryWhenNoSegment() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)scala.package$.MODULE$.List().empty());
        Mockito.when((Object)log.activeSegment()).thenReturn(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testBeforeUploadAdvancesToNextState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -1L;
        long x$8 = 0L;
        String x$9 = "delete";
        int x$10 = 0xA00000;
        String x$11 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$12 = 60000L;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 150, x$6, x$7, x$8, x$9, 65536, 1, x$10, x$11, x$12, true, x$13, x$14, x$15, x$16, x$17, x$18);
        File logDir = Paths.get(TestUtils.tempDirectory(null, null).getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MergedLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, new BrokerTopicStats(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), 0L, 0L, 300000, new ProducerStateManagerConfig(3600000), 600000, this.tierLogComponents(), logDirFailureChannel, LogOffsetsListener.NO_OP_OFFSETS_LISTENER, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>());
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to AfterUpload");
    }

    @Test
    public void testBeforeUploadOverlappingSegment() {
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -1L;
        long x$8 = 0L;
        String x$9 = "delete";
        int x$10 = 0xA00000;
        String x$11 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$12 = 60000L;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 1000, x$6, x$7, x$8, x$9, 65536, 1, x$10, x$11, x$12, true, x$13, x$14, x$15, x$16, x$17, x$18);
        File logDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils.tempDirectory(null, null));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(logDir);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = this.createTierPartitionState(logDir, topicIdPartition, logDirFailureChannel, true, false);
        tierPartitionState.beginCatchup();
        tierPartitionState.onCatchUpComplete();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierPartitionStateFactory().mayEnableTiering(topicPartition, logConfig))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicIdPartition.topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockScheduler x$23 = this.mockTime().scheduler();
        BrokerTopicStats x$24 = new BrokerTopicStats();
        Metrics x$25 = new Metrics();
        MockTime x$26 = this.mockTime();
        ProducerStateManagerConfig x$28 = new ProducerStateManagerConfig(3600000);
        None$ x$30 = None$.MODULE$;
        TierLogComponents x$32 = this.tierLogComponents();
        None$ x$35 = None$.MODULE$;
        LogOffsetsListener x$36 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$37 = None$.MODULE$;
        ConcurrentHashMap x$38 = new ConcurrentHashMap();
        MergedLog log = MergedLog$.MODULE$.apply(logDir, logConfig, 0L, 0L, (Scheduler)x$23, x$24, x$25, (Time)x$26, 300000, x$28, 600000, (Option)x$30, logDirFailureChannel, x$32, true, (Option)x$35, true, x$36, (Option)x$37, x$38);
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState, topicIdPartition, 0, UUID.randomUUID(), 0L, 60L, 15000L, 15000L, 1000, false, false, false, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        int newTierEpoch = 1;
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, newTierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        log.updateHighWatermark(log.logEndOffset());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<CompletableFuture<TierPartitionState.AppendResult>>(null, tierPartitionState){
            private final TierPartitionState tierPartitionState$1;

            public CompletableFuture<TierPartitionState.AppendResult> answer(InvocationOnMock invocation) {
                AbstractTierMetadata metadata = (AbstractTierMetadata)invocation.getArgument(0);
                return CompletableFuture.completedFuture(this.tierPartitionState$1.append(metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(newTierEpoch), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to Upload");
    }

    private TierPartitionState createTierPartitionState(File dir, TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean tieringEnabled, boolean compactEnabled) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, logDirFailureChannel, topicIdPartition.topicPartition(), tieringEnabled, (Scheduler)this.mockTime().scheduler(), false, compactEnabled, (Time)this.mockTime(), TierPartitionStateCleanupConfig.EMPTY, false, -1);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates_$eq((TierPartitionState[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates()), (Object)tierPartitionState, ClassTag$.MODULE$.apply(TierPartitionState.class)));
        return tierPartitionState;
    }

    public TierArchiverStateTest() {
        this.tierTopicName = "_confluent-tier-state";
        this.tierTopicNumPartitions = 1;
        this.brokerId = 1;
    }
}

