/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005M2AAB\u0004\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u00019\t)rJ\u001a4tKRl\u0015\r]*vaBd\u0017.\u001a:UKN$(B\u0001\u0005\n\u0003)\u0019w.\u001c9bGRLwN\u001c\u0006\u0003\u0015-\tQ\u0001^1tWNT!\u0001D\u0007\u0002\tQLWM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aB\u0001\u0016i\u0016\u001cHo\u00144gg\u0016$X*\u00199TkB\u0004H.[3s)\u0005i\u0002C\u0001\n\u001f\u0013\ty2C\u0001\u0003V]&$\bF\u0001\u0002\"!\t\u00113&D\u0001$\u0015\t!S%A\u0002ba&T!AJ\u0014\u0002\u000f),\b/\u001b;fe*\u0011\u0001&K\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002U\u0005\u0019qN]4\n\u00051\u001a#\u0001\u0002+fgR\fA\u0003^3tiN+GOT;n\u001b\u0006\u00048\u000fT1sO\u0016\u0014\bFA\u0002\"\u0003U!Xm\u001d;TKRtU/\\'baN\u001cV.\u00197mKJD#\u0001B\u0011\u00023Q,7\u000f^\"iC:<Wm\u00144gg\u0016$X*\u00199NK6|'/\u001f\u0015\u0003\u000b\u0005\u0002")
public class OffsetMapSupplierTest {
    @Test
    public void testOffsetMapSupplier() {
        int maxNumMaps = 2;
        int memory = 1024;
        OffsetMapSupplier offsetMapSupplier = new OffsetMapSupplier(maxNumMaps, memory);
        OffsetMap offsetMap1 = offsetMapSupplier.getOffsetMap();
        Assertions.assertEquals((int)0, (int)offsetMap1.size());
        OffsetMap offsetMap2 = offsetMapSupplier.getOffsetMap();
        Assertions.assertEquals((int)0, (int)offsetMap2.size());
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> offsetMapSupplier.getOffsetMap(), ClassTag$.MODULE$.apply(TierMetadataRetriableException.class), new Position("OffsetMapSupplierTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        offsetMap1.put(ByteBuffer.allocate(10), 100L);
        Assertions.assertEquals((int)1, (int)offsetMap1.size());
        offsetMapSupplier.reclaimOffsetMap(offsetMap1);
        OffsetMap offsetMap3 = offsetMapSupplier.getOffsetMap();
        Assertions.assertEquals((int)0, (int)offsetMap3.size());
    }

    @Test
    public void testSetNumMapsLarger() {
        int maxNumMaps = 2;
        int memory = 1024;
        int newNumMaps = 4;
        OffsetMapSupplier offsetMapSupplier = new OffsetMapSupplier(maxNumMaps, memory);
        offsetMapSupplier.getOffsetMap();
        offsetMapSupplier.getOffsetMap();
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> offsetMapSupplier.getOffsetMap(), ClassTag$.MODULE$.apply(TierMetadataRetriableException.class), new Position("OffsetMapSupplierTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        offsetMapSupplier.reconfigure(newNumMaps, memory);
        offsetMapSupplier.getOffsetMap();
        offsetMapSupplier.getOffsetMap();
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> offsetMapSupplier.getOffsetMap(), ClassTag$.MODULE$.apply(TierMetadataRetriableException.class), new Position("OffsetMapSupplierTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
    }

    @Test
    public void testSetNumMapsSmaller() {
        int maxNumMaps = 2;
        int memory = 1024;
        int newNumMaps = 1;
        OffsetMapSupplier offsetMapSupplier = new OffsetMapSupplier(maxNumMaps, memory);
        OffsetMap offsetMap1 = offsetMapSupplier.getOffsetMap();
        OffsetMap offsetMap2 = offsetMapSupplier.getOffsetMap();
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> offsetMapSupplier.getOffsetMap(), ClassTag$.MODULE$.apply(TierMetadataRetriableException.class), new Position("OffsetMapSupplierTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        offsetMapSupplier.reconfigure(newNumMaps, memory);
        offsetMapSupplier.reclaimOffsetMap(offsetMap1);
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> offsetMapSupplier.getOffsetMap(), ClassTag$.MODULE$.apply(TierMetadataRetriableException.class), new Position("OffsetMapSupplierTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        offsetMapSupplier.reclaimOffsetMap(offsetMap2);
        offsetMapSupplier.getOffsetMap();
    }

    @Test
    public void testChangeOffsetMapMemory() {
        int maxNumMaps = 2;
        int memory = 1024;
        int newMemory = 2048;
        OffsetMapSupplier offsetMapSupplier = new OffsetMapSupplier(maxNumMaps, memory);
        OffsetMap map1 = offsetMapSupplier.getOffsetMap();
        OffsetMap map2 = offsetMapSupplier.getOffsetMap();
        Assertions.assertEquals((int)memory, (int)map1.memory());
        Assertions.assertEquals((int)memory, (int)map2.memory());
        offsetMapSupplier.reconfigure(maxNumMaps, newMemory);
        offsetMapSupplier.reclaimOffsetMap(map1);
        OffsetMap newMap1 = offsetMapSupplier.getOffsetMap();
        Assertions.assertEquals((int)newMemory, (int)newMap1.memory());
        offsetMapSupplier.reclaimOffsetMap(map2);
        OffsetMap newMap2 = offsetMapSupplier.getOffsetMap();
        Assertions.assertEquals((int)newMemory, (int)newMap2.memory());
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> offsetMapSupplier.getOffsetMap(), ClassTag$.MODULE$.apply(TierMetadataRetriableException.class), new Position("OffsetMapSupplierTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }
}

