/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.MergedLog$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.exceptions.TierSnapshotChecksumValidationFailedException;
import kafka.tier.exceptions.TierSnapshotDelayedRetryException;
import kafka.tier.exceptions.TierSnapshotFailedException;
import kafka.tier.exceptions.TierSnapshotFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.SnapshotTasksConfig;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask$;
import kafka.tier.tasks.snapshot.SnapshotTestUtils;
import kafka.tier.tasks.snapshot.TierMetadataSnapshotManager;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015c\u0001\u0002(P\u0001aCQa\u0018\u0001\u0005\u0002\u0001D\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00013\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0003\u0001\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003f\u0011\u001d9\b\u00011A\u0005\u0004aDqA \u0001A\u0002\u0013\u0005q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015B=\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013\u0005\u0011q\u0001\u0005\f\u0003+\u0001\u0001\u0019!a\u0001\n\u0003\t9\u0002C\u0006\u0002\u001c\u0001\u0001\r\u0011!Q!\n\u0005%\u0001bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0001\u0003?A1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002:!Y\u0011Q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0011\u0011-\ty\u0004\u0001a\u0001\u0002\u0004%\t!!\u0011\t\u0017\u0005-\u0003\u00011AA\u0002\u0013\u0005\u0011Q\n\u0005\f\u0003#\u0002\u0001\u0019!A!B\u0013\t\u0019\u0005C\u0006\u0002T\u0001\u0001\r\u00111A\u0005\u0002\u0005U\u0003bCA2\u0001\u0001\u0007\t\u0019!C\u0001\u0003KB1\"!\u001b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002X!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002p!I\u0011Q\u0010\u0001C\u0002\u0013\u0005\u0011q\u0010\u0005\t\u0003\u001b\u0003\u0001\u0015!\u0003\u0002\u0002\"I\u0011q\u0012\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003;\u0003\u0001\u0015!\u0003\u0002\u0014\"I\u0011q\u0014\u0001C\u0002\u0013\u0005\u0011\u0011\u0015\u0005\t\u0003_\u0003\u0001\u0015!\u0003\u0002$\"I\u0011\u0011\u0017\u0001C\u0002\u0013\u0005\u00111\u0017\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u00026\"I\u00111\u0019\u0001C\u0002\u0013\u0005\u0011Q\u0019\u0005\t\u0003\u001b\u0004\u0001\u0015!\u0003\u0002H\"I\u0011q\u001a\u0001C\u0002\u0013\u0005\u0011\u0011\u001b\u0005\t\u00033\u0004\u0001\u0015!\u0003\u0002T\"I\u00111\u001c\u0001C\u0002\u0013\u0005\u0011Q\u001c\u0005\t\u0003W\u0004\u0001\u0015!\u0003\u0002`\"I\u0011Q\u001e\u0001C\u0002\u0013\u0005\u0011q\u001e\u0005\t\u0003o\u0004\u0001\u0015!\u0003\u0002r\"I\u0011\u0011 \u0001C\u0002\u0013\u0005\u0011q\u001e\u0005\t\u0003w\u0004\u0001\u0015!\u0003\u0002r\"I\u0011Q \u0001C\u0002\u0013\u0005\u0011q \u0005\t\u0005\u001f\u0001\u0001\u0015!\u0003\u0003\u0002!I!\u0011\u0003\u0001C\u0002\u0013\u0005!1\u0003\u0005\t\u00057\u0001\u0001\u0015!\u0003\u0003\u0016!I!Q\u0004\u0001C\u0002\u0013\u0005!q\u0004\u0005\t\u0005O\u0001\u0001\u0015!\u0003\u0003\"!Y!\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0016\u0011-\u0011\u0019\u0004\u0001a\u0001\u0002\u0004%\tA!\u000e\t\u0017\te\u0002\u00011A\u0001B\u0003&!Q\u0006\u0005\n\u0005w\u0001!\u0019!C\u0001\u0003_D\u0001B!\u0010\u0001A\u0003%\u0011\u0011\u001f\u0005\f\u0005\u007f\u0001\u0001\u0019!a\u0001\n\u0003\u0011\t\u0005C\u0006\u0003P\u0001\u0001\r\u00111A\u0005\u0002\tE\u0003b\u0003B+\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0007B1Ba\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003B!Y!\u0011\f\u0001A\u0002\u0003\u0007I\u0011\u0001B.\u0011-\u0011y\u0006\u0001a\u0001\u0002\u0003\u0006KAa\u0011\t\u0017\t\u0005\u0004\u00011AA\u0002\u0013\u0005!1\r\u0005\f\u0005k\u0002\u0001\u0019!a\u0001\n\u0003\u00119\bC\u0006\u0003|\u0001\u0001\r\u0011!Q!\n\t\u0015\u0004b\u0003B?\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u007fB1Ba\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\n\"Y!Q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BA\u0011%\u0011y\t\u0001b\u0001\n\u0003\u0011\t\n\u0003\u0005\u0003 \u0002\u0001\u000b\u0011\u0002BJ\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0005GCqAa/\u0001\t\u0003\u0011\u0019\u000bC\u0004\u0003F\u0002!\tAa)\t\u000f\t=\u0007\u0001\"\u0001\u0003$\"9!1\u001b\u0001\u0005\u0002\t\r\u0006b\u0002Bl\u0001\u0011\u0005!1\u0015\u0005\b\u00057\u0004A\u0011\u0001BR\u0011\u001d\u0011y\u000e\u0001C\u0001\u0005CDqa!\t\u0001\t\u0003\u0011\u0019\u000bC\u0004\u0004&\u0001!\tAa)\t\u000f\r%\u0002\u0001\"\u0001\u0003$\"91Q\u0006\u0001\u0005\u0002\r=\u0002bBB\u001d\u0001\u0011\u000511\b\u0002\u0019\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R$\u0016m]6UKN$(B\u0001)R\u0003!\u0019h.\u00199tQ>$(B\u0001*T\u0003\u0015!\u0018m]6t\u0015\t!V+\u0001\u0003uS\u0016\u0014(\"\u0001,\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0017\t\u00035vk\u0011a\u0017\u0006\u00029\u0006)1oY1mC&\u0011al\u0017\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0007C\u00012\u0001\u001b\u0005y\u0015\u0001C3yK\u000e,Ho\u001c:\u0016\u0003\u0015\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002kW\u0006!Q\u000f^5m\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\4\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\fA\"\u001a=fGV$xN]0%KF$\"!\u001d;\u0011\u0005i\u0013\u0018BA:\\\u0005\u0011)f.\u001b;\t\u000fU\u001c\u0011\u0011!a\u0001K\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\u0015DXmY;u_J\u0004\u0013AA3d+\u0005I\bC\u0001>}\u001b\u0005Y(B\u00015\\\u0013\ti8P\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061QmY0%KF$2!]A\u0001\u0011\u001d)h!!AA\u0002e\f1!Z2!\u0003\r\u0019G\u000f_\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0019\u0016a\u00024fi\u000eDWM]\u0005\u0005\u0003'\tiAA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/A\u0004dib|F%Z9\u0015\u0007E\fI\u0002\u0003\u0005v\u0013\u0005\u0005\t\u0019AA\u0005\u0003\u0011\u0019G\u000f\u001f\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0005\t\u0005\u0003G\t\u0019$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0019\u0019w.\\7p]*\u0019a+a\u000b\u000b\t\u00055\u0012qF\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0012aA8sO&!\u0011QGA\u0013\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR\u0019\u0011/a\u000f\t\u0011Ud\u0011\u0011!a\u0001\u0003C\tq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:,\"!a\u0011\u0011\t\u0005\u0015\u0013qI\u0007\u0002'&\u0019\u0011\u0011J*\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0001\u0006;pa&\u001c\u0017\n\u001a)beRLG/[8o?\u0012*\u0017\u000fF\u0002r\u0003\u001fB\u0001\"^\b\u0002\u0002\u0003\u0007\u00111I\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0005\u0005]\u0003\u0003BA-\u0003?j!!a\u0017\u000b\t\u0005u\u0013QE\u0001\u0006kRLGn]\u0005\u0005\u0003C\nYF\u0001\u0005N_\u000e\\G+[7f\u00031iwnY6US6,w\fJ3r)\r\t\u0018q\r\u0005\tkJ\t\t\u00111\u0001\u0002X\u0005IQn\\2l)&lW\rI\u0001\u0011i&,'\u000fV8qS\u000el\u0015M\\1hKJ,\"!a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001eT\u0003\u0015!x\u000e]5d\u0013\u0011\tI(a\u001d\u0003!QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\u0018!\u0005;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3sA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAAA!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD+\u000611/\u001a:wKJLA!a#\u0002\u0006\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u00071|w-\u0006\u0002\u0002\u0014B!\u0011QSAM\u001b\t\t9JC\u0002\u0002\u0010VKA!a'\u0002\u0018\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003\u0011awn\u001a\u0011\u0002\u0013A\f'\u000f^5uS>tWCAAR!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAU+\u000691\r\\;ti\u0016\u0014\u0018\u0002BAW\u0003O\u0013\u0011\u0002U1si&$\u0018n\u001c8\u0002\u0015A\f'\u000f^5uS>t\u0007%A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f+\t\t)\f\u0005\u0003\u00028\u0006uVBAA]\u0015\r\tYlU\u0001\u0006gR|'/Z\u0005\u0005\u0003\u007f\u000bILA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007%\u0001\u000ej]6+W\u000eV5fe>\u0013'.Z2u'R|'/Z\"p]\u001aLw-\u0006\u0002\u0002HB!\u0011qWAe\u0013\u0011\tY-!/\u0003C5{7m[%o\u001b\u0016lwN]=US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0007>tg-[4\u00027%tW*Z7US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0007>tg-[4!\u0003QIg.T3n)&,'o\u00142kK\u000e$8\u000b^8sKV\u0011\u00111\u001b\t\u0005\u0003o\u000b).\u0003\u0003\u0002X\u0006e&aG'pG.Le.T3n_JLH+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\u000bj]6+W\u000eV5fe>\u0013'.Z2u'R|'/\u001a\u0011\u0002%QLWM\u001d)beRLG/[8o'R\fG/Z\u000b\u0003\u0003?\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0004\u0003K\u001c\u0016!B:uCR,\u0017\u0002BAu\u0003G\u0014!\u0003V5feB\u000b'\u000f^5uS>t7\u000b^1uK\u0006\u0019B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fA\u0005A!M]8lKJLE-\u0006\u0002\u0002rB\u0019!,a=\n\u0007\u0005U8LA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u001fMt\u0017\r]:i_R$\u0006N]3bIN\f\u0001c\u001d8baNDw\u000e\u001e+ie\u0016\fGm\u001d\u0011\u0002%Mt\u0017\r]:i_R$\u0016m]6D_:4\u0017nZ\u000b\u0003\u0005\u0003\u0001RA\u0017B\u0002\u0005\u000fI1A!\u0002\\\u0005\u0019y\u0005\u000f^5p]B!!\u0011\u0002B\u0006\u001b\u0005\t\u0016b\u0001B\u0007#\n\u00192K\\1qg\"|G\u000fV1tWN\u001cuN\u001c4jO\u0006\u00192O\\1qg\"|G\u000fV1tW\u000e{gNZ5hA\u0005yA/[3s)\u0006\u001c8n]\"p]\u001aLw-\u0006\u0002\u0003\u0016A!!\u0011\u0002B\f\u0013\r\u0011I\"\u0015\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\u0006\u0001B/[3s)\u0006\u001c8n]\"p]\u001aLw\rI\u0001\u0010g:\f\u0007o\u001d5pi6+GO]5dgV\u0011!\u0011\u0005\t\u0004E\n\r\u0012b\u0001B\u0013\u001f\n9R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^'fiJL7m]\u0001\u0011g:\f\u0007o\u001d5pi6+GO]5dg\u0002\n1b[1gW\u0006\u001cuN\u001c4jOV\u0011!Q\u0006\t\u0005\u0003\u0007\u0013y#\u0003\u0003\u00032\u0005\u0015%aC&bM.\f7i\u001c8gS\u001e\fqb[1gW\u0006\u001cuN\u001c4jO~#S-\u001d\u000b\u0004c\n]\u0002\u0002C;0\u0003\u0003\u0005\rA!\f\u0002\u0019-\fgm[1D_:4\u0017n\u001a\u0011\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\rY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eI\u0001\u0007i6\u0004H)\u001b:\u0016\u0005\t\r\u0003\u0003\u0002B#\u0005\u0017j!Aa\u0012\u000b\u0007\t%3.\u0001\u0002j_&!!Q\nB$\u0005\u00111\u0015\u000e\\3\u0002\u0015Ql\u0007\u000fR5s?\u0012*\u0017\u000fF\u0002r\u0005'B\u0001\"\u001e\u001b\u0002\u0002\u0003\u0007!1I\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u0006QAn\\4ESJ|F%Z9\u0015\u0007E\u0014i\u0006\u0003\u0005vo\u0005\u0005\t\u0019\u0001B\"\u0003\u001dawn\u001a#je\u0002\nAb\u001d8baNDw\u000e^:ESJ,\"A!\u001a\u0011\t\t\u001d$\u0011O\u0007\u0003\u0005SRAAa\u001b\u0003n\u0005!a-\u001b7f\u0015\r\u0011yg[\u0001\u0004]&|\u0017\u0002\u0002B:\u0005S\u0012A\u0001U1uQ\u0006\u00012O\\1qg\"|Go\u001d#je~#S-\u001d\u000b\u0004c\ne\u0004\u0002C;;\u0003\u0003\u0005\rA!\u001a\u0002\u001bMt\u0017\r]:i_R\u001cH)\u001b:!\u0003%!Xm\u001d;Vi&d7/\u0006\u0002\u0003\u0002B\u0019!Ma!\n\u0007\t\u0015uJA\tT]\u0006\u00048\u000f[8u)\u0016\u001cH/\u0016;jYN\fQ\u0002^3tiV#\u0018\u000e\\:`I\u0015\fHcA9\u0003\f\"AQ/PA\u0001\u0002\u0004\u0011\t)\u0001\u0006uKN$X\u000b^5mg\u0002\n\u0001\u0003Z3gCVdG/Q<bSR$\u0016.\\3\u0016\u0005\tM\u0005\u0003\u0002BK\u00057k!Aa&\u000b\u0007\te50\u0001\u0005ekJ\fG/[8o\u0013\u0011\u0011iJa&\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\tB-\u001a4bk2$\u0018i^1jiRKW.\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0003ED3!\u0011BT!\u0011\u0011IKa.\u000e\u0005\t-&\u0002\u0002BW\u0005_\u000b1!\u00199j\u0015\u0011\u0011\tLa-\u0002\u000f),\b/\u001b;fe*!!QWA\u0018\u0003\u0015QWO\\5u\u0013\u0011\u0011ILa+\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0011%q\u0018\t\u0005\u0005S\u0013\t-\u0003\u0003\u0003D\n-&!C!gi\u0016\u0014X)Y2i\u0003u!Xm\u001d;CK\u001a|'/\u001a'fC\u0012,'o\u00158baNDw\u000e^*uCR,\u0007fA\"\u0003JB!!\u0011\u0016Bf\u0013\u0011\u0011iMa+\u0003\tQ+7\u000f^\u0001 i\u0016\u001cHOQ3g_J,W*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^*uCR,\u0007f\u0001#\u0003J\u0006\u0019C/Z:u)\u0006\u001c8nQ1oG\u0016dG.\u0019;j_:\fe\u000eZ\"p]\u001aLw-\u00169eCR,\u0007fA#\u0003J\u0006\u0001C/Z:u':\f\u0007o\u001d5piR\u000b7o[*fiN\u0004\u0016-^:f\u001f:\u0014V\r\u001e:zQ\r1%\u0011Z\u0001-i\u0016\u001cHo\u00158baNDw\u000e\u001e+bg.\u001c\u0015M\\2fY2,Gm\u00165f]2{w\rR5s\u0013N$U\r\\3uK\u0012D3a\u0012Be\u00031!Xm\u001d;T]\u0006\u00048\u000f[8u)\r\t(1\u001d\u0005\b\u0005KD\u0005\u0019\u0001Bt\u0003\u0011\tGnZ8\u0011\t\t%(\u0011_\u0007\u0003\u0005WTAA!<\u0003p\u0006A1\r[3dWN,XNC\u0002\u0002^UKAAa=\u0003l\nI\u0011\t\\4pe&$\b.\u001c\u0015\f\u0011\n]8qAB\u0005\u0007\u0017\u0019i\u0001\u0005\u0003\u0003z\u000e\rQB\u0001B~\u0015\u0011\u0011iPa@\u0002\u0011A\u0014xN^5eKJTAa!\u0001\u00030\u00061\u0001/\u0019:b[NLAa!\u0002\u0003|\nQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0005\t\u001d\u0018!\u00028b[\u0016\u001cH\u0006BB\b\u0007'\t#a!\u0005\u0002\u000b\u0005#E*\u0012*\"\u0005\rU\u0011a\u0003(P?\u000eCUiQ&T+6C3\u0001SB\r!\u0011\u0019Yb!\b\u000e\u0005\t}\u0018\u0002BB\u0010\u0005\u007f\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003a\"Xm\u001d;T]\u0006\u00048\u000f[8u)\u0006\\WM\\!u\u0019\u0006$XM](gMN,G\u000f\u00165b]Ns\u0017\r]:i_RLe.\u001b;jCR,wJ\u001a4tKRD3!\u0013Be\u0003-\"Xm\u001d;T]\u0006\u00048\u000f[8u+Bdw.\u00193GC&d7\u000fR;f)>LeN^1mS\u0012\u001c\u0005.Z2lgVl\u0007f\u0001&\u0003J\u0006QC/Z:u\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGRLwN\\*uCR,\u0007fA&\u0003J\u00061B/Z:u':\f\u0007o\u001d5piV+\u0018\u000eZ*fCJ\u001c\u0007\u000eF\u0002r\u0007cAqA!:M\u0001\u0004\u00119\u000fK\u0006M\u0005o\u001c9a!\u0003\u0004\f\rUB\u0006BB\b\u0007'A3\u0001TB\r\u0003U!Xm\u001d;QCJ\u001cXm\u00158baNDw\u000e\u001e)bi\"$2!]B\u001f\u0011\u001d\u0011)/\u0014a\u0001\u0005OD3\"\u0014B|\u0007\u000f\u0019Iaa\u0003\u0004B1\"1qBB\nQ\ri5\u0011\u0004")
public class MetadataSnapshotTaskTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private CancellationContext ctx;
    private TopicPartition topicPartition;
    private TopicIdPartition topicIdPartition;
    private MockTime mockTime;
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
    private final Partition partition = (Partition)Mockito.mock(Partition.class);
    private final TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final MockInMemoryTierObjectStoreConfig inMemTierObjectStoreConfig = new MockInMemoryTierObjectStoreConfig(Optional.of(UUID.randomUUID().toString()), Optional.of(Predef$.MODULE$.int2Integer(0)), "");
    private final MockInMemoryTierObjectStore inMemTierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), this.inMemTierObjectStoreConfig());
    private final TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
    private final int brokerId;
    private final int snapshotThreads;
    private final Option<SnapshotTasksConfig> snapshotTaskConfig = new Some((Object)new SnapshotTasksConfig(java.time.Duration.ofSeconds(30L).toMillis(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
    private final TierTasksConfig tierTasksConfig;
    private final MetadataSnapshotMetrics snapshotMetrics;
    private KafkaConfig kafkaConfig;
    private final int leaderEpoch;
    private File tmpDir;
    private File logDir;
    private Path snapshotsDir;
    private SnapshotTestUtils testUtils;
    private final FiniteDuration defaultAwaitTime;

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public void mockTime_$eq(MockTime x$1) {
        this.mockTime = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public AbstractLog log() {
        return this.log;
    }

    public Partition partition() {
        return this.partition;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public MockInMemoryTierObjectStoreConfig inMemTierObjectStoreConfig() {
        return this.inMemTierObjectStoreConfig;
    }

    public MockInMemoryTierObjectStore inMemTierObjectStore() {
        return this.inMemTierObjectStore;
    }

    public TierPartitionState tierPartitionState() {
        return this.tierPartitionState;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int snapshotThreads() {
        return this.snapshotThreads;
    }

    public Option<SnapshotTasksConfig> snapshotTaskConfig() {
        return this.snapshotTaskConfig;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public MetadataSnapshotMetrics snapshotMetrics() {
        return this.snapshotMetrics;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public void kafkaConfig_$eq(KafkaConfig x$1) {
        this.kafkaConfig = x$1;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public Path snapshotsDir() {
        return this.snapshotsDir;
    }

    public void snapshotsDir_$eq(Path x$1) {
        this.snapshotsDir = x$1;
    }

    public SnapshotTestUtils testUtils() {
        return this.testUtils;
    }

    public void testUtils_$eq(SnapshotTestUtils x$1) {
        this.testUtils = x$1;
    }

    public FiniteDuration defaultAwaitTime() {
        return this.defaultAwaitTime;
    }

    @BeforeEach
    public void setup() {
        this.executor_$eq(Executors.newFixedThreadPool(this.snapshotThreads()));
        this.ctx_$eq(CancellationContext.newContext());
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.snapshotsDir_$eq(this.logDir().toPath().resolve("snapshots"));
        Files.createDirectory(this.snapshotsDir(), new FileAttribute[0]);
        int x$1 = this.brokerId();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = TestUtils$.MODULE$.MockZkPort();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var22_11 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var23_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var24_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        this.kafkaConfig_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21)));
        File parseTopicPartitionName_dir = this.logDir();
        Object var25_25 = null;
        this.topicPartition_$eq(LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir));
        this.topicIdPartition_$eq(new TopicIdPartition(this.topicPartition().topic(), UUID.randomUUID(), this.topicPartition().partition()));
        this.mockTime_$eq(new MockTime(0L, 0L, 0L));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)this.log().tierPartitionState()).thenReturn((Object)this.tierPartitionState());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.log().dir()).thenReturn((Object)this.logDir());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierPartitionState().isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.tierPartitionState().tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch()));
        Mockito.when((Object)this.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch((long)this.leaderEpoch(), Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierMetadataSnapshotUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
    }

    @AfterEach
    public void tearDown() {
        this.executor().shutdownNow();
        if (this.log() != null) {
            this.log().close();
        }
        Utils.delete((File)this.tmpDir(), (boolean)false);
        Utils.delete((File)this.logDir(), (boolean)false);
        Utils.delete((File)this.snapshotsDir().toFile(), (boolean)true);
        this.ctx().cancel();
    }

    @Test
    public void testBeforeLeaderSnapshotState() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$1(true, false), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("is undergoing unclean leader recovery"), (String)"Unexpected cause for exception");
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            boolean x$2 = false;
            return (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$1(x$2, true), (Duration)this.defaultAwaitTime());
        });
        if (try_2 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }
        if (!(try_2 instanceof Failure)) {
            throw new MatchError((Object)try_2);
        }
        Throwable ex2 = ((Failure)try_2).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex2.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex2.getMessage().contains("is undergoing tier metadata recovery"), (String)"Unexpected cause for exception");
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$1(false, false), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_3 instanceof Failure) {
            Throwable ex3 = ((Failure)try_3).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex3).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        throw new MatchError((Object)try_3);
    }

    @Test
    public void testBeforeMetadataSnapshotState() {
        this.mockTime().sleep(java.time.Duration.ofSeconds(10L).toMillis());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$2(java.time.Duration.ofSeconds(9L).toMillis()), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierSnapshotDelayedRetryException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("delay retry"), (String)"Unexpected cause for exception");
        this.mockTime().sleep(java.time.Duration.ofSeconds(50L).toMillis());
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$2(java.time.Duration.ofSeconds(9L).toMillis()), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex2 = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex2).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$2(-1L), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotState.class, nextState2.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_3 instanceof Failure) {
            Throwable ex3 = ((Failure)try_3).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex3).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        }
        throw new MatchError((Object)try_3);
    }

    @Test
    public void testTaskCancellationAndConfigUpdate() {
        String baseNameStr = MergedLog$.MODULE$.tierStateFile(this.logDir(), 0L, "").getName();
        FileTierPartitionStateSnapshotObject snapshotMetadata = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), 123L, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, Algorithm.ADLER);
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), UUID.randomUUID(), new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        .colon.colon states = new .colon.colon((Object)new MetadataSnapshotTask.BeforeLeaderSnapshotState(this.leaderEpoch()), (List)new .colon.colon((Object)new MetadataSnapshotTask.BeforeMetadataSnapshotState(this.leaderEpoch()), (List)new .colon.colon((Object)new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate), (List)new .colon.colon((Object)new MetadataSnapshotTask.AfterMetadataSnapshotState(this.leaderEpoch(), this.snapshotsDir(), snapshotInitiate, snapshotMetadata), (List)new .colon.colon((Object)new MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState(this.leaderEpoch()), (List)new .colon.colon((Object)new MetadataSnapshotTask.FailedMetadataSnapshotState(this.leaderEpoch()), (List)Nil$.MODULE$))))));
        TierTasks tierTasks = new TierTasks(this.tierTasksConfig(), this.replicaManager(), (TierReplicaManager)Mockito.mock(TierReplicaManager.class), (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class), (TierTopicAppender)Mockito.mock(TierTopicManager.class), (TierObjectStore)new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(this.brokerId()))), (Time)this.mockTime());
        Assertions.assertEquals((int)this.tierTasksConfig().numSnapshotThreads(), (int)((ThreadPoolExecutor)tierTasks.snapshotExecutor()).getCorePoolSize());
        Assertions.assertEquals((Object)this.tierTasksConfig(), (Object)((TierMetadataSnapshotManager)tierTasks.tierMetadataSnapshotManager().get()).config());
        this.cancelledTasksDoNotProgress$1((List)states);
        int x$1 = this.tierTasksConfig().numArchiverThreads();
        int x$2 = this.tierTasksConfig().numCleanerThreads();
        int x$3 = this.tierTasksConfig().numSnapshotThreads();
        int x$4 = this.tierTasksConfig().brokerId();
        None$ x$5 = None$.MODULE$;
        long x$6 = 600000L;
        long x$7 = 500L;
        int x$8 = 50;
        int x$9 = 300000;
        boolean x$10 = false;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        TierTasksConfig newTierTasksConfig = new TierTasksConfig(x$1, x$2, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, (Option)x$12, (Option)x$5);
        this.disabledConfigCancelsProgress$1((List)states, newTierTasksConfig);
    }

    @Test
    public void testSnapshotTaskSetsPauseOnRetry() {
        MetadataSnapshotTask.BeforeMetadataSnapshotState state = new MetadataSnapshotTask.BeforeMetadataSnapshotState(this.leaderEpoch());
        MetadataSnapshotTask task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.tierPartitionState().lastSnapshotTimestampMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)java.time.Duration.ofSeconds(5L).toMillis()));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TierMetadataRetriableException("foo"), new TierObjectStoreRetriableException("bar")});
        this.mockTime().sleep(java.time.Duration.ofSeconds(100L).toMillis());
        MetadataSnapshotTask result1 = (MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result1.pausedUntil().isDefined(), (String)"task should be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"task should not be cancelled");
        Instant pauseTime1 = (Instant)result1.pausedUntil().get();
        this.mockTime().sleep(java.time.Duration.ofSeconds(100L).toMillis());
        MetadataSnapshotTask result2 = (MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result2.pausedUntil().isDefined(), (String)"task should be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"task should not be cancelled");
        Assertions.assertTrue((boolean)((Instant)result2.pausedUntil().get()).isAfter(pauseTime1), (String)"second pause time should be greater than first pause time");
    }

    @Test
    public void testSnapshotTaskCancelledWhenLogDirIsDeleted() {
        UUID snapshotId = UUID.randomUUID();
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        MetadataSnapshotTask.MetadataSnapshotState state = new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate);
        MetadataSnapshotTask task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        Utils.delete((File)this.logDir(), (boolean)false);
        Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)this.ctx().isCancelled(), (String)"task should be cancelled after logDir was not found");
        Assertions.assertTrue((boolean)task.isErrorState());
        Assertions.assertEquals(NoSuchFileException.class, task.errorState().get().getClass());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)None$.MODULE$);
        task = new MetadataSnapshotTask(this.ctx(), this.topicIdPartition(), (MetadataSnapshotTask.MetadataSnapshotTaskState)state, this.snapshotMetrics(), this.brokerId());
        Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)this.ctx().isCancelled(), (String)"task should be cancelled after logDir was not found");
        Assertions.assertFalse((boolean)task.isErrorState());
    }

    @ParameterizedTest
    @EnumSource(value=Algorithm.class, names={"ADLER", "NO_CHECKSUM"})
    public void testSnapshot(Algorithm algo) {
        UUID snapshotId = UUID.randomUUID();
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        MetadataSnapshotTask.MetadataSnapshotState state = new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            }
            throw new MatchError((Object)try_);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        SnapshotTestUtils qual$1 = this.testUtils();
        boolean x$3 = qual$1.createRandomSnapshotFile$default$3();
        boolean x$4 = qual$1.createRandomSnapshotFile$default$4();
        OffsetAndEpoch x$5 = qual$1.createRandomSnapshotFile$default$5();
        qual$1.createRandomSnapshotFile(snapshotId, algo, x$3, x$4, x$5);
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.AfterMetadataSnapshotState.class, nextState2.getClass(), (String)"Unexpected next state");
        this.tierObjectStore().putObject((TierObjectStore.ObjectStoreMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (TierObjectStore.FileType)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("foo"), new IllegalStateException("illegal state")});
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState3 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState3.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        }
        if (!(try_3 instanceof Failure)) {
            throw new MatchError((Object)try_3);
        }
        Throwable ex = ((Failure)try_3).exception();
        Assertions.assertEquals(TierObjectStoreRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Try try_4 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_4 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState4 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_4).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState4.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        }
        if (!(try_4 instanceof Failure)) {
            throw new MatchError((Object)try_4);
        }
        Throwable ex2 = ((Failure)try_4).exception();
        Assertions.assertEquals(IllegalStateException.class, ex2.getClass(), (String)"Unexpected exception");
        this.ctx().cancel();
        Try try_5 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_5 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState5 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_5).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState5.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        }
        if (!(try_5 instanceof Failure)) {
            throw new MatchError((Object)try_5);
        }
        Throwable ex3 = ((Failure)try_5).exception();
        Assertions.assertEquals(TierSnapshotFencedException.class, ex3.getClass(), (String)"Unexpected exception");
        Utils.delete((File)this.logDir(), (boolean)false);
        Try try_6 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_6 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState6 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_6).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Unexpected transition to next state ").append(nextState6.toString()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        }
        if (try_6 instanceof Failure) {
            Throwable ex4 = ((Failure)try_6).exception();
            Assertions.assertEquals(NoSuchFileException.class, ex4.getClass(), (String)"Unexpected exception");
            return;
        }
        throw new MatchError((Object)try_6);
    }

    @Test
    public void testSnapshotTakenAtLaterOffsetThanSnapshotInitiateOffset() {
        UUID snapshotId = UUID.randomUUID();
        OffsetAndEpoch snapshotInitiateOffsetAndEpoch = new OffsetAndEpoch(0L, Optional.empty());
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, snapshotInitiateOffsetAndEpoch, this.brokerId());
        ObjectRef currentState = ObjectRef.create((Object)new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate));
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        OffsetAndEpoch snapshotTakenOffsetAndEpoch = new OffsetAndEpoch(8L, Optional.empty());
        SnapshotTestUtils qual$1 = this.testUtils();
        boolean x$4 = qual$1.createRandomSnapshotFile$default$3();
        boolean x$5 = qual$1.createRandomSnapshotFile$default$4();
        qual$1.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, x$4, x$5, snapshotTakenOffsetAndEpoch);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotTaskState)currentState$1.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.inMemTierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            }
            throw new MatchError((Object)try_);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
        Assertions.assertEquals(MetadataSnapshotTask.AfterMetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
        Option<FileTierPartitionStateSnapshotObject> snapshotObject = this.testUtils().verifySnapshotExistenceAtObjectStore(snapshotId, true);
        Assertions.assertEquals((Object)snapshotTakenOffsetAndEpoch, (Object)((FileTierPartitionStateSnapshotObject)snapshotObject.get()).lastMaterializedEventOffsetAndEpoch());
        currentState.elem = nextState;
        ObjectRef snapshotUploadComplete = ObjectRef.create(null);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<CompletableFuture<TierPartitionState.AppendResult>>(null, snapshotUploadComplete){
            private final ObjectRef snapshotUploadComplete$1;

            public CompletableFuture<TierPartitionState.AppendResult> answer(InvocationOnMock invocation) {
                this.snapshotUploadComplete$1.elem = (TierMetadataSnapshotUploadComplete)invocation.getArgument(0);
                return CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED);
            }
            {
                this.snapshotUploadComplete$1 = snapshotUploadComplete$1;
            }
        });
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotTaskState)currentState$1.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.inMemTierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState.class, nextState2.getClass(), (String)"Unexpected next state");
        currentState.elem = nextState2;
        Assertions.assertNotNull((Object)((TierMetadataSnapshotUploadComplete)snapshotUploadComplete.elem), (String)"TierTopicAppender not called with snapshotUploadComplete event");
        Assertions.assertEquals((Object)snapshotTakenOffsetAndEpoch, (Object)((TierMetadataSnapshotUploadComplete)snapshotUploadComplete.elem).snapshotOffsetAndEpoch());
    }

    @Test
    public void testSnapshotUploadFailsDueToInvalidChecksum() {
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        UUID snapshotId = UUID.randomUUID();
        SnapshotTestUtils qual$1 = this.testUtils();
        OffsetAndEpoch x$5 = qual$1.createRandomSnapshotFile$default$5();
        qual$1.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, false, true, x$5);
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        ObjectRef state = ObjectRef.create((Object)new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotState)state$2.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            throw Assertions$.MODULE$.fail("Unexpected transition to next state with invalid checksum", new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierSnapshotChecksumValidationFailedException.class, ex.getClass(), (String)"Unexpected exception during snapshot upload");
        Assertions.assertNull((Object)ex.getCause());
        snapshotId = UUID.randomUUID();
        SnapshotTestUtils qual$2 = this.testUtils();
        OffsetAndEpoch x$10 = qual$2.createRandomSnapshotFile$default$5();
        qual$2.createRandomSnapshotFile(snapshotId, Algorithm.ADLER, false, false, x$10);
        snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition(), this.leaderEpoch(), snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId());
        state.elem = new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch(), this.logDir(), snapshotInitiate);
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)((MetadataSnapshotTask.MetadataSnapshotState)state$2.elem).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.defaultAwaitTime()));
        if (try_2 instanceof Success) {
            throw Assertions$.MODULE$.fail("Unexpected transition to next state with invalid checksum", new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        }
        if (try_2 instanceof Failure) {
            Throwable ex2 = ((Failure)try_2).exception();
            Assertions.assertEquals(TierSnapshotChecksumValidationFailedException.class, ex2.getClass(), (String)"Unexpected exception during snapshot upload");
            Assertions.assertNotNull((Object)ex2.getCause());
            return;
        }
        throw new MatchError((Object)try_2);
    }

    @Test
    public void testMetadataSnapshotGarbageCollectionState() {
        this.testUtils_$eq(new SnapshotTestUtils(this.topicIdPartition(), this.brokerId(), this.leaderEpoch(), this.logDir(), this.ctx(), this.snapshotMetrics(), this.mockTime(), this.tierTopicManager(), this.replicaManager(), this.inMemTierObjectStore(), this.tierTasksConfig(), this.snapshotsDir()));
        this.mockTime().setCurrentTimeMs(System.currentTimeMillis() - 172800000L);
        UUID snapshot1Id = UUID.randomUUID();
        FileTierPartitionStateSnapshotObject snapshot1Info = this.testUtils().createAndUploadSnapshotFile(snapshot1Id, Algorithm.ADLER);
        this.mockTime().setCurrentTimeMs(System.currentTimeMillis() - 86400000L);
        UUID snapshot2Id = UUID.randomUUID();
        this.testUtils().createAndUploadSnapshotFile(snapshot2Id, Algorithm.ADLER);
        long lastSnapshotTimestampMs = System.currentTimeMillis();
        this.mockTime().setCurrentTimeMs(lastSnapshotTimestampMs);
        UUID snapshot3Id = UUID.randomUUID();
        FileTierPartitionStateSnapshotObject snapshot3Info = this.testUtils().createAndUploadSnapshotFile(snapshot3Id, Algorithm.ADLER);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Left().apply((Object)Errors.KAFKA_STORAGE_ERROR));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(90).append("Unexpected transition to next state ").append(nextState.toString()).append(". State must not transition when partition is in error").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierSnapshotFencedException.class, ex.getClass(), (String)"Unexpected exception");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)None$.MODULE$);
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id), (Duration)this.defaultAwaitTime()));
        if (!(try_2 instanceof Success)) {
            if (try_2 instanceof Failure) {
                Throwable ex2 = ((Failure)try_2).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(55).append("Unexpected exception when log instance is not present. ").append(ex2.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
            }
            throw new MatchError((Object)try_2);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_2).value();
        Assertions.assertEquals(MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState.class, nextState.getClass(), (String)new StringBuilder(96).append("Unexpected transition to next state ").append(nextState.toString()).append(". State must not transition when log instance is not present").toString());
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)this.log()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id), (Duration)this.defaultAwaitTime()));
        if (try_3 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState2 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_3).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(83).append("Unexpected transition to next state ").append(nextState2.toString()).append(". State must not transition when log is deleted").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        }
        if (!(try_3 instanceof Failure)) {
            throw new MatchError((Object)try_3);
        }
        Throwable ex3 = ((Failure)try_3).exception();
        Assertions.assertEquals(TierSnapshotFencedException.class, ex3.getClass(), (String)"Unexpected exception");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierPartitionState().status()).thenReturn((Object)TierPartitionStatus.ERROR);
        Try try_4 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs, snapshot3Id), (Duration)this.defaultAwaitTime()));
        if (try_4 instanceof Success) {
            MetadataSnapshotTask.MetadataSnapshotTaskState nextState3 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_4).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(108).append("Unexpected transition to next state ").append(nextState3.toString()).append(". State must not transition when tier partition state is in error status").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
        }
        if (!(try_4 instanceof Failure)) {
            throw new MatchError((Object)try_4);
        }
        Throwable ex4 = ((Failure)try_4).exception();
        Assertions.assertEquals(TierSnapshotFailedException.class, ex4.getClass(), (String)"Unexpected exception");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Mockito.when((Object)this.tierPartitionState().status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Try try_5 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(lastSnapshotTimestampMs + 1L, UUID.randomUUID()), (Duration)this.defaultAwaitTime()));
        if (!(try_5 instanceof Success)) {
            if (try_5 instanceof Failure) {
                Throwable ex5 = ((Failure)try_5).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(56).append("Unexpected exception ").append(ex5.getMessage()).append(" when committed snapshot is missing").toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            }
            throw new MatchError((Object)try_5);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState4 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_5).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState4.getClass(), (String)"Unexpected state transition when committed snapshot is missing");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Try try_6 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(snapshot1Info.snapshotTimestampMs(), snapshot1Info.snapshotId()), (Duration)this.defaultAwaitTime()));
        if (!(try_6 instanceof Success)) {
            if (try_6 instanceof Failure) {
                Throwable ex6 = ((Failure)try_6).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex6.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
            }
            throw new MatchError((Object)try_6);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState5 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_6).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState5.getClass(), (String)"Unexpected state transition");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$))), (List<UUID>)Nil$.MODULE$);
        Try try_7 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(snapshot3Info.snapshotTimestampMs(), snapshot3Info.snapshotId()), (Duration)this.defaultAwaitTime()));
        if (!(try_7 instanceof Success)) {
            if (try_7 instanceof Failure) {
                Throwable ex7 = ((Failure)try_7).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex7.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
            }
            throw new MatchError((Object)try_7);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState6 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_7).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState6.getClass(), (String)"Unexpected state transition");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$), (List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)Nil$.MODULE$)));
        this.mockTime().setCurrentTimeMs(System.currentTimeMillis() + 604800000L);
        Try try_8 = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)this.taskTransitionHelper$3(snapshot3Info.snapshotTimestampMs(), snapshot3Info.snapshotId()), (Duration)this.defaultAwaitTime()));
        if (!(try_8 instanceof Success)) {
            if (try_8 instanceof Failure) {
                Throwable ex8 = ((Failure)try_8).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex8.getMessage()).toString(), new Position("MetadataSnapshotTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
            }
            throw new MatchError((Object)try_8);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState7 = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_8).value();
        Assertions.assertEquals(MetadataSnapshotTask.BeforeMetadataSnapshotState.class, nextState7.getClass(), (String)"Unexpected state transition");
        this.testUtils().verifyExistenceOfSnapshots((List<UUID>)new .colon.colon((Object)snapshot3Id, (List)Nil$.MODULE$), (List<UUID>)new .colon.colon((Object)snapshot1Id, (List)new .colon.colon((Object)snapshot2Id, (List)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @EnumSource(value=Algorithm.class, names={"ADLER", "NO_CHECKSUM"})
    public void testSnapshotUuidSearch(Algorithm algo) {
        void var15_15;
        void var12_12;
        void var9_9;
        void var6_6;
        String baseNameStr = MergedLog$.MODULE$.tierStateFile(this.logDir(), 0L, "").getName();
        UUID snapshotId = UUID.randomUUID();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()));
        FileTierPartitionStateSnapshotObject utils1 = new FileTierPartitionStateSnapshotObject(snapshotId, 123L, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils1.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple2 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata1 = (FileTierPartitionStateSnapshotObject)tuple2._2();
        Assertions.assertEquals((long)123L, (long)var6_6.snapshotTimestampMs());
        FileTierPartitionStateSnapshotObject utils2 = new FileTierPartitionStateSnapshotObject(snapshotId, 45L, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils2.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple22 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata2 = (FileTierPartitionStateSnapshotObject)tuple22._2();
        Assertions.assertEquals((long)45L, (long)var9_9.snapshotTimestampMs());
        FileTierPartitionStateSnapshotObject utils3 = new FileTierPartitionStateSnapshotObject(snapshotId, 678L, new OffsetAndEpoch(12L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils3.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple23 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata3 = (FileTierPartitionStateSnapshotObject)tuple23._2();
        Assertions.assertEquals((long)45L, (long)var12_12.snapshotTimestampMs());
        FileTierPartitionStateSnapshotObject utils4 = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), 10L, new OffsetAndEpoch(15L, Optional.of(Predef$.MODULE$.int2Integer(0))), 0, baseNameStr, algo);
        Files.createFile(this.snapshotsDir().resolve(utils4.encodeSnapshotName()), new FileAttribute[0]);
        Tuple2 tuple24 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata4 = (FileTierPartitionStateSnapshotObject)tuple24._2();
        Assertions.assertEquals((long)45L, (long)var15_15.snapshotTimestampMs());
        Utils.delete((File)this.logDir(), (boolean)false);
        Assertions.assertThrows(NoSuchFileException.class, () -> MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @EnumSource(value=Algorithm.class, names={"ADLER", "NO_CHECKSUM"})
    public void testParseSnapshotPath(Algorithm algo) {
        void var7_7;
        String baseName = MergedLog$.MODULE$.tierStateFile(this.logDir(), 0L, "").getName();
        UUID snapshotId = UUID.randomUUID();
        FileTierPartitionStateSnapshotObject utils = new FileTierPartitionStateSnapshotObject(snapshotId, 123L, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(-1))), 0, baseName, algo);
        Path localPath = this.snapshotsDir().resolve(utils.encodeSnapshotName());
        Files.write(localPath, "".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Tuple2 tuple2 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject snapshotMetadata = (FileTierPartitionStateSnapshotObject)tuple2._2();
        TierObjectStore.TierPartitionStateSnapshotMetadata objectMetadata = new TierObjectStore.TierPartitionStateSnapshotMetadata(this.topicIdPartition(), (FileTierPartitionStateSnapshotObject)var7_7);
        String remotePath = objectMetadata.toPath("bar", TierObjectStore.FileType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
        Assertions.assertEquals((Object)snapshotId, (Object)objectMetadata.snapshotObject().snapshotId());
        Assertions.assertEquals((long)123L, (long)objectMetadata.snapshotObject().snapshotTimestampMs());
        Assertions.assertEquals((long)10L, (long)objectMetadata.snapshotObject().lastMaterializedEventOffsetAndEpoch().offset());
        Assertions.assertEquals(Optional.empty(), (Object)objectMetadata.snapshotObject().lastMaterializedEventOffsetAndEpoch().epoch());
        Assertions.assertEquals((int)0, (int)objectMetadata.snapshotObject().tierEpoch());
        Assertions.assertEquals((Object)algo, (Object)objectMetadata.snapshotObject().checksumAlgorithm());
        Assertions.assertTrue((boolean)((Object)localPath).toString().endsWith(algo.suffix));
        Assertions.assertTrue((boolean)remotePath.contains(((Object)localPath.getFileName()).toString()));
    }

    private final Future taskTransitionHelper$1(boolean uncleanLeader, boolean metadataRecovering) {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeader));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.log().isTierMetadataStateRecovering())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)metadataRecovering));
        return new MetadataSnapshotTask.BeforeLeaderSnapshotState(this.leaderEpoch()).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
    }

    private static final boolean taskTransitionHelper$default$1$1() {
        return false;
    }

    private static final boolean taskTransitionHelper$default$2$1() {
        return false;
    }

    private final Future taskTransitionHelper$2(long lastSnapshotTimestampMs) {
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.tierPartitionState().lastSnapshotTimestampMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)lastSnapshotTimestampMs));
        return new MetadataSnapshotTask.BeforeMetadataSnapshotState(this.leaderEpoch()).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
    }

    public static final /* synthetic */ void $anonfun$testTaskCancellationAndConfigUpdate$1(MetadataSnapshotTaskTest $this, MetadataSnapshotTask.MetadataSnapshotTaskState state) {
        CancellationContext tmpCtx = CancellationContext.newContext();
        MetadataSnapshotTask task = new MetadataSnapshotTask(tmpCtx, $this.topicIdPartition(), state, $this.snapshotMetrics(), $this.brokerId());
        tmpCtx.cancel();
        Assertions.assertEquals((Object)((MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)$this.mockTime(), (TierTopicAppender)$this.tierTopicManager(), $this.tierObjectStore(), $this.replicaManager(), $this.tierTasksConfig(), (Option)None$.MODULE$, $this.ec()), (Duration)$this.defaultAwaitTime())).state(), (Object)state, (String)new StringBuilder(27).append("expected task to remain in ").append(state).toString());
    }

    private final void cancelledTasksDoNotProgress$1(List states) {
        states.foreach((Function1 & Serializable)state -> {
            MetadataSnapshotTaskTest.$anonfun$testTaskCancellationAndConfigUpdate$1(this, state);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testTaskCancellationAndConfigUpdate$2(MetadataSnapshotTaskTest $this, TierTasksConfig newTierTasksConfig$1, MetadataSnapshotTask.MetadataSnapshotTaskState state) {
        MetadataSnapshotTask task = new MetadataSnapshotTask($this.ctx(), $this.topicIdPartition(), state, $this.snapshotMetrics(), $this.brokerId());
        Assertions.assertEquals((Object)((MetadataSnapshotTask)Await$.MODULE$.result((Awaitable)task.transition((Time)$this.mockTime(), (TierTopicAppender)$this.tierTopicManager(), $this.tierObjectStore(), $this.replicaManager(), newTierTasksConfig$1, (Option)None$.MODULE$, $this.ec()), (Duration)$this.defaultAwaitTime())).state(), (Object)state, (String)new StringBuilder(27).append("expected task to remain in ").append(state).toString());
    }

    private final void disabledConfigCancelsProgress$1(List states, TierTasksConfig newTierTasksConfig) {
        states.foreach((Function1 & Serializable)state -> {
            MetadataSnapshotTaskTest.$anonfun$testTaskCancellationAndConfigUpdate$2(this, newTierTasksConfig, state);
            return BoxedUnit.UNIT;
        });
    }

    private final Future taskTransitionHelper$3(long lastSnapshotTimestampMs, UUID lastCommittedSnapshotId) {
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.tierPartitionState().lastSnapshotTimestampMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)lastSnapshotTimestampMs));
        Mockito.when((Object)this.tierPartitionState().lastCommittedSnapshotId()).thenReturn((Object)lastCommittedSnapshotId);
        return new MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState(this.leaderEpoch()).transition(this.ctx(), this.topicIdPartition(), this.snapshotMetrics(), this.brokerId(), (Time)this.mockTime(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.inMemTierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, this.ec());
    }

    public MetadataSnapshotTaskTest() {
        this.brokerId = 0;
        this.snapshotThreads = 1;
        int x$3 = this.snapshotThreads();
        int x$4 = this.brokerId();
        Option<SnapshotTasksConfig> x$5 = this.snapshotTaskConfig();
        long x$6 = 600000L;
        long x$7 = 500L;
        int x$8 = 50;
        int x$9 = 300000;
        boolean x$10 = false;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        this.tierTasksConfig = new TierTasksConfig(1, 1, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11, (Option)x$12, x$5);
        this.snapshotMetrics = new MetadataSnapshotMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        this.leaderEpoch = 0;
        this.defaultAwaitTime = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
    }
}

