/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import kafka.server.Defaults;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TierMetadataValidatorTest {
    MockTime time = new MockTime();
    List<TierObjectMetadata> aList = new ArrayList<TierObjectMetadata>();
    List<TierObjectMetadata> eList = new ArrayList<TierObjectMetadata>();
    TopicIdPartition tid = new TopicIdPartition("a1", UUID.randomUUID(), 0);
    Iterator<TierObjectMetadata> aIterator;
    Iterator<TierObjectMetadata> eIterator;
    TierObjectStore objStore;
    Scheduler scheduler;
    private final Function<TopicPartition, Long> constantStartOffsetProducer = topic -> 0L;
    private final CancellationContext cancellationContext = CancellationContext.newContext();
    private final TierObjectStore.Backend backend = TierObjectStore.Backend.Mock;

    @BeforeEach
    public void setup() throws IOException {
        this.aList.add(new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 0L, 1000L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, -1L));
        this.aList.add(new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 1001L, 2000L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, 1000L));
        this.aList.add(new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 2001L, 3000L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, false, true, 1000L));
        this.eList.add(new TierObjectMetadata(this.tid, 0, this.aList.get(0).objectId(), 0L, 1000L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, -1L));
        this.eList.add(new TierObjectMetadata(this.tid, 0, this.aList.get(1).objectId(), 1001L, 2000L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, 1000L));
        this.eList.add(new TierObjectMetadata(this.tid, 0, this.aList.get(2).objectId(), 2001L, 3000L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, false, true, 1000L));
        this.objStore = TierObjectStoreFactory.getObjectStoreInstance((Time)this.time, (TierObjectStore.Backend)this.backend, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig());
        this.scheduler = new KafkaScheduler(1, true, "test-scheduler-", false);
        this.scheduler.startup();
        for (TierObjectMetadata tierMetadata : this.aList) {
            TierMetadataValidatorTest.uploadSegmentToObjectStore(tierMetadata, this.objStore);
        }
        this.aIterator = this.aList.iterator();
        this.eIterator = this.eList.iterator();
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        this.scheduler.shutdown();
        TierObjectStoreFactory.closeBackendInstance((TierObjectStore.Backend)this.backend);
    }

    public static void uploadSegmentToObjectStore(TierObjectMetadata tierMetadata, TierObjectStore objStore) throws IOException {
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(tierMetadata.topicIdPartition(), tierMetadata.objectId(), tierMetadata.tierEpoch(), tierMetadata.baseOffset(), tierMetadata.hasEpochState(), tierMetadata.hasAbortedTxns(), tierMetadata.hasProducerState(), tierMetadata.opaqueData());
        File segmentFile = TierMetadataValidatorTest.generateDummyTempFiles(tierMetadata.objectIdAsBase64(), TierObjectStore.FileType.SEGMENT, tierMetadata.size());
        File offsetIndexFile = TierMetadataValidatorTest.generateDummyTempFiles(tierMetadata.objectIdAsBase64(), TierObjectStore.FileType.OFFSET_INDEX, tierMetadata.size());
        File timestampIndexFile = TierMetadataValidatorTest.generateDummyTempFiles(tierMetadata.objectIdAsBase64(), TierObjectStore.FileType.TIMESTAMP_INDEX, tierMetadata.size());
        objStore.putSegment(metadata, segmentFile, offsetIndexFile, timestampIndexFile, Optional.empty(), Optional.empty(), Optional.empty());
    }

    static File generateDummyTempFiles(String fileName, TierObjectStore.FileType type, long size) throws IOException {
        File tempFile = File.createTempFile(fileName, "." + type.suffix());
        byte[] buffer = new byte[(int)size];
        try (FileOutputStream stream = new FileOutputStream(tempFile);){
            stream.write(buffer);
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    @Test
    public void testTierMetadataValidatorTest() {
        String[] args = new String[]{"--metadata-states-dir", "/mnt/kafka", "--working-dir", "/tmp/rohit", "--bootstrap-server", "localhost:7099", "--tier-state-topic-partition", "10", "--tier-partition-state-cleanup-feature-flag", "true", "--tier-partition-state-cleanup-interval", "50", "--snapshot-states-file", "true", "--confluent.tier.backend", "Mock", "--cluster-id", "mock_cluster", "--broker.id", "42"};
        TierMetadataValidator validator = new TierMetadataValidator(args, this.scheduler);
        Assertions.assertEquals((Object)validator.props.getProperty("metadata-states-dir"), (Object)"/mnt/kafka");
        Assertions.assertEquals((Object)validator.workDir, (Object)"/tmp/rohit");
        Assertions.assertEquals((Object)validator.props.get("bootstrap-server"), (Object)"localhost:7099");
        Assertions.assertEquals((Object)validator.props.get("tier-state-topic-partition"), (Object)10);
        Assertions.assertEquals((Object)validator.props.get("snapshot-states-files"), (Object)true);
        Assertions.assertEquals((Object)validator.props.get("validate-tier-storage"), (Object)true);
        Assertions.assertEquals((Object)validator.props.get("validate-tier-storage-offset"), (Object)false);
        Assertions.assertEquals((Object)validator.props.get(KafkaConfig.TierBackendProp()), (Object)TierObjectStore.Backend.Mock);
        Assertions.assertEquals((Object)validator.props.get(KafkaConfig.BrokerIdProp()), (Object)42);
        Assertions.assertEquals((Object)validator.props.getProperty("cluster-id"), (Object)"mock_cluster");
        Assertions.assertEquals((Object)validator.props.get("tier-partition-state-cleanup-feature-flag"), (Object)true);
        Assertions.assertEquals((Object)validator.props.get("tier-partition-state-cleanup-delay"), (Object)Defaults.TierPartitionStateCleanupDelayMs());
        Assertions.assertEquals((Object)validator.props.get("tier-partition-state-cleanup-interval"), (Object)50L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void basicValidateStatesTest(boolean isFtpsCleanupEnabled) {
        Assertions.assertTrue((boolean)TierMetadataValidator.isValidStates(this.aIterator, this.eIterator, (long)0L, Optional.of(this.objStore), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, (boolean)isFtpsCleanupEnabled));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void validationFailOnVoidOffsetRange(boolean isFtpsCleanupEnabled) {
        TierObjectMetadata obj = this.eList.get(0);
        this.eList.set(0, new TierObjectMetadata(obj.topicIdPartition(), obj.tierEpoch(), obj.objectId(), obj.baseOffset() + 1L, obj.endOffset(), obj.maxTimestamp(), obj.firstBatchTimestamp(), obj.size(), obj.state(), false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, isFtpsCleanupEnabled, obj.stateChangeTimestamp()));
        this.aList.set(0, this.eList.get(0));
        this.aIterator = this.aList.iterator();
        this.eIterator = this.eList.iterator();
        Assertions.assertFalse((boolean)TierMetadataValidator.isValidStates(this.aIterator, this.eIterator, (long)0L, Optional.of(this.objStore), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, (boolean)isFtpsCleanupEnabled));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void validationPassOnVoidOffsetRangeBeforeStartOffset(boolean isFtpsCleanupEnabled) {
        TierObjectMetadata obj = this.eList.get(0);
        this.eList.set(0, new TierObjectMetadata(obj.topicIdPartition(), obj.tierEpoch(), obj.objectId(), obj.baseOffset() + 1L, obj.endOffset(), obj.maxTimestamp(), obj.firstBatchTimestamp(), obj.size(), obj.state(), false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, isFtpsCleanupEnabled, obj.stateChangeTimestamp()));
        this.aList.set(0, this.eList.get(0));
        this.aIterator = this.aList.iterator();
        this.eIterator = this.eList.iterator();
        Assertions.assertTrue((boolean)TierMetadataValidator.isValidStates(this.aIterator, this.eIterator, (long)1001L, Optional.of(this.objStore), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, (boolean)isFtpsCleanupEnabled));
        this.aIterator = this.aList.iterator();
        this.eIterator = this.eList.iterator();
        Assertions.assertFalse((boolean)TierMetadataValidator.isValidStates(this.aIterator, this.eIterator, (long)501L, Optional.of(this.objStore), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, (boolean)isFtpsCleanupEnabled));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void validationPassOnFencedMappingInActiveRange(boolean isFtpsCleanupEnabled) {
        TierObjectMetadata obj = this.eList.get(2);
        this.eList.set(2, new TierObjectMetadata(obj.topicIdPartition(), obj.tierEpoch(), obj.objectId(), obj.baseOffset(), obj.endOffset(), obj.maxTimestamp(), obj.firstBatchTimestamp(), obj.size(), TierObjectMetadata.State.SEGMENT_FENCED, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, isFtpsCleanupEnabled, obj.stateChangeTimestamp()));
        this.aList.set(2, new TierObjectMetadata(obj.topicIdPartition(), obj.tierEpoch(), obj.objectId(), obj.baseOffset(), obj.endOffset(), obj.maxTimestamp(), obj.firstBatchTimestamp(), obj.size(), TierObjectMetadata.State.SEGMENT_FENCED, false, false, false, TierUploadType.Compaction, TierObjectStore.OpaqueData.ZEROED, false, isFtpsCleanupEnabled, obj.stateChangeTimestamp()));
        this.aList.add(obj);
        this.eList.add(obj);
        this.aIterator = this.aList.iterator();
        this.eIterator = this.eList.iterator();
        Assertions.assertTrue((boolean)TierMetadataValidator.isValidStates(this.aIterator, this.eIterator, (long)0L, Optional.of(this.objStore), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, (boolean)isFtpsCleanupEnabled));
    }

    @Test
    public void validationTierStateEntriesWithFtpsCleanupEnabled() {
        TierObjectMetadata obj = this.eList.get(0);
        this.eList.set(0, new TierObjectMetadata(obj.topicIdPartition(), obj.tierEpoch(), obj.objectId(), obj.baseOffset(), obj.endOffset(), obj.maxTimestamp() - 1L, obj.firstBatchTimestamp(), obj.size(), obj.state(), false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, obj.stateChangeTimestamp()));
        Assertions.assertFalse((boolean)TierMetadataValidator.isValidStates(this.aList.iterator(), this.eList.iterator(), (long)0L, Optional.of(this.objStore), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, (boolean)true));
        this.eList.set(0, this.aList.get(0));
        this.aList.add(0, new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 0L, 500L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, true, this.time.milliseconds()));
        this.aList.add(0, new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 0L, 200L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, true, this.time.milliseconds()));
        this.aList.add(new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 3001L, 4000L, 1L, 1000L, 1000, TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, true, this.time.milliseconds()));
        obj = this.aList.get(0);
        this.eList.add(0, new TierObjectMetadata(obj.topicIdPartition(), obj.tierEpoch(), obj.objectId(), obj.baseOffset(), obj.endOffset(), obj.maxTimestamp(), obj.firstBatchTimestamp(), obj.size(), obj.state(), false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, true, 1000L));
        Assertions.assertTrue((boolean)TierMetadataValidator.isValidStates(this.aList.iterator(), this.eList.iterator(), (long)0L, Optional.of(this.objStore), (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer, (boolean)true));
    }

    @Test
    public void testOffsetScanThrowsWithMockBackend() {
        String[] args = new String[]{"--metadata-states-dir", "/mnt/kafka", "--working-dir", "/tmp/rohit", "--bootstrap-server", "localhost:7099", "--tier-state-topic-partition", "10", "--snapshot-states-file", "true", "--confluent.tier.backend", "Mock", "--cluster-id", "mock_cluster", "--broker.id", "42", "--validate-tier-storage-offset", "true"};
        Exception caught = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new TierMetadataValidator(args, this.scheduler));
        String actualMsg = caught.getMessage();
        String expectedMsg = "Unsupported backend for offset scan: " + TierObjectStore.Backend.Mock;
        Assertions.assertTrue((boolean)actualMsg.contains(expectedMsg));
    }

    @Test
    public void testObjectStoreIgnoresInactiveSegment() {
        TierObjectMetadata deletedMetadata = new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 41L, 50L, 1L, 10L, 10, TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, 500L);
        Function<TopicPartition, Long> startOffsetProducer = topic -> deletedMetadata.endOffset() + 1L;
        TierMetadataValidator.OffsetValidationResult validationResult = TierMetadataValidator.verifyObjectInBackend((TierObjectMetadata)deletedMetadata, (long)0L, (TierObjectStore)this.objStore, (boolean)false, (CancellationContext)this.cancellationContext, startOffsetProducer);
        Assertions.assertTrue((boolean)validationResult.result);
        Assertions.assertEquals((long)(deletedMetadata.endOffset() + 1L), (long)validationResult.firstValidOffset);
    }

    @Test
    public void testObjectStoreIgnoresFencedSegment() {
        TierObjectMetadata deletedMetadata = new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 41L, 50L, 1L, 10L, 10, TierObjectMetadata.State.SEGMENT_FENCED, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, true, 500L);
        Function<TopicPartition, Long> startOffsetProducer = topic -> 20L;
        TierMetadataValidator.OffsetValidationResult validationResult = TierMetadataValidator.verifyObjectInBackend((TierObjectMetadata)deletedMetadata, (long)0L, (TierObjectStore)this.objStore, (boolean)false, (CancellationContext)this.cancellationContext, startOffsetProducer);
        Assertions.assertTrue((boolean)validationResult.result);
    }

    @Test
    public void testNonExistentObject() {
        TierObjectMetadata nonExistentMetadata = new TierObjectMetadata(this.tid, 0, UUID.randomUUID(), 41L, 50L, 1L, 10L, 10, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, false, false, 500L);
        Assertions.assertFalse((boolean)TierMetadataValidator.verifyObjectInBackend((TierObjectMetadata)nonExistentMetadata, (long)0L, (TierObjectStore)this.objStore, (boolean)false, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer).result);
    }

    @Test
    public void testOffsetScanFailsWithMockBackend() {
        TierMetadataValidator.OffsetValidationResult validationResult = TierMetadataValidator.verifyObjectInBackend((TierObjectMetadata)this.aList.get(0), (long)0L, (TierObjectStore)this.objStore, (boolean)true, (CancellationContext)this.cancellationContext, this.constantStartOffsetProducer);
        Assertions.assertFalse((boolean)validationResult.result);
    }
}

