/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kafka.api.IntegrationTestHarness;
import kafka.log.LocalLog$;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierRecordType;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryTestUtils$;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateFencingIntegrationTriggerTest$;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001dq!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)d\u0001\u0002\u0016\"\u00019CQA\r\u0003\u0005\u0002UCQa\u0016\u0003\u0005RaCq\u0001\u0018\u0003C\u0002\u0013%Q\f\u0003\u0004l\t\u0001\u0006IA\u0018\u0005\bY\u0012\u0011\r\u0011\"\u0003n\u0011\u0019!H\u0001)A\u0005]\"9Q\u000f\u0002a\u0001\n\u00131\b\"CA\u0001\t\u0001\u0007I\u0011BA\u0002\u0011\u001d\ty\u0001\u0002Q!\n]D\u0011\"!\u0005\u0005\u0005\u0004%I!a\u0005\t\u0011\u0005MB\u0001)A\u0005\u0003+A1\"!\u000e\u0005\u0001\u0004\u0005\r\u0011\"\u0003\u00028!Y\u0011Q\t\u0003A\u0002\u0003\u0007I\u0011BA$\u0011-\tY\u0005\u0002a\u0001\u0002\u0003\u0006K!!\u000f\t\u0017\u00055C\u00011AA\u0002\u0013%\u0011q\u0007\u0005\f\u0003\u001f\"\u0001\u0019!a\u0001\n\u0013\t\t\u0006C\u0006\u0002V\u0011\u0001\r\u0011!Q!\n\u0005e\u0002\"CA,\t\t\u0007I\u0011BA-\u0011!\t9\u0007\u0002Q\u0001\n\u0005m\u0003\"CA5\t\t\u0007I\u0011BA6\u0011!\t\u0019\b\u0002Q\u0001\n\u00055\u0004\u0002CA;\t\t\u0007I\u0011\u0002-\t\u000f\u0005]D\u0001)A\u00053\"9\u0011\u0011\u0010\u0003\u0005\n\u0005m\u0004bBAS\t\u0011\u0005\u0013q\u0015\u0005\b\u0003\u007f#A\u0011IAa\u0011\u001d\tY\r\u0002C\u0001\u0003\u001b\fq\u0006V5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a+gnY5oO&sG/Z4sCRLwN\u001c+sS\u001e<WM\u001d+fgRT!AI\u0012\u0002\u000bQ|w\u000e\\:\u000b\u0005\u0011*\u0013\u0001\u0002;jKJT\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001!\tI\u0013!D\u0001\"\u0005=\"\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GK:\u001c\u0017N\\4J]R,wM]1uS>tGK]5hO\u0016\u0014H+Z:u'\t\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\naeZ3oKJ\fG/\u001a\"p_2,\u0017M\\\"p[\nLg.\u0019;j_:\u001cHgV5uQF+xN];n+\u00051\u0004cA\u001c?\u00016\t\u0001H\u0003\u0002:u\u000511\u000f\u001e:fC6T!a\u000f\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0005!!.\u0019<b\u0013\ty\u0004H\u0001\u0004TiJ,\u0017-\u001c\t\u0003\u00032k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003\u000b\u001a\u000ba\u0001]1sC6\u001c(BA$I\u0003\u001dQW\u000f]5uKJT!!\u0013&\u0002\u000b),h.\u001b;\u000b\u0003-\u000b1a\u001c:h\u0013\ti%IA\u0005Be\u001e,X.\u001a8ugN\u0011Aa\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0016\n1!\u00199j\u0013\t!\u0016K\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t)\u00051\u0006CA\u0015\u0005\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003e\u0003\"!\f.\n\u0005ms#aA%oi\u0006!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\u0012A\u0018\t\u0003?&l\u0011\u0001\u0019\u0006\u0003C\n\f1\u0001\\8h\u0015\t\u0019G-A\u0005j]R,'O\\1mg*\u0011QMZ\u0001\bgR|'/Y4f\u0015\t1sM\u0003\u0002i\u0015\u00061\u0011\r]1dQ\u0016L!A\u001b1\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\na\u0001\\8h\t&\u0014X#\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005Ed\u0014\u0001\u00027b]\u001eL!a\u001d9\u0003\rM#(/\u001b8h\u0003\u001dawn\u001a#je\u0002\nq\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001aKG.Z:\u0016\u0003]\u00042!\f={\u0013\tIhFA\u0003BeJ\f\u0017\u0010\u0005\u0002|}6\tAP\u0003\u0002~G\u0005)1\u000f^1uK&\u0011q\u0010 \u0002\u0017\r&dW\rV5feB\u000b'\u000f^5uS>t7\u000b^1uK\u0006YB/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r&dWm]0%KF$B!!\u0002\u0002\fA\u0019Q&a\u0002\n\u0007\u0005%aF\u0001\u0003V]&$\b\u0002CA\u0007\u0019\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'\u0001\ruS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)\u001b7fg\u0002\nq\u0002\u001e9jIN$vNQ3GK:\u001cW\rZ\u000b\u0003\u0003+\u0001\u0002\"a\u0006\u0002\"\u0005\u0015\u0012QF\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003?q\u0013AC2pY2,7\r^5p]&!\u00111EA\r\u0005\ri\u0015\r\u001d\t\u0005\u0003O\tI#D\u0001$\u0013\r\tYc\t\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042!LA\u0018\u0013\r\t\tD\f\u0002\b\u0005>|G.Z1o\u0003A!\b/\u001b3t)>\u0014UMR3oG\u0016$\u0007%A\u000bu_BL7-\u00133QCJ$\u0018\u000e^5p]N4\u0015\u000e\\3\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}B(\u0001\u0002j_&!\u00111IA\u001f\u0005\u00111\u0015\u000e\\3\u00023Q|\u0007/[2JIB\u000b'\u000f^5uS>t7OR5mK~#S-\u001d\u000b\u0005\u0003\u000b\tI\u0005C\u0005\u0002\u000eE\t\t\u00111\u0001\u0002:\u00051Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\:GS2,\u0007%\u0001\nqe>\u0004XM\u001d;jKN\u001cuN\u001c4GS2,\u0017A\u00069s_B,'\u000f^5fg\u000e{gN\u001a$jY\u0016|F%Z9\u0015\t\u0005\u0015\u00111\u000b\u0005\n\u0003\u001b!\u0012\u0011!a\u0001\u0003s\t1\u0003\u001d:pa\u0016\u0014H/[3t\u0007>tgMR5mK\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0003\u00037\u0002B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003C*\u0013!B;uS2\u001c\u0018\u0002BA3\u0003?\u0012\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nab\u00197fC:,\b\u000fR3mCfl5/\u0006\u0002\u0002nA\u0019Q&a\u001c\n\u0007\u0005EdF\u0001\u0003M_:<\u0017aD2mK\u0006tW\u000f\u001d#fY\u0006LXj\u001d\u0011\u0002#\rdW-\u00198va&sG/\u001a:wC2l5/\u0001\ndY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0013AC1eIJ+\u0007\u000f\\5dCR\u0001\u0012QAA?\u0003\u0003\u000b\t*!&\u0002\u001a\u0006u\u0015\u0011\u0015\u0005\b\u0003\u007fb\u0002\u0019AA\u0013\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0004r\u0001\r!!\"\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000f\u0005\u0003\u0002\b\u00065UBAAE\u0015\r\tYiI\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0003\u001f\u000bIIA\tUS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJDq!a%\u001d\u0001\u0004\ti#A\bdQ\u0016\u001c7n];n\u000b:\f'\r\\3e\u0011\u001d\t9\n\ba\u0001\u0003[\tabY8na\u0006\u001cG/\u00128bE2,G\rC\u0004\u0002\u001cr\u0001\r!!\f\u0002\u001d\rdW-\u00198va\u0016s\u0017M\u00197fI\"9\u0011q\u0014\u000fA\u0002\u00055\u0012!\t;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cf.\u00199tQ>$XI\\1cY\u0016$\u0007BBAR9\u0001\u0007\u0011,\u0001\u0005ce>\\WM]%e\u0003\u0015\u0019X\r^+q)\u0011\t)!!+\t\u000f\u0005-V\u00041\u0001\u0002.\u0006AA/Z:u\u0013:4w\u000e\u0005\u0003\u00020\u0006MVBAAY\u0015\t\u0011f)\u0003\u0003\u00026\u0006E&\u0001\u0003+fgRLeNZ8)\u0007u\tI\f\u0005\u0003\u00020\u0006m\u0016\u0002BA_\u0003c\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tGCAA\u0003Q\rq\u0012Q\u0019\t\u0005\u0003_\u000b9-\u0003\u0003\u0002J\u0006E&!C!gi\u0016\u0014X)Y2i\u0003)\"Xm\u001d;QCJ$\u0018\u000e^5p]\u001a+gnY3Fm\u0016tG/\u00138kK\u000e$\u0018n\u001c8B]\u00124UM\\2j]\u001e$B\"!\u0002\u0002P\u0006E\u00171[Ak\u0003/Dq!a% \u0001\u0004\ti\u0003C\u0004\u0002\u0018~\u0001\r!!\f\t\u000f\u0005mu\u00041\u0001\u0002.!9\u0011qT\u0010A\u0002\u00055\u0002bBAm?\u0001\u0007\u00111\\\u0001\u0007cV|'/^7\u0011\t\u0005u\u00171\u001e\b\u0005\u0003?\f9\u000fE\u0002\u0002b:j!!a9\u000b\u0007\u0005\u0015x%\u0001\u0004=e>|GOP\u0005\u0004\u0003St\u0013A\u0002)sK\u0012,g-C\u0002t\u0003[T1!!;/Q\u001dy\u0012\u0011_A|\u0003s\u00042!QAz\u0013\r\t)P\u0011\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003w\f\u0013\u0001\u000e\u0015\u0004?\u0005}\b\u0003\u0002B\u0001\u0005\u0007i\u0011\u0001R\u0005\u0004\u0005\u000b!%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0002")
public class TierPartitionStateFencingIntegrationTriggerTest
extends IntegrationTestHarness {
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final String logDir = TestUtils.tempDirectory(null, null).getAbsolutePath();
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final scala.collection.immutable.Map<TopicIdPartition, Object> tpidsToBeFenced = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("the_dark_knight", UUID.randomUUID(), 2)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mummy_returns", UUID.randomUUID(), 3)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mission_impossible", UUID.randomUUID(), 5)), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    private File topicIdPartitionsFile;
    private File propertiesConfFile;
    private final kafka.utils.MockTime mockTime = new kafka.utils.MockTime();
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;

    public static Stream<Arguments> generateBooleanCombinations4WithQuorum() {
        return TierPartitionStateFencingIntegrationTriggerTest$.MODULE$.generateBooleanCombinations4WithQuorum();
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    private LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private String logDir() {
        return this.logDir;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private scala.collection.immutable.Map<TopicIdPartition, Object> tpidsToBeFenced() {
        return this.tpidsToBeFenced;
    }

    private File topicIdPartitionsFile() {
        return this.topicIdPartitionsFile;
    }

    private void topicIdPartitionsFile_$eq(File x$1) {
        this.topicIdPartitionsFile = x$1;
    }

    private File propertiesConfFile() {
        return this.propertiesConfFile;
    }

    private void propertiesConfFile_$eq(File x$1) {
        this.propertiesConfFile = x$1;
    }

    private kafka.utils.MockTime mockTime() {
        return this.mockTime;
    }

    private long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    private int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled, int brokerId) {
        TopicPartition logDirName_topicPartition = topicIdPartition.topicPartition();
        Object var10_8 = null;
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, this.logDirFailureChannel(), topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler(), checksumEnabled, compactEnabled, (Time)this.mockTime(), new TierPartitionStateCleanupConfig(cleanupEnabled, this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), tierPartitionStateSnapshotEnabled, brokerId);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        tierPartitionState.setTieredPartitionRecoveryWorkflowCb(op -> System.out.println(new StringBuilder(14).append("Received ").append(op.toString()).append(" for ").append(topicIdPartition).toString()));
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;

            public String id() {
                return new StringBuilder(48).append("TierPartitionStateFencingIntegrationTriggerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus targetStatus, OffsetAndEpoch sourceOffsetAndEpoch, Optional<ByteBuffer> targetStateOpt) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, targetStateOpt, targetStatus, sourceOffsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete metadata, ByteBuffer snapshotBuffer, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.processSnapshotMaterializationEvent(metadata, snapshotBuffer, targetStatus, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public long localMaterializedOffset() {
                return this.tierPartitionState$1.lastLocalMaterializedSrcOffsetAndEpoch().offset();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }

            public void beginDiscover() {
                this.tierPartitionState$1.beginDiscover();
            }

            public void completeDiscover() {
                this.tierPartitionState$1.onDiscoverComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.topicIdPartitionsFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        this.tpidsToBeFenced().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$setUp$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            if (x$3 != null) {
                TopicIdPartition tpid = (TopicIdPartition)x$3._1();
                return this.createTopic(tpid.topic(), 10, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
            }
            throw new MatchError(null);
        });
        RecoveryTestUtils$.MODULE$.writeFencingFile(this.topicIdPartitionsFile(), this.tpidsToBeFenced());
        this.propertiesConfFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Function1 & Serializable)tierPartitionState -> {
            TierPartitionStateFencingIntegrationTriggerTest.$anonfun$tearDown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithQuorum"})
    public void testPartitionFenceEventInjectionAndFencing(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled, String quorum) {
        int brokerId = 0;
        String tierTopicNamespace = "";
        short numTierTopicPartitions = 19;
        int tierTopicReplicationFactor = 3;
        this.createTopic(TierTopic.topicName((String)tierTopicNamespace), numTierTopicPartitions, tierTopicReplicationFactor, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        TierTopic tierTopic = new TierTopic(tierTopicNamespace);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.eq((Object)tierTopic.topicName()), ArgumentMatchers.eq((int)numTierTopicPartitions), ArgumentMatchers.eq((short)Defaults$.MODULE$.TierMetadataReplicationFactor()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)numTierTopicPartitions));
        tierTopic.initialize(internalAdmin, (int)numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor());
        File workingDir = TestUtils.tempDirectory(null, null);
        Utils.mkProperties((Map)new HashMap<String, String>(this, workingDir){
            {
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
            }
        }).store(new PrintWriter(this.propertiesConfFile()), "");
        String tempFileName = "working-file";
        Path tempFilePath = Paths.get(workingDir.getAbsolutePath(), tempFileName);
        Files.createFile(tempFilePath, new FileAttribute[0]);
        File tempFile = new File(tempFilePath.toFile().getAbsolutePath());
        Assertions.assertTrue((tempFile.exists() && tempFile.isFile() ? 1 : 0) != 0);
        File outputDir = TestUtils.tempDirectory(null, null);
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), this.topicIdPartitionsFile().getPath(), RecoveryUtils.makeArgument((String)"output.json"), fenceOutFile});
        Assertions.assertTrue((!tempFile.exists() ? 1 : 0) != 0);
        Buffer fenceEvents = CollectionConverters$.MODULE$.ListHasAsScala(FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]))).asScala();
        Assertions.assertEquals((int)this.tpidsToBeFenced().size(), (int)fenceEvents.size());
        scala.collection.mutable.Map partitionToFenceEventInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        fenceEvents.foreach((Function1 & Serializable)output -> {
            TopicIdPartition outputTpid = new TopicIdPartition(output.topic, CoreUtils$.MODULE$.uuidFromBase64(output.topicIdBase64), output.partition);
            Assertions.assertTrue((boolean)this.tpidsToBeFenced().contains((Object)outputTpid));
            Assertions.assertTrue((BoxesRunTime.equals((Object)this.tpidsToBeFenced().apply((Object)outputTpid), (Object)output.freezeMergedLogStartOffset) ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordOffset >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordTimestamp >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordPartition >= 0 ? 1 : 0) != 0);
            CoreUtils$.MODULE$.uuidFromBase64(output.recordMessageIdBase64);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)output.partition)), output));
        });
        TierTopicManagerConfig config = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1())), tierTopicNamespace, numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor(), -1, "unknown", Predef$.MODULE$.long2Long(Defaults$.MODULE$.TierMetadataMaxPollMs()), Predef$.MODULE$.int2Integer(Defaults$.MODULE$.TierMetadataRequestTimeoutMs()), Defaults$.MODULE$.TierPartitionStateCommitInterval(), Collections.singletonList(this.logDir()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()));
        TierTopicConsumerSupplier primaryConsumerSupplier = new TierTopicConsumerSupplier(config, "primary");
        Consumer verificationConsumer = primaryConsumerSupplier.get();
        Set tierTopicPartitions = TierTopicManager.partitions((String)tierTopic.topicName(), (int)tierTopic.numPartitions().getAsInt());
        verificationConsumer.assign((Collection)tierTopicPartitions);
        tierTopicPartitions.forEach(tp -> verificationConsumer.seekToBeginning(Collections.singletonList(tp)));
        ListBuffer records = new ListBuffer();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$4(this, verificationConsumer, config, records)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out trying to fetch TierTopic records");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.mutable.Set allFencedTpids = (scala.collection.mutable.Set)((SetOps)Set$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)this.tpidsToBeFenced().keySet());
        records.foreach((Function1 & Serializable)record -> {
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            Assertions.assertEquals((Object)TierRecordType.PartitionFence, (Object)((AbstractTierMetadata)eventOpt.get()).type());
            TierPartitionFence fenceEvent = (TierPartitionFence)eventOpt.get();
            Assertions.assertTrue((boolean)allFencedTpids.contains((Object)fenceEvent.topicIdPartition()));
            Assertions.assertTrue((fenceEvent.freezeLogStartOffset() == BoxesRunTime.unboxToBoolean((Object)this.tpidsToBeFenced().apply((Object)fenceEvent.topicIdPartition())) ? 1 : 0) != 0);
            allFencedTpids.remove((Object)fenceEvent.topicIdPartition());
            int userPartition = fenceEvent.topicIdPartition().partition();
            Assertions.assertTrue((boolean)partitionToFenceEventInfoMap.contains((Object)BoxesRunTime.boxToInteger((int)userPartition)));
            FenceEventInfo fenceEventInfo = (FenceEventInfo)partitionToFenceEventInfoMap.apply((Object)BoxesRunTime.boxToInteger((int)userPartition));
            Assertions.assertEquals((Object)fenceEvent.messageId(), (Object)CoreUtils$.MODULE$.uuidFromBase64(fenceEventInfo.recordMessageIdBase64));
            Assertions.assertEquals((long)record.offset(), (long)fenceEventInfo.recordOffset);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$minus$eq((Object)BoxesRunTime.boxToInteger((int)userPartition));
        });
        Assertions.assertTrue((boolean)allFencedTpids.isEmpty());
        verificationConsumer.close();
        TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(config, (Supplier)primaryConsumerSupplier, (Supplier)new TierTopicConsumerSupplier(config, "catchup"), (Supplier)new TierTopicConsumerSupplier(config, "discover"), new TierTopicManagerCommitter(config, this.logDirFailureChannel()), tierStateFetcher, Optional.empty(), (Time)new MockTime());
        this.tpidsToBeFenced().foreach((Function1 & Serializable)x0$1 -> {
            TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$7(this, tierTopicConsumer, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId, x0$1);
            return BoxedUnit.UNIT;
        });
        tierTopicConsumer.initialize((InitializedTierTopic)tierTopic);
        tierTopicConsumer.start();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Function1 & Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$9($this, state)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for fencing");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        tierTopicConsumer.shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$setUp$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$4(TierPartitionStateFencingIntegrationTriggerTest $this, Consumer verificationConsumer$1, TierTopicManagerConfig config$1, ListBuffer records$1) {
        Iterator batchIterator = verificationConsumer$1.poll(config$1.pollDuration).iterator();
        while (batchIterator.hasNext()) {
            records$1.$plus$eq(batchIterator.next());
        }
        return records$1.size() == $this.tpidsToBeFenced().size();
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$5() {
        return "Timed out trying to fetch TierTopic records";
    }

    public static final /* synthetic */ void $anonfun$testPartitionFenceEventInjectionAndFencing$7(TierPartitionStateFencingIntegrationTriggerTest $this, TierTopicConsumer tierTopicConsumer$1, boolean checksumEnabled$1, boolean compactEnabled$1, boolean cleanupEnabled$1, boolean tierPartitionStateSnapshotEnabled$1, int brokerId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition tpid = (TopicIdPartition)x0$1._1();
            $this.addReplica(tpid, tierTopicConsumer$1, checksumEnabled$1, compactEnabled$1, cleanupEnabled$1, tierPartitionStateSnapshotEnabled$1, brokerId$1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$9(TierPartitionStateFencingIntegrationTriggerTest $this, FileTierPartitionState state) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.tpidsToBeFenced().apply(state.topicIdPartition().get()))) {
            TierPartitionStatus tierPartitionStatus = state.status();
            TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
            return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
        }
        TierPartitionStatus tierPartitionStatus = state.status();
        TierPartitionStatus tierPartitionStatus3 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus3) : tierPartitionStatus3 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$10() {
        return "Timed out waiting for fencing";
    }

    public TierPartitionStateFencingIntegrationTriggerTest() {
        this.cleanupIntervalMs = 0;
    }
}

