/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Properties;
import java.util.UUID;
import kafka.server.Defaults;
import kafka.tier.tools.TierMetadataDebugger;
import kafka.tier.tools.TierTopicMaterializationToolConfig;
import kafka.tier.tools.TierTopicMaterializationUtils;
import kafka.utils.CoreUtils;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TierTopicMaterializationUtilsTest {
    private Scheduler scheduler;

    @BeforeEach
    public void setup() {
        this.scheduler = new KafkaScheduler(1, true, "test-scheduler-", false);
        this.scheduler.startup();
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        this.scheduler.shutdown();
    }

    @Test
    public void TierTopicMaterializationToolTest() {
        UUID uuid = UUID.randomUUID();
        Properties props = new Properties();
        props.put("bootstrap-server", "localhost:9092");
        props.put("source-topic-id", CoreUtils.uuidToBase64((UUID)uuid));
        props.put("source-partition", "10");
        props.put("start-offset", "4");
        props.put("working-dir", "/tmp/path");
        props.put("tier-partition-state-cleanup-feature-flag", "true");
        props.put("tier-partition-state-cleanup-interval", "5");
        TierTopicMaterializationToolConfig config = new TierTopicMaterializationToolConfig(props);
        TierTopicMaterializationUtils tool = new TierTopicMaterializationUtils(config, new Properties(), this.scheduler);
        Assertions.assertEquals((Object)tool.config.materializationPath, (Object)"/tmp/path");
        Assertions.assertEquals((Integer)tool.config.userPartition, (int)10);
        Assertions.assertEquals((Object)tool.config.userTopicId, (Object)uuid);
        Assertions.assertEquals((Integer)tool.config.endOffset, (int)-1);
        Assertions.assertEquals((Object)tool.config.dumpHeader, (Object)false);
        Assertions.assertEquals((Object)tool.config.getBoolean("tier-partition-state-cleanup-feature-flag"), (Object)true);
        Assertions.assertEquals((Long)tool.config.getLong("tier-partition-state-cleanup-interval"), (long)5L);
        Assertions.assertEquals((Long)tool.config.getLong("tier-partition-state-cleanup-delay"), (long)Defaults.TierPartitionStateCleanupDelayMs());
    }

    @Test
    public void TierTopicMaterializationToolSetupTest() {
        String[] args = new String[]{"--source-partition", "10", "--start-offset", "5", "--tier-partition-state-cleanup-feature-flag", "true", "--tier-partition-state-cleanup-delay", "50", "--tier-compact-feature-flag", "true"};
        Properties props = TierMetadataDebugger.fetchPropertiesFromArgs((String[])args);
        System.out.println(props);
        System.out.println("source-partition");
        TierTopicMaterializationUtils consumer = new TierTopicMaterializationUtils(new TierTopicMaterializationToolConfig(props), new Properties(), this.scheduler);
        Assertions.assertEquals((Integer)consumer.config.startOffset, (int)0);
        Assertions.assertEquals((Integer)consumer.config.userPartition, (int)10);
        Assertions.assertEquals((Object)consumer.config.userTopicId, (Object)TierTopicMaterializationToolConfig.EMPTY_UUID);
        Assertions.assertEquals((Object)consumer.config.getBoolean("tier-partition-state-cleanup-feature-flag"), (Object)true);
        Assertions.assertEquals((Long)consumer.config.getLong("tier-partition-state-cleanup-delay"), (long)50L);
        Assertions.assertEquals((Long)consumer.config.getLong("tier-partition-state-cleanup-interval"), (long)Defaults.TierPartitionStateCleanupIntervalMs());
        Assertions.assertTrue((boolean)consumer.config.getBoolean("tier-compact-feature-flag"));
    }
}

