/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AdminOperationException;
import kafka.log.LocalLog$;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicDataLossValidator;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Short$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tUh\u0001\u0002(P\u0001YCQ!\u0018\u0001\u0005\u0002y+A!\u0019\u0001\u0001E\u0016!a\u000e\u0001\u0001p\u0011\u001d\u0011\bA1A\u0005\nMDa\u0001 \u0001!\u0002\u0013!\bbB?\u0001\u0005\u0004%IA \u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003\u0000\u0011!\ti\u0001\u0001b\u0001\n\u0013\u0019\bbBA\b\u0001\u0001\u0006I\u0001\u001e\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"!\t\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003KA\u0001\"a\r\u0001A\u0003%\u0011q\u0005\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003oA\u0001\"a\u0010\u0001A\u0003%\u0011\u0011\b\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"a\u0013\u0001A\u0003%\u0011Q\t\u0005\t\u0003\u001b\u0002!\u0019!C\u0005g\"9\u0011q\n\u0001!\u0002\u0013!\b\"CA)\u0001\t\u0007I\u0011BA*\u0011!\t\t\b\u0001Q\u0001\n\u0005U\u0003\"CA:\u0001\t\u0007I\u0011BA;\u0011\u001d\t9\b\u0001Q\u0001\n=D\u0011\"!\u001f\u0001\u0005\u0004%I!a\u001f\t\u000f\u0005u\u0004\u0001)A\u0005E\"I\u0011q\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\b\u0003\u0003\u0003\u0001\u0015!\u0003c\u0011%\t\u0019\t\u0001b\u0001\n\u0013\tY\bC\u0004\u0002\u0006\u0002\u0001\u000b\u0011\u00022\t\u0013\u0005\u001d\u0005A1A\u0005\n\u0005%\u0005\u0002CAL\u0001\u0001\u0006I!a#\t\u0013\u0005e\u0005A1A\u0005\n\u0005m\u0005\u0002CAU\u0001\u0001\u0006I!!(\t\u0013\u0005-\u0006A1A\u0005\n\u00055\u0006\u0002CA[\u0001\u0001\u0006I!a,\t\u0013\u0005]\u0006\u00011A\u0005\n\u0005e\u0006\"CAe\u0001\u0001\u0007I\u0011BAf\u0011!\t9\u000e\u0001Q!\n\u0005m\u0006\"CAm\u0001\t\u0007I\u0011BAn\u0011!\tI\u000f\u0001Q\u0001\n\u0005u\u0007\"CAv\u0001\t\u0007I\u0011BAw\u0011!\t)\u0010\u0001Q\u0001\n\u0005=\b\"CA|\u0001\t\u0007I\u0011BA}\u0011!\u0011\t\u0001\u0001Q\u0001\n\u0005m\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u001b\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005\u000bAqA!\u0005\u0001\t\u0003\u0011)\u0001C\u0005\u0003\u0014\u0001\u0011\r\u0011\"\u0001\u0002z\"A!Q\u0003\u0001!\u0002\u0013\tY\u0010C\u0004\u0003\u0018\u0001!\tA!\u0007\t\u000f\tE\u0002\u0001\"\u0001\u0003\u001a!9!1\b\u0001\u0005\u0002\te\u0001b\u0002B \u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005\u0007\u0002A\u0011\u0001B\r\u0011\u001d\u00119\u0005\u0001C\u0001\u00053AqAa\u0013\u0001\t\u0003\u0011I\u0002C\u0004\u0003P\u0001!\tA!\u0007\t\u000f\tM\u0003\u0001\"\u0001\u0003\u001a!9!q\u000b\u0001\u0005\u0002\te\u0001b\u0002B.\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005?\u0002A\u0011\u0001B\r\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u00053AqAa\u001a\u0001\t\u0003\u0011I\u0002C\u0004\u0003l\u0001!\tA!\u0007\t\u000f\t=\u0004\u0001\"\u0001\u0003\u001a!9!1\u000f\u0001\u0005\u0002\te\u0001b\u0002B<\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005w\u0002A\u0011\u0001B\r\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003CqA!'\u0001\t\u0013\u0011Y\nC\u0005\u0003>\u0002\t\n\u0011\"\u0003\u0003@\"I!Q\u001b\u0001\u0012\u0002\u0013%!q\u001b\u0005\n\u00057\u0004\u0011\u0013!C\u0005\u0005;DqA!9\u0001\t\u0013\u0011I\u0002C\u0004\u0003d\u0002!IA!\u0007\t\u000f\t\u0015\b\u0001\"\u0003\u0003h\n!B+[3s)>\u0004\u0018nY'b]\u0006<WM\u001d+fgRT!\u0001U)\u0002\u000bQ|\u0007/[2\u000b\u0005I\u001b\u0016\u0001\u0002;jKJT\u0011\u0001V\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u000b\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0003\"\u0001\u0019\u0001\u000e\u0003=\u0013\u0001cQ8ogVlWM]*vaBd\u0017.\u001a:\u0011\t\r4\u0007\u000e[\u0007\u0002I*\u0011Q-U\u0001\u0007G2LWM\u001c;\n\u0005\u001d$'\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'\u000fE\u0002YS.L!A[-\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ac\u0017BA7Z\u0005\u0011\u0011\u0015\u0010^3\u0003!A\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003B2qQ\"L!!\u001d3\u0003)5{7m\u001b)s_\u0012,8-\u001a:TkB\u0004H.[3s\u0003%\u0019G.^:uKJLE-F\u0001u!\t)(0D\u0001w\u0015\t9\b0\u0001\u0003mC:<'\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014aa\u0015;sS:<\u0017AC2mkN$XM]%eA\u00059A/Z7q\t&\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002y\u0003\tIw.\u0003\u0003\u0002\n\u0005\r!\u0001\u0002$jY\u0016\f\u0001\u0002^3na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u00059An\\4ESJ\u001cXCAA\u000b!\u0015\t9\"!\bu\u001b\t\tIBC\u0002\u0002\u001ca\fA!\u001e;jY&!\u0011qDA\r\u0005%\t%O]1z\u0019&\u001cH/\u0001\u0005m_\u001e$\u0015N]:!\u0003A!\u0018.\u001a:Ti\u0006$XMR3uG\",'/\u0006\u0002\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.E\u000bqAZ3uG\",'/\u0003\u0003\u00022\u0005-\"\u0001\u0005+jKJ\u001cF/\u0019;f\r\u0016$8\r[3s\u0003E!\u0018.\u001a:Ti\u0006$XMR3uG\",'\u000fI\u0001\u0017i&,'\u000fV8qS\u000etU/\u001c)beRLG/[8ogV\u0011\u0011\u0011\b\t\u00041\u0006m\u0012bAA\u001f3\n)1\u000b[8si\u00069B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0017i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jOV\u0011\u0011Q\t\t\u0004A\u0006\u001d\u0013bAA%\u001f\n1B+[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw-A\fuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5hA\u0005iA/[3s)>\u0004\u0018n\u0019(b[\u0016\fa\u0002^5feR{\u0007/[2OC6,\u0007%A\nuS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002VA1\u0011qCA,\u00037JA!!\u0017\u0002\u001a\t\u00191+\u001a;\u0011\t\u0005u\u0013QN\u0007\u0003\u0003?RA!!\u0019\u0002d\u000511m\\7n_:T1\u0001VA3\u0015\u0011\t9'!\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY'A\u0002pe\u001eLA!a\u001c\u0002`\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0006;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\tqe>$WoY3s'V\u0004\b\u000f\\5feV\tq.A\tqe>$WoY3s'V\u0004\b\u000f\\5fe\u0002\nq\u0003\u001d:j[\u0006\u0014\u0018pQ8ogVlWM]*vaBd\u0017.\u001a:\u0016\u0003\t\f\u0001\u0004\u001d:j[\u0006\u0014\u0018pQ8ogVlWM]*vaBd\u0017.\u001a:!\u0003]\u0019\u0017\r^2ikB\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'/\u0001\rdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0002\n\u0001\u0004Z5tG>4XM]\"p]N,X.\u001a:TkB\u0004H.[3s\u0003e!\u0017n]2pm\u0016\u00148i\u001c8tk6,'oU;qa2LWM\u001d\u0011\u0002\u001b%tG/\u001a:oC2\fE-\\5o+\t\tY\t\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\tjU\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005U\u0015q\u0012\u0002\u000e\u0013:$XM\u001d8bY\u0006#W.\u001b8\u0002\u001d%tG/\u001a:oC2\fE-\\5oA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005u\u0005\u0003BAP\u0003Kk!!!)\u000b\u0007\u0005\r6+A\u0002m_\u001eLA!a*\u0002\"\nQAj\\4NC:\fw-\u001a:\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\ty\u000b\u0005\u0003\u0002\u000e\u0006E\u0016\u0002BAZ\u0003\u001f\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003]!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GS2,7/\u0006\u0002\u0002<B!\u0001,[A_!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAb#\u0006)1\u000f^1uK&!\u0011qYAa\u0005Y1\u0015\u000e\\3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017a\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0006M\u0007c\u0001-\u0002P&\u0019\u0011\u0011[-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003+,\u0013\u0011!a\u0001\u0003w\u000b1\u0001\u001f\u00132\u0003a!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GS2,7\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002^B!\u0011q\\As\u001b\t\t\tOC\u0002\u0002dN\u000bQ!\u001e;jYNLA!a:\u0002b\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\bdY\u0016\fg.\u001e9EK2\f\u00170T:\u0016\u0005\u0005=\bc\u0001-\u0002r&\u0019\u00111_-\u0003\t1{gnZ\u0001\u0010G2,\u0017M\\;q\t\u0016d\u0017-_'tA\u0005\t2\r\\3b]V\u0004\u0018J\u001c;feZ\fG.T:\u0016\u0005\u0005m\bc\u0001-\u0002~&\u0019\u0011q`-\u0003\u0007%sG/\u0001\ndY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0013aD2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3\u0016\u0005\t\u001d\u0001c\u0001-\u0003\n%\u0019!1B-\u0003\u000f\t{w\u000e\\3b]\u0006q1m\\7qC\u000e$XI\\1cY\u0016$\u0017AD2mK\u0006tW\u000f]#oC\ndW\rZ\u0001\"i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00158baNDw\u000e^#oC\ndW\rZ\u0001\tEJ|7.\u001a:JI\u0006I!M]8lKJLE\rI\u0001\ti\u0016\f'\u000fZ8x]R\u0011\u0011Q\u001a\u0015\u0004g\tu\u0001\u0003\u0002B\u0010\u0005[i!A!\t\u000b\t\t\r\"QE\u0001\u0004CBL'\u0002\u0002B\u0014\u0005S\tqA[;qSR,'O\u0003\u0003\u0003,\u0005%\u0014!\u00026v]&$\u0018\u0002\u0002B\u0018\u0005C\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f^!eI6+G/\u00193bi\u0006\u0014UMZ8sKJ+\u0017\rZ=)\u0007Q\u0012)\u0004\u0005\u0003\u0003 \t]\u0012\u0002\u0002B\u001d\u0005C\u0011A\u0001V3ti\u0006yB/Z:u\tV\u0004H.[2bi\u0016\u0014V-];fgR\u0014UMZ8sKJ+\u0017\rZ=)\u0007U\u0012)$\u0001\u0018uKN$(+\u001a;ss>sWK\\6o_^tW\t_2faRLwN\u001c#ve&tw\rV8qS\u000e\u001c%/Z1uS>t\u0007f\u0001\u001c\u00036\u0005\u0019C/Z:u!\u0006\u0014H/\u001b;j_:,'oU3ukB<\u0006.\u001a8U_BL7-\u0012=jgR\u001c\bfA\u001c\u00036\u0005\u0019B/Z:u%\u0016$(/[3e\u001b\u0016\u001c8/Y4fg\"\u001a\u0001H!\u000e\u0002uQ,7\u000f\u001e$f]\u000eLgn\u001a,jCB\u000b'\u000f^5uS>tg)\u001a8dK\u00163XM\u001c;P]\u0016k\u0007\u000f^=US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0007fA\u001d\u00036\u0005iD/Z:u\r\u0016t7-\u001b8h-&\f\u0007+\u0019:uSRLwN\u001c$f]\u000e,WI^3oi>sgj\u001c8F[B$\u0018\u0010V5feB\u000b'\u000f^5uS>t7\u000b^1uK\"\u001a!H!\u000e\u0002mQ,7\u000f\u001e$viV\u0014X-T3tg\u0006<WMR3oG\u0016$\u0017I\u001a;feB\u000b'\u000f^5uS>tG)\u001a7fi\u0016\u0004&/Z%oSRL\u0017\r^3)\u0007m\u0012)$A\u0012uKN$8+\u001a;FeJ|'\u000fU1si&$\u0018n\u001c8t\tV\u0014\u0018N\\4GK:\u001c\u0017N\\4)\u0007q\u0012)$A\u0010uKN$(+Z2pm\u0016\u0014x\u000b[5mK\u000e\u000bGo\u00195va\u000e{gn];nKJD3!\u0010B\u001b\u0003\u0019\"Xm\u001d;IC:$G.\u001b8h\r>\u0014(+Z:u_J,wJ\u001c(p]\u0016\u0013(o\u001c:Ti\u0006$Xo\u001d\u0015\u0004}\tU\u0012\u0001\u000e;fgR\u0004&o\\2fgNlUm]:bO\u0016\u001c\bk\\:u'R\fG/\u001a$f]\u000eLgn\u001a#ve&twm\u00148mS:,7\u000b^1uK\"\u001aqH!\u000e\u0002\u0015R,7\u000f\u001e+sC:\u001c\u0018\u000e^5p]\u001a\u0013x.\\\"bi\u000eDW\u000f]\"p]N,X.\u001a:U_B\u0013\u0018.\\1ss\u000e{gn];nKJLe.\u0012:s_J\u001cF/\u0019;f)\",gNU3d_Z,'/\u001f\u0015\u0004\u0001\nU\u0012!\u000b;fgR$U\r^3di\u0012\u000bG/\u0019'pgNLe\u000eV5feR{\u0007/[2O_R$&/[4hKJ,G\rK\u0002B\u0005k\tQ\u0004^3ti\u0012+G/Z2u\t\u0006$\u0018\rT8tg&sG+[3s)>\u0004\u0018n\u0019\u0015\u0004\u0005\nU\u0012\u0001\t;fgR<U\r\u001e+jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014Vm];miND3a\u0011B\u001b\u0003Q!Xm\u001d;WC2LG-\u0019;f\t\u0006$\u0018\rT8tg\"\u001aAI!\u000e\u0002OQ,7\u000f^$fiRKWM\u001d+pa&\u001cW*\u0019=PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195Cs\u001a#\bo\u001d\u0015\u0004\u000b\nU\u0012AC1eIJ+\u0007\u000f\\5dCR1\u0011Q\u001aBB\u0005\u001fCqA!\"G\u0001\u0004\u00119)\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B!!\u0011\u0012BF\u001b\u0005\t\u0016b\u0001BG#\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005#3\u0005\u0019\u0001BJ\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\t\u0004A\nU\u0015b\u0001BL\u001f\n\tB+[3s)>\u0004\u0018nY\"p]N,X.\u001a:\u0002'M,G/\u001e9US\u0016\u00148i\\7q_:,g\u000e^:\u0015\u0015\tu%q\u0016BY\u0005k\u00139\fE\u0005Y\u0005?\u0013\u0019Ja)\u0003*&\u0019!\u0011U-\u0003\rQ+\b\u000f\\34!\u0011\u0011II!*\n\u0007\t\u001d\u0016K\u0001\nUS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bc\u00011\u0003,&\u0019!QV(\u0003!QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b\"CA!\u000fB\u0005\t\u0019AA#\u0011\u001d\u0011\u0019l\u0012a\u0001\u0005\u000f\t1BY3d_6,'+Z1es\"I\u0011\u0011T$\u0011\u0002\u0003\u0007\u0011Q\u0014\u0005\n\u0003g:\u0005\u0013!a\u0001\u0005s\u00032Aa/\u0004\u001b\u0005\u0001\u0011!H:fiV\u0004H+[3s\u0007>l\u0007o\u001c8f]R\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0005'\u0006BA#\u0005\u0007\\#A!2\u0011\t\t\u001d'\u0011[\u0007\u0003\u0005\u0013TAAa3\u0003N\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001fL\u0016AC1o]>$\u0018\r^5p]&!!1\u001bBe\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001eg\u0016$X\u000f\u001d+jKJ\u001cu.\u001c9p]\u0016tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u001c\u0016\u0005\u0003;\u0013\u0019-A\u000ftKR,\b\u000fV5fe\u000e{W\u000e]8oK:$8\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yN\u000b\u0003\u0003:\n\r\u0017!G7pm\u0016\u0014VmY8sIN$v.\u00117m\u0007>t7/^7feN\fAD]3tK:$\u0007K]3wS>,8\u000f\u0015:pIV\u001cWMU3rk\u0016\u001cH/\u0001\bcK\u000e|W.Z!sG\"Lg/\u001a:\u0015\u0015\u00055'\u0011\u001eBv\u0005_\u0014\u0019\u0010C\u0004\u0003\u00066\u0003\rAa\"\t\u000f\t5X\n1\u0001\u0002|\u0006YA.Z1eKJ,\u0005o\\2i\u0011\u001d\u0011\t0\u0014a\u0001\u0005S\u000b\u0001\u0003^5feR{\u0007/[2NC:\fw-\u001a:\t\u000f\tEU\n1\u0001\u0003\u0014\u0002")
public class TierTopicManagerTest {
    private final String clusterId;
    private final File tempDir = TestUtils.tempDirectory(null, null);
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final short tierTopicNumPartitions = (short)7;
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()));
    private final String tierTopicName = TierTopic.topicName((String)"");
    private final java.util.Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("discover", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
    private final LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final kafka.utils.MockTime time = new kafka.utils.MockTime();
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final int brokerId;

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private java.util.Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier() {
        return this.discoverConsumerSupplier;
    }

    private InternalAdmin internalAdmin() {
        return this.internalAdmin;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private kafka.utils.MockTime time() {
        return this.time;
    }

    private long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    private int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean compactEnabled() {
        return false;
    }

    public boolean cleanupEnabled() {
        return false;
    }

    public boolean tierPartitionStateSnapshotEnabled() {
        return false;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @AfterEach
    public void teardown() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Function1 & Serializable)tierPartitionState -> {
            TierTopicManagerTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        Mockito.framework().clearInlineMocks();
        Utils.delete((File)new File(this.logDir()), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddMetadataBeforeReady() {
        void var6_6;
        void var7_7;
        MockProducerSupplier<byte[], byte[]> x$4;
        LogManager x$3;
        int epoch = 0;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, x$3 = this.setupTierComponents$default$3(), x$4 = this.setupTierComponents$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var7_7.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo_1", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(topicIdPartition_1, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_1.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_1), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        var6_6.register(topicIdPartition_1, clientCtx_1);
        Assertions.assertEquals((int)1, (int)var6_6.immigratingPartitions().size());
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("foo_2", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(topicIdPartition_2, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_2.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_2), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        var6_6.register(topicIdPartition_2, clientCtx_2);
        Assertions.assertEquals((int)2, (int)var6_6.immigratingPartitions().size());
        CompletableFuture future_1 = var7_7.addMetadata((AbstractTierMetadata)initLeader_1);
        CompletableFuture future_2 = var7_7.addMetadata((AbstractTierMetadata)initLeader_2);
        Assertions.assertTrue((boolean)var7_7.tryBecomeReady(false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$1(this, (TierTopicConsumer)var6_6, future_1, future_2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for futures to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_1.get());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_2.get());
        Assertions.assertEquals((int)2, (int)var6_6.primaryConsumerPartitions().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDuplicateRequestBeforeReady() {
        void var8_8;
        void var7_7;
        MockProducerSupplier<byte[], byte[]> x$4;
        LogManager x$3;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int epoch = 0;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, x$3 = this.setupTierComponents$default$3(), x$4 = this.setupTierComponents$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        Assertions.assertFalse((boolean)var8_8.isReadyForWrites());
        UUID objectId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, epoch, objectId, 0);
        CompletableFuture oldInitLeaderResult = var8_8.addMetadata((AbstractTierMetadata)initLeader);
        CompletableFuture newInitLeaderResult = var8_8.addMetadata((AbstractTierMetadata)initLeader);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (TierPartitionState.AppendResult)oldInitLeaderResult.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TierTopicManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169))).getCause() instanceof TierMetadataFatalException));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        Assertions.assertTrue((boolean)var8_8.tryBecomeReady(false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$2(this, (TierTopicConsumer)var7_7, newInitLeaderResult)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting to become archiver");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, newInitLeaderResult.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryOnUnknownExceptionDuringTopicCreation() {
        void var5_5;
        void var6_6;
        MockProducerSupplier<byte[], byte[]> x$4;
        LogManager x$3;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, x$3 = this.setupTierComponents$default$3(), x$4 = this.setupTierComponents$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var6_6.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new TimeoutException("timeout when creating topic")}).thenThrow(new Throwable[]{new AdminOperationException("admin operation exception")}).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        var6_6.tryBecomeReady(false);
        Assertions.assertFalse((boolean)var6_6.isReadyForWrites());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)1))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        var6_6.tryBecomeReady(false);
        Assertions.assertFalse((boolean)var6_6.isReadyForWrites());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)2))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        var6_6.tryBecomeReady(false);
        Assertions.assertTrue((boolean)var6_6.isReadyForWrites());
        ((InternalAdmin)Mockito.verify((Object)this.internalAdmin(), (VerificationMode)Mockito.times((int)3))).ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any());
        Assertions.assertEquals((int)this.tierTopicNumPartitions(), (int)var5_5.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionerSetupWhenTopicExists() {
        void var6_6;
        void var7_7;
        MockProducerSupplier<byte[], byte[]> x$4;
        LogManager x$3;
        int existingPartitions = this.tierTopicNumPartitions() - 2;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, x$3 = this.setupTierComponents$default$3(), x$4 = this.setupTierComponents$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var7_7.isReadyForWrites());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)existingPartitions));
        var7_7.tryBecomeReady(false);
        Assertions.assertTrue((boolean)var7_7.isReadyForWrites());
        Assertions.assertEquals((int)existingPartitions, (int)var6_6.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetriedMessages() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var8_8, (TierTopicConsumer)var7_7);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResult = var8_8.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, initiateResult.get());
        this.resendPreviousProduceRequest();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        CompletableFuture completeResult = var8_8.addMetadata((AbstractTierMetadata)uploadComplete);
        var7_7.doWork();
        Assertions.assertFalse((boolean)completeResult.isDone(), (String)"Upload complete result should not have been completed by materialization of UploadInitiate");
        Assertions.assertEquals((long)1L, (long)var7_7.numListeners());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnEmptyTierPartitionState() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        CompletableFuture partitionFenceFuture = var8_8.addMetadata((AbstractTierMetadata)partitionFence);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(this, (TierTopicConsumer)var7_7, partitionFenceFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out trying to finish TierPartitionFence");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var7_7.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnNonEmptyTierPartitionState() {
        void var9_9;
        void var8_8;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var8_8);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var9_9, (TierTopicConsumer)var8_8);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var9_9.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var8_8.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var8_8.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var8_8.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = var9_9.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        var8_8.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadCompleteFuture.get());
        Assertions.assertEquals((Object)uploadInitiate.messageId(), (Object)((TierLogSegment)this.tierPartitionStateFiles()[0].metadata(100L).get()).objectId());
        Assertions.assertEquals((int)0, (int)var8_8.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var8_8.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture partitionFenceFuture = var9_9.addMetadata((AbstractTierMetadata)partitionFence);
        this.moveRecordsToAllConsumers();
        var8_8.doWork();
        Assertions.assertTrue((boolean)partitionFenceFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var8_8.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var8_8.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var8_8.primaryConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFutureMessageFencedAfterPartitionDeletePreInitiate() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 31;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var8_8, (TierTopicConsumer)var7_7);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var8_8.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeletePreInitiate partitionDeletePreInitiate = new TierPartitionDeletePreInitiate(topicIdPartition, UUID.randomUUID());
        CompletableFuture partitionDeletePreInitiateFuture = var8_8.addMetadata((AbstractTierMetadata)partitionDeletePreInitiate);
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)partitionDeletePreInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, partitionDeletePreInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierSegmentUploadInitiate newUploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 101L, 200L, 200L, 200L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture newUploadInitiateFuture = var8_8.addMetadata((AbstractTierMetadata)newUploadInitiate);
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)newUploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, newUploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = var8_8.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
        TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID());
        CompletableFuture deleteInitiateFuture = var8_8.addMetadata((AbstractTierMetadata)deleteInitiate);
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)deleteInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, deleteInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.PENDING_DELETION, (Object)this.tierPartitionStateFiles()[0].status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetErrorPartitionsDuringFencing() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var6_6);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResultFuture = var7_7.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$1(this, (TierTopicConsumer)var6_6, initiateResultFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out trying to finish TierSegmentUploadInitiate");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, initiateResultFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var6_6.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var6_6.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var6_6.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverWhileCatchupConsumer() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var8_8, (TierTopicConsumer)var7_7);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        state.flush();
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, state.lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = var8_8.addMetadata((AbstractTierMetadata)uploadComplete);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var8_8.addMetadata((AbstractTierMetadata)uploadInitiate);
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenThrow(new Throwable[]{new IOException("couldn't fetch")}).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)1, (int)var7_7.catchUpConsumerPartitions().size());
        Assertions.assertTrue((boolean)var7_7.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var7_7.catchUpConsumerErrorPartitions().isEmpty());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$1(this, (TierTopicConsumer)var7_7, uploadCompleteFuture, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CompletableFuture becomeArchiverFinalFuture = var8_8.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)2))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlingForRestoreOnNonErrorStatus() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        CompletableFuture becomeArchiverFinalFuture = var8_8.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var7_7.primaryConsumerPartitions().size());
        state.flush();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer restoreBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)restoreBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$1(this, (TierTopicConsumer)var7_7)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)var7_7.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var7_7.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessMessagesPostStateFencingDuringOnlineState() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)var8_8, (TierTopicConsumer)var7_7);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = var8_8.addMetadata((AbstractTierMetadata)uploadComplete);
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var7_7.primaryConsumerErrorPartitions()).asScala());
        state.flush();
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var8_8.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var7_7.primaryConsumerErrorPartitions()).asScala());
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(this, (TierTopicConsumer)var7_7)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)var7_7.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var7_7.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = var8_8.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)1))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        this.addReplica(topicIdPartition, (TierTopicConsumer)var7_7);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.primaryConsumerErrorPartitions().size());
        state.flush();
        Path flushedPath = Paths.get(state.flushedPath(), new String[0]);
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(flushedPath);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, true, false, false, TierUploadType.Archive, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = var8_8.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(this, (TierTopicConsumer)var7_7, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for upload initiate future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)1, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertTrue((boolean)var7_7.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var7_7.primaryConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)1, (int)var7_7.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerPartitions().size());
        CompletableFuture becomeArchiverFuture = var8_8.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, becomeArchiverFuture.get());
        Assertions.assertEquals((int)0, (int)var7_7.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)var7_7.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(var7_7.primaryConsumerErrorPartitions()).asScala());
        Algorithm algorithm = ChecksumUtils.tierStateFileAlgorithm((Path)flushedPath);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.Byte2byte(algorithm.id));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(this, (TierTopicConsumer)var7_7)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for recover metadata future");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)var7_7.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)var7_7.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = var8_8.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        var7_7.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDetectDataLossInTierTopicNotTriggered() {
        void var9_9;
        void var5_5;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicNumPartitions())));
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        LogManager x$3 = this.setupTierComponents$default$3();
        MockProducerSupplier<byte[], byte[]> x$4 = this.setupTierComponents$default$4();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, true, x$3, x$4);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager_0 = (TierTopicManager)tuple3._3();
        Assertions.assertFalse((boolean)var5_5.detectDataLossInTierTopicHead());
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logManager.hadCleanShutdown())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierTopicManagerConfig newTierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(true), Predef$.MODULE$.boolean2Boolean(true));
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple32 = this.setupTierComponents(newTierTopicManagerConfig, true, logManager, this.setupTierComponents$default$4());
        if (tuple32 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager_1 = (TierTopicManager)tuple32._3();
        Assertions.assertFalse((boolean)var9_9.detectDataLossInTierTopicHead());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logManager.hadCleanShutdown())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)logManager.allLogs()).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Assertions.assertFalse((boolean)var9_9.detectDataLossInTierTopicHead());
        TierTopicManager spyTierTopicManager = (TierTopicManager)Mockito.spy((Object)var9_9);
        HashMap<TopicPartition, OffsetAndEpoch> tierTopicPartitionOffsetAndEpochMap = new HashMap<TopicPartition, OffsetAndEpoch>();
        tierTopicPartitionOffsetAndEpochMap.put(new TopicPartition("_confluent-tier-state", 5), new OffsetAndEpoch(12L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        ((TierTopicManager)Mockito.doAnswer(arg_0 -> TierTopicManagerTest.$anonfun$testDetectDataLossInTierTopicNotTriggered$2((TierTopicManager)var9_9, tierTopicPartitionOffsetAndEpochMap, arg_0)).when((Object)spyTierTopicManager)).dataLossValidator();
        Assertions.assertFalse((boolean)spyTierTopicManager.detectDataLossInTierTopicHead());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDetectDataLossInTierTopic() {
        void var6_6;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.internalAdmin().ensureTopic((String)ArgumentMatchers.eq((Object)this.tierTopicName()), ArgumentMatchers.eq((int)this.tierTopicNumPartitions()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logManager.hadCleanShutdown())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        TierTopicManagerConfig newTierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(true), Predef$.MODULE$.boolean2Boolean(true));
        MockProducerSupplier producerSupplier = (MockProducerSupplier)Mockito.mock(MockProducerSupplier.class);
        KafkaProducer producer = (KafkaProducer)Mockito.mock(KafkaProducer.class);
        Mockito.when(producerSupplier.get()).thenReturn((Object)producer);
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(newTierTopicManagerConfig, false, logManager, producerSupplier);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        TierTopicManager spyTierTopicManager = (TierTopicManager)Mockito.spy((Object)var6_6);
        HashMap<TopicPartition, OffsetAndEpoch> tierTopicPartitionOffsetAndEpochMap = new HashMap<TopicPartition, OffsetAndEpoch>();
        TopicPartition tierTopicPartition = new TopicPartition("_confluent-tier-state", 0);
        OffsetAndEpoch offsetAndEpochFromFtps = new OffsetAndEpoch(12L, Optional.of(Predef$.MODULE$.int2Integer(5)));
        tierTopicPartitionOffsetAndEpochMap.put(tierTopicPartition, offsetAndEpochFromFtps);
        ConfluentAdmin adminClient = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        KafkaFuture kafkaFutureForPartitionResult = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)kafkaFutureForPartitionResult.get()).thenReturn((Object)new PartitionResult(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()));
        Mockito.when((Object)adminClient.replicaStatus((java.util.Set)ArgumentMatchers.eq(tierTopicPartitionOffsetAndEpochMap.keySet()), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)new ReplicaStatusResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition), (Object)kafkaFutureForPartitionResult)}))).asJava()));
        long tierTopicPartitionEndOffset = offsetAndEpochFromFtps.offset() - 1L;
        RemoteLeaderEndPoint leaderEndPoint = (RemoteLeaderEndPoint)Mockito.mock(RemoteLeaderEndPoint.class);
        Mockito.when((Object)leaderEndPoint.fetchEpochEndOffsetsAsJava((java.util.Map)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(5).setEndOffset(tierTopicPartitionEndOffset))}))).asJava());
        TopicIdPartition userTopicPartition0 = new TopicIdPartition("utp", UUID.randomUUID(), 0);
        TopicIdPartition userTopicPartition1 = new TopicIdPartition("utp", UUID.randomUUID(), 1);
        MergedLog log0 = (MergedLog)Mockito.mock(MergedLog.class);
        MergedLog log1 = (MergedLog)Mockito.mock(MergedLog.class);
        Mockito.when((Object)logManager.allLogs()).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MergedLog[]{log0, log1})));
        FileTierPartitionState ftps0 = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
        FileTierPartitionState ftps1 = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
        Mockito.when((Object)log0.topicIdPartition()).thenReturn((Object)Option$.MODULE$.apply((Object)userTopicPartition0));
        Mockito.when((Object)log1.topicIdPartition()).thenReturn((Object)Option$.MODULE$.apply((Object)userTopicPartition1));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log0.isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log1.isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log0.isStray())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log1.isStray())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)log0.tierPartitionState()).thenReturn((Object)ftps0);
        Mockito.when((Object)log1.tierPartitionState()).thenReturn((Object)ftps1);
        Mockito.when((Object)ftps0.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)ftps1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)ftps0.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)offsetAndEpochFromFtps);
        Mockito.when((Object)ftps1.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        RecordMetadata recordMetadata0 = new RecordMetadata(tierTopicPartition, tierTopicPartitionEndOffset, 0, -1L, -1, -1);
        RecordMetadata recordMetadata1 = new RecordMetadata(tierTopicPartition, tierTopicPartitionEndOffset, 1, -1L, -1, -1);
        RecordMetadata recordMetadata2 = new RecordMetadata(tierTopicPartition, tierTopicPartitionEndOffset, 2, -1L, -1, -1);
        Future recordMetadataFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)producer.send((ProducerRecord)ArgumentMatchers.any())).thenReturn((Object)recordMetadataFuture);
        Mockito.when(recordMetadataFuture.get()).thenReturn((Object)recordMetadata0).thenReturn((Object)recordMetadata1).thenReturn((Object)recordMetadata2);
        ((TierTopicManager)Mockito.doAnswer(arg_0 -> TierTopicManagerTest.$anonfun$testDetectDataLossInTierTopic$2((TierTopicManager)var6_6, tierTopicPartitionOffsetAndEpochMap, adminClient, leaderEndPoint, arg_0)).when((Object)spyTierTopicManager)).dataLossValidator();
        spyTierTopicManager.tryBecomeReady(false);
        ((LogManager)Mockito.verify((Object)logManager, (VerificationMode)Mockito.times((int)1))).hadCleanShutdown();
        ((KafkaFuture)Mockito.verify((Object)kafkaFutureForPartitionResult, (VerificationMode)Mockito.times((int)2))).get();
        ((ConfluentAdmin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)2))).replicaStatus((java.util.Set)ArgumentMatchers.eq(tierTopicPartitionOffsetAndEpochMap.keySet()), (ReplicaStatusOptions)ArgumentMatchers.any());
        ((RemoteLeaderEndPoint)Mockito.verify((Object)leaderEndPoint, (VerificationMode)Mockito.times((int)1))).fetchEpochEndOffsetsAsJava((java.util.Map)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)logManager, (VerificationMode)Mockito.times((int)1))).allLogs();
        ((KafkaProducer)Mockito.verify((Object)producer, (VerificationMode)Mockito.times((int)3))).send((ProducerRecord)ArgumentMatchers.any());
        Mockito.when((Object)leaderEndPoint.fetchEpochEndOffsetsAsJava((java.util.Map)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(5).setEndOffset(20L))}))).asJava());
        Assertions.assertFalse((boolean)spyTierTopicManager.detectDataLossInTierTopicHead());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetTierTopicPartitionResults() {
        void var5_5;
        MockProducerSupplier<byte[], byte[]> x$4;
        LogManager x$3;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, x$3 = this.setupTierComponents$default$3(), x$4 = this.setupTierComponents$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        TopicPartition tierTopicPartition_0 = new TopicPartition(this.tierTopicName(), 0);
        KafkaFuture kafkaFuture_0 = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        PartitionResult partitionResult_0 = new PartitionResult(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        Mockito.when((Object)kafkaFuture_0.get()).thenReturn((Object)partitionResult_0);
        TopicPartition tierTopicPartition_1 = new TopicPartition(this.tierTopicName(), 1);
        KafkaFuture kafkaFuture_1 = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)kafkaFuture_1.get()).thenThrow(new Throwable[]{new TimeoutException()});
        ReplicaStatusResult replicaStatusResult = new ReplicaStatusResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition_0), (Object)kafkaFuture_0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition_1), (Object)kafkaFuture_1)}))).asJava());
        ConfluentAdmin adminClient = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        Mockito.when((Object)adminClient.replicaStatus((java.util.Set)ArgumentMatchers.any(), (ReplicaStatusOptions)ArgumentMatchers.any())).thenReturn((Object)replicaStatusResult);
        java.util.Map tierTopicPartitionResults = var5_5.dataLossValidator().getTierTopicPartitionLeaderInfo(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tierTopicPartition_0, tierTopicPartition_1}))).asJava(), adminClient);
        Assertions.assertEquals((int)2, (int)tierTopicPartitionResults.size());
        Assertions.assertEquals((Object)partitionResult_0, tierTopicPartitionResults.get(tierTopicPartition_0));
        Assertions.assertEquals((int)-1, (int)((PartitionResult)tierTopicPartitionResults.get(tierTopicPartition_1)).leaderId());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateDataLoss() {
        void var5_5;
        MockProducerSupplier<byte[], byte[]> x$4;
        LogManager x$3;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, false, x$3 = this.setupTierComponents$default$3(), x$4 = this.setupTierComponents$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        HashMap dataLossPartitionEndOffset = new HashMap();
        TopicPartition tierTopicPartition_0 = new TopicPartition("_confluent-tier-state", 0);
        OffsetAndEpoch offsetAndEpochFromFtps_0 = new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(1)));
        TopicPartition tierTopicPartition_1 = new TopicPartition("_confluent-tier-state", 1);
        OffsetAndEpoch offsetAndEpochFromFtps_1 = new OffsetAndEpoch(15L, Optional.of(Predef$.MODULE$.int2Integer(2)));
        TopicPartition tierTopicPartition_2 = new TopicPartition("_confluent-tier-state", 2);
        OffsetAndEpoch offsetAndEpochFromFtps_2 = new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1)));
        TopicPartition tierTopicPartition_3 = new TopicPartition("_confluent-tier-state", 3);
        OffsetAndEpoch offsetAndEpochFromFtps_3 = new OffsetAndEpoch(25L, Optional.of(Predef$.MODULE$.int2Integer(3)));
        HashMap<TopicPartition, OffsetAndEpoch> partitionToValidate = new HashMap<TopicPartition, OffsetAndEpoch>();
        partitionToValidate.put(tierTopicPartition_0, offsetAndEpochFromFtps_0);
        partitionToValidate.put(tierTopicPartition_1, offsetAndEpochFromFtps_1);
        partitionToValidate.put(tierTopicPartition_2, offsetAndEpochFromFtps_2);
        partitionToValidate.put(tierTopicPartition_3, offsetAndEpochFromFtps_3);
        HashMap<TopicPartition, PartitionResult> leaderInfoMapBefore = new HashMap<TopicPartition, PartitionResult>();
        HashMap<TopicPartition, PartitionResult> leaderInfoMapAfter = new HashMap<TopicPartition, PartitionResult>();
        PartitionResult partitionResult_0 = new PartitionResult(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        PartitionResult partitionResult_1 = new PartitionResult(3, 10, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        PartitionResult partitionResult_2 = new PartitionResult(2, 5, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        leaderInfoMapBefore.put(tierTopicPartition_0, partitionResult_0);
        leaderInfoMapAfter.put(tierTopicPartition_0, partitionResult_0);
        leaderInfoMapBefore.put(tierTopicPartition_1, partitionResult_1);
        leaderInfoMapAfter.put(tierTopicPartition_1, partitionResult_1);
        leaderInfoMapBefore.put(tierTopicPartition_2, partitionResult_2);
        leaderInfoMapAfter.put(tierTopicPartition_2, partitionResult_2);
        leaderInfoMapBefore.put(tierTopicPartition_3, new PartitionResult(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()));
        leaderInfoMapAfter.put(tierTopicPartition_3, new PartitionResult(3, 2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()));
        HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> epochEndOffsetsResMap = new HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>();
        epochEndOffsetsResMap.put(tierTopicPartition_0, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(1).setEndOffset(15L).setErrorCode(Errors.NONE.code()));
        epochEndOffsetsResMap.put(tierTopicPartition_1, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(2).setEndOffset(9L).setErrorCode(Errors.NONE.code()));
        epochEndOffsetsResMap.put(tierTopicPartition_2, new OffsetForLeaderEpochResponseData.EpochEndOffset().setErrorCode(Errors.BROKER_NOT_AVAILABLE.code()));
        epochEndOffsetsResMap.put(tierTopicPartition_3, new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(3).setEndOffset(30L).setErrorCode(Errors.NONE.code()));
        var5_5.dataLossValidator().validateDataLoss(partitionToValidate, dataLossPartitionEndOffset, epochEndOffsetsResMap, leaderInfoMapBefore, leaderInfoMapAfter);
        Assertions.assertEquals((int)1, (int)dataLossPartitionEndOffset.size());
        Assertions.assertEquals((long)9L, (Long)dataLossPartitionEndOffset.getOrDefault(tierTopicPartition_1, Predef$.MODULE$.long2Long(-1L)));
        Assertions.assertEquals((int)2, (int)partitionToValidate.size());
        Assertions.assertTrue((boolean)partitionToValidate.containsKey(tierTopicPartition_2));
        Assertions.assertTrue((boolean)partitionToValidate.containsKey(tierTopicPartition_3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetTierTopicMaxOffsetAndEpochByFtps() {
        void var6_6;
        MockProducerSupplier<byte[], byte[]> x$4;
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        TierTopic tierTopic = (TierTopic)Mockito.mock(TierTopic.class);
        TierTopicManagerConfig x$3 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$3, false, logManager, x$4 = this.setupTierComponents$default$4());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        TopicPartition tierTopicPartition_0 = new TopicPartition("_confluent-tier-state", 0);
        TopicPartition tierTopicPartition_1 = new TopicPartition("_confluent-tier-state", 1);
        MergedLog log_0 = (MergedLog)Mockito.mock(MergedLog.class);
        TopicIdPartition topicIdPartition_0 = new TopicIdPartition("test", UUID.randomUUID(), 0);
        FileTierPartitionState tierPartitionState_0 = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
        OffsetAndEpoch localMaterializedOffsetAndEpoch_0 = new OffsetAndEpoch(12L, Optional.of(Predef$.MODULE$.int2Integer(1)));
        Mockito.when((Object)log_0.tierPartitionState()).thenReturn((Object)tierPartitionState_0);
        Mockito.when((Object)log_0.topicIdPartition()).thenReturn((Object)Option$.MODULE$.apply((Object)topicIdPartition_0));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_0.isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_0.isStray())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)tierPartitionState_0.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)tierPartitionState_0.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)localMaterializedOffsetAndEpoch_0);
        Mockito.when((Object)tierTopic.toTierTopicPartition(topicIdPartition_0)).thenReturn((Object)tierTopicPartition_1);
        MergedLog log_1 = (MergedLog)Mockito.mock(MergedLog.class);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("test", UUID.randomUUID(), 1);
        FileTierPartitionState tierPartitionState_1 = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
        OffsetAndEpoch localMaterializedOffsetAndEpoch_1 = new OffsetAndEpoch(16L, Optional.of(Predef$.MODULE$.int2Integer(2)));
        Mockito.when((Object)log_1.tierPartitionState()).thenReturn((Object)tierPartitionState_1);
        Mockito.when((Object)log_1.topicIdPartition()).thenReturn((Object)Option$.MODULE$.apply((Object)topicIdPartition_1));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_1.isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_1.isStray())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)tierPartitionState_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)tierPartitionState_1.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)localMaterializedOffsetAndEpoch_1);
        Mockito.when((Object)tierTopic.toTierTopicPartition(topicIdPartition_1)).thenReturn((Object)tierTopicPartition_1);
        MergedLog log_2 = (MergedLog)Mockito.mock(MergedLog.class);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("test", UUID.randomUUID(), 2);
        FileTierPartitionState tierPartitionState_2 = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
        OffsetAndEpoch localMaterializedOffsetAndEpoch_2 = new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1)));
        Mockito.when((Object)log_2.tierPartitionState()).thenReturn((Object)tierPartitionState_2);
        Mockito.when((Object)log_2.topicIdPartition()).thenReturn((Object)Option$.MODULE$.apply((Object)topicIdPartition_2));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_2.isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_2.isStray())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)tierPartitionState_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)tierPartitionState_2.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)localMaterializedOffsetAndEpoch_2);
        Mockito.when((Object)tierTopic.toTierTopicPartition(topicIdPartition_2)).thenReturn((Object)tierTopicPartition_0);
        MergedLog log_3 = (MergedLog)Mockito.mock(MergedLog.class);
        TopicIdPartition topicIdPartition_3 = new TopicIdPartition("test", UUID.randomUUID(), 3);
        FileTierPartitionState tierPartitionState_3 = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
        Mockito.when((Object)log_3.tierPartitionState()).thenReturn((Object)tierPartitionState_3);
        Mockito.when((Object)log_3.topicIdPartition()).thenReturn((Object)Option$.MODULE$.apply((Object)topicIdPartition_3));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_3.isDeleted())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log_3.isStray())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)tierPartitionState_3.status()).thenReturn((Object)TierPartitionStatus.ERROR);
        Mockito.when((Object)logManager.allLogs()).thenReturn((Object)new .colon.colon((Object)log_0, (List)new .colon.colon((Object)log_1, (List)new .colon.colon((Object)log_2, (List)new .colon.colon((Object)log_3, (List)Nil$.MODULE$)))));
        java.util.Map m = var6_6.dataLossValidator().getTierTopicMaxOffsetAndEpochByFtps(tierTopic);
        Assertions.assertEquals((int)2, (int)m.size());
        OffsetAndEpoch offsetAndEpochForTtp_0 = (OffsetAndEpoch)m.get(tierTopicPartition_0);
        OffsetAndEpoch offsetAndEpochForTtp_1 = (OffsetAndEpoch)m.get(tierTopicPartition_1);
        Assertions.assertEquals((Object)localMaterializedOffsetAndEpoch_2, (Object)offsetAndEpochForTtp_0);
        Assertions.assertEquals((Object)localMaterializedOffsetAndEpoch_1, (Object)offsetAndEpochForTtp_1);
        ((LogManager)Mockito.verify((Object)logManager, (VerificationMode)Mockito.times((int)1))).allLogs();
        ((TierTopic)Mockito.verify((Object)tierTopic, (VerificationMode)Mockito.times((int)3))).toTierTopicPartition((TopicIdPartition)ArgumentMatchers.any());
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer) {
        TopicPartition logDirName_topicPartition = topicIdPartition.topicPartition();
        Object var5_3 = null;
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), new TierPartitionStateCleanupConfig(this.cleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()), (Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;

            public String id() {
                return new StringBuilder(21).append("TierTopicManagerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete metadata, ByteBuffer snapshotBuffer, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.processSnapshotMaterializationEvent(metadata, snapshotBuffer, targetStatus, offsetAndEpoch);
            }

            public long localMaterializedOffset() {
                return this.tierPartitionState$1.lastLocalMaterializedSrcOffsetAndEpoch().offset();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }

            public void beginDiscover() {
                this.tierPartitionState$1.beginDiscover();
            }

            public void completeDiscover() {
                this.tierPartitionState$1.onDiscoverComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    private Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> setupTierComponents(TierTopicManagerConfig tierTopicManagerConfig, boolean becomeReady, LogManager logManager, MockProducerSupplier<byte[], byte[]> producerSupplier) {
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(tierTopicManagerConfig, this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), this.discoverConsumerSupplier(), new TierTopicManagerCommitter(tierTopicManagerConfig, new LogDirFailureChannel(1)), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        TierReplicaManager tierReplicaManager = new TierReplicaManager();
        Mockito.when((Object)this.replicaManager().logManager()).thenReturn((Object)logManager);
        TierTopicManager tierTopicManager = new TierTopicManager(tierTopicManagerConfig, tierTopicConsumer, producerSupplier, () -> this.internalAdmin(), this.replicaManager(), (Time)this.time(), (Metrics)Mockito.mock(Metrics.class));
        if (becomeReady) {
            Assertions.assertTrue((boolean)tierTopicManager.tryBecomeReady(false));
        }
        return new Tuple3((Object)tierTopicConsumer, (Object)tierReplicaManager, (Object)tierTopicManager);
    }

    private TierTopicManagerConfig setupTierComponents$default$1() {
        return this.tierTopicManagerConfig();
    }

    private LogManager setupTierComponents$default$3() {
        return this.logManager();
    }

    private MockProducerSupplier<byte[], byte[]> setupTierComponents$default$4() {
        return this.producerSupplier();
    }

    private void moveRecordsToAllConsumers() {
        this.primaryConsumerSupplier().moveRecordsFromProducer();
        this.catchupConsumerSupplier().moveRecordsFromProducer();
    }

    private void resendPreviousProduceRequest() {
        MockProducer<byte[], byte[]> mockProducer = this.producerSupplier().producer();
        ProducerRecord lastSentRecord = (ProducerRecord)mockProducer.history().get(mockProducer.history().size() - 1);
        this.producerSupplier().producer().send(lastSentRecord);
        this.moveRecordsToAllConsumers();
    }

    /*
     * WARNING - void declaration
     */
    private void becomeArchiver(TopicIdPartition topicIdPartition, int leaderEpoch, TierTopicManager tierTopicManager, TierTopicConsumer tierTopicConsumer) {
        CompletableFuture becomeArchiverFuture = tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$becomeArchiver$1(this, tierTopicConsumer, becomeArchiverFuture)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting to become archiver");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFuture.get());
    }

    public static final /* synthetic */ void $anonfun$teardown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testAddMetadataBeforeReady$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$1, CompletableFuture future_1$1, CompletableFuture future_2$1) {
        $this.primaryConsumerSupplier().moveRecordsFromProducer();
        tierTopicConsumer$1.doWork();
        return future_1$1.isDone() && future_2$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testAddMetadataBeforeReady$2() {
        return "Timed out waiting for futures to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testDuplicateRequestBeforeReady$2(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$2, CompletableFuture newInitLeaderResult$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$2.doWork();
        return newInitLeaderResult$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testDuplicateRequestBeforeReady$3() {
        return "Timed out waiting to become archiver";
    }

    public static final /* synthetic */ boolean $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$3, CompletableFuture partitionFenceFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$3.doWork();
        return partitionFenceFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2() {
        return "Timed out trying to finish TierPartitionFence";
    }

    public static final /* synthetic */ boolean $anonfun$testSetErrorPartitionsDuringFencing$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$4, CompletableFuture initiateResultFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$4.doWork();
        return initiateResultFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testSetErrorPartitionsDuringFencing$2() {
        return "Timed out trying to finish TierSegmentUploadInitiate";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoverWhileCatchupConsumer$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$5, CompletableFuture uploadCompleteFuture$1, CompletableFuture uploadInitiateFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$5.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            if (uploadCompleteFuture$1.isDone() && uploadInitiateFuture$1.isDone()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRecoverWhileCatchupConsumer$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testHandlingForRestoreOnNonErrorStatus$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$6) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$6.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testHandlingForRestoreOnNonErrorStatus$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$7) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$7.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8, CompletableFuture uploadInitiateFuture$2) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        return uploadInitiateFuture$2.isDone();
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2() {
        return "Timed out waiting for upload initiate future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ TierTopicDataLossValidator $anonfun$testDetectDataLossInTierTopicNotTriggered$2(TierTopicManager tierTopicManager_1$1, HashMap tierTopicPartitionOffsetAndEpochMap$1, InvocationOnMock x$14) {
        TierTopicDataLossValidator spyDataLossValidator = (TierTopicDataLossValidator)Mockito.spy((Object)tierTopicManager_1$1.dataLossValidator());
        ((TierTopicDataLossValidator)Mockito.doAnswer(x$15 -> tierTopicPartitionOffsetAndEpochMap$1).when((Object)spyDataLossValidator)).getTierTopicMaxOffsetAndEpochByFtps((TierTopic)ArgumentMatchers.any());
        ((TierTopicDataLossValidator)Mockito.doAnswer(x$16 -> null).when((Object)spyDataLossValidator)).createAdminClient();
        return spyDataLossValidator;
    }

    public static final /* synthetic */ TierTopicDataLossValidator $anonfun$testDetectDataLossInTierTopic$2(TierTopicManager tierTopicManager$1, HashMap tierTopicPartitionOffsetAndEpochMap$2, ConfluentAdmin adminClient$1, RemoteLeaderEndPoint leaderEndPoint$1, InvocationOnMock x$17) {
        TierTopicDataLossValidator spyDataLossValidator = (TierTopicDataLossValidator)Mockito.spy((Object)tierTopicManager$1.dataLossValidator());
        ((TierTopicDataLossValidator)Mockito.doAnswer(x$18 -> tierTopicPartitionOffsetAndEpochMap$2).when((Object)spyDataLossValidator)).getTierTopicMaxOffsetAndEpochByFtps((TierTopic)ArgumentMatchers.any());
        ((TierTopicDataLossValidator)Mockito.doAnswer(x$19 -> adminClient$1).when((Object)spyDataLossValidator)).createAdminClient();
        ((TierTopicDataLossValidator)Mockito.doAnswer(x$20 -> leaderEndPoint$1).when((Object)spyDataLossValidator)).getLeaderEndPoint(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((int)1), (java.util.Map)ArgumentMatchers.any());
        return spyDataLossValidator;
    }

    public static final /* synthetic */ boolean $anonfun$becomeArchiver$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$9, CompletableFuture becomeArchiverFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$9.doWork();
        return becomeArchiverFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$becomeArchiver$2() {
        return "Timed out waiting to become archiver";
    }

    public TierTopicManagerTest() {
        this.clusterId = "mycluster";
        this.cleanupIntervalMs = 0;
        this.brokerId = -1;
    }
}

