/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.AbstractLog;
import kafka.log.LogManager$;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001C\u0011\u0019i\u0005\u0001)A\u0005\u0007\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002,\u0001A\u0003%\u0001\u000bC\u0004X\u0001\t\u0007I\u0011A(\t\ra\u0003\u0001\u0015!\u0003Q\u0011\u001dI\u0006A1A\u0005\u0002=CaA\u0017\u0001!\u0002\u0013\u0001\u0006bB.\u0001\u0005\u0004%\ta\u0014\u0005\u00079\u0002\u0001\u000b\u0011\u0002)\t\u000fu\u0003!\u0019!C\u0001\u001f\"1a\f\u0001Q\u0001\nACqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004h\u0001\u0001\u0006I!\u0019\u0005\bQ\u0002\u0011\r\u0011\"\u0001j\u0011\u0019i\u0007\u0001)A\u0005U\"9a\u000e\u0001b\u0001\n\u0003y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0004u\u0001\t\u0007I\u0011A;\t\u000f\u0005\r\u0001\u0001)A\u0005m\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0004\u0011-\t\u0019\u0002\u0001a\u0001\u0002\u0004%\t!!\u0006\t\u0017\u0005\u0005\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0002\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\ti\u0003\u0001C\u0001\u0003KAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002N\u0001!\t!!\r\t\u000f\u0005=\u0003\u0001\"\u0001\u00022!9\u0011\u0011\f\u0001\u0005\u0002\u0005E\u0002bBA2\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003O\u0002A\u0011AA\u0019\u0011\u001d\tY\u0007\u0001C\u0001\u0003cAq!a\u001c\u0001\t\u0003\t\t\u0004C\u0004\u0002t\u0001!\t!!\r\t\u000f\u0005]\u0004\u0001\"\u0001\u00022!9\u00111\u0010\u0001\u0005\u0002\u0005E\u0002bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003C\u0003A\u0011AA\u0019\u0011\u001d\t)\u000b\u0001C\u0005\u0003OCq!a0\u0001\t\u0013\t\t\rC\u0004\u0002J\u0002!I!a3\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBAv\u0001\u0011%\u0011\u0011\u0007\u0002\u0014\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugR+7\u000f\u001e\u0006\u0003eM\nQ\u0001^8pYNT\u0011\u0001N\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0007\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0002\"\u0001\u0011\u0001\u000e\u0003E\na\u0001^7q\t&\u0014X#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015AA5p\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013aC:fO6,g\u000e\u001e(b[\u0016,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u001e\u000bA\u0001\\1oO&\u0011QK\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019M,w-\\3oi:\u000bW.\u001a\u0011\u0002\u00171|wMR5mKB\u000bG\u000f[\u0001\rY><g)\u001b7f!\u0006$\b\u000eI\u0001\rg:\f\u0007o\u001d5piB\u000bG\u000f[\u0001\u000eg:\f\u0007o\u001d5piB\u000bG\u000f\u001b\u0011\u0002\u001b%tG-\u001a=GS2,\u0007+\u0019;i\u00039Ig\u000eZ3y\r&dW\rU1uQ\u0002\n\u0011\u0003^5nK&sG-\u001a=GS2,\u0007+\u0019;i\u0003I!\u0018.\\3J]\u0012,\u0007PR5mKB\u000bG\u000f\u001b\u0011\u0002\tQLW.Z\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AmM\u0001\u0006kRLGn]\u0005\u0003M\u000e\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u000fG2,\u0017M\\;q\t\u0016d\u0017-_'t+\u0005Q\u0007C\u0001\u001dl\u0013\ta\u0017H\u0001\u0003M_:<\u0017aD2mK\u0006tW\u000f\u001d#fY\u0006LXj\u001d\u0011\u0002#\rdW-\u00198va&sG/\u001a:wC2l5/F\u0001q!\tA\u0014/\u0003\u0002ss\t\u0019\u0011J\u001c;\u0002%\rdW-\u00198va&sG/\u001a:wC2l5\u000fI\u0001\bE\u0006$8\r[3t+\u00051\bcA<}}6\t\u0001P\u0003\u0002zu\u00069Q.\u001e;bE2,'BA>:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{b\u00141\"\u0011:sCf\u0014UO\u001a4feB\u0011\u0001i`\u0005\u0004\u0003\u0003\t$!\u0003\"bi\u000eD\u0017J\u001c4p\u0003!\u0011\u0017\r^2iKN\u0004\u0013a\u00017pOV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\ty!\u0004\u0002\u0002\u000e)\u0019\u0011QA\u001a\n\t\u0005E\u0011Q\u0002\u0002\f\u0003\n\u001cHO]1di2{w-A\u0004m_\u001e|F%Z9\u0015\t\u0005]\u0011Q\u0004\t\u0004q\u0005e\u0011bAA\u000es\t!QK\\5u\u0011%\ty\"GA\u0001\u0002\u0004\tI!A\u0002yIE\nA\u0001\\8hA\u0005y1\r[3dWN,X.\u00128bE2,G-\u0006\u0002\u0002(A\u0019\u0001(!\u000b\n\u0007\u0005-\u0012HA\u0004C_>dW-\u00198\u0002%\u0019$\bo]\"mK\u0006tW\u000f]#oC\ndW\rZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003/A3!HA\u001b!\u0011\t9$!\u0013\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t1!\u00199j\u0015\u0011\ty$!\u0011\u0002\u000f),\b/\u001b;fe*!\u00111IA#\u0003\u0015QWO\\5u\u0015\t\t9%A\u0002pe\u001eLA!a\u0013\u0002:\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!\u0005$GmU5na2,'+Z2pe\u0012\u001c\u0018\u0001\u0003;fCJ$un\u001e8)\u0007}\t\u0019\u0006\u0005\u0003\u00028\u0005U\u0013\u0002BA,\u0003s\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002AQ,7\u000f\u001e\"bi\u000eD\u0017I\u001c3SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PkR\u0004X\u000f\u001e\u0015\u0004A\u0005u\u0003\u0003BA\u001c\u0003?JA!!\u0019\u0002:\t!A+Z:u\u0003A!Xm\u001d;Qe&tG\u000fR1uC2{w\rK\u0002\"\u0003;\nq\u0003^3ti\u0012+X\u000e]%oI\u0016DX*[:nCR\u001c\u0007.Z:)\u0007\t\ni&A\fuKN$H)^7q)&lW-\u00138eKb,%O]8sg\"\u001a1%!\u0018\u00025Q,7\u000f\u001e#v[B$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3)\u0007\u0011\ni&A\fuKN$H)^7q\u001b\u0016$\u0018\rZ1uCJ+7m\u001c:eg\"\u001aQ%!\u0018\u00021Q,7\u000f\u001e#v[BlU\r^1eCR\f7K\\1qg\"|G\u000fK\u0002'\u0003;\n!\u0003^3ti\u0012+X\u000e]#naRL\u0018J\u001c3fq\"\u001aq%!\u0018\u0002%I,h\u000eR;na2{wmU3h[\u0016tGo\u001d\u000b\u0005\u0003\u0007\u000b9\n\u0005\u0003\u0002\u0006\u0006Me\u0002BAD\u0003\u001f\u00032!!#:\u001b\t\tYIC\u0002\u0002\u000eV\na\u0001\u0010:p_Rt\u0014bAAIs\u00051\u0001K]3eK\u001aL1!VAK\u0015\r\t\t*\u000f\u0005\b\u00033C\u0003\u0019AAN\u0003\u0011\t'oZ:\u0011\u000ba\ni*a!\n\u0007\u0005}\u0015HA\u0003BeJ\f\u00170\u0001\u0010uKN$\bK]5oi\u0012\u000bG/\u0019'pOB\u000b'\u000f^5bY\n\u000bGo\u00195fg\"\u001a\u0011&!\u0018\u0002#I,\u0017\r\u001a\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002*\u0006=\u0006#\u0002\u001d\u0002,\u0006\r\u0015bAAWs\t1q\n\u001d;j_:Dq!!-+\u0001\u0004\t\u0019,A\u0003mS:,7\u000f\u0005\u0004\u00026\u0006m\u00161Q\u0007\u0003\u0003oS1!!/H\u0003\u0011)H/\u001b7\n\t\u0005u\u0016q\u0017\u0002\r\u0019&\u001cH/\u0013;fe\u0006$xN]\u0001\u0018e\u0016\fG\rU1si&\fGNQ1uG\",7OQ=uKN$R\u0001]Ab\u0003\u000bDq!!-,\u0001\u0004\t\u0019\f\u0003\u0004\u0002H.\u0002\r\u0001]\u0001\u0006Y&l\u0017\u000e^\u0001\rG>,h\u000e\u001e\"bi\u000eDWm\u001d\u000b\u0004a\u00065\u0007bBAYY\u0001\u0007\u00111W\u0001\u0011e\u0016\fGMQ1uG\"\u0014VmY8sIN$B!a5\u0002\\B1\u0011Q[Al\u0003\u0007k\u0011A_\u0005\u0004\u00033T(aA*fc\"9\u0011\u0011W\u0017A\u0002\u0005M\u0016a\u00059beN,W*\u001a;bI\u0006$\u0018MR5fY\u0012\u001cH\u0003BAq\u0003O\u0004\u0002\"!\"\u0002d\u0006\r\u00151Q\u0005\u0005\u0003K\f)JA\u0002NCBDq!!;/\u0001\u0004\t\u0019)\u0001\u0003mS:,\u0017aG1tg\u0016\u0014H\u000fR;na2{wMU3d_J$W*\u001a;bI\u0006$\u0018\r")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private AbstractLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean ftpsCleanupEnabled() {
        return false;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        props.setProperty("confluent.tier.enable", "true");
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some(Mockito.mock(TierTopicConsumer.class)), (Option)new Some(Mockito.mock(TierObjectStore.class)), new TierPartitionStateFactory(true, this.checksumEnabled(), true, new TierPartitionStateCleanupConfig(this.ftpsCleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), true, 0), (Option)None$.MODULE$);
        Metrics metrics = new Metrics();
        LogManager$.MODULE$.createProducerStateSensors(metrics);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(3600000);
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        None$ x$15 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$20 = new ConcurrentHashMap();
        this.log_$eq((AbstractLog)MergedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, metrics, (Time)x$6, 300000, x$10, x$11, (Option)x$18, x$12, tierLogComponents, true, (Option)x$15, true, x$19, (Option)x$17, x$20));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            void withRecords_partitionLeaderEpoch;
            AbstractLog qual$1 = this.log();
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toSeq().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            boolean bl = false;
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var7_5 = null;
            simpleRecordArray = null;
            MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            return qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        AbstractLog qual$1 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var30_4 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        AbstractLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl2 = false;
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        Object var33_12 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$6 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        AppendOrigin x$8 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 3, x$8, x$9, x$10);
        AbstractLog qual$3 = this.log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl3 = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var36_20 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$11 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$13 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, 3, x$13, x$14, x$15);
        AbstractLog qual$4 = this.log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var39_30 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        AppendOrigin x$18 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, 3, x$18, x$19, x$20);
        AbstractLog qual$5 = this.log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.GZIP;
        Object var45_40 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$21 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        AppendOrigin x$23 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, 5, x$23, x$24, x$25);
        AbstractLog qual$6 = this.log();
        MemoryRecords x$26 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        MetadataVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, 7, AppendOrigin.COORDINATOR, x$29, x$30);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()});
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpTierPartitionState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.log().topicPartition().topic(), UUID.randomUUID(), this.log().topicPartition().partition());
        AbstractLog qual$1 = this.log();
        Uuid x$1 = topicIdPartition.kafkaTopicId();
        int x$2 = qual$1.assignTopicId$default$2();
        qual$1.assignTopicId(x$1, x$2);
        this.log().tierPartitionState().beginCatchup();
        this.log().tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.empty()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.log().tierPartitionState().append((AbstractTierMetadata)new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 1L, 1500L, 100L, 100, true, false, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), TierObjectStore.OpaqueData.ZEROED), new OffsetAndEpoch(1L, Optional.empty())));
        this.log().tierPartitionState().flush();
        String suffix = this.checksumEnabled() ? Algorithm.ADLER.suffix : Algorithm.NO_CHECKSUM.suffix;
        String[] stringArray = new String[2];
        stringArray[0] = "--files";
        stringArray[1] = new StringBuilder(0).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, "").getAbsolutePath()).append(suffix).toString();
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments(stringArray), topicIdPartition);
        String[] stringArray2 = new String[2];
        stringArray2[0] = "--files";
        stringArray2[1] = new StringBuilder(8).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, "").getAbsolutePath()).append(".mutable").append(suffix).toString();
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments(stringArray2), topicIdPartition);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_timestampType;
        void withRecords_records;
        void withRecords_timestampType2;
        void withRecords_timestampType3;
        MockTime mockTime = new MockTime();
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -1L;
        long x$5 = 0L;
        String x$6 = "delete";
        int x$7 = 0x10000C;
        int x$8 = 4096;
        int x$9 = 0xA00000;
        String x$10 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$11 = 60000L;
        boolean x$12 = false;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        MergedLog log = LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)mockTime.scheduler(), (Time)mockTime, 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), TierLogComponents$.MODULE$.EMPTY(), new LogDirFailureChannel(10), LogOffsetsListener.NO_OP_OFFSETS_LISTENER, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>());
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var34_22 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        CompressionType withRecords_compressionType2 = CompressionType.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var35_30 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        byte withRecords_magic3 = 2;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset3 = 0L;
        timestampType3 = null;
        Object var37_34 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType3, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), new Metrics(), (Scheduler)this.time().scheduler(), new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1), KafkaMetadataLog$.MODULE$.apply$default$8(), KafkaMetadataLog$.MODULE$.apply$default$9());
        int lastContainedLogTimestamp = 10000;
        try (AutoCloseable resource_resource = (AutoCloseable)RecordsSnapshotWriter.createWithHeader(() -> metadataLog.createNewSnapshot(new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)new MockTime(), (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE).get();){
            SnapshotWriter snapshotWriter = (SnapshotWriter)resource_resource;
            DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2((Seq)metadataRecords, snapshotWriter);
        }
        Object var5_4 = null;
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"));
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"));
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        System.setOut(System.out);
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<String> partialLines = Arrays.asList(this.runDumpLogSegments(new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+"));
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOps)option.get()).apply(0);
                batchesBytes += StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size));
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$6 -> x$6.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = (FetchDataInfo)this.log().read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true, false);
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)this.batches().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.batches().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    private static final void validate$1(String output, TopicIdPartition topicIdPartition$1) {
        Object[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps(lines), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains("Header"))).get()).contains(topicIdPartition$1.topicIdAsBase64()));
        Assertions.assertTrue((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps(lines), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("SEGMENT_UPLOAD_INITIATE"))));
    }

    public static final /* synthetic */ void $anonfun$testDumpMetadataSnapshot$2(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        snapshotWriter.append(CollectionConverters$.MODULE$.SeqHasAsJava(metadataRecords$1).asJava());
        snapshotWriter.freeze();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$18)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$20)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$21)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
        this.cleanupIntervalMs = 0;
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter);
        return BoxedUnit.UNIT;
    }
}

