/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.Adler32;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.test.TestUtils;

public final class CheckedFileIOTestUtils$ {
    public static final CheckedFileIOTestUtils$ MODULE$ = new CheckedFileIOTestUtils$();

    public ByteBuffer readAllBytes(Path path) {
        FileChannel cfIO = FileChannel.open(path, StandardOpenOption.READ);
        ByteBuffer bb = ByteBuffer.allocate((int)cfIO.size()).order(ByteOrder.LITTLE_ENDIAN);
        cfIO.read(bb, 0L);
        bb.flip();
        cfIO.close();
        return bb;
    }

    public ByteBuffer maybeMigrateAndReadAllBytes(Path path, Algorithm algo, short superBlockLen) {
        ByteBuffer byteBuffer;
        String tempDir_prefix = "test-kafka-";
        Object var8_4 = null;
        Path tmpDest = TestUtils.tempDirectory(null, (String)tempDir_prefix).toPath().resolve(new StringBuilder(4).append("file").append(algo.suffix).toString());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ};
        Object var9_6 = null;
        CheckedFileIO srcChannel = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        OpenOption[] openOrCreate_options = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var10_8 = null;
        CheckedFileIO destChannel = CheckedFileIO.openOrCreate((Path)tmpDest, (Algorithm)algo, (short)superBlockLen, (boolean)false, (OpenOption[])openOrCreate_options);
        destChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        destChannel.close();
        srcChannel.close();
        try {
            byteBuffer = this.readAllBytes(tmpDest);
        }
        finally {
            Files.deleteIfExists(tmpDest);
        }
        return byteBuffer;
    }

    public long computeChecksum(String s) {
        Adler32 adler32 = new Adler32();
        adler32.update(this.toByteBuffer(s));
        return adler32.getValue();
    }

    public ByteBuffer toByteBuffer(String s) {
        return ByteBuffer.wrap(s.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer toByteBuffer(byte s) {
        return ByteBuffer.wrap(new byte[]{s}).order(ByteOrder.LITTLE_ENDIAN);
    }

    public Algorithm checksumAlgorithm(boolean checksumEnabled) {
        if (checksumEnabled) {
            return Algorithm.ADLER;
        }
        return Algorithm.NO_CHECKSUM;
    }

    public short superBlockLength(boolean checksumEnabled) {
        if (checksumEnabled) {
            return 512;
        }
        return 0;
    }

    private CheckedFileIOTestUtils$() {
    }
}

