/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.HashMap;
import kafka.utils.ConfluentUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfluentUtilsTest {
    @Test
    public void testHasCCloudHostPatternWithDefaults() {
        HashMap brokerConfigs = new HashMap();
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"localhost"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.stag.cpdev.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.devel.cpdev.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"FOO.BAR.CONFLUENT.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.stag.cpdev.cloudxxx"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.devel.xxxxcpdev.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud.xxx"));
    }

    @Test
    public void testHasCCloudHostPatternWithConfigs() {
        HashMap<String, String> brokerConfigs = new HashMap<String, String>();
        brokerConfigs.put("confluent.ccloud.host.suffixes", ".aws.confluent,.confluent.fedramp");
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"localhost"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"test.stag.cpdev.cloud"));
        Assertions.assertFalse((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent.cloud"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"foo.bar.us-west2.aws.confluent"));
        Assertions.assertTrue((boolean)ConfluentUtils.hasCCloudHostPattern(brokerConfigs, (String)"pkc-xxx.confluent.fedramp"));
    }
}

