/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.cloud;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.utils.cloud.EpochAndSeqNumber;
import kafka.utils.cloud.LinkedCloudObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e4A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\f\u0001C\u00013!)A\f\u0001C\u0005;\n)B*\u001b8lK\u0012\u001cEn\\;e\u001f\nTWm\u0019;UKN$(BA\u0004\t\u0003\u0015\u0019Gn\\;e\u0015\tI!\"A\u0003vi&d7OC\u0001\f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\ta!A\ruKN$H*\u0019;fgR\u001cu.\\7jiR,Gm\u00142kK\u000e$H#\u0001\u000e\u0011\u0005=Y\u0012B\u0001\u000f\u0011\u0005\u0011)f.\u001b;)\u0007\tqR\u0006E\u0002\u0010?\u0005J!\u0001\t\t\u0003\rQD'o\\<t!\t\u0011#F\u0004\u0002$Q9\u0011AeJ\u0007\u0002K)\u0011a\u0005D\u0001\u0007yI|w\u000e\u001e \n\u0003EI!!\u000b\t\u0002\u000fA\f7m[1hK&\u00111\u0006\f\u0002\u0015\u0013:$XM\u001d:vaR,G-\u0012=dKB$\u0018n\u001c8\u000b\u0005%\u0002\u0012\u0007\u0002\u0010/m1\u0003\"aL\u001a\u000f\u0005A\n\u0004C\u0001\u0013\u0011\u0013\t\u0011\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a\u0011c\u0015\u0019sgO$=+\tA\u0014(F\u0001/\t\u0015QDB1\u0001@\u0005\u0005!\u0016B\u0001\u001f>\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0011a\bE\u0001\u0007i\"\u0014xn^:\u0012\u0005\u0001\u001b\u0005CA\bB\u0013\t\u0011\u0005CA\u0004O_RD\u0017N\\4\u0011\u0005\u0011+eBA\b)\u0013\t1EFA\u0005UQJ|w/\u00192mKF*1\u0005S%K}9\u0011q\"S\u0005\u0003}A\tDAI\b\u0011\u0017\n)1oY1mCF\u0012a%\t\u0015\u0003\u00059\u0003\"a\u0014-\u000e\u0003AS!!\u0015*\u0002\u0007\u0005\u0004\u0018N\u0003\u0002T)\u00069!.\u001e9ji\u0016\u0014(BA+W\u0003\u0015QWO\\5u\u0015\u00059\u0016aA8sO&\u0011\u0011\f\u0015\u0002\u0005)\u0016\u001cH/A\nuKN$x)\u001a;PaRLW.\u00197DQ\u0006Lg\u000e\u000b\u0002\u0004\u001d\u0006y\u0001.\u001a7qKJ<UM\\3sCR|'\u000fF\u0003_MB,x\u000f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006A1O\\1qg\"|GO\u0003\u0002d\u0015\u0005!A/[3s\u0013\t)\u0007MA\fUS\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_R|%M[3di\")q\r\u0002a\u0001Q\u0006a1-\u001e:sK:$X\t]8dQB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005Y\u0006twMC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=T'aB%oi\u0016<WM\u001d\u0005\u0006c\u0012\u0001\rA]\u0001\u0011GV\u0014(/\u001a8u'\u0016\fh*^7cKJ\u0004\"aD:\n\u0005Q\u0004\"\u0001\u0002'p]\u001eDQA\u001e\u0003A\u0002!\f\u0011\u0002\u001d:fm\u0016\u0003xn\u00195\t\u000ba$\u0001\u0019\u0001:\u0002\u001bA\u0014XM^*fc:+XNY3s\u0001")
public class LinkedCloudObjectTest {
    @Test
    public void testLatestCommittedObject() throws InterruptedException {
        TierTopicSnapshotObject obj1 = this.helperGenerator(Predef$.MODULE$.int2Integer(0), 0L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj2 = this.helperGenerator(Predef$.MODULE$.int2Integer(2), 1L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj3 = this.helperGenerator(Predef$.MODULE$.int2Integer(1), 2L, Predef$.MODULE$.int2Integer(0), 0L);
        Optional latestObject = LinkedCloudObject.latestCommittedObject(Arrays.asList(obj1, obj2, obj3));
        Assertions.assertTrue((boolean)latestObject.isPresent());
        Assertions.assertEquals((Object)obj2, latestObject.get());
    }

    @Test
    public void testGetOptimalChain() {
        TierTopicSnapshotObject obj1 = this.helperGenerator(Predef$.MODULE$.int2Integer(0), 0L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj2 = this.helperGenerator(Predef$.MODULE$.int2Integer(0), 1L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj3 = this.helperGenerator(Predef$.MODULE$.int2Integer(1), 0L, Predef$.MODULE$.int2Integer(0), 0L);
        TierTopicSnapshotObject obj4 = this.helperGenerator(Predef$.MODULE$.int2Integer(1), 1L, Predef$.MODULE$.int2Integer(1), 0L);
        TierTopicSnapshotObject obj5 = this.helperGenerator(Predef$.MODULE$.int2Integer(2), 0L, Predef$.MODULE$.int2Integer(0), 1L);
        List optimalList = LinkedCloudObject.getOptimalChain(Arrays.asList(obj1, obj2, obj3, obj4, obj5));
        Assertions.assertEquals(Arrays.asList(obj1, obj2, obj5), (Object)optimalList);
    }

    private TierTopicSnapshotObject helperGenerator(Integer currentEpoch, long currentSeqNumber, Integer prevEpoch, long prevSeqNumber) {
        return new TierTopicSnapshotObject(0L, 0L, new EpochAndSeqNumber(Predef$.MODULE$.Integer2int(currentEpoch), currentSeqNumber), new EpochAndSeqNumber(Predef$.MODULE$.Integer2int(prevEpoch), prevSeqNumber));
    }
}

