/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.Collection;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import kafka.security.authorizer.AclEntry$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]4Aa\u0002\u0005\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00011!)1\t\u0001C\u0001\t\")A\r\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")Q\u000f\u0001C\u0001S\nA\"l[!dY6KwM]1uS>t7\t\\5f]R$Vm\u001d;\u000b\u0005%Q\u0011!C7jOJ\fG/[8o\u0015\tYA\"\u0001\u0002{W*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u0005YQ6.T5he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!\u0001\u000bnS\u001e\u0014\u0018\r^3BG2\u001c\u0018I\u001c3WKJLg-\u001f\u000b\u00043}A\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"\u0001B+oSRDQ\u0001\t\u0002A\u0002\u0005\n!\"Y;uQ>\u0014\u0018N_3s!\t\u0011c%D\u0001$\u0015\t\u0001CE\u0003\u0002&\u0019\u0005A1/Z2ve&$\u00180\u0003\u0002(G\ti\u0011i\u00197BkRDwN]5{KJDQ!\u000b\u0002A\u0002)\nA!Y2mgB\u00191f\r\u001c\u000f\u00051\ndBA\u00171\u001b\u0005q#BA\u0018\u000f\u0003\u0019a$o\\8u}%\tA$\u0003\u000237\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001b6\u0005\r\u0019V-\u001d\u0006\u0003em\u0001\"aN!\u000e\u0003aR!!\u000f\u001e\u0002\u0007\u0005\u001cGN\u0003\u0002<y\u000511m\\7n_:T!!D\u001f\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0005\u0003\u0005b\u0012!\"Q2m\u0005&tG-\u001b8h\u0003\u0001\u0012X\r\u001d7bG\u0016\f5\r\\:B]\u0012\u0014V-\u00193XSRD\u0017)\u001e;i_JL'0\u001a:\u0015\u000b\u0015keJ\u0016/\u0011\u0007\u0019SeG\u0004\u0002H\u0011B\u0011QfG\u0005\u0003\u0013n\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\r\u0019V\r\u001e\u0006\u0003\u0013nAQ\u0001I\u0002A\u0002\u0005BQaT\u0002A\u0002A\u000bqB]3t_V\u00148-\u001a)biR,'O\u001c\t\u0003#Rk\u0011A\u0015\u0006\u0003'j\n\u0001B]3t_V\u00148-Z\u0005\u0003+J\u0013qBU3t_V\u00148-\u001a)biR,'O\u001c\u0005\u0006/\u000e\u0001\r\u0001W\u0001\u0005C\u000e,7\u000fE\u0002,ge\u0003\"a\u000e.\n\u0005mC$AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uefDQ!X\u0002A\u0002y\u000bA\u0001\u001d:fIB!!dX#b\u0013\t\u00017DA\u0005Gk:\u001cG/[8ocA\u0011!DY\u0005\u0003Gn\u0011qAQ8pY\u0016\fg.A\u0012eK2,G/\u001a*fg>,(oY3B]\u0012\u0014V-\u00193XSRD\u0017)\u001e;i_JL'0\u001a:\u0015\u0007e1w\rC\u0003!\t\u0001\u0007\u0011\u0005C\u0003P\t\u0001\u0007\u0001+A\u000euKN$\u0018i\u00197t\u001b&<'/\u0019;f\u0003:$G)^1m/JLG/\u001a\u000b\u00023!\u0012Qa\u001b\t\u0003YNl\u0011!\u001c\u0006\u0003]>\f1!\u00199j\u0015\t\u0001\u0018/A\u0004kkBLG/\u001a:\u000b\u0005I|\u0014!\u00026v]&$\u0018B\u0001;n\u0005\u0011!Vm\u001d;\u00023Q,7\u000f^!dYN\u001c\u0005.\u00198hKNLen\u00158baNDw\u000e\u001e\u0015\u0003\r-\u0004")
public class ZkAclMigrationClientTest
extends ZkMigrationTestHarness {
    public void migrateAclsAndVerify(AclAuthorizer authorizer, Seq<AclBinding> acls) {
        authorizer.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava(acls).asJava());
        ArrayBuffer batches = new ArrayBuffer();
        this.migrationClient().migrateAcls(batch -> batches.append((Object)CollectionConverters$.MODULE$.ListHasAsScala(batch).asScala()));
        ArrayBuffer records = (ArrayBuffer)((StrictOptimizedIterableOps)batches.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$1 -> (AccessControlEntryRecord)x$1.message());
        Assertions.assertEquals((int)acls.size(), (int)records.size(), (String)"Expected one record for each ACLBinding");
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AclBinding> replaceAclsAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern, Seq<AccessControlEntry> aces, Function1<scala.collection.immutable.Set<AclBinding>, Object> pred) {
        void var7_11;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().writeResourceAcls(resourcePattern, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(aces).asJava(), this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply((Object)(computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$replaceAclsAndReadWithAuthorizer$1(authorizer, resourceFilter))))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set acls = (scala.collection.immutable.Set)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp());
        return var7_11;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteResourceAndReadWithAuthorizer(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        void var5_9;
        Tuple2 tuple2;
        AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resourcePattern.resourceType(), resourcePattern.name(), resourcePattern.patternType()), AclBindingFilter.ANY.entryFilter());
        this.migrationState_$eq(this.migrationClient().aclClient().deleteResource(resourcePattern, this.migrationState()));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkAclMigrationClientTest.$anonfun$deleteResourceAndReadWithAuthorizer$1(authorizer, resourceFilter)).isEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean ok = tuple22._2$mcZ$sp();
        Assertions.assertTrue((boolean)var5_9);
    }

    @Test
    public void testAclsMigrateAndDualWrite() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("baz-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource4 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("test-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AccessControlEntry ace1 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding acl1 = new AclBinding(resource1, ace1);
        AccessControlEntry ace2 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
        AclBinding acl2 = new AclBinding(resource1, ace2);
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)this.zkConnect())}))).asJava());
            this.migrateAclsAndVerify(authorizer, (Seq<AclBinding>)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$)))));
            Assertions.assertTrue((boolean)this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)ace1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$1(acls))).contains((Object)acl1));
            this.deleteResourceAndReadWithAuthorizer(authorizer, resource1);
            AccessControlEntry newAce1 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            Assertions.assertTrue((boolean)((SetOps)this.replaceAclsAndReadWithAuthorizer(authorizer, resource1, (Seq<AccessControlEntry>)new .colon.colon((Object)newAce1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$2(acls))).map((Function1 & Serializable)x$4 -> x$4.entry())).contains((Object)newAce1));
            AccessControlEntry newAce2 = new AccessControlEntry(principal.toString(), "10.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            Assertions.assertTrue((boolean)((SetOps)this.replaceAclsAndReadWithAuthorizer(authorizer, resource2, (Seq<AccessControlEntry>)new .colon.colon((Object)acl3.entry(), (List)new .colon.colon((Object)newAce2, (List)Nil$.MODULE$)), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$4(acls))).map((Function1 & Serializable)x$5 -> x$5.entry())).subsetOf((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3.entry(), newAce2}))));
            Uuid linkId1 = Uuid.randomUuid();
            Uuid linkId2 = Uuid.randomUuid();
            AccessControlEntry linkedAce1 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID, linkId1}))).asJava());
            scala.collection.immutable.Set<AclBinding> resource3Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource3, (Seq<AccessControlEntry>)new .colon.colon((Object)linkedAce1, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$6(acls)));
            Assertions.assertEquals((Object)linkedAce1, (Object)((AclBinding)resource3Acls.head()).entry());
            AccessControlEntry linkedAce2 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkId2}))).asJava());
            scala.collection.immutable.Set<AclBinding> resource4Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource4, (Seq<AccessControlEntry>)new .colon.colon((Object)linkedAce2, (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$7(acls)));
            Assertions.assertEquals((Object)linkedAce2, (Object)((AclBinding)resource4Acls.head()).entry());
            resource3Acls = this.replaceAclsAndReadWithAuthorizer(authorizer, resource3, (Seq<AccessControlEntry>)new .colon.colon((Object)SecurityUtils.aceWithoutLinkId((AccessControlEntry)linkedAce1), (List)Nil$.MODULE$), (Function1<scala.collection.immutable.Set<AclBinding>, Object>)(Function1 & Serializable)acls -> BoxesRunTime.boxToBoolean((boolean)ZkAclMigrationClientTest.$anonfun$testAclsMigrateAndDualWrite$8(linkedAce1, acls)));
            Assertions.assertEquals((Object)SecurityUtils.aceWithoutLinkId((AccessControlEntry)linkedAce1), (Object)((AclBinding)resource3Acls.head()).entry());
            this.deleteResourceAndReadWithAuthorizer(authorizer, resource4);
        }
    }

    @Test
    public void testAclsChangesInSnapshot() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("baz-").append(Uuid.randomUuid()).toString(), PatternType.LITERAL);
        String username1 = "alice";
        String username2 = "blah";
        KafkaPrincipal principal1 = new KafkaPrincipal("User", username1);
        KafkaPrincipal principal2 = new KafkaPrincipal("User", username2);
        AclEntry acl1Resource1 = new AclEntry(new AccessControlEntry(principal1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW), resource1);
        AclEntry acl1Resource2 = new AclEntry(new AccessControlEntry(principal2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), resource2);
        this.zkClient().createAclPaths();
        this.zkClient().createAclsForResourceIfNotExists(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource1})));
        this.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1Resource2})));
        MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
        AccessControlEntryRecord acl1Resource3 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.10.1").setOperation(AclOperation.READ.code()).setPrincipal(AclEntry$.MODULE$.WildcardPrincipalString()).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource3.patternType().code()).setResourceName(resource3.name()).setResourceType(resource3.resourceType().code());
        delta.replay(acl1Resource3);
        AccessControlEntryRecord acl2Resource1 = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setHost("192.168.15.1").setOperation(AclOperation.WRITE.code()).setPrincipal(principal1.toString()).setPermissionType(AclPermissionType.ALLOW.code()).setPatternType(resource1.patternType().code()).setResourceName(resource1.name()).setResourceType(resource1.resourceType().code());
        delta.replay(acl2Resource1);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        new KRaftMigrationZkWriter((MigrationClient)this.migrationClient()).handleSnapshot(image, (x$6, x$7, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        scala.collection.immutable.Set resource1AclsInZk = this.zkClient().getVersionedAclsForResource(resource1).acls();
        Assertions.assertEquals((int)1, (int)resource1AclsInZk.size());
        Assertions.assertEquals((Object)new AccessControlEntry(acl2Resource1.principal(), acl2Resource1.host(), AclOperation.fromCode((byte)acl2Resource1.operation()), AclPermissionType.fromCode((byte)acl2Resource1.permissionType())), (Object)((AclEntry)resource1AclsInZk.head()).ace());
        Assertions.assertTrue((boolean)this.zkClient().getVersionedAclsForResource(resource2).acls().isEmpty());
        scala.collection.immutable.Set resource3AclsInZk = this.zkClient().getVersionedAclsForResource(resource3).acls();
        Assertions.assertEquals((Object)new AccessControlEntry(acl1Resource3.principal(), acl1Resource3.host(), AclOperation.fromCode((byte)acl1Resource3.operation()), AclPermissionType.fromCode((byte)acl1Resource3.permissionType())), (Object)((AclEntry)resource3AclsInZk.head()).ace());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$replaceAclsAndReadWithAuthorizer$1(AclAuthorizer authorizer$1, AclBindingFilter resourceFilter$1) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(resourceFilter$1)).asScala().toSet();
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$deleteResourceAndReadWithAuthorizer$1(AclAuthorizer authorizer$2, AclBindingFilter resourceFilter$2) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$2.acls(resourceFilter$2)).asScala().toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$1(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$2(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$4(scala.collection.immutable.Set acls) {
        return acls.size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$6(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$7(scala.collection.immutable.Set acls) {
        return acls.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAclsMigrateAndDualWrite$8(AccessControlEntry linkedAce1$1, scala.collection.immutable.Set acls) {
        if (acls.size() == 1) {
            AccessControlEntry accessControlEntry = ((AclBinding)acls.head()).entry();
            AccessControlEntry accessControlEntry2 = SecurityUtils.aceWithoutLinkId((AccessControlEntry)linkedAce1$1);
            if (!(accessControlEntry != null ? !accessControlEntry.equals(accessControlEntry2) : accessControlEntry2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ Object $anonfun$deleteResourceAndReadWithAuthorizer$2$adapted(scala.collection.immutable.Set x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty());
    }
}

