/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import io.confluent.kafka.availability.NetworkAvailabilityManager;
import io.confluent.kafka.availability.NetworkAvailabilityManager$;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import unit.kafka.server.NetworkAvailabilityManagerRequestTest;

@ScalaSignature(bytes="\u0006\u0005m2A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C!3!)!\u0006\u0001C\u0001W!)\u0011\b\u0001C\u0001W\t1d*\u001a;x_J\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us6\u000bg.Y4fe\"+\u0017\r\u001c;iG\",7m\u001b+f]\u0006tGOU3rk\u0016\u001cH\u000fV3ti*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%Q\u0011!B6bM.\f'\"A\u0006\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\b#)\t\u0011\"\u0003\u0002\u0014!\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002-A\u0011q\u0003A\u0007\u0002\r\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011A!\u00168ji\")\u0011E\u0001a\u0001E\u0005Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B;uS2T\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\tQ\u0001K]8qKJ$\u0018.Z:\u0002)Q,7\u000f^#yi\u0016\u0014h.\u00197SKF,Xm\u001d;t)\u0005Q\u0002FA\u0002.!\tqs'D\u00010\u0015\t\u0001\u0014'A\u0002ba&T!AM\u001a\u0002\u000f),\b/\u001b;fe*\u0011A'N\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002m\u0005\u0019qN]4\n\u0005az#\u0001\u0002+fgR\fq\u0003^3ti\"+\u0017\r\u001c;i\u0007\",7m\u001b*fcV,7\u000f^:)\u0005\u0011i\u0003")
public class NetworkAvailabilityManagerHealthcheckTenantRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), NetworkAvailabilityManagerRequestTest.TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), NetworkAvailabilityManagerRequestTest.TestPrincipalBuilderReturningHealthcheckMultitenant.class.getName());
    }

    @Test
    public void testExternalRequests() {
        String topic = "topic";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        producer.send(record2);
        Assertions.assertEquals((long)0L, (long)((NetworkAvailabilityManager)this.brokerSocketServer(0).requestCallbackManager()).externalRequests());
        Assertions.assertEquals((long)0L, (long)((NetworkAvailabilityManager)this.brokerSocketServer(0).requestCallbackManager()).healthCheckRequests());
    }

    @Test
    public void testHealthCheckRequests() {
        String topic = "topic";
        Properties producerProperties = new Properties();
        producerProperties.setProperty("client.id", NetworkAvailabilityManager$.MODULE$.HEALTH_CHECK_CLIENT_ID());
        KafkaProducer producer = this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProperties);
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        producer.send(record2);
        Assertions.assertTrue((((NetworkAvailabilityManager)this.brokerSocketServer(0).requestCallbackManager()).healthCheckRequests() > 0L ? 1 : 0) != 0);
    }
}

