/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.io.Serializable;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ProducerIdQuotaManager;
import kafka.server.ProducerIdQuotaManagerConfig;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00014Aa\u0004\t\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0017\u0001A\u0003%A\u0005C\u0004.\u0001\t\u0007I\u0011B\u0012\t\r9\u0002\u0001\u0015!\u0003%\u0011\u001dy\u0003A1A\u0005\nABa\u0001\u000e\u0001!\u0002\u0013\t\u0004bB\u001b\u0001\u0005\u0004%IA\u000e\u0005\u0007u\u0001\u0001\u000b\u0011B\u001c\t\u000bm\u0002A\u0011\u0002\u001f\t\u000b-\u0003A\u0011\u0001'\t\u000bi\u0003A\u0011\u0001'\t\u000bq\u0003A\u0011\u0001'\t\u000by\u0003A\u0011\u0001'\u00035A\u0013x\u000eZ;dKJLE-U;pi\u0006l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005E\u0011\u0012AB:feZ,'O\u0003\u0002\u0014)\u0005)1.\u00194lC*\tQ#\u0001\u0003v]&$8\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ!!E\u000e\u000b\u0003MI!!\b\u000e\u00035\t\u000b7/Z\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0001\u0012\u0001B+tKJ,\u0012\u0001\n\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019\u0019FO]5oO\u0006)Qk]3sA\u0005A1\t\\5f]RLE-A\u0005DY&,g\u000e^%eA\u000511m\u001c8gS\u001e,\u0012!\r\t\u00033IJ!a\r\u000e\u00039A\u0013x\u000eZ;dKJLE-U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001D2mS\u0016tGoQ8oM&<W#A\u001c\u0011\u0005eA\u0014BA\u001d\u001b\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\u000eG2LWM\u001c;D_:4\u0017n\u001a\u0011\u0002!]LG\u000f[)v_R\fW*\u00198bO\u0016\u0014HCA\u001fD!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0011)f.\u001b;\t\u000b\u0011S\u0001\u0019A#\u0002\u0003\u0019\u0004BA\u0010$I{%\u0011qi\u0010\u0002\n\rVt7\r^5p]F\u0002\"!G%\n\u0005)S\"A\u0006)s_\u0012,8-\u001a:JIF+x\u000e^1NC:\fw-\u001a:\u0002_Q,7\u000f\u001e(p)\"\u0014x\u000e\u001e;mK^CWM\u001c\"fY><8i\\;oiF+x\u000e^1CK2|wOU1uKF+x\u000e^1\u0015\u0003uB#a\u0003(\u0011\u0005=CV\"\u0001)\u000b\u0005E\u0013\u0016aA1qS*\u00111\u000bV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)f+A\u0003kk:LGOC\u0001X\u0003\ry'oZ\u0005\u00033B\u0013A\u0001V3ti\u0006yC/Z:u\u001d>$\u0006N]8ui2,w\u000b[3o\u0005\u0016dwn^\"pk:$\u0018+^8uC\u0006\u0013wN^3SCR,\u0017+^8uC\"\u0012ABT\u00010i\u0016\u001cHOT8UQJ|G\u000f\u001e7f/\",g.\u00112pm\u0016\u001cu.\u001e8u#V|G/\u0019\"fY><(+\u0019;f#V|G/\u0019\u0015\u0003\u001b9\u000bQ\u0006^3tiRC'o\u001c;uY\u0016<\u0006.\u001a8BE>4XmQ8v]R\fVo\u001c;b\u0003\n|g/\u001a*bi\u0016\fVo\u001c;bQ\tqa\n")
public class ProducerIdQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private final String User;
    private final String ClientId;
    private final ProducerIdQuotaManagerConfig config = new ProducerIdQuotaManagerConfig(100, 100);
    private final ClientQuotaManagerConfig clientConfig = new ClientQuotaManagerConfig(10, 1, ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0);

    private String User() {
        return this.User;
    }

    private String ClientId() {
        return this.ClientId;
    }

    private ProducerIdQuotaManagerConfig config() {
        return this.config;
    }

    private ClientQuotaManagerConfig clientConfig() {
        return this.clientConfig;
    }

    private void withQuotaManager(Function1<ProducerIdQuotaManager, BoxedUnit> f) {
        ProducerIdQuotaManager quotaManager = new ProducerIdQuotaManager(this.config(), this.clientConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            f.apply((Object)quotaManager);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testNoThrottleWhenBelowCountQuotaBelowRateQuota() {
        this.withQuotaManager((Function1<ProducerIdQuotaManager, BoxedUnit>)(Function1 & Serializable)quotaManager -> {
            ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenBelowCountQuotaBelowRateQuota$1(this, quotaManager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoThrottleWhenBelowCountQuotaAboveRateQuota() {
        this.withQuotaManager((Function1<ProducerIdQuotaManager, BoxedUnit>)(Function1 & Serializable)quotaManager -> {
            ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenBelowCountQuotaAboveRateQuota$1(this, quotaManager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoThrottleWhenAboveCountQuotaBelowRateQuota() {
        this.withQuotaManager((Function1<ProducerIdQuotaManager, BoxedUnit>)(Function1 & Serializable)quotaManager -> {
            ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenAboveCountQuotaBelowRateQuota$1(this, quotaManager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testThrottleWhenAboveCountQuotaAboveRateQuota() {
        this.withQuotaManager((Function1<ProducerIdQuotaManager, BoxedUnit>)(Function1 & Serializable)quotaManager -> {
            ProducerIdQuotaManagerTest.$anonfun$testThrottleWhenAboveCountQuotaAboveRateQuota$1(this, quotaManager);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testNoThrottleWhenBelowCountQuotaBelowRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 1.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public static final /* synthetic */ void $anonfun$testNoThrottleWhenBelowCountQuotaAboveRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 1.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 2.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public static final /* synthetic */ void $anonfun$testNoThrottleWhenAboveCountQuotaBelowRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 100.0));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 1.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public static final /* synthetic */ void $anonfun$testThrottleWhenAboveCountQuotaAboveRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 10.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
        int throttleTime = $this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 110.0);
        Assertions.assertEquals((int)0, (int)throttleTime, (String)"Should not be throttled");
        throttleTime = $this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 110.0);
        Assertions.assertEquals((int)1000, (int)throttleTime, (String)"Should be throttled");
        $this.throttle((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), throttleTime, $this.callback());
        Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public ProducerIdQuotaManagerTest() {
        this.User = "ANONYMOUS";
        this.ClientId = "test-client";
    }
}

