/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server.link;

import java.util.concurrent.ExecutionException;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)2Aa\u0001\u0003\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013\tYR\t_2fgNLg/\u001a'pO\u001eLgn\u001a%b]\u0012dWM\u001d+fgRT!!\u0002\u0004\u0002\t1Lgn\u001b\u0006\u0003\u000f!\taa]3sm\u0016\u0014(BA\u0005\u000b\u0003\u0015Y\u0017MZ6b\u0015\u0005Y\u0011\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0011\u0005]\u0001Q\"\u0001\u0003\u00027Q,7\u000f^#yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3s)\u0005Q\u0002CA\b\u001c\u0013\ta\u0002C\u0001\u0003V]&$\bF\u0001\u0002\u001f!\ty\u0002&D\u0001!\u0015\t\t#%A\u0002ba&T!a\t\u0013\u0002\u000f),\b/\u001b;fe*\u0011QEJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002O\u0005\u0019qN]4\n\u0005%\u0002#\u0001\u0002+fgR\u0004")
public class ExcessiveLoggingHandlerTest {
    @Test
    public void testExcessiveLoggingHandler() {
        ExcessiveLoggingHandler excessiveLoggingHandler = new ExcessiveLoggingHandler();
        Logging logging = (Logging)Mockito.mock(Logging.class);
        String errMsgOne = "Invalid request type one.";
        ExecutionException exceptionTypeOne = new ExecutionException((Throwable)new InvalidRequestException(errMsgOne));
        excessiveLoggingHandler.handle((Throwable)exceptionTypeOne, logging, "Error msg");
        Assertions.assertEquals((int)0, (int)excessiveLoggingHandler.ignoredWarnLogCount());
        excessiveLoggingHandler.handle((Throwable)exceptionTypeOne, logging, "Error msg");
        Assertions.assertEquals((int)1, (int)excessiveLoggingHandler.ignoredWarnLogCount());
        ExecutionException exceptionTypeTwo = new ExecutionException((Throwable)new InvalidRequestException("Invalid request type two."));
        excessiveLoggingHandler.handle((Throwable)exceptionTypeTwo, logging, "Error msg");
        Assertions.assertEquals((int)1, (int)excessiveLoggingHandler.ignoredWarnLogCount());
        excessiveLoggingHandler.handle((Throwable)exceptionTypeTwo, logging, "Error msg");
        Assertions.assertEquals((int)2, (int)excessiveLoggingHandler.ignoredWarnLogCount());
        ExecutionException exceptionTypeThree = new ExecutionException(new IllegalArgumentException(errMsgOne));
        excessiveLoggingHandler.handle((Throwable)exceptionTypeThree, logging, "Error msg");
        Assertions.assertEquals((int)2, (int)excessiveLoggingHandler.ignoredWarnLogCount());
        excessiveLoggingHandler.handle((Throwable)exceptionTypeThree, logging, "Error msg");
        Assertions.assertEquals((int)3, (int)excessiveLoggingHandler.ignoredWarnLogCount());
        excessiveLoggingHandler.handle(new Throwable("A throwable"), logging, "Error msg");
        Assertions.assertEquals((int)3, (int)excessiveLoggingHandler.ignoredWarnLogCount());
        excessiveLoggingHandler.handle((Throwable)new ExecutionException(null), logging, "Error msg");
        Assertions.assertEquals((int)3, (int)excessiveLoggingHandler.ignoredWarnLogCount());
    }
}

