/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kafka.log.LocalLog$;
import kafka.log.MergedLog$;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.RestorePartitionOperator;
import kafka.server.Defaults$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.ConfluentLogConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\u0017.\u0001QBQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005\u0002\u0001CQ\u0001\u0012\u0001\u0005\u0002\u0001CQ!\u0012\u0001\u0005\u0002\u0001CQA\u0012\u0001\u0005\u0002\u001dCQ!\u0015\u0001\u0005\u0002\u0001CQA\u0015\u0001\u0005\u0002MCqa\u0016\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004]\u0001\u0001\u0006I!\u0017\u0005\b;\u0002\u0011\r\u0011\"\u0001T\u0011\u0019q\u0006\u0001)A\u0005)\"9q\f\u0001b\u0001\n\u0003\u0001\u0007BB5\u0001A\u0003%\u0011\rC\u0004k\u0001\t\u0007I\u0011A6\t\r=\u0004\u0001\u0015!\u0003m\u0011\u001d\u0001\bA1A\u0005\u0002EDa!\u001e\u0001!\u0002\u0013\u0011\bb\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003y\u0011!\t\u0019\u0001\u0001b\u0001\n\u00039\bbBA\u0003\u0001\u0001\u0006I\u0001\u001f\u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"!\t\u0001A\u0003%\u00111\u0002\u0005\n\u0003G\u0001!\u0019!C\u0001\u0003KA\u0001\"a\f\u0001A\u0003%\u0011q\u0005\u0005\n\u0003c\u0001!\u0019!C\u0001\u0003gA\u0001\"!\u0013\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u0017\u0002!\u0019!C\u0001\u0003\u001bB\u0001\"a\u0016\u0001A\u0003%\u0011q\n\u0005\t\u0017\u0002\u0011\r\u0011\"\u0001\u0002Z!A\u0011\u0011\r\u0001!\u0002\u0013\tY\u0006C\u0005\u0002d\u0001\u0011\r\u0011\"\u0001\u0002f!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0007C\u0005\u0002p\u0001\u0011\r\u0011\"\u0001\u0002r!A\u0011\u0011\u0010\u0001!\u0002\u0013\t\u0019\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005m\u0005\u0001\"\u0001\u0002~!9\u0011Q\u0015\u0001\u0005\u0002\u0005u\u0004bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KD\u0001\"a@\u0001\u0005\u0004%I\u0001\u0017\u0005\b\u0005\u0003\u0001\u0001\u0015!\u0003Z\u0005u\u0011Vm\u001d;pe\u0016$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3UKN$(B\u0001\u00180\u0003\u0015!xn\u001c7t\u0015\t\u0001\u0014'A\u0003lC\u001a\\\u0017MC\u00013\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001!\u000e\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0004C\u0001 \u0001\u001b\u0005i\u0013aD2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3\u0016\u0003\u0005\u0003\"A\u000e\"\n\u0005\r;$a\u0002\"p_2,\u0017M\\\u0001\u001ai&,'o\u00117fC:,'OR3biV\u0014X-\u00128bE2,G-A\u0014uS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7\t\\3b]V\u0004h)Z1ukJ,WI\\1cY\u0016$\u0017!D2mK\u0006tW\u000f]\"p]\u001aLw-F\u0001I!\tIu*D\u0001K\u0015\tYE*A\u0003ti\u0006$XM\u0003\u0002N\u001d\u0006!A/[3s\u0015\u0005\u0001\u0014B\u0001)K\u0005}!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3DY\u0016\fg.\u001e9D_:4\u0017nZ\u0001\"i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00158baNDw\u000e^#oC\ndW\rZ\u0001\tEJ|7.\u001a:JIV\tA\u000b\u0005\u00027+&\u0011ak\u000e\u0002\u0004\u0013:$\u0018AD2mK\u0006tW\u000f\u001d#fY\u0006LXj]\u000b\u00023B\u0011aGW\u0005\u00037^\u0012A\u0001T8oO\u0006y1\r\\3b]V\u0004H)\u001a7bs6\u001b\b%A\tdY\u0016\fg.\u001e9J]R,'O^1m\u001bN\f!c\u00197fC:,\b/\u00138uKJ4\u0018\r\\'tA\u0005\t2\r[3dWN,X.\u00117h_JLG\u000f[7\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u0011\rDWmY6tk6T!A\u001a(\u0002\u000bU$\u0018\u000e\\:\n\u0005!\u001c'!C!mO>\u0014\u0018\u000e\u001e5n\u0003I\u0019\u0007.Z2lgVl\u0017\t\\4pe&$\b.\u001c\u0011\u0002!M,\b/\u001a:CY>\u001c7\u000eT3oORDW#\u00017\u0011\u0005Yj\u0017B\u000188\u0005\u0015\u0019\u0006n\u001c:u\u0003E\u0019X\u000f]3s\u00052|7m\u001b'f]\u001e$\b\u000eI\u0001\bM\u0006\u001cGo\u001c:z+\u0005\u0011\bCA%t\u0013\t!(JA\rUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)Y2u_JL\u0018\u0001\u00034bGR|'/\u001f\u0011\u0002\u0013A\f'/\u001a8u\t&\u0014X#\u0001=\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018AA5p\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a >\u0003\t\u0019KG.Z\u0001\u000ba\u0006\u0014XM\u001c;ESJ\u0004\u0013a\u00013je\u0006!A-\u001b:!\u0003\t!\b/\u0006\u0002\u0002\fA!\u0011QBA\u000f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AB2p[6|gNC\u00021\u0003+QA!a\u0006\u0002\u001a\u00051\u0011\r]1dQ\u0016T!!a\u0007\u0002\u0007=\u0014x-\u0003\u0003\u0002 \u0005=!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013\u0001\u0002;qS\u0012,\"!a\n\u0011\t\u0005%\u00121F\u0007\u0002\u0019&\u0019\u0011Q\u0006'\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017!\u0002;qS\u0012\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u00026A!\u0011qGA#\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012a\u00017pO*!\u0011qHA!\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0003\u0002D\u0005M\u0011aB:u_J\fw-Z\u0005\u0005\u0003\u000f\nID\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0016Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005=\u0003\u0003BA)\u0003'j\u0011!Z\u0005\u0004\u0003+*'\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0016\u0005\u0005m\u0003cA%\u0002^%\u0019\u0011q\f&\u0003-\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\faa\u001d;bi\u0016\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\t9\u0007\u0005\u0003\u00028\u0005%\u0014\u0002BA6\u0003s\u0011\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\nd_:4G.^3oi2{wmQ8oM&<WCAA:!\u0011\t9$!\u001e\n\t\u0005]\u0014\u0011\b\u0002\u0013\u0007>tg\r\\;f]RdunZ\"p]\u001aLw-A\nd_:4G.^3oi2{wmQ8oM&<\u0007%A\u0003tKR,\b\u000f\u0006\u0002\u0002\u0000A\u0019a'!!\n\u0007\u0005\ruG\u0001\u0003V]&$\bf\u0001\u0013\u0002\bB!\u0011\u0011RAL\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015aA1qS*!\u0011\u0011SAJ\u0003\u001dQW\u000f]5uKJTA!!&\u0002\u001a\u0005)!.\u001e8ji&!\u0011\u0011TAF\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u001aQ%a(\u0011\t\u0005%\u0015\u0011U\u0005\u0005\u0003G\u000bYIA\u0005BMR,'/R1dQ\u00061B/Z:u+B$\u0017\r^3TK\u001elWM\u001c;Ti\u0006$X\rK\u0002'\u0003S\u0003B!!#\u0002,&!\u0011QVAF\u0005\u0011!Vm\u001d;\u00021U\u0004Hn\\1e\u0013:LG/\u0019;f\u0003:$7i\\7qY\u0016$X\r\u0006\b\u0002\u0000\u0005M\u0016qWAd\u0003\u0017\fy-a5\t\r\u0005Uv\u00051\u0001U\u0003\u0015)\u0007o\\2i\u0011\u001d\tIl\na\u0001\u0003w\u000b\u0001b\u001c2kK\u000e$\u0018\n\u001a\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*\u0019\u0011\u0011\u0019?\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000b\fyL\u0001\u0003V+&#\u0005BBAeO\u0001\u0007\u0011,A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bBBAgO\u0001\u0007\u0011,A\u0005f]\u0012|eMZ:fi\"1\u0011\u0011[\u0014A\u0002Q\u000bAa]5{K\"1\u0011Q[\u0014A\u0002e\u000bA\"\\1y)&lWm\u001d;b[B\f\u0011\u0004Z3mKR,\u0017J\\5uS\u0006$X-\u00118e\u0007>l\u0007\u000f\\3uKRA\u0011qPAn\u0003;\fy\u000e\u0003\u0004\u00026\"\u0002\r\u0001\u0016\u0005\b\u0003sC\u0003\u0019AA^\u0011\u0019\t\t\u000f\u000ba\u00013\u0006\u0001B-\u001a7fi\u0016\u001cu.\u001c9mKR,Gk]\u0001\u0011O\u0016$H+[3s'R\fG/\u001a$jY\u0016$B!a:\u0002~B!\u0011\u0011^A|\u001d\u0011\tY/a=\u0011\u0007\u00055x'\u0004\u0002\u0002p*\u0019\u0011\u0011_\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\t)pN\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00181 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Ux\u0007\u0003\u0004\u0002\u0004%\u0002\r\u0001_\u0001\u0012_:,W*\u001b8vi\u0016Le.T5mY&\u001c\u0018AE8oK6Kg.\u001e;f\u0013:l\u0015\u000e\u001c7jg\u0002\u0002")
public class RestoreTierPartitionStateTest {
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final Algorithm checksumAlgorithm = this.checksumEnabled() ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
    private final short superBlockLength = (short)(this.checksumEnabled() ? 512 : 0);
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled(), this.tierCleanerFeatureEnabled(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
    private final File parentDir = TestUtils.tempDirectory(null, null);
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
    private final TopicPartition tp;
    private final TopicIdPartition tpid;
    private final LogDirFailureChannel logDirFailureChannel;
    private final MockTime time;
    private final FileTierPartitionState state;
    private final LogConfig logConfig;
    private final ConfluentLogConfig confluentLogConfig;
    private final long oneMinuteInMillis;

    public boolean checksumEnabled() {
        return false;
    }

    public boolean tierCleanerFeatureEnabled() {
        return false;
    }

    public boolean tierPartitionStateCleanupFeatureEnabled() {
        return false;
    }

    public TierPartitionStateCleanupConfig cleanupConfig() {
        return new TierPartitionStateCleanupConfig(this.tierPartitionStateCleanupFeatureEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs());
    }

    public boolean tierPartitionStateSnapshotEnabled() {
        return false;
    }

    public int brokerId() {
        return 0;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public ConfluentLogConfig confluentLogConfig() {
        return this.confluentLogConfig;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ debug_this = TestUtils$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = RestoreTierPartitionStateTest.$anonfun$setup$2(this, op);
                Object var3_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)debug_this, (String)msgWithLogIdent_msg));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().confluentLogConfig()).thenReturn((Object)this.confluentLogConfig());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.confluentLogConfig().tierEnable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    @Test
    public void testUpdateSegmentState() {
        int epoch = 3;
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef baseOffset = IntRef.create((int)0);
        long start = System.currentTimeMillis();
        LongRef timestamp = LongRef.create((long)start);
        ArrayBuffer objectIds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            int endOffset = baseOffset$1.elem + numOffsetsInSegment;
            UUID objectId = UUID.randomUUID();
            objectIds.$plus$eq((Object)objectId);
            this.uploadInitateAndComplete(epoch, objectId, baseOffset$1.elem, endOffset, 100, timestamp$1.elem);
            timestamp$1.elem += this.oneMinuteInMillis();
            baseOffset$1.elem = endOffset + 1;
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.deleteInitiateAndComplete(epoch, (UUID)objectIds.apply(i), start));
        this.state().close();
        RestorePartitionOperator restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        FtpsSegmentView operatorContext = restoreOperator.operatorContext();
        long headerSize = operatorContext.header().size();
        Assertions.assertEquals((long)150L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((int)3, (int)operatorContext.segmentStateMap().size());
        Assertions.assertEquals((int)2, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)1, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        Map pathmap = CollectionConverters$.MODULE$.MapHasAsScala(restoreOperator.restore()).asScala();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)2, (int)pathmap.size());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> Assertions.assertTrue((boolean)pathmap.keySet().contains(objectIds.apply(index))));
        restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        operatorContext = restoreOperator.operatorContext();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)0, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)3, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.tierCleanerFeatureEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.tierPartitionStateCleanupFeatureEnabled(), start);
        reopenedState.close();
    }

    private void uploadInitateAndComplete(int epoch, UUID objectId, long startOffset, long endOffset, int size, long maxTimestamp) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, startOffset, endOffset, maxTimestamp, -1L, size, false, false, false, TierUploadType.Archive, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private void deleteInitiateAndComplete(int epoch, UUID objectId, long deleteCompleteTs) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId, stateOffset, deleteCompleteTs), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private String getTierStateFile(File dir) {
        Object object = new Object();
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)file -> {
                RestoreTierPartitionStateTest.$anonfun$getTierStateFile$1(object, file);
                return BoxedUnit.UNIT;
            });
            return null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (String)ex.value();
            }
            throw ex;
        }
    }

    private long oneMinuteInMillis() {
        return this.oneMinuteInMillis;
    }

    public static final /* synthetic */ String $anonfun$setup$2(RestoreTierPartitionStateTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$getTierStateFile$1(Object nonLocalReturnKey1$1, File file) {
        if (file.isFile() && MergedLog$.MODULE$.isTierStateFile(file)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)file.getAbsolutePath());
        }
    }

    public RestoreTierPartitionStateTest() {
        this.cleanupIntervalMs = 0;
        File parseTopicPartitionName_dir = this.dir();
        Object var1_1 = null;
        this.tp = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
        this.logDirFailureChannel = new LogDirFailureChannel(5);
        this.time = new MockTime();
        this.state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.tierCleanerFeatureEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        this.logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        this.confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        this.oneMinuteInMillis = 60000L;
    }
}

