/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.zk;

import java.io.Serializable;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.zk.ConfluentAssignmentMigration$;
import kafka.zk.KRaftAssignment;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005E3Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)\u0001\u0007\u0001C\u0001?!)!\u0007\u0001C\u0001?!)A\u0007\u0001C\u0001?!)a\u0007\u0001C\u0001?!)\u0001\b\u0001C\u0001?!)!\b\u0001C\u0001?!)A\b\u0001C\u0001?!)a\b\u0001C\u0005\u007f\t\u00013i\u001c8gYV,g\u000e^!tg&<g.\\3oi6KwM]1uS>tG+Z:u\u0015\tia\"\u0001\u0002{W*\u0011q\u0002E\u0001\u0006W\u000647.\u0019\u0006\u0002#\u0005!QO\\5u\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\tA\"A\u0016uKN$hI]8n5.$vn\u0013*bMR\f5o]5h]6,g\u000e^,ji\"|W\u000f^(cg\u0016\u0014h/\u001a:t)\u0005\u0001\u0003CA\u000b\"\u0013\t\u0011cC\u0001\u0003V]&$\bF\u0001\u0002%!\t)c&D\u0001'\u0015\t9\u0003&A\u0002ba&T!!\u000b\u0016\u0002\u000f),\b/\u001b;fe*\u00111\u0006L\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002[\u0005\u0019qN]4\n\u0005=2#\u0001\u0002+fgR\f\u0001\u0006^3ti\u001a\u0013x.\u001c.l)>\\%+\u00194u\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001f\n\u001cXM\u001d<feND#a\u0001\u0013\u0002{Q,7\u000f\u001e$s_6T6\u000eV8L%\u00064G/Q:tS\u001etW.\u001a8u/&$\bn\\;u\u001f\n\u001cXM\u001d<feN$UO]5oOJ+\u0017m]:jO:lWM\u001c;)\u0005\u0011!\u0013A\u000f;fgR4%o\\7[WR{7JU1gi\u0006\u001b8/[4o[\u0016tGoV5uQ>\u00137/\u001a:wKJ\u001cH)\u001e:j]\u001e\u0014V-Y:tS\u001etW.\u001a8uQ\t)A%A\u0016uKN$hI]8n\u0017J\u000bg\r\u001e+p5.\f5o]5h]6,g\u000e^,ji\"|W\u000f^(cg\u0016\u0014h/\u001a:tQ\t1A%\u0001\u0015uKN$hI]8n\u0017J\u000bg\r\u001e+p5.\f5o]5h]6,g\u000e^,ji\"|%m]3sm\u0016\u00148\u000f\u000b\u0002\bI\u0005iD/Z:u\rJ|Wn\u0013*bMR$vNW6BgNLwM\\7f]R<\u0016\u000e\u001e5pkR|%m]3sm\u0016\u00148\u000fR;sS:<'+Z1tg&<g.\\3oi\"\u0012\u0001\u0002J\u0001;i\u0016\u001cHO\u0012:p[.\u0013\u0016M\u001a;U_j[\u0017i]:jO:lWM\u001c;XSRDwJY:feZ,'o\u001d#ve&twMU3bgNLwM\\7f]RD#!\u0003\u0013\u0002/Q|\u0007+\u0019:uSRLwN\u001c*fO&\u001cHO]1uS>tGC\u0001!J!\t\tu)D\u0001C\u0015\t\u0019E)\u0001\u0005nKR\fG-\u0019;b\u0015\tyQI\u0003\u0002GY\u00051\u0011\r]1dQ\u0016L!\u0001\u0013\"\u0003+A\u000b'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\")!J\u0003a\u0001\u0017\u0006y1N]1gi\u0006\u001b8/[4o[\u0016tG\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002\u000e\u001d*\tq\"\u0003\u0002Q\u001b\ny1JU1gi\u0006\u001b8/[4o[\u0016tG\u000f")
public class ConfluentAssignmentMigrationTest {
    @Test
    public void testFromZkToKRaftAssignmentWithoutObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.empty();
        ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers);
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), observers, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(replicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromZkToKRaftAssignmentWithObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers);
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)observers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(replicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromZkToKRaftAssignmentWithoutObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.empty();
        ReplicaAssignment.Assignment targetAssignment = new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment reassignmentReplicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers).reassignTo(targetAssignment);
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 0, 1, 2}));
        Seq expectedAddingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}));
        Seq expectedRemovingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)expectedReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), observers, (Seq)expectedAddingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedRemovingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(reassignmentReplicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromZkToKRaftAssignmentWithObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        ReplicaAssignment.Assignment targetAssignment = new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8})));
        ReplicaAssignment reassignmentReplicaAssignment = ReplicaAssignment$.MODULE$.apply(replicas, observers).reassignTo(targetAssignment);
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1, 7, 8, 5, 6}));
        Seq expectedObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 5, 6}));
        Seq expectedAddingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8}));
        Seq expectedRemovingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq expectedAddingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        Seq expectedRemovingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        KRaftAssignment expectedKRaftAssignment = new KRaftAssignment((Seq)expectedReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedAddingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedRemovingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedAddingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)expectedRemovingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)));
        KRaftAssignment actualKRaftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(reassignmentReplicaAssignment);
        Assertions.assertEquals((Object)expectedKRaftAssignment, (Object)actualKRaftAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithoutObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.empty();
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), observers, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), observers, (Option)None$.MODULE$);
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithObservers() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)observers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), observers, (Option)None$.MODULE$);
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithoutObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 0, 1, 2}));
        Seq addingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}));
        Seq removingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)addingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)removingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, addingReplicas, removingReplicas, (Seq)Seq$.MODULE$.empty(), (Option)new Some((Object)Seq$.MODULE$.empty()));
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    @Test
    public void testFromKRaftToZkAssignmentWithObserversDuringReassignment() {
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1, 7, 8, 5, 6}));
        Seq observers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 5, 6}));
        Seq addingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8}));
        Seq removingReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6}));
        Seq addingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        Seq removingObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        Seq originalObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}));
        Seq targetObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}));
        KRaftAssignment kraftAssignment = new KRaftAssignment((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)observers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)addingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)removingReplicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)addingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)), (Seq)removingObservers.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1)));
        ReplicaAssignment expectedReplicaAssignment = new ReplicaAssignment(replicas, addingReplicas, removingReplicas, originalObservers, (Option)new Some((Object)targetObservers));
        ReplicaAssignment actualReplicaAssignment = ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(this.toPartitionRegistration(kraftAssignment));
        Assertions.assertEquals((Object)expectedReplicaAssignment, (Object)actualReplicaAssignment);
    }

    private PartitionRegistration toPartitionRegistration(KRaftAssignment kraftAssignment) {
        return new PartitionRegistration.Builder().setReplicas((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.replicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), (ClassTag)ClassTag$.MODULE$.Int())).setObservers((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.observers().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), (ClassTag)ClassTag$.MODULE$.Int())).setIsr((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.replicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), (ClassTag)ClassTag$.MODULE$.Int())).setRemovingReplicas((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.removingReplicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4)), (ClassTag)ClassTag$.MODULE$.Int())).setAddingReplicas((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.addingReplicas().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$5)), (ClassTag)ClassTag$.MODULE$.Int())).setRemovingObservers((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.removingObservers().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$6)), (ClassTag)ClassTag$.MODULE$.Int())).setAddingObservers((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])kraftAssignment.addingObservers().toArray(ClassTag$.MODULE$.apply(Integer.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$7)), (ClassTag)ClassTag$.MODULE$.Int())).setLeader(Predef$.MODULE$.int2Integer(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(1)).setPartitionEpoch(Predef$.MODULE$.int2Integer(1)).build();
    }
}

