/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u0007\u000f\u0001]AQa\b\u0001\u0005\u0002\u0001BQa\t\u0001\u0005\u0002\u0011BQ\u0001\u000f\u0001\u0005\u0002\u0011BQA\u000f\u0001\u0005\u0002\u0011BQ\u0001\u0010\u0001\u0005\u0002\u0011BQA\u0010\u0001\u0005\u0002\u0011BQ\u0001\u0011\u0001\u0005\u0002\u0011BQA\u0011\u0001\u0005\u0002\u0011BQ\u0001\u0012\u0001\u0005\n\u0015CQ\u0001\u001e\u0001\u0005\nUDQ\u0001 \u0001\u0005\nuDq!a\f\u0001\t\u0013\t\tDA\u000e[W\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5NS\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u001fA\t\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u0005E\u0011\u0012A\u0001>l\u0015\t\u0019B#A\u0003lC\u001a\\\u0017MC\u0001\u0016\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ui\u0011A\u0007\u0006\u0003\u001fmQ!!\u0005\u000f\u000b\u0003MI!A\b\u000e\u0003-i[W*[4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\b\u00029Q,7\u000f^'jOJ\fG/Z#naRL(I]8lKJDU-\u00197uQR\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\bF\u0001\u0002-!\tic'D\u0001/\u0015\ty\u0003'A\u0002ba&T!!\r\u001a\u0002\u000f),\b/\u001b;fe*\u00111\u0007N\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002k\u0005\u0019qN]4\n\u0005]r#\u0001\u0002+fgR\fq\u0003^3ti6KwM]1uK\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5)\u0005\ra\u0013\u0001\n;fgRl\u0015n\u001a:bi\u0016\u0014%o\\6fe\"+\u0017\r\u001c;i\r>\u0014Hi\\<o\u0005J|7.\u001a:)\u0005\u0011a\u0013a\u000b;fgRl\u0015n\u001a:bi\u0016\u0014%o\\6fe\"+\u0017\r\u001c;i\r>\u0014hj\u001c8Fq&\u001cH/\u001a8u\u0005J|7.\u001a:)\u0005\u0015a\u0013\u0001\f;fgRl\u0015n\u001a:bi\u0016\u0014%o\\6fe\"+\u0017\r\u001c;i/&$\b\u000e\u0015:j_J$Um\u001a:bI\u0006$\u0018n\u001c8tQ\t1A&\u0001\fuKN$X\u000b\u001d3bi\u0016\u0014%o\\6fe\"+\u0017\r\u001c;iQ\t9A&A\u0012uKN$X\u000b\u001d3bi\u0016\u0014%o\\6fe\"+\u0017\r\u001c;i/&dGn\u0014<fe^\u0014\u0018\u000e^3)\u0005!a\u0013!J1tg\u0016\u0014HOU3d_J$7/T1uG\",\u0005\u0010]3di\u0016$\u0007*Z1mi\"\u001cF/\u0019;f)\r)ci\u001a\u0005\u0006\u000f&\u0001\r\u0001S\u0001\u0012EJ|7.\u001a:IK\u0006dG\u000f[*uCR,\u0007\u0003B%M\u001dFk\u0011A\u0013\u0006\u0003\u0017\u001e\n!bY8mY\u0016\u001cG/[8o\u0013\ti%JA\u0002NCB\u0004\"AJ(\n\u0005A;#aA%oiB\u0019!+\u0017/\u000f\u0005M;\u0006C\u0001+(\u001b\u0005)&B\u0001,\u0017\u0003\u0019a$o\\8u}%\u0011\u0001lJ\u0001\u0007!J,G-\u001a4\n\u0005i[&aA*fi*\u0011\u0001l\n\t\u0003;\u0016l\u0011A\u0018\u0006\u0003?\u0002\fQ!\u00193nS:T!!\u00192\u0002\u000f\rd\u0017.\u001a8ug*\u00111c\u0019\u0006\u0003IR\na!\u00199bG\",\u0017B\u00014_\u0005]!Um\u001a:bI\u0016$'I]8lKJ\u001cu.\u001c9p]\u0016tG\u000fC\u0003i\u0013\u0001\u0007\u0011.A\rsK\u001eL7\u000f\u001e:bi&|gn\u00115b]\u001e,'+Z2pe\u0012\u001c\bcA%kY&\u00111N\u0013\u0002\u0004'\u0016\f\bCA7s\u001b\u0005q'BA8q\u0003!iW\r^1eCR\f'BA9c\u0003\u0019\u0019w.\\7p]&\u00111O\u001c\u0002\u001f\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|gn\u00115b]\u001e,'+Z2pe\u0012\f\u0001c\u0019:fCR,'I]8lKJLeNZ8\u0015\u0005YT\bCA<y\u001b\u0005Y\u0012BA=\u001c\u0005)\u0011%o\\6fe&sgm\u001c\u0005\u0006w*\u0001\rAT\u0001\u0003S\u0012\f!C\u0019:pW\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]R)a0a\u0002\u0002\u001cA\u0019q0a\u0001\u000e\u0005\u0005\u0005!BA8c\u0013\u0011\t)!!\u0001\u0003%\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0003\u0013Y\u0001\u0019AA\u0006\u0003!\u0011'o\\6fe&#\u0007\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\u000f%sG/Z4fe\"9\u0011QD\u0006A\u0002\u0005}\u0011\u0001\u00043fOJ\fG-\u0019;j_:\u001c\bCBA\u0011\u0003O\tI#\u0004\u0002\u0002$)!\u0011QEA\n\u0003\u0011)H/\u001b7\n\u0007i\u000b\u0019\u0003E\u0002\u0000\u0003WIA!!\f\u0002\u0002\tIB)Z4sC\u0012,GM\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;f\u0003M\u0011'o\\6feJ+w-[:ue\u0006$\u0018n\u001c8t)\u0019\t\u0019$a\u000e\u0002<A9\u0011\u0011EA\u001b\u0003\u0017q\u0018bA'\u0002$!1\u0011\u0011\b\u0007A\u00029\u000b!B\\;n\u0005J|7.\u001a:t\u0011\u001d\ti\u0002\u0004a\u0001\u0003{\u0001R!\u0013'O\u0003\u007f\u0001BAU-\u0002*\u0001")
public class ZkBrokerHealthMigrationTest
extends ZkMigrationTestHarness {
    @Test
    public void testMigrateEmptyBrokerHealth() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)0, (int)batches.size());
    }

    @Test
    public void testMigrateBrokerHealth() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        Map brokerHealthState = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        this.zkClient().setBrokerHealthState(brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$1 -> x$1.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealth$3(message)))).map((Function1 & Serializable)x$2 -> (BrokerRegistrationChangeRecord)x$2)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)brokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testMigrateBrokerHealthForDownBroker() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        Map brokerHealthState = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        this.zkClient().setBrokerHealthState(brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$3 -> x$3.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealthForDownBroker$3(message)))).map((Function1 & Serializable)x$4 -> (BrokerRegistrationChangeRecord)x$4)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)brokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testMigrateBrokerHealthForNonExistentBroker() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        scala.collection.mutable.Map brokerHealthState = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        scala.collection.mutable.Map expectedBrokerHealthState = (scala.collection.mutable.Map)brokerHealthState.clone();
        expectedBrokerHealthState.remove((Object)BoxesRunTime.boxToInteger((int)2));
        this.zkClient().setBrokerHealthState((Map)brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(2, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.empty())));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$5 -> x$5.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealthForNonExistentBroker$3(message)))).map((Function1 & Serializable)x$6 -> (BrokerRegistrationChangeRecord)x$6)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)expectedBrokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testMigrateBrokerHealthWithPriorDegradations() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        scala.collection.mutable.Map brokerHealthState = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3})))}));
        this.zkClient().setBrokerHealthState((Map)brokerHealthState);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateBrokerHealth(batch -> batches.add(batch), this.brokerRegistrations(3, (Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerHealthState[]{new DegradedBrokerHealthState("rcca-345", BrokerComponent.NETWORK)})))})))));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq registrationChangeRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$7 -> x$7.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkBrokerHealthMigrationTest.$anonfun$testMigrateBrokerHealthWithPriorDegradations$3(message)))).map((Function1 & Serializable)x$8 -> (BrokerRegistrationChangeRecord)x$8)).toSeq();
        this.assertRecordsMatchExpectedHealthState((Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>>)brokerHealthState, (Seq<BrokerRegistrationChangeRecord>)registrationChangeRecords);
    }

    @Test
    public void testUpdateBrokerHealth() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        DegradedBrokerComponent brokerComponent1 = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        DegradedBrokerComponent brokerComponent2 = new DegradedBrokerComponent("rcca-123", BrokerComponent.STORAGE.id());
        DegradedBrokerComponent brokerComponent3 = new DegradedBrokerComponent("rcca-234", BrokerComponent.UNSPECIFIED.id());
        java.util.Map brokerHealthState = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent1, brokerComponent2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent3}))).asJava())}))).asJava();
        this.migrationState_$eq(this.migrationClient().brokerHealthClient().writeBrokerHealthState(brokerHealthState, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Map brokerHealthFromZk = this.zkClient().getBrokerHealthState();
        Assertions.assertEquals((int)3, (int)brokerHealthFromZk.size());
        brokerHealthFromZk.foreach((Function1 & Serializable)x0$1 -> {
            ZkBrokerHealthMigrationTest.$anonfun$testUpdateBrokerHealth$1(brokerHealthState, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUpdateBrokerHealthWillOverwrite() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        DegradedBrokerComponent brokerComponent = new DegradedBrokerComponent("rcca-123", BrokerComponent.UNSPECIFIED.id());
        this.zkClient().setBrokerHealthState((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent})))})));
        java.util.Map brokerHealthState = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{brokerComponent}))).asJava())}))).asJava();
        this.migrationState_$eq(this.migrationClient().brokerHealthClient().writeBrokerHealthState(brokerHealthState, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Map brokerHealthFromZk = this.zkClient().getBrokerHealthState();
        Assertions.assertEquals((int)1, (int)brokerHealthFromZk.size());
        Assertions.assertEquals(brokerHealthState.get(BoxesRunTime.boxToInteger((int)2)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)brokerHealthFromZk.apply((Object)BoxesRunTime.boxToInteger((int)2))).asJava());
        java.util.Map emptyBrokerHealthState = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava();
        this.migrationState_$eq(this.migrationClient().brokerHealthClient().writeBrokerHealthState(emptyBrokerHealthState, this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        brokerHealthFromZk = this.zkClient().getBrokerHealthState();
        Assertions.assertEquals((int)0, (int)brokerHealthFromZk.size());
    }

    private void assertRecordsMatchExpectedHealthState(Map<Object, scala.collection.immutable.Set<DegradedBrokerComponent>> brokerHealthState, Seq<BrokerRegistrationChangeRecord> registrationChangeRecords) {
        Assertions.assertEquals((int)brokerHealthState.size(), (int)registrationChangeRecords.size(), (String)new StringBuilder(51).append("Expected number of brokers with degradations to be ").append(brokerHealthState.size()).toString());
        registrationChangeRecords.foreach((Function1 & Serializable)record -> {
            ZkBrokerHealthMigrationTest.$anonfun$assertRecordsMatchExpectedHealthState$1(brokerHealthState, record);
            return BoxedUnit.UNIT;
        });
    }

    private BrokerInfo createBrokerInfo(int id) {
        return BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(id, (Seq)new .colon.colon((Object)new EndPoint(new StringBuilder(9).append("test.host").append(Integer.toString(id)).toString(), 9000 + id, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures()), MetadataVersion.latest(), 9010 + id);
    }

    private BrokerRegistration brokerRegistration(Integer brokerId, java.util.Set<DegradedBrokerHealthState> degradations) {
        return new BrokerRegistration(Predef$.MODULE$.Integer2int(brokerId), 1L, Uuid.randomUuid(), new HashMap(), new HashMap(), Optional.empty(), false, true, true, degradations);
    }

    private java.util.Map<Integer, BrokerRegistration> brokerRegistrations(int numBrokers, Map<Object, scala.collection.immutable.Set<DegradedBrokerHealthState>> degradations) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.unboxToInt((Object)b)), (Object)this.brokerRegistration(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)b)), CollectionConverters$.MODULE$.SetHasAsJava((Set)degradations.getOrElse((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)b)), (Function0 & Serializable)() -> (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$))).asJava()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealth$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealthForDownBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealthForNonExistentBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateBrokerHealthWithPriorDegradations$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REGISTRATION_CHANGE_RECORD);
    }

    public static final /* synthetic */ void $anonfun$testUpdateBrokerHealth$1(java.util.Map brokerHealthState$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            scala.collection.immutable.Set degradedBrokerComponent = (scala.collection.immutable.Set)x0$1._2();
            Assertions.assertEquals(brokerHealthState$1.get(BoxesRunTime.boxToInteger((int)brokerId)), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)degradedBrokerComponent).asJava());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$assertRecordsMatchExpectedHealthState$1(Map brokerHealthState$2, BrokerRegistrationChangeRecord record) {
        Assertions.assertTrue((boolean)brokerHealthState$2.contains((Object)BoxesRunTime.boxToInteger((int)record.brokerId())));
        java.util.List expectedBrokerHealth = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)brokerHealthState$2.apply((Object)BoxesRunTime.boxToInteger((int)record.brokerId()))).map((Function1 & Serializable)component -> new BrokerRegistrationChangeRecord.DegradedComponent().setReason(component.reason()).setComponentCode(component.brokerComponent().id()))).toList()).asJava();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(expectedBrokerHealth).asScala().toSet(), (Object)CollectionConverters$.MODULE$.ListHasAsScala(record.degradedComponents()).asScala().toSet());
    }
}

