/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.ClusterLinkMetadata;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Optional;
import java.util.Set;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;

public class ClusterLinkDeletionEvent
extends MetadataCollectorEvent {
    private final Set<String> deleteClusterLinks;

    public ClusterLinkDeletionEvent(ZKMetadataCollector collector, Set<String> deleteClusterLinks, Time time) {
        super(collector, time);
        this.deleteClusterLinks = deleteClusterLinks;
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        LOG.debug("Deleting cluster links {}", this.deleteClusterLinks);
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        for (String deleteClusterLink : this.deleteClusterLinks) {
            String logicalClusterId = TenantHelpers.extractTenantPrefix(deleteClusterLink, false);
            MetadataEvent deleted = context.localStore().removeClusterLinkMetadataEvent(logicalClusterId, deleteClusterLink);
            Optional<String> clusterLinkId = Optional.ofNullable(deleted).map(MetadataEvent::getClusterLinkMetadata).map(ClusterLinkMetadata::getClusterLinkId);
            if (!clusterLinkId.isPresent()) {
                clusterLinkId = Optional.ofNullable(context.removeClusterLinkFromInitialSnapshot(deleteClusterLink)).map(ClusterLinkInfo::clusterLinkId).map(Uuid::toString);
            }
            MetadataEvent clusterLinkMetadataEvent = MetadataEventUtils.clusterLinkMetadataEventForDeletion(TenantHelpers.extractLogicalName(deleteClusterLink), clusterLinkId, eventTimestamp);
            MetadataChange clusterLinkDeleteChange = MetadataEventUtils.entityDeleteEvent(logicalClusterId, clusterLinkMetadataEvent);
            this.emitClusterLinkDeltaEvent(context, clusterLinkDeleteChange);
        }
    }

    public String toString() {
        return "ClusterLinkDeletionEvent(deletedClusterLinks=" + this.deleteClusterLinks + ')';
    }
}

