/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import kafka.catalog.metadata.MirrorTopicInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;

public class TopicConfigChangeEvent
extends MetadataCollectorEvent {
    private final String logicalClusterId;
    private final String topic;
    private final LogConfig newConfig;
    private final Properties updateProperties;

    public TopicConfigChangeEvent(ZKMetadataCollector collector, String logicalClusterId, String topic, LogConfig newConfig, Properties updateProperties, Time time) {
        super(collector, time);
        this.logicalClusterId = logicalClusterId;
        this.topic = topic;
        this.newConfig = newConfig;
        this.updateProperties = updateProperties;
    }

    public void run() throws Exception {
        int replicas;
        int partitions;
        Uuid id;
        ZKMetadataCollectorContext context = this.context();
        LOG.debug("Updating Topic Config for topic {} with new topicLogConfig {} and properties {}", new Object[]{this.topic, this.newConfig, this.updateProperties});
        MetadataEvent metadataEvent = context.localStore().topicMetadataEvent(this.topic);
        HashSet<String> allOverriddenConfigKeys = new HashSet<String>(this.updateProperties.stringPropertyNames());
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        Optional<Object> mirrorTopicInfo = Optional.empty();
        MirrorTopicMetadata mirrorTopicMetadata = null;
        if (metadataEvent != null) {
            TopicMetadata topicMetadata = metadataEvent.getTopicMetadata();
            id = Uuid.fromString((String)topicMetadata.getTopicId());
            partitions = topicMetadata.getPartitionsCount();
            replicas = topicMetadata.getReplicationFactor();
            mirrorTopicMetadata = topicMetadata.getMirrorTopicMetadata();
        } else if (!context.cacheInitialized() && context.topicInfo(this.topic) != null) {
            TopicInfo topicInfo = context.removeTopicFromInitialSnapshot(this.topic);
            id = topicInfo.topicId();
            partitions = topicInfo.partitions();
            replicas = topicInfo.replicationFactors();
            if (topicInfo.mirrorTopicInfo().isPresent()) {
                mirrorTopicInfo = topicInfo.mirrorTopicInfo();
            }
            allOverriddenConfigKeys.addAll(this.newConfig.overriddenConfigs);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignore {} because topic id is not available in local cache or initial snapshot", (Object)this);
            }
            return;
        }
        if (mirrorTopicInfo.isPresent()) {
            MirrorTopicInfo mirrorInfo = (MirrorTopicInfo)mirrorTopicInfo.get();
            mirrorTopicMetadata = MetadataEventUtils.mirrorTopicMetadata(mirrorInfo.linkId(), mirrorInfo.linkName(), mirrorInfo.sourceTopicId(), mirrorInfo.sourceTopicName(), mirrorInfo.mirrorTopicState(), mirrorInfo.remoteClusterId(), null);
        }
        MetadataEvent newMetadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(this.newConfig, TenantHelpers.extractLogicalName(this.topic), id, partitions, replicas, mirrorTopicMetadata, eventTimestamp, null);
        Set<String> topicConfigOverrides = this.filterCatalogConfigOverride(allOverriddenConfigKeys);
        HashSet<String> topicConfigReset = metadataEvent == null ? new HashSet<String>() : MetadataEventUtils.topicLogConfigDiff(metadataEvent.getTopicMetadata(), newMetadataEvent.getTopicMetadata());
        topicConfigReset.removeAll(topicConfigOverrides);
        if (!topicConfigOverrides.isEmpty() || !topicConfigReset.isEmpty()) {
            context.localStore().addTopicMetadataEvent(this.logicalClusterId, this.topic, newMetadataEvent, topicConfigOverrides, topicConfigReset);
            MetadataChange topicMetadataChange = MetadataEventUtils.entityUpdateEvent(this.logicalClusterId, newMetadataEvent);
            this.emitTopicDeltaEvent(context, topicMetadataChange);
        }
    }

    public String toString() {
        return "TopicConfigChangeEvent(topic=" + this.topic + ", retentionMs=" + this.newConfig.getLong("retention.ms") + ", retentionBytes=" + this.newConfig.getLong("retention.bytes") + ", keySchemaValidation=" + this.newConfig.getBoolean("confluent.key.schema.validation") + ", valueSchemaValidation=" + this.newConfig.getBoolean("confluent.value.schema.validation") + ", cleanupPolicy=" + this.newConfig.getList("cleanup.policy") + ')';
    }

    @Override
    public void handleException(Throwable e) {
        if (e instanceof CollectorContextNotInitializedException) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignore {} because it's a non-active collector", (Object)this);
            }
        } else {
            LOG.error("Unexpected error handling {}", (Object)this, (Object)e);
            this.recordEventHandleError();
        }
    }
}

