/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.exceptions.CollectorContextNotInitializedException;
import kafka.catalog.metadata.MirrorTopicInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;

public class TopicCreationEvent
extends MetadataCollectorEvent {
    private final Map<String, TopicInfo> newTopicWithInfo;

    public TopicCreationEvent(ZKMetadataCollector collector, Map<String, TopicInfo> newTopicWithInfo, Time time) {
        super(collector, time);
        this.newTopicWithInfo = newTopicWithInfo;
    }

    public void run() throws CollectorContextNotInitializedException {
        ZKMetadataCollectorContext context = this.context();
        LOG.debug("Creating topics {}", this.newTopicWithInfo.keySet());
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        for (String topic : this.newTopicWithInfo.keySet()) {
            TopicInfo topicInfo = this.newTopicWithInfo.get(topic);
            String logicalClusterId = topicInfo.logicalClusterId();
            try {
                LogConfig logConfigsMap = this.getLogConfigsForTopic(context, topic);
                MirrorTopicMetadata mirrorTopicMetadata = null;
                if (topicInfo.mirrorTopicInfo().isPresent()) {
                    MirrorTopicInfo mirrorTopicInfo = topicInfo.mirrorTopicInfo().get();
                    mirrorTopicMetadata = MetadataEventUtils.mirrorTopicMetadata(mirrorTopicInfo.linkId(), mirrorTopicInfo.linkName(), mirrorTopicInfo.sourceTopicId(), mirrorTopicInfo.sourceTopicName(), mirrorTopicInfo.mirrorTopicState(), mirrorTopicInfo.remoteClusterId(), eventTimestamp);
                }
                MetadataEvent topicMetadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfigsMap, TenantHelpers.extractLogicalName(topic), topicInfo.topicId(), topicInfo.partitions(), topicInfo.replicationFactors(), mirrorTopicMetadata, null, eventTimestamp);
                Set<String> topicConfigOverrides = this.filterCatalogConfigOverride(logConfigsMap.overriddenConfigs);
                context.localStore().addTopicMetadataEvent(logicalClusterId, topic, topicMetadataEvent, topicConfigOverrides, Collections.emptySet());
                MetadataChange topicMetadataChange = MetadataEventUtils.entityCreateEvent(logicalClusterId, topicMetadataEvent);
                this.emitTopicDeltaEvent(context, topicMetadataChange);
                context.removeTopicFromInitialSnapshot(topic);
            }
            catch (Exception e) {
                LOG.error("Skipping topic '{}' due to", (Object)topic, (Object)e);
                context.catalogMetrics().collectorEventHandleErrorSensor.record();
            }
        }
    }

    public String toString() {
        return "TopicCreationEvent(newTopics=" + this.newTopicWithInfo.keySet() + ')';
    }
}

