/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.metadata;

import java.util.Objects;
import java.util.Optional;
import kafka.catalog.metadata.MirrorTopicInfo;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Uuid;

public class TopicInfo {
    private final String logicalClusterId;
    private final Uuid topicId;
    private final int partitions;
    private final int replicationFactors;
    private final Optional<MirrorTopicInfo> mirrorTopicInfo;

    public TopicInfo(String topic, Uuid topicId, int partitions, int replicationFactors) {
        this(topic, topicId, partitions, replicationFactors, Optional.empty());
    }

    public TopicInfo(String topic, Uuid topicId, int partitions, int replicationFactors, Optional<MirrorTopicInfo> mirrorTopicInfo) {
        String tenantPrefix = TenantHelpers.extractTenantPrefix(topic, false);
        this.logicalClusterId = tenantPrefix == null ? "" : tenantPrefix;
        this.topicId = topicId;
        this.partitions = partitions;
        this.replicationFactors = replicationFactors;
        this.mirrorTopicInfo = mirrorTopicInfo;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public int partitions() {
        return this.partitions;
    }

    public int replicationFactors() {
        return this.replicationFactors;
    }

    public Optional<MirrorTopicInfo> mirrorTopicInfo() {
        return this.mirrorTopicInfo;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public String toString() {
        String mirrorTopicInfoString = this.mirrorTopicInfo.map(topicInfo -> ", mirrorTopicInfo=" + topicInfo).orElse("");
        return "TopicInfo(topicId=" + this.topicId + ", logicalClusterId=" + this.logicalClusterId + ", partitions=" + this.partitions + ", replicationFactors=" + this.replicationFactors + mirrorTopicInfoString + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicInfo)) {
            return false;
        }
        TopicInfo that = (TopicInfo)o;
        return Objects.equals(this.topicId, that.topicId) && Objects.equals(this.logicalClusterId, that.logicalClusterId) && this.partitions == that.partitions() && this.replicationFactors == that.replicationFactors() && Objects.equals(this.mirrorTopicInfo, that.mirrorTopicInfo());
    }

    public int hashCode() {
        return Objects.hash(this.topicId, this.logicalClusterId, this.partitions, this.replicationFactors, this.mirrorTopicInfo);
    }
}

