/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.ElectionResult;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.LeaderPriorityChangeElectionStrategy$;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\r\u001a\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b)\u0003A\u0011A&\t\u000fM\u0003!\u0019!C\u0005)\"11\f\u0001Q\u0001\nUCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004b\u0001\u0001\u0006IA\u0018\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u00199\u0007\u0001)A\u0005I\")\u0001\u000e\u0001C!S\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\ty\u0005\u0001C\u0005\u0003#Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAM\u0001\u0011%\u0011q\u0019\u0002\u00185.\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016T!AG\u000e\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u001d\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\nS\"A\r\n\u0005\tJ\"!\u0006)beRLG/[8o'R\fG/Z'bG\"Lg.Z\u0001\u0007G>tg-[4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dZ\u0012AB:feZ,'/\u0003\u0002*M\tY1*\u00194lC\u000e{gNZ5h\u0003\u001diW\r\u001e:jGN\u0004\"\u0001L\u001b\u000e\u00035R!A\u000b\u0018\u000b\u0005=\u0002\u0014AB2p[6|gN\u0003\u0002\u001dc)\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0013\t1TFA\u0004NKR\u0014\u0018nY:\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\u0005\u0002!s%\u0011!(\u0007\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011\u0001%P\u0005\u0003}e\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0003!Q8n\u00117jK:$\bCA!E\u001b\u0005\u0011%BA\"\u001c\u0003\tQ8.\u0003\u0002F\u0005\ni1*\u00194lCj[7\t\\5f]R\fAdY8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0005\u0002!\u0011&\u0011\u0011*\u0007\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0003\u0019a\u0014N\\5u}Q9A*\u0014(P!F\u0013\u0006C\u0001\u0011\u0001\u0011\u0015\u0019s\u00011\u0001%\u0011\u0015Qs\u00011\u0001,\u0011\u00159t\u00011\u00019\u0011\u0015Yt\u00011\u0001=\u0011\u0015yt\u00011\u0001A\u0011\u00151u\u00011\u0001H\u0003eI7\u000fT3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018pU;qa>\u0014H/\u001a3\u0016\u0003U\u0003\"AV-\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u0013qAQ8pY\u0016\fg.\u0001\u000ejg2+\u0017\rZ3s%\u0016\u001cwN^3ssN+\b\u000f]8si\u0016$\u0007%\u0001\u0007d_:$(o\u001c7mKJLE-F\u0001_!\t1v,\u0003\u0002a/\n\u0019\u0011J\u001c;\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0003QaW-\u00193fe\u0016cWm\u0019;j_:\u001cVM\\:peV\tA\r\u0005\u0002-K&\u0011a-\f\u0002\u0007'\u0016t7o\u001c:\u0002+1,\u0017\rZ3s\u000b2,7\r^5p]N+gn]8sA\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u001dQ\u00171CA\u000f\u0003O\u0001Ba\u001b8qi6\tAN\u0003\u0002n/\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=d'aA'baB\u0011\u0011O]\u0007\u0002]%\u00111O\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0019)X0!\u0001\u0002\b9\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003sv\ta\u0001\u0010:p_Rt\u0014\"\u0001-\n\u0005q<\u0016a\u00029bG.\fw-Z\u0005\u0003}~\u0014a!R5uQ\u0016\u0014(B\u0001?X!\r)\u00181A\u0005\u0004\u0003\u000by(!\u0003+ie><\u0018M\u00197f!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u00077\u0005\u0019\u0011\r]5\n\t\u0005E\u00111\u0002\u0002\r\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\u0005\b\u0003+q\u0001\u0019AA\f\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0005W\u0006e\u0001/C\u0002\u0002\u001c1\u00141aU3r\u0011\u001d\tyB\u0004a\u0001\u0003C\t1\u0002^1sO\u0016$8\u000b^1uKB\u0019\u0001%a\t\n\u0007\u0005\u0015\u0012D\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\u0005%b\u00021\u0001\u0002,\u0005\u0011\u0003/\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\*ue\u0006$XmZ=PaR\u0004RAVA\u0017\u0003cI1!a\fX\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001%a\r\n\u0007\u0005U\u0012DA\u0010QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]N#(/\u0019;fOf\fa\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0002\"\u0005m\u0002BBA\u001f\u001f\u0001\u0007\u0001/A\u0005qCJ$\u0018\u000e^5p]\u0006!Bm\u001c%b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$rA[A\"\u0003\u000b\n9\u0005C\u0004\u0002\u0016A\u0001\r!a\u0006\t\u000f\u0005}\u0001\u00031\u0001\u0002\"!9\u0011\u0011\u0006\tA\u0002\u0005-\u0012aI5oSRL\u0017\r\\5{K2+\u0017\rZ3s\u0003:$\u0017j\u001d:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003/\ti\u0005C\u0004\u0002\u0016E\u0001\r!a\u0006\u00021\u0015dWm\u0019;MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0003k\u0003'\n)\u0006C\u0004\u0002\u0016I\u0001\r!a\u0006\t\u000f\u0005]#\u00031\u0001\u00022\u0005y\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\*ue\u0006$XmZ=\u00025\u0011|W\t\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\r\u0005u\u0013QNA8!\u001d1\u0016qLA2\u0003/I1!!\u0019X\u0005\u0019!V\u000f\u001d7feA)1N\u001c9\u0002fA1Q/`A4\u0003\u000f\u00012!^A5\u0013\r\tYg \u0002\n\u000bb\u001cW\r\u001d;j_:Dq!!\u0006\u0014\u0001\u0004\t9\u0002C\u0004\u0002XM\u0001\r!!\r\u0002C\r|G\u000e\\3diVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]N#\u0018\r^3\u0015\r\u0005U\u0014qPAD!\u0015Y\u0017\u0011DA<!\u001d1\u0016\u0011\u00109\u0002~UK1!a\u001fX\u0005\u0019!V\u000f\u001d7fgA)a+!\f\u0002\b!9\u0011\u0011\u0011\u000bA\u0002\u0005\r\u0015!\u00047fC\u0012,'/\u00118e\u0013N\u00148\u000fE\u0003l\u00033\t)\t\u0005\u0004W\u0003?\u0002\u0018q\u0001\u0005\u0007\u0003\u0013#\u0002\u0019A+\u0002\u0019\u0005dGn\\<V]\u000edW-\u00198\u0002)1|w-\u00138wC2LG\r\u0016:b]NLG/[8o)\u0019\ty)!&\u0002\u0018B\u0019a+!%\n\u0007\u0005MuK\u0001\u0003V]&$\bBBA\u001f+\u0001\u0007\u0001\u000fC\u0004\u0002 U\u0001\r!!\t\u0002)1|wMR1jY\u0016$7\u000b^1uK\u000eC\u0017M\\4f))\ty)!(\u0002 \u0006\r\u0016Q\u0015\u0005\u0007\u0003{1\u0002\u0019\u00019\t\u000f\u0005\u0005f\u00031\u0001\u0002\"\u0005I1-\u001e:s'R\fG/\u001a\u0005\b\u0003?1\u0002\u0019AA\u0011\u0011\u001d\t9K\u0006a\u0001\u0003S\u000bAaY8eKB!\u00111VAa\u001d\u0011\ti+a/\u000f\t\u0005=\u0016q\u0017\b\u0005\u0003c\u000b)LD\u0002x\u0003gK\u0011\u0001N\u0005\u0003eMJ1!!/2\u0003%Qxn\\6fKB,'/\u0003\u0003\u0002>\u0006}\u0016aD&fKB,'/\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005e\u0016'\u0003\u0003\u0002D\u0006\u0015'\u0001B\"pI\u0016TA!!0\u0002@RQ\u0011qRAe\u0003\u0017\fi-a4\t\r\u0005ur\u00031\u0001q\u0011\u001d\t\tk\u0006a\u0001\u0003CAq!a\b\u0018\u0001\u0004\t\t\u0003C\u0004\u0002R^\u0001\r!!\u0001\u0002\u0003Q\u0004")
public class ZkPartitionStateMachine
extends PartitionStateMachine {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final boolean isLeaderRecoverySupported;
    private final int controllerId;
    private final Sensor leaderElectionSensor;

    private boolean isLeaderRecoverySupported() {
        return this.isLeaderRecoverySupported;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private Sensor leaderElectionSensor() {
        return this.leaderElectionSensor;
    }

    @Override
    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        if (partitions.nonEmpty()) {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Attempting to transition ").append(partitions.size()).append(" partitions to ").append(targetState).append(" ").append("with election strategy ").append(partitionLeaderElectionStrategyOpt).toString());
                this.controllerBrokerRequestBatch.newBatch();
                Map<TopicPartition, Either<Throwable, LeaderAndIsr>> result = this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                return result;
            }
            catch (ControllerMovedException e) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Failed to complete transition of ").append(partitions.size()).append(" to ").append(targetState).append(" since ").append("the controller has moved").toString());
                throw e;
            }
            catch (Throwable e) {
                partitions.foreach((Function1 & Serializable)partition -> {
                    this.logFailedStateChange(partition, this.partitionState(partition), targetState, e);
                    return BoxedUnit.UNIT;
                });
                return partitions.iterator().map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)package$.MODULE$.Left().apply((Object)e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
        }
        return (Map)scala.collection.Map$.MODULE$.empty();
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext.partitionState(partition);
    }

    /*
     * WARNING - void declaration
     */
    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        void var6_6;
        void var7_7;
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        partitions.foreach((Function1 & Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<TopicPartition>, Seq<TopicPartition>> tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        var7_7.foreach((Function1 & Serializable)partition -> {
            this.logInvalidTransition(partition, targetState);
            return BoxedUnit.UNIT;
        });
        if (NewPartition$.MODULE$.equals(targetState)) {
            var6_6.foreach((Function1 & Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$3(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        if (OnlinePartition$.MODULE$.equals(targetState)) {
            Buffer uninitializedPartitions = (Buffer)Buffer$.MODULE$.empty();
            Buffer partitionsToElectLeader = (Buffer)Buffer$.MODULE$.empty();
            var6_6.foreach((Function1 & Serializable)partition -> {
                PartitionState partitionState = this.partitionState((TopicPartition)partition);
                if (OfflinePartition$.MODULE$.equals(partitionState) ? true : OnlinePartition$.MODULE$.equals(partitionState)) {
                    return partitionsToElectLeader.$plus$eq(partition);
                }
                if (NewPartition$.MODULE$.equals(partitionState)) {
                    return uninitializedPartitions.$plus$eq(partition);
                }
                return BoxedUnit.UNIT;
            });
            if (uninitializedPartitions.nonEmpty()) {
                this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions).foreach((Function1 & Serializable)partition -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$6(this, stateChangeLog, targetState, partition);
                    return BoxedUnit.UNIT;
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electionResults = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalArgumentException("Election strategy is a required field when the target state is OnlinePartition");
                }));
                electionResults.foreach((Function1 & Serializable)x0$1 -> {
                    ZkPartitionStateMachine.$anonfun$doHandleStateChanges$9(this, stateChangeLog, targetState, x0$1);
                    return BoxedUnit.UNIT;
                });
                return electionResults;
            }
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        if (OfflinePartition$.MODULE$.equals(targetState) ? true : NonExistentPartition$.MODULE$.equals(targetState)) {
            var6_6.foreach((Function1 & Serializable)partition -> {
                ZkPartitionStateMachine.$anonfun$doHandleStateChanges$11(this, stateChangeLog, targetState, partition);
                return BoxedUnit.UNIT;
            });
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        throw new MatchError((Object)targetState);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        Seq seq;
        void var5_5;
        void var4_4;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Tuple2 tuple2 = ((Seq)((Seq)partitions.map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), $this.controllerContext.partitionReplicaAssignment((TopicPartition)partition)))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition partition = (TopicPartition)x0$1._1();
                Seq liveReplicasForPartition = (Seq)((Seq)x0$1._2()).filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
            }
            throw new MatchError(null);
        })).partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$4(x0$2)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple2._2();
        var4_4.foreach((Function1 & Serializable)x0$3 -> {
            ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$5(this, x0$3);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((IterableOnceOps)var5_5.map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                TopicPartition partition = (TopicPartition)x0$4._1();
                Seq liveReplicas = (Seq)x0$4._2();
                int leader = BoxesRunTime.unboxToInt((Object)liveReplicas.find((Function1)(JFunction1.mcZI.sp & Serializable)id -> !$this.controllerContext.degradedBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)liveReplicas.head())));
                LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leader, (List<Object>)liveReplicas.toList());
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.controllerContext.epochZkVersion());
        }
        catch (ControllerMovedException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Controller moved to another broker when trying to create the topic partition state znode", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw e;
        }
        catch (Exception e) {
            var5_5.foreach((Function1 & Serializable)x0$5 -> {
                ZkPartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$11(this, e, x0$5);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        seq.foreach((Function1 & Serializable)createResponse -> {
            KeeperException.Code code = createResponse.resultCode();
            TopicPartition partition = (TopicPartition)createResponse.ctx().get();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)partition);
            KeeperException.Code code2 = code;
            KeeperException.Code code3 = KeeperException.Code.OK;
            if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                $this.controllerContext.putPartitionLeadershipInfo(partition, leaderIsrAndControllerEpoch);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), true);
                return successfulInitializations.$plus$eq((Object)partition);
            }
            this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
            return BoxedUnit.UNIT;
        });
        return successfulInitializations;
    }

    /*
     * WARNING - void declaration
     */
    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        long startMs = System.currentTimeMillis();
        Seq<TopicPartition> remaining = partitions;
        scala.collection.mutable.Map finishedElections = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        while (remaining.nonEmpty()) {
            void var8_7;
            void var9_8;
            Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> tuple2 = this.doElectLeaderForPartitions(remaining, partitionLeaderElectionStrategy);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map finished = (Map)tuple2._1();
            Seq updatesToRetry = (Seq)tuple2._2();
            remaining = var9_8;
            finishedElections.$plus$plus$eq((IterableOnce)var8_7);
            if (!remaining.nonEmpty() || !this.logger().underlying().isInfoEnabled()) continue;
            this.logger().underlying().info("Retrying leader election with strategy {} for {} partitions", new Object[]{partitionLeaderElectionStrategy, BoxesRunTime.boxToInteger((int)remaining.size())});
        }
        long endMs = System.currentTimeMillis();
        this.leaderElectionSensor().record((double)(endMs - startMs), endMs, false);
        return finishedElections.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        void var16_16;
        void var15_15;
        void var11_11;
        void var10_10;
        Tuple2 tuple2;
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple2((Object)partitions.iterator().map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)package$.MODULE$.Left().apply((Object)e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        Seq<GetDataResponse> getDataResponses = seq;
        scala.collection.mutable.Map failedElections = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer validLeaderAndIsrs = (Buffer)Buffer$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            PartitionState currState = this.partitionState(partition);
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                Option<LeaderIsrAndControllerEpoch> option = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (option instanceof Some) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                    if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                        String failMsg = new StringBuilder(234).append("Aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append("already written by another controller. This probably means that the current controller ").append(this.controllerId()).append(" went through ").append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString();
                        return failedElections.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg)));
                    }
                    return validLeaderAndIsrs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch.leaderAndIsr()));
                }
                if (None$.MODULE$.equals(option)) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                    return failedElections.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)exception));
                }
                throw new MatchError(option);
            }
            KeeperException.Code code3 = getDataResponse.resultCode();
            KeeperException.Code code4 = KeeperException.Code.NONODE;
            if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(63).append("LeaderAndIsr information doesn't exist for partition ").append(partition).append(" in ").append(currState).append(" state").toString());
                return failedElections.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)exception));
            }
            return failedElections.put((Object)partition, (Object)package$.MODULE$.Left().apply(getDataResponse.resultException().get()));
        });
        if (validLeaderAndIsrs.isEmpty()) {
            return new Tuple2((Object)failedElections.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        if (partitionLeaderElectionStrategy instanceof OfflinePartitionLeaderElectionStrategy) {
            boolean allowUnclean = ((OfflinePartitionLeaderElectionStrategy)partitionLeaderElectionStrategy).allowUnclean();
            Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> partitionsWithUncleanLeaderElectionState = this.collectUncleanLeaderElectionState((Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs, allowUnclean);
            tuple2 = Election$.MODULE$.leaderForOffline(this.controllerContext, this.isLeaderRecoverySupported(), partitionsWithUncleanLeaderElectionState).partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$3(x$6)));
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForReassign(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$4(x$7)));
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$5(x$8)));
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$6(x$9)));
        } else if (LeaderPriorityChangeElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy)) {
            tuple2 = Election$.MODULE$.leaderForPriorityChange(this.controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$7(x$10)));
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq partitionsWithoutLeaders = (Seq)tuple22._1();
        Seq partitionsWithLeaders = (Seq)tuple22._2();
        var10_10.foreach((Function1 & Serializable)electionResult -> {
            TopicPartition partition = electionResult.topicPartition();
            String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(partitionLeaderElectionStrategy).toString();
            return failedElections.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg)));
        });
        scala.collection.immutable.Map recipientsPerPartition = ((IterableOnceOps)var11_11.map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.liveReplicas()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map adjustedLeaderAndIsrs = ((IterableOnceOps)var11_11.map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.leaderAndIsr().get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError(null);
        }
        Map<TopicPartition, Either<Exception, LeaderAndIsr>> finishedUpdates = updateLeaderAndIsrResult.finishedPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partition, result) -> {
            result.foreach((Function1 & Serializable)leaderAndIsr -> {
                ZkPartitionStateMachine.$anonfun$doElectLeaderForPartitions$12($this, partition, recipientsPerPartition$1, leaderAndIsr);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        var15_15.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var17_17 = null;
        if (this.isDebugEnabled()) {
            var16_16.foreach((Function1 & Serializable)partition -> {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Controller failed to elect leader for partition ").append(partition).append(". ").append("Attempted to write state ").append(adjustedLeaderAndIsrs$1.apply((Object)partition)).append(", but failed with bad ZK version. This will be retried.").toString());
                return BoxedUnit.UNIT;
            });
        }
        return new Tuple2((Object)var15_15.$plus$plus((IterableOnce)failedElections), (Object)var16_16);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> collectUncleanLeaderElectionState(Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs, boolean allowUnclean) {
        void var5_5;
        Seq seq;
        void var4_4;
        Tuple2 tuple2 = leaderAndIsrs.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkPartitionStateMachine.$anonfun$collectUncleanLeaderElectionState$1(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
        if (allowUnclean) {
            seq = (Seq)var4_4.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition partition = (TopicPartition)x0$2._1();
                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$2._2();
                    return new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                throw new MatchError(null);
            });
        } else {
            void var7_7;
            void var8_8;
            Tuple2<Map<String, Properties>, Map<String, Exception>> tuple22 = this.zkClient.getTopicConfigOverrides((Set<String>)var4_4.iterator().map((Function1 & Serializable)x0$3 -> {
                if (x0$3 != null) {
                    return ((TopicPartition)x0$3._1()).topic();
                }
                throw new MatchError(null);
            }).toSet());
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Map configOverrides = (Map)tuple22._1();
            Map failed = (Map)tuple22._2();
            seq = (Seq)var4_4.map(arg_0 -> ZkPartitionStateMachine.$anonfun$collectUncleanLeaderElectionState$5(this, (Map)var8_8, (Map)var7_7, arg_0));
        }
        return (Seq)seq.$plus$plus((IterableOnce)var5_5.map((Function1 & Serializable)x0$5 -> {
            if (x0$5 != null) {
                TopicPartition partition = (TopicPartition)x0$5._1();
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$5._2();
                return new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            throw new MatchError(null);
        }));
    }

    private void logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = this.partitionState(partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder(87).append("Partition ").append(partition).append(" should be in one of ").append(targetState.validPreviousStates().mkString(",")).append(" states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString());
        this.logFailedStateChange(partition, currState, targetState, e);
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.logFailedStateChange(partition, currState, targetState, KeeperException.create((KeeperException.Code)code));
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" failed to change state for partition ").append(partition).append(" ").append("from ").append(currState).append(" to ").append(targetState).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with ").append("assigned replicas ").append($this.controllerContext.partitionReplicaAssignment(partition).mkString(",")).toString());
        $this.controllerContext.putPartitionState(partition, NewPartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$6(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").append(((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo(partition).get()).leaderAndIsr()).toString());
        $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Right) {
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)either).value();
                stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).append(" with state ").append(leaderAndIsr).toString());
                $this.controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
                return;
            }
        }
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Left) {
                Throwable e = (Throwable)((Left)either).value();
                $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, e);
                return;
            }
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$11(ZkPartitionStateMachine $this, StateChangeLogger stateChangeLog$1, PartitionState targetState$2, TopicPartition partition) {
        stateChangeLog$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Changed partition ").append(partition).append(" from ").append($this.partitionState(partition)).append(" to ").append(targetState$2).toString());
        $this.controllerContext.putPartitionState(partition, targetState$2);
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((Seq)x0$2._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$5(ZkPartitionStateMachine $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition partition = (TopicPartition)x0$3._1();
            String failMsg = new StringBuilder(167).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" encountered error during state change of ").append("partition ").append(partition).append(" from New to Online, assigned replicas are ").append("[").append($this.controllerContext.partitionReplicaAssignment(partition).mkString(",")).append("], live brokers are [").append($this.controllerContext.liveBrokerIds()).append("]. No assigned ").append("replica is alive.").toString();
            $this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$11(ZkPartitionStateMachine $this, Exception e$3, Tuple2 x0$5) {
        if (x0$5 != null) {
            TopicPartition partition = (TopicPartition)x0$5._1();
            $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)NewPartition$.MODULE$, e$3);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$3(ElectionResult x$6) {
        return x$6.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$4(ElectionResult x$7) {
        return x$7.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$5(ElectionResult x$8) {
        return x$8.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$6(ElectionResult x$9) {
        return x$9.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$7(ElectionResult x$10) {
        return x$10.leaderAndIsr().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$12(ZkPartitionStateMachine $this, TopicPartition partition$6, scala.collection.immutable.Map recipientsPerPartition$1, LeaderAndIsr leaderAndIsr) {
        ReplicaAssignment replicaAssignment = $this.controllerContext.partitionFullReplicaAssignment(partition$6);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.putPartitionLeadershipInfo(partition$6, leaderIsrAndControllerEpoch);
        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)recipientsPerPartition$1.apply((Object)partition$6)), partition$6, leaderIsrAndControllerEpoch, replicaAssignment, false);
    }

    public static final /* synthetic */ boolean $anonfun$collectUncleanLeaderElectionState$1(ZkPartitionStateMachine $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            return ((LeaderAndIsr)x0$1._2()).isr().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$13 -> $this.controllerContext.isReplicaOnline(x$13, partition)).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Tuple3 $anonfun$collectUncleanLeaderElectionState$5(ZkPartitionStateMachine $this, Map failed$1, Map configOverrides$1, Tuple2 x0$4) {
        if (x0$4 != null) {
            TopicPartition partition = (TopicPartition)x0$4._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$4._2();
            if (failed$1.contains((Object)partition.topic())) {
                $this.logFailedStateChange(partition, $this.partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)failed$1.apply((Object)partition.topic()));
                return new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Properties topicConfig = (Properties)configOverrides$1.apply((Object)partition.topic());
            boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)topicConfig.getProperty("unclean.leader.election.enable")).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$16)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.config.uncleanLeaderElectionEnable()));
            return new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeaderElectionEnabled));
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZkPartitionStateMachine(KafkaConfig config, Metrics metrics, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.isLeaderRecoverySupported = config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_4_IV1);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(38).append("[PartitionStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
        this.leaderElectionSensor = metrics.sensor("LeaderElectionTime");
        Sensor sensor = this.leaderElectionSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("leader-election-time-max", "controller-metrics", "The max time it took to perform leader election");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.leaderElectionSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("leader-election-time-avg", "controller-metrics", "The avg time it took to perform leader election");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }
}

