/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.coordinator.transaction.BaseKey;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.coordinator.transaction.UnknownKey;
import kafka.internals.generated.TransactionLogKey;
import kafka.internals.generated.TransactionLogValue;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Record;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;

public final class TransactionLog$ {
    public static final TransactionLog$ MODULE$ = new TransactionLog$();
    private static final int DefaultNumPartitions = 50;
    private static final int DefaultSegmentBytes = 0x6400000;
    private static final short DefaultReplicationFactor = (short)3;
    private static final int DefaultMinInSyncReplicas = 2;
    private static final int DefaultLoadBufferSize = 0x500000;
    private static final String DefaultPlacementConstraints = "";
    private static final CompressionType EnforcedCompressionType = CompressionType.NONE;
    private static final short EnforcedRequiredAcks = (short)-1;

    public int DefaultNumPartitions() {
        return DefaultNumPartitions;
    }

    public int DefaultSegmentBytes() {
        return DefaultSegmentBytes;
    }

    public short DefaultReplicationFactor() {
        return DefaultReplicationFactor;
    }

    public int DefaultMinInSyncReplicas() {
        return DefaultMinInSyncReplicas;
    }

    public int DefaultLoadBufferSize() {
        return DefaultLoadBufferSize;
    }

    public String DefaultPlacementConstraints() {
        return DefaultPlacementConstraints;
    }

    public CompressionType EnforcedCompressionType() {
        return EnforcedCompressionType;
    }

    public short EnforcedRequiredAcks() {
        return EnforcedRequiredAcks;
    }

    public byte[] keyToBytes(String transactionalId) {
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new TransactionLogKey().setTransactionalId(transactionalId));
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata) {
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (transactionState != null && transactionState.equals(empty$) && txnMetadata.topicPartitions().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(72).append("Transaction is not expected to have any partitions since its state is ").append(txnMetadata.txnState()).append(": ").append(txnMetadata).toString());
        }
        TransactionState transactionState2 = txnMetadata.txnState();
        Empty$ empty$2 = Empty$.MODULE$;
        List transactionPartitions = transactionState2 != null && transactionState2.equals(empty$2) ? null : CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)txnMetadata.topicPartitions().groupBy((Function1 & Serializable)x$1 -> x$1.topic()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)x0$1._2();
                return new TransactionLogValue.PartitionsSchema().setTopic(topic).setPartitionIds(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)partitions.map((Function1 & Serializable)tp -> tp.partition())).toList()).asJava());
            }
            throw new MatchError(null);
        })).toList()).asJava();
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new TransactionLogValue().setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStatus(txnMetadata.txnState().id()).setTransactionLastUpdateTimestampMs(txnMetadata.txnLastUpdateTimestamp()).setTransactionStartTimestampMs(txnMetadata.txnStartTimestamp()).setTransactionPartitions(transactionPartitions));
    }

    public BaseKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            TransactionLogKey value = new TransactionLogKey((Readable)new ByteBufferAccessor(buffer), version);
            return new TxnKey(version, value.transactionalId());
        }
        return new UnknownKey(version);
    }

    public Option<TransactionMetadata> readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 1) {
            TransactionLogValue value = new TransactionLogValue((Readable)new ByteBufferAccessor(buffer), version);
            TransactionMetadata transactionMetadata = new TransactionMetadata(transactionalId, value.producerId(), -1L, value.producerEpoch(), -1, value.transactionTimeoutMs(), TransactionState$.MODULE$.fromId(value.transactionStatus()), (scala.collection.mutable.Set<TopicPartition>)((scala.collection.mutable.Set)Set$.MODULE$.empty()), value.transactionStartTimestampMs(), value.transactionLastUpdateTimestampMs());
            if (!transactionMetadata.state().equals(Empty$.MODULE$)) {
                value.transactionPartitions().forEach(partitionsSchema -> transactionMetadata.addPartitions((Set<TopicPartition>)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionsSchema.partitionIds()).asScala().map((Function1 & Serializable)partitionId -> new TopicPartition(partitionsSchema.topic(), Predef$.MODULE$.Integer2int(partitionId)))).toSet()));
            }
            return new Some((Object)transactionMetadata);
        }
        throw new IllegalStateException(new StringBuilder(55).append("Unknown version ").append(version).append(" from the transaction log message value").toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        BaseKey baseKey = this.readTxnRecordKey(record.key());
        if (baseKey instanceof TxnKey) {
            String string;
            TxnKey txnKey = (TxnKey)baseKey;
            String keyString = new StringBuilder(38).append("transaction_metadata::transactionalId=").append(txnKey.transactionalId()).toString();
            Option<TransactionMetadata> option = this.readTxnRecordValue(txnKey.transactionalId(), record.value());
            if (None$.MODULE$.equals(option)) {
                string = "<DELETE>";
            } else if (option instanceof Some) {
                TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
                string = new StringBuilder(83).append("producerId:").append(txnMetadata.producerId()).append(",").append("producerEpoch:").append(txnMetadata.producerEpoch()).append(",").append("state=").append(txnMetadata.state()).append(",").append("partitions=").append(txnMetadata.topicPartitions().mkString("[", ",", "]")).append(",").append("txnLastUpdateTimestamp=").append(txnMetadata.txnLastUpdateTimestamp()).append(",").append("txnTimeoutMs=").append(txnMetadata.txnTimeoutMs()).toString();
            } else {
                throw new MatchError(option);
            }
            String valueString = string;
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }
        if (baseKey instanceof UnknownKey) {
            UnknownKey unknownKey = (UnknownKey)baseKey;
            return new Tuple2((Object)new Some((Object)new StringBuilder(17).append("unknown::version=").append(unknownKey.version()).toString()), (Object)None$.MODULE$);
        }
        throw new MatchError((Object)baseKey);
    }

    private TransactionLog$() {
    }
}

