/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.broker.StartOffsetChangeEvent$;
import kafka.durability.events.controller.AbstractControllerDurabilityEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.server.ReplicaManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEd\u0001B\u0012%\u0001-B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011)\u0019!C!q!Ia\b\u0001B\u0001B\u0003%\u0011h\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\t\u0001B\u0001B\u0003%\u0001\nC\u0003V\u0001\u0011\u0005a\u000b\u0003\u0005]\u0001\t\u0007I\u0011\t\u0013^\u0011\u0019!\u0007\u0001)A\u0005=\")Q\r\u0001C!M\")A\u000f\u0001C!k\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\t\u0003\u001f\u0002A\u0011\u0001\u0013\u0002R!Q\u0011Q\r\u0001\u0012\u0002\u0013\u0005A%a\u001a\t\u0015\u0005u\u0004!%A\u0005\u0002\u0011\ny\b\u0003\u0005\u0002\u0004\u0002!\t\u0001JAC\u0011)\tI\fAI\u0001\n\u0003!\u0013q\r\u0005\u000b\u0003w\u0003\u0011\u0013!C\u0001I\u0005}\u0004bBA_\u0001\u0011%\u0011q\u0018\u0005\n\u0003?\u0004\u0011\u0013!C\u0005\u0003CD\u0001\"!:\u0001\t\u0003!\u0013q\u001d\u0005\u000b\u0003k\u0004\u0011\u0013!C\u0001I\u0005\u001d\u0004BCA|\u0001E\u0005I\u0011\u0001\u0013\u0002\u0000!A\u0011\u0011 \u0001\u0005\u0002\u0011\nY\u0010\u0003\u0006\u0003\f\u0001\t\n\u0011\"\u0001%\u0003OB\u0001B!\u0004\u0001\t\u0003!#q\u0002\u0005\u000b\u0005?\u0001\u0011\u0013!C\u0001I\u0005\u001d\u0004\u0002\u0003B\u0011\u0001\u0011\u0005AEa\t\t\u0011\tE\u0002\u0001\"\u0001%\u0005gAqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003L\u0001!\tA!\u0014\t\u000f\tu\u0003\u0001\"\u0001\u0003`!9!Q\r\u0001\u0005\u0002\t\u001d\u0004\"\u0003B8\u0001E\u0005I\u0011AA4\u0005\u0005\u0012%o\\6fe\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u0015\t)c%A\bnCR,'/[1mSj\fG/[8o\u0015\t9\u0003&\u0001\u0006ekJ\f'-\u001b7jifT\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0006\u0005\u0002.]5\tA%\u0003\u00020I\t\u0019\u0013IY:ue\u0006\u001cG\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^:NCR,'/[1mSj,\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003eUj\u0011a\r\u0006\u0003i!\naa]3sm\u0016\u0014\u0018B\u0001\u001c4\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!\u0001\u001a2\u0016\u0003e\u0002\"A\u000f\u001f\u000e\u0003mR!a\u000e\u0014\n\u0005uZ$\u0001\u0004#ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013\u0015a\u00013cA%\u0011qGL\u0001\te\u0016\u0004xN\u001d;feB\u0011!)R\u0007\u0002\u0007*\u0011AIJ\u0001\u0006CV$\u0017\u000e^\u0005\u0003\r\u000e\u0013Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"!S*\u000e\u0003)S!a\u0013'\u0002\u000bU$\u0018\u000e\\:\u000b\u00055s\u0015AB2p[6|gN\u0003\u0002*\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!&J\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\bF\u0003X1fS6\f\u0005\u0002.\u0001!)\u0001G\u0002a\u0001c!)qG\u0002a\u0001s!)\u0001I\u0002a\u0001\u0003\")qI\u0002a\u0001\u0011\u0006Ia/\u00197jI\u0006$xN]\u000b\u0002=B\u0011qLY\u0007\u0002A*\u0011\u0011\rJ\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017BA2a\u0005=\u0011%o\\6feZ\u000bG.\u001b3bi>\u0014\u0018A\u0003<bY&$\u0017\r^8sA\u0005QAn\\4hKJt\u0015-\\3\u0016\u0003\u001d\u0004\"\u0001[9\u000f\u0005%|\u0007C\u00016n\u001b\u0005Y'B\u00017+\u0003\u0019a$o\\8u})\ta.A\u0003tG\u0006d\u0017-\u0003\u0002q[\u00061\u0001K]3eK\u001aL!A]:\u0003\rM#(/\u001b8h\u0015\t\u0001X.A\u0006nCR,'/[1mSj,GC\u0001<{!\t9\b0D\u0001n\u0013\tIXNA\u0004C_>dW-\u00198\t\u000bmT\u0001\u0019\u0001?\u0002\rI,7m\u001c:e!\u001di\u0018QAA\u0005\u0003\u0013i\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001C2p]N,X.\u001a:\u000b\u0007\u0005\ra*A\u0004dY&,g\u000e^:\n\u0007\u0005\u001daP\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u000b]\fY!a\u0004\n\u0007\u00055QNA\u0003BeJ\f\u0017\u0010E\u0002x\u0003#I1!a\u0005n\u0005\u0011\u0011\u0015\u0010^3\u000215\fG/\u001a:jC2L'0Z%oU\u0016\u001cG/\u001a3Ti\u0006$X\r\u0006\u0003\u0002\u001a\u0005}\u0001cA<\u0002\u001c%\u0019\u0011QD7\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003CY\u0001\u0019AA\u0012\u0003AIgN[3diN#\u0018\r^3Fm\u0016tG\u000f\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\r\t\u0014xn[3s\u0015\r\tiCJ\u0001\u0007KZ,g\u000e^:\n\t\u0005E\u0012q\u0005\u0002\u0011\u0013:TWm\u0019;Ti\u0006$X-\u0012<f]R\fA$\\1uKJL\u0017\r\\5{K>3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\u0005\u0002\u001a\u0005]\u0012\u0011IA&\u0011\u001d\tI\u0004\u0004a\u0001\u0003w\t\u0011c\u001c4gg\u0016$8\t[1oO\u0016,e/\u001a8u!\u0011\t)#!\u0010\n\t\u0005}\u0012q\u0005\u0002\u0012\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$\bbBA\"\u0019\u0001\u0007\u0011QI\u0001\u0006gR\fG/\u001a\t\u0004u\u0005\u001d\u0013bAA%w\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007BBA'\u0019\u0001\u0007q-\u0001\u0005nKR\fG-\u0019;b\u0003qi\u0017\r^3sS\u0006d\u0017N_3EK2,G/\u001a*fG>\u0014H-\u0012<f]R$\"\"!\u0007\u0002T\u0005u\u0013qLA1\u0011\u001d\t)&\u0004a\u0001\u0003/\n!\u0003Z3mKR,'+Z2pe\u0012\u001cXI^3oiB!\u0011QEA-\u0013\u0011\tY&a\n\u0003%\u0011+G.\u001a;f%\u0016\u001cwN\u001d3t\u000bZ,g\u000e\u001e\u0005\b\u0003\u0007j\u0001\u0019AA#\u0011!\ti%\u0004I\u0001\u0002\u00049\u0007\u0002CA2\u001bA\u0005\t\u0019\u0001<\u00027U\u0004H-\u0019;f\u001f:d\u0017pQ8n[&$8\u000b^1si>3gm]3u\u0003\u0019j\u0017\r^3sS\u0006d\u0017N_3EK2,G/\u001a*fG>\u0014H-\u0012<f]R$C-\u001a4bk2$HeM\u000b\u0003\u0003SR3aZA6W\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA<[\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AJ7bi\u0016\u0014\u0018.\u00197ju\u0016$U\r\\3uKJ+7m\u001c:e\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0011\u0016\u0004m\u0006-\u0014aH7bi\u0016\u0014\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\u000eC\u0017M\\4fgR\u0001\u0012\u0011DAD\u0003'\u000bi*a*\u00022\u0006M\u0016Q\u0017\u0005\b\u0003\u0013\u0003\u0002\u0019AAF\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!$\u0002\u00106\tA*C\u0002\u0002\u00122\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0016B\u0001\r!a&\u0002\u000b\u0015\u0004xn\u00195\u0011\u0007]\fI*C\u0002\u0002\u001c6\u00141!\u00138u\u0011\u001d\ty\n\u0005a\u0001\u0003C\u000b1\u0001[<n!\r9\u00181U\u0005\u0004\u0003Kk'\u0001\u0002'p]\u001eDq!!+\u0011\u0001\u0004\tY+A\u0002jgJ\u0004R\u0001[AW\u0003/K1!a,t\u0005\r\u0019V\r\u001e\u0005\b\u0003\u0007\u0002\u0002\u0019AA#\u0011!\ti\u0005\u0005I\u0001\u0002\u00049\u0007\u0002CA\\!A\u0005\t\u0019\u0001<\u0002-Q\u0014\u0018nZ4fe\u0016$')_#q_\u000eD7\t[1oO\u0016\f\u0011&\\1uKJL\u0017\r\\5{K\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0007\"\fgnZ3tI\u0011,g-Y;mi\u00122\u0014!K7bi\u0016\u0014\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$s'A\u0011nC.,w)\u001a8fe&\u001c7\u000b^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\b\u0002B\u0006\u001d\u0017\u0011[Aj\u0003/\fI.!8\u0011\t\u0005\u0015\u00121Y\u0005\u0005\u0003\u000b\f9C\u0001\fTi\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u001d\tIm\u0005a\u0001\u0003\u0017\f!!\u001b3\u0011\t\u00055\u0015QZ\u0005\u0004\u0003\u001fd%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\t)j\u0005a\u0001\u0003/Cq!!6\u0014\u0001\u0004\t\t+A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bbBAP'\u0001\u0007\u0011\u0011\u0015\u0005\b\u00037\u001c\u0002\u0019AAL\u0003\u0019qw\u000eZ3JI\"I\u0011\u0011V\n\u0011\u0002\u0003\u0007\u00111V\u0001,[\u0006\\WmR3oKJL7m\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u001d\u0016\u0005\u0003W\u000bY'\u0001\fnCR,'/[1mSj,7\u000b^1si>3gm]3u))\tI\"!;\u0002n\u0006=\u0018\u0011\u001f\u0005\b\u0003W,\u0002\u0019AAa\u0003Y\u0019H/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$\bbBA\"+\u0001\u0007\u0011Q\t\u0005\t\u0003\u001b*\u0002\u0013!a\u0001O\"A\u00111_\u000b\u0011\u0002\u0003\u0007a/A\u0006wC2LG-\u0019;f\u0011^k\u0015\u0001I7bi\u0016\u0014\u0018.\u00197ju\u0016\u001cF/\u0019:u\u001f\u001a47/\u001a;%I\u00164\u0017-\u001e7uIM\n\u0001%\\1uKJL\u0017\r\\5{KN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005YR.\u0019;fe&\fG.\u001b>f\u000bB|7\r[\"iC:<W-\u0012<f]R$\u0002\"!\u0007\u0002~\n\u001d!\u0011\u0002\u0005\b\u0003\u007fD\u0002\u0019\u0001B\u0001\u0003A)\u0007o\\2i\u0007\"\fgnZ3Fm\u0016tG\u000f\u0005\u0003\u0002&\t\r\u0011\u0002\u0002B\u0003\u0003O\u0011\u0001#\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\t\u000f\u0005\r\u0003\u00041\u0001\u0002F!A\u0011Q\n\r\u0011\u0002\u0003\u0007q-A\u0013nCR,'/[1mSj,W\t]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0005IR.\u0019;fe&\fG.\u001b>f\u0013N\u0013V\t\u001f9b]\u0012,e/\u001a8u)!\tIB!\u0005\u0003\u001c\tu\u0001b\u0002B\n5\u0001\u0007!QC\u0001\u000fSN\u0014X\t\u001f9b]\u0012,e/\u001a8u!\u0011\t)Ca\u0006\n\t\te\u0011q\u0005\u0002\u000f\u0013N\u0014X\t\u001f9b]\u0012,e/\u001a8u\u0011\u001d\t\u0019E\u0007a\u0001\u0003\u000bB\u0001\"!\u0014\u001b!\u0003\u0005\raZ\u0001$[\u0006$XM]5bY&TX-S*S\u000bb\u0004\u0018M\u001c3Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003}i\u0017\r^3sS\u0006d\u0017N_3SKR,g\u000e^5p]\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\u0007\u00033\u0011)Ca\f\t\u000f\t\u001dB\u00041\u0001\u0003*\u0005!\"/\u001a;f]RLwN\\\"iC:<W-\u0012<f]R\u0004B!!\n\u0003,%!!QFA\u0014\u0005Q\u0011V\r^3oi&|gn\u00115b]\u001e,WI^3oi\"9\u00111\t\u000fA\u0002\u0005\u0015\u0013AG7bi\u0016\u0014\u0018.\u00197ju\u0016$U\r\\3uKB\u000b'\u000f^5uS>tG\u0003BA\r\u0005kAqAa\u000e\u001e\u0001\u0004\u0011I$\u0001\u000beK2,G/\u001a)beRLG/[8o\u000bZ,g\u000e\u001e\t\u0005\u0003K\u0011Y$\u0003\u0003\u0003>\u0005\u001d\"\u0001\u0006#fY\u0016$X\rU1si&$\u0018n\u001c8Fm\u0016tG/\u0001\tnCR,'/[1mSj,7\u000b^1uKRA\u0011\u0011\u0004B\"\u0005\u000b\u00129\u0005C\u0004\u0002Dy\u0001\r!!\u0012\t\u000f\u0005Ue\u00041\u0001\u0002\u0018\"9!\u0011\n\u0010A\u0002\u0005-\u0017\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003I\u0019H/\u00197f)>\u0004\u0018nY%e\u000bZ,g\u000e^:\u0015\u000bY\u0014yEa\u0017\t\u000f\tEs\u00041\u0001\u0003T\u0005)QM^3oiB!!Q\u000bB,\u001b\t\tY#\u0003\u0003\u0003Z\u0005-\"aF!cgR\u0014\u0018m\u0019;EkJ\f'-\u001b7jif,e/\u001a8u\u0011\u001d\t\u0019e\ba\u0001\u0003\u000b\n\u0011d\u00195fG.l\u0015n]:j]\u001e$v\u000e]5d\t\u0016dW\r^5p]R1\u0011\u0011\u0004B1\u0005GBqA!\u0015!\u0001\u0004\u0011\u0019\u0006C\u0004\u0002D\u0001\u0002\r!!\u0012\u0002#!\fg\u000e\u001a7f'R\fG.Z#wK:$8\u000fF\u0004w\u0005S\u0012YG!\u001c\t\u000f\tE\u0013\u00051\u0001\u0003T!9\u00111I\u0011A\u0002\u0005\u0015\u0003\u0002CA'CA\u0005\t\u0019A4\u00027!\fg\u000e\u001a7f'R\fG.Z#wK:$8\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class BrokerDurabilityEventsMaterialize
extends AbstractDurabilityEventsMaterialize {
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final BrokerValidator validator;

    @Override
    public DurabilityDB db() {
        return super.db();
    }

    @Override
    public BrokerValidator validator() {
        return this.validator;
    }

    @Override
    public String loggerName() {
        return BrokerDurabilityEventsMaterialize.class.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        void deserialize_value;
        void deserialize_key;
        byte[] byArray = (byte[])((byte[])record.value()).clone();
        byte[] byArray2 = (byte[])((byte[])record.key()).clone();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var15_4 = null;
        byArray2 = null;
        byArray = null;
        AbstractDurabilityEvent event = DeserializerTrait.deserialize$(deserialize_this, (byte[])deserialize_key, (byte[])deserialize_value);
        String metadata = new StringBuilder(24).append("Durability audits topic ").append(Utils$.MODULE$.consumerRecordMetadata(record)).toString();
        if (event instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)event;
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).toString());
            if (healthCheckEvent.nodeId() == Utils$.MODULE$.getBrokerId(this.replicaManager)) {
                this.materializeHealthCheck(healthCheckEvent);
            }
            return true;
        }
        if (event instanceof InjectStateEvent) {
            InjectStateEvent injectStateEvent = (InjectStateEvent)event;
            this.materializeInjectedState(injectStateEvent);
            return true;
        }
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return false;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.epoch() == state.latestEpoch() && record.timestamp() < state.latestTimestamp()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Ignoring event ").append(event).append(" with epoch ").append(event.epoch()).append(" as it's from retry and duplicate.").append("Current epoch is ").append(state.latestEpoch()).append(" and state ts: record ts: ").append(record.timestamp()).toString());
            return false;
        }
        this.checkMissingTopicDeletion(event, state);
        if (event.epoch() < state.latestEpoch() || this.staleTopicIdEvents(event, state)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Ignoring event ").append(event).append(". Current state is ").append(state).toString());
            return this.handleStaleEvents(event, state, metadata);
        }
        state.latestTimestamp_$eq(record.timestamp());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(state).toString());
        if (event instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)event;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state, metadata);
        } else if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, false);
        } else if (event instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)event;
            this.materializeEpochChangeEvent(epochChangeEvent, state, metadata);
        } else if (event instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)event;
            this.materializeISRExpandEvent(isrExpandEvent, state, metadata);
        } else if (event instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)event;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (event instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)event;
            this.materializeStartOffset(startOffsetChangeEvent, state, metadata, true);
        } else {
            if (event instanceof DeletePartitionEvent) {
                DeletePartitionEvent deletePartitionEvent = (DeletePartitionEvent)event;
                this.materializeDeletePartition(deletePartitionEvent);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).append(" ").append(metadata).toString());
                return true;
            }
            if (event instanceof AbstractControllerDurabilityEvent) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Broker materialization rejected for ControllerDurabilityEvent ").append(event).toString());
                return false;
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("DurabilityMaterialization: Ignoring unexpected durability event type ").append(event.eventType()).append(": ").append(event).append(",").append(" ").append(metadata).toString());
            return false;
        }
        this.materializeState(state, event.epoch(), event.topicIdPartition());
        this.db().addPartition(event.topicIdPartition().topicPartition(), state);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
        return true;
    }

    private void materializeInjectedState(InjectStateEvent injectStateEvent) {
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(injectStateEvent.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (injectStateEvent.removePartition()) {
            this.db().deletePartition(injectStateEvent.topicIdPartition().topicPartition());
        } else {
            if (injectStateEvent.epoch() != -1) {
                state.latestEpoch_$eq(injectStateEvent.epoch());
            }
            if (injectStateEvent.highWatermark() != -1L) {
                state.highWatermark_$eq(injectStateEvent.highWatermark());
            }
            if (injectStateEvent.logStartOffset() != -1L) {
                state.committedStartOffset_$eq(injectStateEvent.logStartOffset());
                state.startOffset_$eq(injectStateEvent.logStartOffset());
            }
            if (injectStateEvent.config() != -1L) {
                state.config_$eq(injectStateEvent.config());
            }
            this.db().addPartition(injectStateEvent.topicIdPartition().topicPartition(), state);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Updated the durabilityDB due to injected Event ").append(injectStateEvent).append(" with new state ").append(state).toString());
    }

    private void materializeOffsetChangeEvent(OffsetChangeEvent offsetChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(offsetChangeEvent.topicIdPartition().topicPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.highWatermark(), offsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(offsetChangeEvent.topicIdPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.logStartOffset(), offsetChangeEvent.highWatermark(), offsetChangeEvent.nodeId(), offsetChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state, String metadata, boolean updateOnlyCommitStartOffset) {
        state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), deleteRecordsEvent.trimOffset()));
        state.lapseWatchStartTime_$eq(0L);
        if (updateOnlyCommitStartOffset) {
            return;
        }
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicIdPartition().topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicIdPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state, metadata, this.materializeStartOffset$default$4());
    }

    public String materializeDeleteRecordEvent$default$3() {
        return "";
    }

    public boolean materializeDeleteRecordEvent$default$4() {
        return false;
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata, boolean triggeredByEpochChange) {
        this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, metadata, triggeredByEpochChange);
        if (this.validator().isInSync(isr)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, state, metadata);
        }
        state.highWatermark_$eq(hwm);
    }

    public String materializeHighWatermarkChanges$default$6() {
        return "";
    }

    public boolean materializeHighWatermarkChanges$default$7() {
        return false;
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicIdPartition id, int epoch, long startOffset, long hwm, int nodeId, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr, nodeId);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$6() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent startOffsetChangeEvent, PartitionState state, String metadata, boolean validateHWM) {
        block12: {
            block11: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block10: {
                    if (state.startOffset() <= 0L) {
                        state.committedStartOffset_$eq(startOffsetChangeEvent.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    } else if (this.validator().isInSync(startOffsetChangeEvent.isr()) && state.committedStartOffset() < startOffsetChangeEvent.logStartOffset() && this.validator().validateDBLogStartOffset(startOffsetChangeEvent, state, metadata)) {
                        this.validator().validateLocalLogStartOffset(startOffsetChangeEvent.topicIdPartition(), startOffsetChangeEvent.logStartOffset(), metadata);
                        state.committedStartOffset_$eq(startOffsetChangeEvent.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (validateHWM) {
                        this.materializeHighWatermarkChanges(startOffsetChangeEvent.topicIdPartition().topicPartition(), startOffsetChangeEvent.epoch(), startOffsetChangeEvent.highWatermark(), startOffsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
                    }
                    state.startOffset_$eq(startOffsetChangeEvent.logStartOffset());
                    Enumeration.Value value3 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        state.retentionSz_$eq(startOffsetChangeEvent.retentionValue());
                        return;
                    }
                    value2 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    value = RetentionType$.MODULE$.TimeBasedRetention();
                    if (value2 != null) break block10;
                    if (value != null) {
                        return;
                    }
                    break block11;
                }
                if (!value2.equals(value)) break block12;
            }
            state.retentionMs_$eq(startOffsetChangeEvent.retentionValue());
            return;
        }
    }

    public String materializeStartOffset$default$3() {
        return "";
    }

    public boolean materializeStartOffset$default$4() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state, String metadata) {
        this.validator().validateDBEpochChange(epochChangeEvent, state, metadata);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicIdPartition().topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, metadata, true);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicIdPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.nodeId(), epochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent, metadata);
        state.epochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
    }

    public String materializeEpochChangeEvent$default$3() {
        return "";
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state, String metadata) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicIdPartition().topicPartition(), state, metadata);
    }

    public String materializeISRExpandEvent$default$3() {
        return "";
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), state.startOffset()));
            state.lapseWatchStartTime_$eq(0L);
            state.retentionSz_$eq(retentionChangeEvent.size());
            state.retentionMs_$eq(retentionChangeEvent.timeMs());
        }
        if (retentionChangeEvent.isCompacted()) {
            state.config_$eq(ConfigFlag$.MODULE$.OnceCompacted().id());
            return;
        }
    }

    public void materializeDeletePartition(DeletePartitionEvent deletePartitionEvent) {
        this.db().deletePartition(deletePartitionEvent.topicIdPartition().topicPartition());
    }

    private void materializeState(PartitionState state, int epoch, TopicIdPartition topicIdPartition) {
        if (epoch != -1) {
            state.latestEpoch_$eq(epoch);
        }
        state.topicId_$eq(topicIdPartition.topicId());
    }

    public boolean staleTopicIdEvents(AbstractDurabilityEvent event, PartitionState state) {
        Uuid uuid = state.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = event.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (!(uuid3 != null ? !uuid3.equals(uuid4) : uuid4 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void checkMissingTopicDeletion(AbstractDurabilityEvent event, PartitionState state) {
        v0 = state.topicId();
        var4_3 = Uuid.ZERO_UUID;
        if (!(v0 == null ? var4_3 != null : v0.equals(var4_3) == false)) ** GOTO lbl-1000
        v1 = event.topicIdPartition().topicId();
        var5_4 = Uuid.ZERO_UUID;
        if (!(v1 == null ? var5_4 != null : v1.equals(var5_4) == false)) ** GOTO lbl-1000
        v2 = event.topicIdPartition().topicId();
        var6_5 = state.topicId();
        if (v2 == null ? var6_5 != null : v2.equals(var6_5) == false) {
            reset = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = event instanceof EpochChangeEvent ? (var7_7 = (EpochChangeEvent)event).epoch() == 0 && var7_7.firstOffset() == 0L && var7_7.highWatermark() <= 0L : (reset = false);
        }
        if (reset) {
            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkMissingTopicDeletion$1(kafka.durability.events.AbstractDurabilityEvent kafka.durability.db.PartitionState ), ()Ljava/lang/String;)((AbstractDurabilityEvent)event, (PartitionState)state));
            state.reset();
            state.topicId_$eq(event.topicIdPartition().topicId());
            this.reporter.resetTopicPartition(event.topicIdPartition().topicPartition());
            return;
        }
    }

    public boolean handleStaleEvents(AbstractDurabilityEvent event, PartitionState state, String metadata) {
        if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, true);
            return true;
        }
        return false;
    }

    public String handleStaleEvents$default$3() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$checkMissingTopicDeletion$1(AbstractDurabilityEvent event$2, PartitionState state$3) {
        return new StringBuilder(44).append("Durability partition reset for ").append(event$2).append(" old topicID ").append(state$3.topicId()).toString();
    }

    public BrokerDurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        super(db, reporter, time);
        this.validator = new BrokerValidator(replicaManager, reporter, time);
    }
}

