/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization.validation;

import java.io.Serializable;
import kafka.durability.Utils;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.PartitionState;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.validation.AbstractValidator;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B\u0012%\u00015B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005C\bC\u0005D\u0001\t\u0005\t\u0015!\u0003>\t\"AQ\t\u0001B\u0001B\u0003%a\tC\u0003T\u0001\u0011\u0005A\u000b\u0003\u0005Z\u0001\t\u0007I\u0011\u0001\u0014[\u0011\u0019\t\u0007\u0001)A\u00057\"9!\r\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011\u0002.\t\r\u0015\u0004\u0001\u0015!\u0003\\\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015\u0019\b\u0001\"\u0001u\u0011%\tI\u0003AI\u0001\n\u0003\tY\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003\"CA+\u0001E\u0005I\u0011AA\u0016\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!a$\u0001\t\u0003\t\t\nC\u0005\u0002$\u0002\t\n\u0011\"\u0001\u0002,!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+Dq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002l\u0002!\t!!<\t\u000f\u0005U\b\u0001\"\u0003\u0002x\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001\u0002\u0003B\u0007\u0001\u0011\u0005aEa\u0004\b\u0013\tmA%!A\t\u0002\tua\u0001C\u0012%\u0003\u0003E\tAa\b\t\rM\u0003C\u0011\u0001B\u0014\u0011%\u0011I\u0003II\u0001\n\u0003\u0011YCA\bCe>\\WM\u001d,bY&$\u0017\r^8s\u0015\t)c%\u0001\u0006wC2LG-\u0019;j_:T!a\n\u0015\u0002\u001f5\fG/\u001a:jC2L'0\u0019;j_:T!!\u000b\u0016\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0002T\"\u0001\u0013\n\u0005E\"#!E!cgR\u0014\u0018m\u0019;WC2LG-\u0019;pe\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]R\u0013AB:feZ,'/\u0003\u0002:m\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0011I,\u0007o\u001c:uKJ,\u0012!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\"\nQ!Y;eSRL!AQ \u0003\u001b\u0005+H-\u001b;SKB|'\u000f^3s\u0003%\u0011X\r]8si\u0016\u0014\b%\u0003\u0002<a\u0005!A/[7f!\t9\u0015+D\u0001I\u0015\tI%*A\u0003vi&d7O\u0003\u0002L\u0019\u000611m\\7n_:T!aK'\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\u0005\u0003%\"\u0013A\u0001V5nK\u00061A(\u001b8jiz\"B!\u0016,X1B\u0011q\u0006\u0001\u0005\u0006e\u0019\u0001\r\u0001\u000e\u0005\u0006w\u0019\u0001\r!\u0010\u0005\b\u000b\u001a\u0001\n\u00111\u0001G\u0003q\u0011V\r^3oi&|g\u000eV5nK6\u000b'oZ5o\u001f\u001a,%O]8s\u001bN,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0004\u0013:$\u0018!\b*fi\u0016tG/[8o)&lW-T1sO&twJZ#se>\u0014Xj\u001d\u0011\u00025I+G/\u001a8uS>t7+\u001b>f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:\u00027I+G/\u001a8uS>t7+\u001b>f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:!\u0003mi\u0015\r_(gMN,GoR1q)>dWM]1oG\u0016$\u0016.\\3Ng\u0006aR*\u0019=PM\u001a\u001cX\r^$baR{G.\u001a:b]\u000e,G+[7f\u001bN\u0004\u0013A\u00037pO\u001e,'OT1nKV\t\u0001\u000e\u0005\u0002ja:\u0011!N\u001c\t\u0003Wvk\u0011\u0001\u001c\u0006\u0003[2\na\u0001\u0010:p_Rt\u0014BA8^\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=l\u0016a\u0006<bY&$\u0017\r^3E\u0005\"Kw\r[,bi\u0016\u0014X.\u0019:l)-)\bP`A\u0001\u0003\u0017\tY\"a\b\u0011\u0005q3\u0018BA<^\u0005\u0011)f.\u001b;\t\u000bet\u0001\u0019\u0001>\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u00111\u0010`\u0007\u0002\u0015&\u0011QP\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015yh\u00021\u0001\\\u0003\u0015)\u0007o\\2i\u0011\u001d\t\u0019A\u0004a\u0001\u0003\u000b\t1\u0001[<n!\ra\u0016qA\u0005\u0004\u0003\u0013i&\u0001\u0002'p]\u001eDq!!\u0004\u000f\u0001\u0004\ty!A\u0003ti\u0006$X\r\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002K\u0001\u0003I\nLA!!\u0007\u0002\u0014\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007\u0002CA\u000f\u001dA\u0005\t\u0019\u00015\u0002\u00115,G/\u00193bi\u0006D\u0011\"!\t\u000f!\u0003\u0005\r!a\t\u0002\u001b%\u001cX\t]8dQ\u000eC\u0017M\\4f!\ra\u0016QE\u0005\u0004\u0003Oi&a\u0002\"p_2,\u0017M\\\u0001\"m\u0006d\u0017\u000eZ1uK\u0012\u0013\u0005*[4i/\u0006$XM]7be.$C-\u001a4bk2$H%N\u000b\u0003\u0003[Q3\u0001[A\u0018W\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001e;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\t<bY&$\u0017\r^3E\u0005\"Kw\r[,bi\u0016\u0014X.\u0019:lI\u0011,g-Y;mi\u00122TCAA#U\u0011\t\u0019#a\f\u00023Y\fG.\u001b3bi\u0016dunY1m\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\fk\u0006-\u0013QJA(\u0003#\n\u0019\u0006C\u0003z#\u0001\u0007!\u0010C\u0003\u0000#\u0001\u00071\fC\u0004\u0002\u0004E\u0001\r!!\u0002\t\u000f\u00055\u0011\u00031\u0001\u0002\u0010!A\u0011QD\t\u0011\u0002\u0003\u0007\u0001.A\u0012wC2LG-\u0019;f\u0019>\u001c\u0017\r\u001c'pO\u0016sGm\u00144gg\u0016$H\u0005Z3gCVdG\u000fJ\u001b\u0002#\u001d,GOU3uK:$\u0018n\u001c8WC2,X\r\u0006\u0005\u0002\\\u0005\u0005\u00141MA3!\u0015a\u0016QLA\u0003\u0013\r\ty&\u0018\u0002\u0007\u001fB$\u0018n\u001c8\t\u000be\u001c\u0002\u0019\u0001>\t\u000f\u000551\u00031\u0001\u0002\u0010!9\u0011qM\nA\u0002\u0005%\u0014!\u0004:fi\u0016tG/[8o)f\u0004X\r\u0005\u0003\u0002l\u0005%e\u0002BA7\u0003\u0007sA!a\u001c\u0002~9!\u0011\u0011OA=\u001d\u0011\t\u0019(a\u001e\u000f\u0007-\f)(C\u0001,\u0013\tI#&C\u0002\u0002|!\na!\u001a<f]R\u001c\u0018\u0002BA@\u0003\u0003\u000baA\u0019:pW\u0016\u0014(bAA>Q%!\u0011QQAD\u00035\u0011V\r^3oi&|g\u000eV=qK*!\u0011qPAA\u0013\u0011\tY)!$\u0003\u001bI+G/\u001a8uS>tG+\u001f9f\u0015\u0011\t))a\"\u00021Y\fG.\u001b3bi\u0016$%\tT8h'R\f'\u000f^(gMN,G\u000f\u0006\u0005\u0002$\u0005M\u0015qTAQ\u0011\u001d\t)\n\u0006a\u0001\u0003/\u000bQ!\u001a<f]R\u0004B!!'\u0002\u001c6\u0011\u0011qQ\u0005\u0005\u0003;\u000b9I\u0001\fTi\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u001d\ti\u0001\u0006a\u0001\u0003\u001fA\u0001\"!\b\u0015!\u0003\u0005\r\u0001[\u0001#m\u0006d\u0017\u000eZ1uK\u0012\u0013Ej\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0005Z3gCVdG\u000fJ\u001a\u0002)ML'0\u001a'baN,7)\u00197dk2\fG/[8o))\t\u0019#!+\u0002,\u00065\u0016\u0011\u0017\u0005\b\u0003+3\u0002\u0019AAL\u0011\u001d\tiA\u0006a\u0001\u0003\u001fAq!a,\u0017\u0001\u0004\t)!\u0001\bsKR,g\u000e^5p]Z\u000bG.^3\t\r\u0005ua\u00031\u0001i\u0003Q!\u0018.\\3MCB\u001cXmQ1mGVd\u0017\r^5p]RQ\u00111EA\\\u0003s\u000bY,!0\t\u000f\u0005Uu\u00031\u0001\u0002\u0018\"9\u0011QB\fA\u0002\u0005=\u0001bBAX/\u0001\u0007\u0011Q\u0001\u0005\u0007\u0003;9\u0002\u0019\u00015\u00027Y\fG.\u001b3bi\u0016dunY1m\u0019><7\u000b^1si>3gm]3u)\u001d)\u00181YAg\u0003#Dq!!2\u0019\u0001\u0004\t9-\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B\u001910!3\n\u0007\u0005-'J\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011q\u001a\rA\u0002\u0005\u0015\u0011\u0001\u00047fC\u0012,'o\u00144gg\u0016$\bBBA\u000f1\u0001\u0007\u0001.A\u000bwC2LG-\u0019;f\t\n+\u0005o\\2i\u0007\"\fgnZ3\u0015\u000fU\f9.a8\u0002b\"9\u0011QS\rA\u0002\u0005e\u0007\u0003BAM\u00037LA!!8\u0002\b\n\u0001R\t]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003\u001bI\u0002\u0019AA\b\u0011\u0019\ti\"\u0007a\u0001Q\u0006ab/\u00197jI\u0006$X-\u00129pG\"\u001c\u0005.\u00198hK^KG\u000f\u001b'pG\u0006dG#B;\u0002h\u0006%\bbBAK5\u0001\u0007\u0011\u0011\u001c\u0005\u0007\u0003;Q\u0002\u0019\u00015\u00027Y\fG.\u001b3bi\u0016,\u0005o\\2i\u0007\"\f\u0017N\\,ji\"dunY1m)\u001d)\u0018q^Ay\u0003gDQ!_\u000eA\u0002iDq!!\u0004\u001c\u0001\u0004\ty\u0001\u0003\u0004\u0002\u001em\u0001\r\u0001[\u0001&o&$\b.\u001b8NCJ<\u0017N\\(g\u000bJ\u0014xN\u001d$peRKW.Z't%\u0016$XM\u001c;j_:$b!a\t\u0002z\u0006u\bbBA~9\u0001\u0007\u0011QA\u0001\u0007i&lW-T:\t\u000f\u0005}H\u00041\u0001\u0002\u0006\u0005Y!/\u001a;f]RLwN\\'t\u0003\r:\u0018\u000e\u001e5j]6\u000b'oZ5o\u001f\u001a,%O]8s\r>\u00148+\u001b>f%\u0016$XM\u001c;j_:$b!a\t\u0003\u0006\t%\u0001b\u0002B\u0004;\u0001\u0007\u0011QA\u0001\u0005g&TX\rC\u0004\u0003\fu\u0001\r!!\u0002\u0002\u001bI,G/\u001a8uS>t7+\u001b>f\u0003!I7/\u00138Ts:\u001cG\u0003BA\u0012\u0005#AqAa\u0005\u001f\u0001\u0004\u0011)\"A\u0002jgJ\u0004B!\u001bB\f7&\u0019!\u0011\u0004:\u0003\u0007M+G/A\bCe>\\WM\u001d,bY&$\u0017\r^8s!\ty\u0003eE\u0002!\u0005C\u00012\u0001\u0018B\u0012\u0013\r\u0011)#\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\tu\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003.)\u001aa)a\f")
public class BrokerValidator
extends AbstractValidator {
    private final ReplicaManager replicaManager;
    private final Time time;
    private final int RetentionTimeMarginOfErrorMs;
    private final int RetentionSizeMarginOfError;
    private final int MaxOffsetGapToleranceTimeMs;

    public static Time $lessinit$greater$default$3() {
        return Time.SYSTEM;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public AuditReporter reporter() {
        return super.reporter();
    }

    public int RetentionTimeMarginOfErrorMs() {
        return this.RetentionTimeMarginOfErrorMs;
    }

    private int RetentionSizeMarginOfError() {
        return this.RetentionSizeMarginOfError;
    }

    private int MaxOffsetGapToleranceTimeMs() {
        return this.MaxOffsetGapToleranceTimeMs;
    }

    @Override
    public String loggerName() {
        return BrokerValidator.class.getName();
    }

    public void validateDBHighWatermark(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, String metadata, boolean isEpochChange) {
        if (isEpochChange) {
            return;
        }
        if (hwm < state.highWatermark()) {
            String msg = new StringBuilder(175).append("durability lapse on validation with hwm stored in database, hwm decreased from a previous committed value.\n").append("new hwm: ").append(hwm).append(", db hwm: ").append(state.highWatermark()).append(", event epoch: ").append(epoch).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, state.highWatermark() - hwm, DurabilityLapseType$.MODULE$.HighWatermark(), msg, true, this.reporter().reportDurabilityLapse$default$7());
            return;
        }
    }

    public String validateDBHighWatermark$default$5() {
        return "";
    }

    public boolean validateDBHighWatermark$default$6() {
        return false;
    }

    public void validateLocalLogEndOffset(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, String metadata) {
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), topicPartition);
        if (option instanceof Some) {
            long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (localEndOffset < hwm) {
                String msg = new StringBuilder(200).append("durability lapse on validation with local log end offset, log end offset is found to be less than hwm.\n").append("local end offset: ").append(localEndOffset).append(", hwm: ").append(hwm).append(", event epoch: ").append(epoch).append(", local replica epoch: ").append(state.latestLocalEpoch()).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(topicPartition, localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7());
                return;
            }
            return;
        }
    }

    public String validateLocalLogEndOffset$default$5() {
        return "";
    }

    private Option<Object> getRetentionValue(TopicPartition topicPartition, PartitionState state, Enumeration.Value retentionType) {
        Enumeration.Value value = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value != null ? !value.equals(retentionType) : retentionType != null)) {
            if (state.retentionMs() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionMs()));
            }
            return Utils$.MODULE$.getLocalLogRetentionMs(this.replicaManager(), topicPartition);
        }
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value2 != null ? !value2.equals(retentionType) : retentionType != null)) {
            if (state.retentionSz() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionSz()));
            }
            return Utils$.MODULE$.getLocalLogRetentionSize(this.replicaManager(), topicPartition);
        }
        return None$.MODULE$;
    }

    public boolean validateDBLogStartOffset(StartOffsetChangeEvent event, PartitionState state, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Validating db log startOffset ").append(event).append(" ").append(state).toString());
        Enumeration.Value value = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return this.sizeLapseCalculation(event, state, event.retentionValue(), metadata);
        }
        Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value4 = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            return this.timeLapseCalculation(event, state, event.retentionValue(), metadata);
        }
        Enumeration.Value value5 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value6 = RetentionType$.MODULE$.Other();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            Option<Object> option = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.TimeBasedRetention());
            Option<Object> option2 = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.SizeBasedRetention());
            if (option2 instanceof Some) {
                long retentionSz = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                if (option instanceof Some) {
                    long retentionMs = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Validating for db log start offset lapse for ").append(event).append(" ").append(state).append(" with retentions (").append(retentionSz).append(", ").append(retentionMs).append(")").toString());
                    Option<Object> estimatedSize = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                    Option<Utils.MaxTimestampWithSize> prevSegInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                    if (estimatedSize instanceof Some) {
                        long estimatedSize2 = BoxesRunTime.unboxToLong((Object)((Some)estimatedSize).value());
                        if (prevSegInfo instanceof Some) {
                            Utils.MaxTimestampWithSize prevSegInfo2 = (Utils.MaxTimestampWithSize)((Some)prevSegInfo).value();
                            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize2, retentionSz) && !this.withinMarginOfErrorForTimeMsRetention(prevSegInfo2.maxTimestamp(), retentionMs)) {
                                String msg = new StringBuilder(397).append("durability lapse on validation with db log start offset, the start offset is more than expected retention window.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegInfo2.maxTimestamp()).append(", retentionMs: ").append(retentionMs).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize2).append(", retentionSz: ").append(retentionSz).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Lapse with ").append(estimatedSize2).append(" ").append(prevSegInfo2).append(" ").append(msg).toString());
                                if (state.retentionMs() == -1L && state.retentionSz() == -1L && (state.lapseWatchStartTime() == 0L || this.time.milliseconds() - state.lapseWatchStartTime() < (long)this.MaxOffsetGapToleranceTimeMs())) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Postponing start offset lapse with details: ").append(msg).toString());
                                    if (state.lapseWatchStartTime() == 0L) {
                                        state.lapseWatchStartTime_$eq(this.time.milliseconds());
                                    }
                                    return false;
                                }
                                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7());
                                return true;
                            }
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Validation against db log start offset went fine  ").append(estimatedSize2).append(", ").append(prevSegInfo2).toString());
                            return true;
                        }
                    }
                    return true;
                }
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("validateDBLogStartOffset exits as not able to fetch comparing value ").append(event).append(" ").append(state).toString());
        return true;
    }

    public String validateDBLogStartOffset$default$3() {
        return "";
    }

    private boolean sizeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("sizeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Object> option = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (option instanceof Some) {
            long estimatedSize = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize, retentionValue)) {
                String msg = new StringBuilder(289).append("durability lapse on validation with db log start offset based on size, the start offset is more than expected retention window size.\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize).append(", retentionValue: ").append(retentionValue).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.StartOffset(), msg, true, this.reporter().reportDurabilityLapse$default$7());
                return true;
            }
            return true;
        }
        return true;
    }

    private boolean timeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("timeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Utils.MaxTimestampWithSize> option = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (option instanceof Some) {
            Utils.MaxTimestampWithSize prevMs = (Utils.MaxTimestampWithSize)((Some)option).value();
            if (!this.withinMarginOfErrorForTimeMsRetention(prevMs.maxTimestamp(), retentionValue)) {
                String msg = new StringBuilder(307).append("durability lapse on validation with db log start offset based on time, the start offset is more than expected retention window time.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevMs.maxTimestamp()).append(", retentionValue: ").append(retentionValue).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.StartOffset(), msg, true, this.reporter().reportDurabilityLapse$default$7());
                return true;
            }
            return true;
        }
        return true;
    }

    public void validateLocalLogStartOffset(TopicIdPartition topicIdPartition, long leaderOffset, String metadata) {
        AbstractLog log;
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(topicIdPartition.topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null && log.logStartOffset() > leaderOffset) {
            Utils.MaxTimestampWithSize prevSegmentState;
            Option<Utils.MaxTimestampWithSize> option2 = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), topicIdPartition, log.logStartOffset());
            if (option2 instanceof Some && !this.withinMarginOfErrorForTimeMsRetention((prevSegmentState = (Utils.MaxTimestampWithSize)((Some)option2).value()).maxTimestamp(), log.config().retentionMs) && !this.withinMarginOfErrorForSizeRetention(log.size() + prevSegmentState.size(), log.config().retentionSize)) {
                String msg = new StringBuilder(241).append("durability lapse on validation with local log start offset.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegmentState.maxTimestamp()).append(", retentionMs: ").append(log.config().retentionMs).append("\n").append("Size based lapse info - prevSegmentSize: ").append(prevSegmentState.size()).append(", logSize: ").append(log.size()).append(", retentionSz: ").append(log.config().retentionSize).append("\n").append("broker: ").append(Utils$.MODULE$.getBrokerId(this.replicaManager())).append("\n").append("partition: ").append(topicIdPartition).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(topicIdPartition.topicPartition(), log.logStartOffset(), Math.max(log.logStartOffset() - leaderOffset, 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7());
                return;
            }
            return;
        }
    }

    public void validateDBEpochChange(EpochChangeEvent event, PartitionState state, String metadata) {
        if (event.firstOffset() < state.highWatermark() || event.epoch() < state.latestEpoch()) {
            String msg = new StringBuilder(209).append("durability lapse on epoch change event with db, first offset for new epoch is less than previous recorded db state hwm\n").append("event first offset: ").append(event.firstOffset()).append(", new epoch: ").append(event.epoch()).append("\n").append("db state hwm: ").append(state.highWatermark()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), event.firstOffset(), Math.max(state.highWatermark() - event.firstOffset(), 1L), DurabilityLapseType$.MODULE$.EpochChange(), msg, true, this.reporter().reportDurabilityLapse$default$7());
            return;
        }
    }

    public void validateEpochChangeWithLocal(EpochChangeEvent event, String metadata) {
        if (!this.isInSync(event.isr())) {
            return;
        }
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), event.topicIdPartition().topicPartition());
        Option<Object> option2 = Utils$.MODULE$.getLatestEpoch(this.replicaManager(), event.topicIdPartition().topicPartition());
        if (option2 instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
            if (option instanceof Some) {
                long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (epoch >= event.epoch() && localEndOffset < event.firstOffset()) {
                    String msg = new StringBuilder(217).append("durability lapse on validation of epoch change with local, local end offset is less than first offset of new event\n").append("in-sync partition ").append(event.topicIdPartition()).append("\n").append("local end offset: ").append(localEndOffset).append(", local epoch ").append(epoch).append("\n").append("first offset: ").append(event.firstOffset()).append(" of the new epoch\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7());
                } else if (localEndOffset < event.highWatermark()) {
                    String msg = new StringBuilder(185).append("durability lapse on validation of epoch change with local, local end offset is less than hwm of new event\n").append("For in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local end offset ").append(localEndOffset).append(",local epoch ").append(epoch).append("\n").append("hwm: ").append(event.highWatermark()).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                    this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7());
                }
            }
        }
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), event.topicIdPartition().topicPartition())) {
            return;
        }
        Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), event.topicIdPartition().topicPartition(), event.epoch());
        Option<AbstractLog> log = this.replicaManager().logManager().getLog(event.topicIdPartition().topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (localOffset instanceof Some) {
            long firstOffset = BoxesRunTime.unboxToLong((Object)((Some)localOffset).value());
            if (log instanceof Some) {
                AbstractLog localLog = (AbstractLog)((Some)log).value();
                if (firstOffset != -1L) {
                    if (firstOffset != event.firstOffset() && (firstOffset < event.firstOffset() || firstOffset > localLog.logStartOffset())) {
                        String msg = new StringBuilder(194).append("durability lapse on validation of epoch change with local, local first offset is not equal to first offset of new event\n").append("in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local first offset: ").append(localOffset).append("\n").append("first offset: ").append(event.firstOffset()).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), firstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7());
                        return;
                    }
                    return;
                }
            }
        }
    }

    public void validateEpochChainWithLocal(TopicPartition topicPartition, PartitionState state, String metadata) {
        Object object = new Object();
        try {
            if (Utils$.MODULE$.isCompacted(this.replicaManager(), topicPartition)) {
                return;
            }
            LongRef prevLocalEpochFirstOffset = LongRef.create((long)-1L);
            IntRef prevEpoch = IntRef.create((int)-1);
            ((List)state.epochChain().toList().sortWith((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerValidator.$anonfun$validateEpochChainWithLocal$1(x, y)))).foreach((Function1 & Serializable)x0$1 -> {
                BrokerValidator.$anonfun$validateEpochChainWithLocal$2(this, topicPartition, prevLocalEpochFirstOffset, prevEpoch, state, metadata, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private boolean withinMarginOfErrorForTimeMsRetention(long timeMs, long retentionMs) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("validating ").append(timeMs).append(" against ").append(retentionMs).toString());
        if (timeMs == -1L) {
            return true;
        }
        if (retentionMs == -1L) {
            return false;
        }
        long diff = this.time.milliseconds() - timeMs;
        return retentionMs - diff <= (long)this.RetentionTimeMarginOfErrorMs();
    }

    private boolean withinMarginOfErrorForSizeRetention(long size, long retentionSize) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Validating ").append(size).append(" against ").append(retentionSize).toString());
        if (size == -1L) {
            return true;
        }
        if (retentionSize == -1L) {
            return false;
        }
        return retentionSize - size <= (long)this.RetentionSizeMarginOfError();
    }

    public boolean isInSync(Set<Object> isr) {
        return isr.contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public static final /* synthetic */ boolean $anonfun$validateEpochChainWithLocal$1(Tuple2 x, Tuple2 y) {
        return x._1$mcI$sp() < y._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$validateEpochChainWithLocal$2(BrokerValidator $this, TopicPartition topicPartition$1, LongRef prevLocalEpochFirstOffset$1, IntRef prevEpoch$1, PartitionState state$4, String metadata$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long localEpochFirstOffset;
            int dbEpoch = x0$1._1$mcI$sp();
            long dbEpochFirstOffset = x0$1._2$mcJ$sp();
            Option<Object> option = Utils$.MODULE$.getLocalStartOffsetForEpoch($this.replicaManager(), topicPartition$1, dbEpoch);
            if (option instanceof Some && (localEpochFirstOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) != -1L) {
                AbstractLog log;
                Option<AbstractLog> option2;
                if (dbEpochFirstOffset < prevLocalEpochFirstOffset$1.elem) {
                    String msg = new StringBuilder(218).append("durability lapse on epoch chain validation with db, local first offset is greater than or equal to next epoch's first offset\n").append("partition ").append(topicPartition$1).append("\n").append("prevEpoch: ").append(prevEpoch$1.elem).append(", prevLocalFirstOffset: ").append(prevLocalEpochFirstOffset$1.elem).append("\n").append("dbEpoch: ").append(dbEpoch).append(", db first offset ").append(dbEpochFirstOffset).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, $this.reporter().reportDurabilityLapse$default$7());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (localEpochFirstOffset != dbEpochFirstOffset && (option2 = $this.replicaManager().logManager().getLog(topicPartition$1, $this.replicaManager().logManager().getLog$default$2())) instanceof Some && ((log = (AbstractLog)((Some)option2).value()).logStartOffset() < localEpochFirstOffset || dbEpochFirstOffset > localEpochFirstOffset)) {
                    String msg = new StringBuilder(199).append("durability lapse on epoch chain validation, db first offset is greater than local first offset\n").append("partition: ").append(topicPartition$1).append("\n").append("dbEpoch: ").append(dbEpoch).append(", the local first offset: ").append(localEpochFirstOffset).append("\n").append("db first offset: ").append(dbEpochFirstOffset).append(", log start offset: ").append(log.logStartOffset()).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, $this.reporter().reportDurabilityLapse$default$7());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                prevLocalEpochFirstOffset$1.elem = localEpochFirstOffset;
                prevEpoch$1.elem = dbEpoch;
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public BrokerValidator(ReplicaManager replicaManager, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.time = time;
        super(reporter, time);
        this.RetentionTimeMarginOfErrorMs = 3600000;
        this.RetentionSizeMarginOfError = 0x100000;
        this.MaxOffsetGapToleranceTimeMs = 900000;
    }
}

