/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import kafka.durability.ondemand.Constants;
import kafka.durability.ondemand.GetAuditJobStatusRequest;
import kafka.durability.ondemand.StartAuditJobRequest;
import kafka.durability.ondemand.StopAuditJobRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDemandAuditJobUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnDemandAuditJobUtil.class);

    public static HttpPost buildKafkaHttpRequest(StartAuditJobRequest startAuditJobRequest) throws URISyntaxException {
        Gson gsonObj = new Gson();
        String jsonString = gsonObj.toJson(startAuditJobRequest.getTopicPartitionsMap());
        URI uri = new URIBuilder(startAuditJobRequest.getBrokerUrl() + "/v1/audit/start-audit-job").build();
        HttpPost post = new HttpPost(uri);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("job_id", String.valueOf(startAuditJobRequest.getJobId()));
        attributes.put("topic_partitions_map", jsonString);
        attributes.put("compaction_check_needed", String.valueOf(startAuditJobRequest.isCompactionCheckNeeded()));
        attributes.put("force_start", String.valueOf(startAuditJobRequest.isForceStart()));
        StringBuilder body = new StringBuilder();
        body.append("{");
        for (String key : attributes.keySet()) {
            body.append("\"").append(key).append("\"");
            if (key.equals("topic_partitions_map")) {
                body.append(": ").append((String)attributes.get(key)).append(",");
                continue;
            }
            body.append(": \"").append((String)attributes.get(key)).append("\",");
        }
        body.deleteCharAt(body.length() - 1);
        body.append("}");
        LOGGER.info("build http request with uri: " + uri.toString() + ", body: " + body);
        StringEntity params = new StringEntity(body.toString(), ContentType.APPLICATION_FORM_URLENCODED);
        post.setEntity((HttpEntity)params);
        return post;
    }

    public static HttpPost buildKafkaHttpRequest(GetAuditJobStatusRequest getAuditJobStatusRequest) throws URISyntaxException {
        URI uri = new URIBuilder(getAuditJobStatusRequest.getBrokerUrl() + "/v1/audit/get-audit-job-status").build();
        HttpPost post = new HttpPost(uri);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("detail", String.valueOf(getAuditJobStatusRequest.isDetail()));
        StringBuilder body = new StringBuilder();
        body.append("{");
        attributes.forEach((k, v) -> body.append("\"").append((String)k).append("\": \"").append((String)v).append("\","));
        body.deleteCharAt(body.length() - 1);
        body.append("}");
        body.deleteCharAt(body.length() - 1);
        body.append("}");
        LOGGER.info("build http request with uri: " + uri.toString() + ", body: " + body);
        StringEntity params = new StringEntity(body.toString(), ContentType.APPLICATION_FORM_URLENCODED);
        post.setEntity((HttpEntity)params);
        return post;
    }

    public static HttpGet buildKafkaHttpRequest(StopAuditJobRequest stopAuditJobRequest) throws URISyntaxException {
        URI uri = new URIBuilder(stopAuditJobRequest.getBrokerUrl() + "/v1/audit/stop-audit-job").build();
        HttpGet get = new HttpGet(uri);
        LOGGER.info("build http request with uri: " + uri.toString());
        return get;
    }

    public static CloseableHttpClient buildHttpClient() {
        return HttpClients.custom().addInterceptorLast((response, context) -> {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String errorMessage = String.format("Received non-successful status code %s in response.", statusCode);
                LOGGER.error(errorMessage + " throws IOException to trigger retry.");
                throw new IOException(errorMessage);
            }
        }).setRetryHandler((exception, executionCount, context) -> {
            if (executionCount < 2) {
                long delayMs = Constants.HTTP_RETRY_INTERVAL_IN_MS * (long)executionCount;
                try {
                    LOGGER.info(String.format("httpclient retry #%s, sleeping for %s ms before retry.", executionCount, delayMs), (Throwable)exception);
                    Thread.sleep(delayMs);
                    return true;
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error("Interrupted while waiting to retry HTTP request. Giving up on retrying request.", (Throwable)interruptedException);
                    return false;
                }
            }
            LOGGER.error(String.format("exhaust max http retries: %d", 2));
            return false;
        }).build();
    }
}

