/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rEf!\u0002%J\u0001%k\u0005\u0002\u0003.\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0011-\u0004!\u0011!Q\u0001\nuC\u0001\u0002\u001c\u0001\u0003\u0006\u0004%\t!\u001c\u0005\n\u0003\u0003\u0001!\u0011!Q\u0001\n9D!\"a\u0001\u0001\u0005\u000b\u0007I\u0011AA\u0003\u0011)\tI\u0002\u0001B\u0001B\u0003%\u0011q\u0001\u0005\b\u00037\u0001A\u0011AA\u000f\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0016\u0011\u001d\ti\u0004\u0001C)\u0003\u007fA!\"a\u0016\u0001\u0005\u0004%\t!SA-\u0011!\t)\u0007\u0001Q\u0001\n\u0005m\u0003\"CA4\u0001\u0001\u0007I\u0011BA5\u0011%\t\u0019\t\u0001a\u0001\n\u0013\t)\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0015BA6\u0011%\tY\n\u0001b\u0001\n\u0013\ti\n\u0003\u0005\u00022\u0002\u0001\u000b\u0011BAP\u0011%\t\u0019\f\u0001b\u0001\n\u0013\t)\f\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BA\\\u0011%\t\t\r\u0001b\u0001\n\u0013\t\u0019\r\u0003\u0005\u0002Z\u0002\u0001\u000b\u0011BAc\u0011%\tY\u000e\u0001b\u0001\n\u0013\ti\u000e\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAp\u0011%\t9\u000f\u0001b\u0001\n\u0003\tI\u000f\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BAv\u0011%\tI\u0010\u0001b\u0001\n\u0003\tI\u000f\u0003\u0005\u0002|\u0002\u0001\u000b\u0011BAv\u0011%\ti\u0010\u0001b\u0001\n\u0003\tI\u000f\u0003\u0005\u0002\u0000\u0002\u0001\u000b\u0011BAv\u0011%\u0011\t\u0001\u0001a\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003\f\u0001\u0001\r\u0011\"\u0001\u0003\u000e!A!\u0011\u0003\u0001!B\u0013\u0011)\u0001C\u0005\u0003\u0016\u0001\u0001\r\u0011\"\u0003\u0003\u0018!I!q\u0004\u0001A\u0002\u0013%!\u0011\u0005\u0005\t\u0005K\u0001\u0001\u0015)\u0003\u0003\u001a!I!\u0011\u0006\u0001C\u0002\u0013%!1\u0006\u0005\t\u0005\u0007\u0002\u0001\u0015!\u0003\u0003.!9!Q\t\u0001\u0005\u0002\t\u001d\u0003\u0002\u0003B'\u0001\u0011\u0005\u0011Ja\u0014\t\u0011\tm\u0003\u0001\"\u0001J\u0005;BqA!\u001a\u0001\t\u0003\u00119\u0007C\u0005\u0003\n\u0002\t\n\u0011\"\u0001\u0003\f\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BY\u0001\u0011\u0005!1\u0015\u0005\b\u0005g\u0003A\u0011\u0001B[\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{CqA!1\u0001\t\u0003\u0011\u0019\rC\u0004\u0003L\u0002!IA!4\t\u000f\tm\u0007\u0001\"\u0003\u0003^\"9!\u0011\u001d\u0001\u0005\u0002\t\r\bb\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\n\u0005{\u0004\u0011\u0013!C\u0001\u0005\u007fD\u0011ba\u0001\u0001#\u0003%\ta!\u0002\t\u000f\r%\u0001\u0001\"\u0001\u0004\f!91q\u0003\u0001\u0005\u0002\re\u0001bBB\u0010\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007W\u0001A\u0011AB\u0017\u0011\u001d\u00199\u0004\u0001C\u0001\u0007sA\u0001\"a-\u0001\t\u0003I5Q\b\u0005\b\u0007\u000f\u0002A\u0011AB%\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0007'Bqa!\u0017\u0001\t\u0003\u0019YfB\u0004\u0004^%C\taa\u0018\u0007\r!K\u0005\u0012AB1\u0011\u001d\tY\u0002\u0011C\u0001\u0007GBqa!\u001aA\t\u0003\u00199\u0007C\u0004\u0004l\u0001#\ta!\u001c\t\u000f\rU\u0004\t\"\u0001\u0004x!91\u0011\u0012!\u0005\u0002\r-\u0005bBBO\u0001\u0012\u00051q\u0014\u0005\b\u0007W\u0003E\u0011ABW\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0006\u0003\u0015.\u000b1\u0001\\8h\u0015\u0005a\u0015!B6bM.\f7c\u0001\u0001O)B\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n1\u0011I\\=SK\u001a\u0004\"!\u0016-\u000e\u0003YS!aV&\u0002\u000bU$\u0018\u000e\\:\n\u0005e3&a\u0002'pO\u001eLgnZ\u0001\bY><G)\u001b:t\u0007\u0001)\u0012!\u0018\t\u0004=\u0006\u001cW\"A0\u000b\u0005\u0001\u0004\u0016AC2pY2,7\r^5p]&\u0011!m\u0018\u0002\u0004'\u0016\f\bC\u00013j\u001b\u0005)'B\u00014h\u0003\tIwNC\u0001i\u0003\u0011Q\u0017M^1\n\u0005),'\u0001\u0002$jY\u0016\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u0005Y><7/F\u0001o!\u0011)v.\u001d?\n\u0005A4&\u0001\u0002)p_2\u0004\"A\u001d>\u000e\u0003MT!\u0001^;\u0002\r\r|W.\\8o\u0015\taeO\u0003\u0002xq\u00061\u0011\r]1dQ\u0016T\u0011!_\u0001\u0004_J<\u0017BA>t\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"! @\u000e\u0003%K!a`%\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003+i!!a\u0003\u000b\u0007)\u000biA\u0003\u0003\u0002\u0010\u0005E\u0011!C5oi\u0016\u0014h.\u00197t\u0015\r\t\u0019\"^\u0001\bgR|'/Y4f\u0013\u0011\t9\"a\u0003\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\na\u0001P5oSRtD\u0003CA\u0010\u0003C\t\u0019#!\n\u0011\u0005u\u0004\u0001\"\u0002.\b\u0001\u0004i\u0006\"\u00027\b\u0001\u0004q\u0007bBA\u0002\u000f\u0001\u0007\u0011qA\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005UR/\u0001\u0004tKJ4XM]\u0005\u0005\u0003s\tyCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013A\u00037pO\u001e,'OT1nKV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\n\tF\u0004\u0003\u0002F\u00055\u0003cAA$!6\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017Z\u0016A\u0002\u001fs_>$h(C\u0002\u0002PA\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA*\u0003+\u0012aa\u0015;sS:<'bAA(!\u0006!rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016,\"!a\u0017\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019h\u0003\u0011a\u0017M\\4\n\t\u0005M\u0013qL\u0001\u0016_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3!\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u0016\u0005\u0005-\u0004cBA7\u0003g\u001a\u0017qO\u0007\u0003\u0003_R1!!\u001d`\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002v\u0005=$aA'baB!\u0011\u0011PA@\u001b\t\tYH\u0003\u0003\u0002h\u0005u$bAA\u001b\u0017&!\u0011\u0011QA>\u0005QyeMZ:fi\u000eCWmY6q_&tGOR5mK\u0006y1\r[3dWB|\u0017N\u001c;t?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u00065\u0005cA(\u0002\n&\u0019\u00111\u0012)\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u001fs\u0011\u0011!a\u0001\u0003W\n1\u0001\u001f\u00132\u00031\u0019\u0007.Z2la>Lg\u000e^:!Q\ry\u0011Q\u0013\t\u0004\u001f\u0006]\u0015bAAM!\nAao\u001c7bi&dW-\u0001\u0006j]B\u0013xn\u001a:fgN,\"!a(\u0011\u000f\u0005\u0005\u0016qU9\u0002,6\u0011\u00111\u0015\u0006\u0004\u0003K{\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0003S\u000b\u0019KA\u0004ICNDW*\u00199\u0011\u0007u\fi+C\u0002\u00020&\u0013\u0001\u0003T8h\u00072,\u0017M\\5oON#\u0018\r^3\u0002\u0017%t\u0007K]8he\u0016\u001c8\u000fI\u0001\u0016k:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8t+\t\t9\f\u0005\u0005\u0002\"\u0006\u001d\u0016\u0011IA]!\u0015\t\t+a/r\u0013\u0011\ti,a)\u0003\u0007M+G/\u0001\fv]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:!\u0003\u0011awnY6\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003+l!!!3\u000b\t\u0005-\u0017QZ\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u001f\f\t.\u0001\u0006d_:\u001cWO\u001d:f]RT1!a5h\u0003\u0011)H/\u001b7\n\t\u0005]\u0017\u0011\u001a\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002%A\fWo]3e\u00072,\u0017M\\5oO\u000e{g\u000eZ\u000b\u0003\u0003?\u0004B!a2\u0002b&!\u00111]Ae\u0005%\u0019uN\u001c3ji&|g.A\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$\u0007%\u0001\bdY\u0016\fgNQ=uKNd\u0015m\u001d;\u0016\u0005\u0005-\b\u0003BAw\u0003gl!!a<\u000b\t\u0005E\u0018QZ\u0001\u0007CR|W.[2\n\t\u0005U\u0018q\u001e\u0002\u000b\u0003R|W.[2M_:<\u0017aD2mK\u0006t')\u001f;fg2\u000b7\u000f\u001e\u0011\u0002%\rdW-\u00198bE2,')\u001f;fg2\u000b7\u000f^\u0001\u0014G2,\u0017M\\1cY\u0016\u0014\u0015\u0010^3t\u0019\u0006\u001cH\u000fI\u0001\u0015k:\u001cG.Z1oC\ndWMQ=uKNd\u0015m\u001d;\u0002+Ut7\r\\3b]\u0006\u0014G.\u001a\"zi\u0016\u001cH*Y:uA\u0005IB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p+\t\u0011)\u0001E\u0002P\u0005\u000fI1A!\u0003Q\u0005\u0019!u.\u001e2mK\u0006iB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p?\u0012*\u0017\u000f\u0006\u0003\u0002\b\n=\u0001\"CAH?\u0005\u0005\t\u0019\u0001B\u0003\u0003i!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8!Q\r\u0001\u0013QS\u0001\u000ei&lWm\u00144MCN$(+\u001e8\u0016\u0005\te\u0001cA(\u0003\u001c%\u0019!Q\u0004)\u0003\t1{gnZ\u0001\u0012i&lWm\u00144MCN$(+\u001e8`I\u0015\fH\u0003BAD\u0005GA\u0011\"a$#\u0003\u0003\u0005\rA!\u0007\u0002\u001dQLW.Z(g\u0019\u0006\u001cHOU;oA!\u001a1%!&\u0002+\u0005\u001c\u0007.[3wK\u0012\u001cE.Z1oS:<'+\u0019;j_V\u0011!Q\u0006\t\u0005\u0005_\u0011y$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003\u0011\u0019wN]3\u000b\t\u0005E\"q\u0007\u0006\u0005\u0005s\u0011Y$\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005{\t1aY8n\u0013\u0011\u0011\tE!\r\u0003\u0013!K7\u000f^8he\u0006l\u0017AF1dQ&,g/\u001a3DY\u0016\fg.\u001b8h%\u0006$\u0018n\u001c\u0011\u0002+\u0005dGn\u00117fC:,'o\u00115fG.\u0004x.\u001b8ugV\u0011!\u0011\n\t\b\u0003\u0007\u0012Y%\u001dB\r\u0013\u0011\t)(!\u0016\u0002\u001b\rdW-\u00198j]\u001e\u001cF/\u0019;f)\u0011\u0011\tFa\u0016\u0011\u000b=\u0013\u0019&a+\n\u0007\tU\u0003K\u0001\u0004PaRLwN\u001c\u0005\u0007\u00053:\u0003\u0019A9\u0002\u0005Q\u0004\u0018\u0001E:fi\u000ecW-\u00198j]\u001e\u001cF/\u0019;f)\u0019\t9Ia\u0018\u0003b!1!\u0011\f\u0015A\u0002EDqAa\u0019)\u0001\u0004\tY+A\u0003ti\u0006$X-A\rhe\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><GC\u0002B5\u0005c\u0012y\bE\u0003P\u0005'\u0012Y\u0007E\u0002~\u0005[J1Aa\u001cJ\u0005)aun\u001a+p\u00072,\u0017M\u001c\u0005\b\u0005gJ\u0003\u0019\u0001B;\u0003\u0011!\u0018.\\3\u0011\t\t]$1P\u0007\u0003\u0005sR!aV:\n\t\tu$\u0011\u0010\u0002\u0005)&lW\rC\u0005\u0003\u0002&\u0002\n\u00111\u0001\u0003\u0004\u0006i\u0001O]3DY\u0016\fgn\u0015;biN\u00042! BC\u0013\r\u00119)\u0013\u0002\u000e!J,7\t\\3b]N#\u0018\r^:\u0002G\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0012\u0016\u0005\u0005\u0007\u0013yi\u000b\u0002\u0003\u0012B!!1\u0013BO\u001b\t\u0011)J\u0003\u0003\u0003\u0018\ne\u0015!C;oG\",7m[3e\u0015\r\u0011Y\nU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BP\u0005+\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0019\u0002\u0018-^:f\u00072,\u0017M\\5oO\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0005K\u0003RA\u0018BT\u0005WK1A!+`\u0005!IE/\u001a:bE2,\u0007#B(\u0003.Fd\u0018b\u0001BX!\n1A+\u001e9mKJ\nQ\u0002Z3mKR\f'\r\\3M_\u001e\u001c\u0018!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u0002\b\n]\u0006B\u0002B][\u0001\u0007\u0011/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u0011q\u0011B`\u0011\u0019\u0011IL\fa\u0001c\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BAD\u0005\u000bDqAa20\u0001\u0004\u0011I-A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0011q&qU9\u0002#%\u001c8\t\\3b]&tw-\u00138Ti\u0006$X\r\u0006\u0004\u0003P\nU'q\u001b\t\u0004\u001f\nE\u0017b\u0001Bj!\n9!i\\8mK\u0006t\u0007B\u0002B]a\u0001\u0007\u0011\u000fC\u0004\u0003ZB\u0002\r!a+\u0002\u001b\u0015D\b/Z2uK\u0012\u001cF/\u0019;f\u0003]I7o\u00117fC:LgnZ%o'R\fG/\u001a)bkN,G\r\u0006\u0003\u0003P\n}\u0007B\u0002B]c\u0001\u0007\u0011/\u0001\u000bdQ\u0016\u001c7n\u00117fC:LgnZ!c_J$X\r\u001a\u000b\u0005\u0003\u000f\u0013)\u000f\u0003\u0004\u0003:J\u0002\r!]\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0003CAD\u0005W\u0014yOa>\t\r\t58\u00071\u0001d\u0003\u001d!\u0017\r^1ESJD\u0011B!=4!\u0003\u0005\rAa=\u0002-A\f'\u000f^5uS>tGk\\+qI\u0006$Xm\u0014:BI\u0012\u0004Ra\u0014B*\u0005k\u0004ba\u0014BWc\ne\u0001\"\u0003B}gA\u0005\t\u0019\u0001B~\u0003E\u0001\u0018M\u001d;ji&|g\u000eV8SK6|g/\u001a\t\u0005\u001f\nM\u0013/A\u000eva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$C-\u001a4bk2$HEM\u000b\u0003\u0007\u0003QCAa=\u0003\u0010\u0006YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uIM*\"aa\u0002+\t\tm(qR\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u0002\b\u000e51qBB\n\u0011\u0019\u0011IL\u000ea\u0001c\"11\u0011\u0003\u001cA\u0002\r\fAb]8ve\u000e,Gj\\4ESJDaa!\u00067\u0001\u0004\u0019\u0017A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u0011qQB\u000e\u0011\u001d\u0019ib\u000ea\u0001\u0003\u0003\n1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002\b\u000e\r2QEB\u0014\u0011\u0019\u0011i\u000f\u000fa\u0001G\"1!\u0011\u0018\u001dA\u0002EDqa!\u000b9\u0001\u0004\u0011I\"\u0001\u0004pM\u001a\u001cX\r^\u0001\rI>tWm\u00117fC:Lgn\u001a\u000b\t\u0003\u000f\u001byc!\r\u00044!1!\u0011X\u001dA\u0002EDaA!<:\u0001\u0004\u0019\u0007bBB\u001bs\u0001\u0007!\u0011D\u0001\nK:$wJ\u001a4tKR\fA\u0002Z8oK\u0012+G.\u001a;j]\u001e$B!a\"\u0004<!9!q\u0019\u001eA\u0002\t%G\u0003BB \u0007\u0007\u0002R!a\u0011\u0004BELA!!0\u0002V!91QI\u001eA\u0002\u0005\u0005\u0013A\u00027pO\u0012K'/\u0001\rnCJ\\\u0007+\u0019:uSRLwN\\+oG2,\u0017M\\1cY\u0016$b!a\"\u0004L\r5\u0003bBB#y\u0001\u0007\u0011\u0011\t\u0005\u0007\u0007\u001fb\u0004\u0019A9\u0002\u0013A\f'\u000f^5uS>t\u0017AF5t+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8\u0015\r\t=7QKB,\u0011\u0015QU\b1\u0001}\u0011\u0019\u0011I,\u0010a\u0001c\u0006iR.Y5oi\u0006Lg.\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0002\b\u0006\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0011\u0005u\u00045c\u0001!O)R\u00111qL\u0001\u0013SN\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\r\u0006\u0003\u0003P\u000e%\u0004\"\u0002&C\u0001\u0004a\u0018\u0001\t7pG\u0006dW)\u0019:mS\u0016\u001cH\u000fR5sif\u0014\u0015\r^2i)&lWm\u001d;b[B$bA!\u0007\u0004p\rE\u0004\"\u0002&D\u0001\u0004a\bbBB:\u0007\u0002\u0007!\u0011D\u0001\u0011M&\u00148\u000f\u001e#jeRLxJ\u001a4tKR\f!#\\1y\u0007>l\u0007/Y2uS>tG)\u001a7bsRA!\u0011DB=\u0007w\u001a)\tC\u0003K\t\u0002\u0007A\u0010C\u0004\u0004~\u0011\u0003\raa \u0002-\u0015\f'\u000f\\5fgR$\u0015N\u001d;z)&lWm\u001d;b[B\u0004RaTBA\u00053I1aa!Q\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0004\b\u0012\u0003\rA!\u0007\u0002\u00079|w/\u0001\tdY\u0016\fg.\u00192mK>3gm]3ugRA1QRBJ\u0007+\u001bY\nE\u0002~\u0007\u001fK1a!%J\u00059yeMZ:fiN$vn\u00117fC:DQAS#A\u0002qDqaa&F\u0001\u0004\u0019I*A\bmCN$8\t\\3b]>3gm]3u!\u0015y%1\u000bB\r\u0011\u001d\u00199)\u0012a\u0001\u00053\tqcY1mGVd\u0017\r^3DY\u0016\fg.\u00192mK\nKH/Z:\u0015\u0011\r\u000561UBS\u0007O\u0003ra\u0014BW\u00053\u0011I\u0002C\u0003K\r\u0002\u0007A\u0010C\u0004\u0004t\u0019\u0003\rA!\u0007\t\u000f\r%f\t1\u0001\u0003\u001a\u0005\tRO\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;\u00027\u0011,\u0018\r\\\"p[B\f7\r^5p]\u000ecW-\u00198j]\u001e\u0014u.\u001e8e)\u0011\u0019Ija,\t\u000b);\u0005\u0019\u0001?")
public class LogCleanerManager
implements Logging {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final KafkaMetricsGroup metricsGroup;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private final AtomicLong cleanBytesLast;
    private final AtomicLong cleanableBytesLast;
    private final AtomicLong uncleanableBytesLast;
    private volatile double dirtiestLogCleanableRatio;
    private volatile long timeOfLastRun;
    private final Histogram achievedCleaningRatio;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Object> dualCompactionCleaningBound(AbstractLog log) {
        return LogCleanerManager$.MODULE$.dualCompactionCleaningBound(log);
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(AbstractLog log, long firstDirtyOffset, long uncleanableOffset) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(log, firstDirtyOffset, uncleanableOffset);
    }

    public static OffsetsToClean cleanableOffsets(AbstractLog log, Option<Object> lastCleanOffset, long now) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, lastCleanOffset, now);
    }

    public static long maxCompactionDelay(AbstractLog log, Function0<Object> earliestDirtyTimestamp, long now) {
        long maxCompactionDelay_maxCompactionLagMs = package$.MODULE$.max(log.config().maxCompactionLagMs(), 0L);
        long maxCompactionDelay_cleanUntilTime = now - maxCompactionDelay_maxCompactionLagMs;
        if (maxCompactionDelay_cleanUntilTime < 0L) {
            return 0L;
        }
        long maxCompactionDelay_earliestDirtySegmentTimestamp = earliestDirtyTimestamp.apply$mcJ$sp();
        if (maxCompactionDelay_earliestDirtySegmentTimestamp < maxCompactionDelay_cleanUntilTime) {
            return maxCompactionDelay_cleanUntilTime - maxCompactionDelay_earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    public static long localEarliestDirtyBatchTimestamp(AbstractLog log, long firstDirtyOffset) {
        return LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(log, firstDirtyOffset);
    }

    public static boolean isCompactAndDelete(AbstractLog log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public AtomicLong cleanBytesLast() {
        return this.cleanBytesLast;
    }

    public AtomicLong cleanableBytesLast() {
        return this.cleanableBytesLast;
    }

    public AtomicLong uncleanableBytesLast() {
        return this.uncleanableBytesLast;
    }

    public double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    public void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    private Histogram achievedCleaningRatio() {
        return this.achievedCleaningRatio;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> ((IterableOnceOps)this.checkpoints().values().flatMap((Function1 & Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> this.inProgress().get((Object)tp));
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> this.inProgress().put((Object)tp, (Object)state));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> {
            long now = time.milliseconds();
            this.timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable allCleanableLogs = (Iterable)((IterableOps)((IterableOps)((IterableOps)this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                if (x0$3 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$3._1();
                    AbstractLog log = (AbstractLog)x0$3._2();
                    try {
                        long maxCompactionDelay_earliestDirtySegmentTimestamp;
                        long maxCompactionDelay_maxCompactionLagMs;
                        long maxCompactionDelay_cleanUntilTime;
                        Option lastCleanOffset = lastClean.get((Object)topicPartition);
                        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                        if (offsetsToClean.forceUpdateCheckpoint()) {
                            this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offsetsToClean.firstDirtyOffset()))), this.updateCheckpoints$default$3());
                        }
                        long compactionDelayMs = (maxCompactionDelay_cleanUntilTime = now - (maxCompactionDelay_maxCompactionLagMs = package$.MODULE$.max(log.config().maxCompactionLagMs(), 0L))) < 0L ? 0L : ((maxCompactionDelay_earliestDirtySegmentTimestamp = LogCleanerManager$.MODULE$.localEarliestDirtyBatchTimestamp(log, offsetsToClean.firstDirtyOffset())) < maxCompactionDelay_cleanUntilTime ? maxCompactionDelay_cleanUntilTime - maxCompactionDelay_earliestDirtySegmentTimestamp : 0L);
                        preCleanStats.updateMaxCompactionDelay(compactionDelayMs);
                        return new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                    }
                    catch (Throwable e) {
                        throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                    }
                }
                throw new MatchError(null);
            })).filter((Function1 & Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            this.cleanBytesLast().set(BoxesRunTime.unboxToLong((Object)((IterableOnceOps)allCleanableLogs.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.cleanBytes()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            this.cleanableBytesLast().set(BoxesRunTime.unboxToLong((Object)((IterableOnceOps)allCleanableLogs.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.cleanableBytes()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            this.uncleanableBytesLast().set(BoxesRunTime.unboxToLong((Object)((IterableOnceOps)allCleanableLogs.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.uncleanableBytes()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            Iterable dirtyLogs = (Iterable)allCleanableLogs.filterNot((Function1 & Serializable)logToClean -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$10(this, logToClean)));
            this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$11(ltc)));
            if (cleanableLogs.isEmpty()) {
                return None$.MODULE$;
            }
            preCleanStats.recordCleanablePartitions(cleanableLogs.size());
            LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
            this.achievedCleaningRatio().update((int)(filthiest.cleanableRatio() * (double)100));
            double expectedShrinkageRatio = filthiest.log().lastShrinkageRatio() * filthiest.cleanableRatio();
            this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Filthiest log %s has last.shrinkage.ratio=%.3f, dirty.ratio=%.3f, expected.shrinkage.ratio=%.3f %n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{filthiest.log().name(), BoxesRunTime.boxToDouble((double)filthiest.log().lastShrinkageRatio()), BoxesRunTime.boxToDouble((double)filthiest.cleanableRatio()), BoxesRunTime.boxToDouble((double)expectedShrinkageRatio)})));
            return new Some((Object)filthiest);
        });
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> {
            Iterable deletableLogs = (Iterable)((IterableOps)this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3(this, x0$2)));
            deletableLogs.foreach((Function1 & Serializable)x0$3 -> {
                if (x0$3 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$3._1();
                    return this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                }
                throw new MatchError(null);
            });
            return deletableLogs;
        });
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> {
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$1)));
            toClean.foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition tp = (TopicPartition)x0$2._1();
                    return this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                }
                throw new MatchError(null);
            });
            return toClean;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$));
        });
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), () -> LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition));
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
            Option option = this.inProgress().get(topicPartition);
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
            }
            if (option instanceof Some) {
                int count;
                LogCleaningState state = (LogCleaningState)((Some)option).value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                if (state instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)state;
                    if (logCleaningPaused.pausedCount() == 1) {
                        return this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && (count = logCleaningPaused.pausedCount()) > 1) {
                    return this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
                }
                throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
            }
            throw new MatchError((Object)option);
        }));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            return !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        }
        throw new MatchError((Object)option);
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
        }
        throw new MatchError((Object)option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
            if (Option$.MODULE$.apply((Object)this.logs().get(topicPartition)).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isFrozenLogStartOffsetState()))) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> {
            OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
            if (checkpoint != null) {
                try {
                    scala.collection.immutable.Map map;
                    scala.collection.immutable.Map map2;
                    scala.collection.immutable.Map currentCheckpoint = ((IterableOnceOps)checkpoint.read().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2(this, x0$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    if (partitionToRemove instanceof Some) {
                        TopicPartition topicPartition = (TopicPartition)((Some)partitionToRemove).value();
                        map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartition);
                    } else if (None$.MODULE$.equals(partitionToRemove)) {
                        map2 = currentCheckpoint;
                    } else {
                        throw new MatchError((Object)partitionToRemove);
                    }
                    scala.collection.immutable.Map updatedCheckpoint = map2;
                    if (partitionToUpdateOrAdd instanceof Some) {
                        Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd).value();
                        map = (scala.collection.immutable.Map)updatedCheckpoint.$plus(updatedOffset);
                    } else if (None$.MODULE$.equals(partitionToUpdateOrAdd)) {
                        map = updatedCheckpoint;
                    } else {
                        throw new MatchError((Object)partitionToUpdateOrAdd);
                    }
                    updatedCheckpoint = map;
                    checkpoint.write((Map<TopicPartition, Object>)updatedCheckpoint);
                    return;
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    return;
                }
            }
        });
    }

    public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> {
            try {
                Option option = this.checkpoints().get((Object)sourceLogDir).flatMap((Function1 & Serializable)x$6 -> x$6.read().get((Object)topicPartition));
                if (option instanceof Some) {
                    long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Removing the partition offset data in checkpoint file for '").append(topicPartition).append("' ").append("from ").append(sourceLogDir.getAbsoluteFile()).append(" directory.").toString());
                    Option x$2 = Option$.MODULE$.apply((Object)topicPartition);
                    Option<Tuple2<TopicPartition, Object>> x$3 = this.updateCheckpoints$default$2();
                    this.updateCheckpoints(sourceLogDir, x$3, (Option<TopicPartition>)x$2);
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Adding the partition offset data in checkpoint file for '").append(topicPartition).append("' ").append("to ").append(destLogDir.getAbsoluteFile()).append(" directory.").toString());
                    this.updateCheckpoints(destLogDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offset))), this.updateCheckpoints$default$3());
                } else if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            }
            Set logUncleanablePartitions = (Set)this.uncleanablePartitions().getOrElse((Object)sourceLogDir.toString(), (Function0 & Serializable)() -> (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
            if (logUncleanablePartitions.contains((Object)topicPartition)) {
                logUncleanablePartitions.remove((Object)topicPartition);
                this.markPartitionUncleanable(destLogDir.toString(), topicPartition);
                return;
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x0$1))))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> {
            if (Option$.MODULE$.apply((Object)this.logs().get(topicPartition)).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maybeTruncateCheckpoint$2(x$7)))) {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
                if (checkpoint != null) {
                    Map<TopicPartition, Object> existing = checkpoint.read();
                    if (BoxesRunTime.unboxToLong((Object)existing.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) > offset) {
                        checkpoint.write((Map<TopicPartition, Object>)((Map)((Growable)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus$eq(existing).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset)))));
                        return;
                    }
                    return;
                }
                return;
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get((Object)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))), this.updateCheckpoints$default$3());
                    return this.inProgress().remove((Object)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            }
            throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
        });
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get(topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    return this.inProgress().remove(topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            }
            throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
        }));
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> {
            partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((IterableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        });
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable)() -> {
            Option option = this.uncleanablePartitions().get((Object)logDir);
            if (option instanceof Some) {
                return BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition));
            }
            if (None$.MODULE$.equals(option)) {
                return this.uncleanablePartitions().put((Object)logDir, Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
            }
            throw new MatchError((Object)option);
        });
    }

    public boolean isUncleanablePartition(AbstractLog log, TopicPartition topicPartition) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable)() -> this.uncleanablePartitions().get((Object)log.parentDir()).exists((Function1 & Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition)))));
    }

    public void maintainUncleanablePartitions() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable)() -> {
            this.uncleanablePartitions().values().foreach((Function1 & Serializable)partitions -> {
                LogCleanerManager.$anonfun$maintainUncleanablePartitions$2(this, partitions);
                return BoxedUnit.UNIT;
            });
            ((MapOps)this.uncleanablePartitions().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$5(x0$1)))).keys().toList().foreach((Function1 & Serializable)key -> this.uncleanablePartitions().remove(key));
        });
    }

    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$2(File dir$1) {
        return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$new$10(scala.collection.immutable.Map lastClean$1, TopicPartition tp$1, long now$1, AbstractLog log) {
        void var8_7;
        Option lastCleanOffset = lastClean$1.get((Object)tp$1);
        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now$1);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        return (long)var8_7;
    }

    public static final /* synthetic */ long $anonfun$new$9(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.logs().get(tp)).map((Function1 & Serializable)log -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$10(lastClean$1, tp, now$1, log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$7(File dir$2) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcJ.sp & Serializable)() -> {
            Option option = this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
            if (option instanceof Some) {
                Set partitions = (Set)((Some)option).value();
                scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
                long now = Time.SYSTEM.milliseconds();
                return BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$9(this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            if (None$.MODULE$.equals(option)) {
                return 0L;
            }
            throw new MatchError((Object)option);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$new$14(File dir$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            AbstractLog log = (AbstractLog)x0$1._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$15(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((AbstractLog)x0$2._2()).sizeAsyncUpdated();
        }
        throw new MatchError(null);
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$13(File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)this.logs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$14(dir$3, x0$1)))).map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$15(x0$2)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$17(File dir$3, Tuple2 x0$3) {
        if (x0$3 != null) {
            AbstractLog log = (AbstractLog)x0$3._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$18(Tuple2 x0$4) {
        if (x0$4 != null) {
            return ((AbstractLog)x0$4._2()).sizeDetailsAsyncUpdated().localSize();
        }
        throw new MatchError(null);
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$16(File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)this.logs().filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$17(dir$3, x0$3)))).map((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$18(x0$4)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$20(File dir$3, Tuple2 x0$5) {
        if (x0$5 != null) {
            AbstractLog log = (AbstractLog)x0$5._2();
            return log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$new$21(Tuple2 x0$6) {
        if (x0$6 != null) {
            return ((AbstractLog)x0$6._2()).sizeDetailsAsyncUpdated().tieredSize();
        }
        throw new MatchError(null);
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$19(File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)this.logs().filter((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$20(dir$3, x0$5)))).map((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$21(x0$6)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$22() {
        return Time.SYSTEM.milliseconds() - this.timeOfLastRun();
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((AbstractLog)x0$1._2()).isLocallyCompactable();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            AbstractLog log = (AbstractLog)x0$2._2();
            return $this.isUncleanablePartition(log, topicPartition) || log.isFrozenLogStartOffsetState();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$10(LogCleanerManager $this, LogToClean logToClean) {
        return $this.inProgress().contains((Object)logToClean.topicPartition());
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$11(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > ltc.log().config().minCleanableRatio;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return !((AbstractLog)x0$1._2()).isLocallyCompactable();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            return $this.inProgress().contains((Object)topicPartition);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            return !$this.inProgress().contains((Object)topicPartition) && log.isLocallyCompactable() && !$this.isUncleanablePartition(log, topicPartition);
        }
        throw new MatchError(null);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.logs().keys().contains((Object)tp);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((File)x0$1._1()).getAbsolutePath();
            return string == null ? dir$4 != null : !string.equals(dir$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateCheckpoint$2(AbstractLog x$7) {
        return x$7.config().compact();
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$3(LogCleanerManager $this, TopicPartition id) {
        return $this.logs().contains(id);
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$2(LogCleanerManager $this, Set partitions) {
        ((IterableOnceOps)partitions.filterNot((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$3($this, id)))).toList().foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitions.remove((Object)elem)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$5(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Set)x0$1._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((IterableOnceOps)logDirs.map((Function1 & Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.cleanBytesLast = new AtomicLong(0L);
        this.cleanableBytesLast = new AtomicLong(0L);
        this.uncleanableBytesLast = new AtomicLong(0L);
        this.dirtiestLogCleanableRatio = 0.0;
        logDirs.foreach((Function1 & Serializable)dir -> this.metricsGroup().newGauge("uncleanable-partitions-count", (Gauge)new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$1;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$2(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava()));
        logDirs.foreach((Function1 & Serializable)dir -> this.metricsGroup().newGauge("uncleanable-bytes", (Gauge)new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$7(this.dir$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava()));
        logDirs.foreach((Function1 & Serializable)dir -> {
            this.metricsGroup().newGauge("compacted-partition-bytes", (Gauge)new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$3;

                public final long value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$13(this.dir$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$3 = dir$3;
                }
            }, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava());
            this.metricsGroup().newGauge("compacted-partition-local-bytes", (Gauge)new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$3;

                public final long value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$16(this.dir$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$3 = dir$3;
                }
            }, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava());
            return this.metricsGroup().newGauge("compacted-partition-tiered-bytes", (Gauge)new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$3;

                public final long value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$19(this.dir$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$3 = dir$3;
                }
            }, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())}))).asJava());
        });
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.metricsGroup().newGauge("time-since-last-run-ms", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$22();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.achievedCleaningRatio = this.metricsGroup().newHistogram("AchievedCleaningRatio");
    }
}

