/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.Files;
import kafka.log.SegmentDeletionThrottlerConfig$;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001B\u0013'\u0001-B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\n\u0001B\u0001B\u0003%\u0001\u000bC\u0003T\u0001\u0011\u0005A\u000b\u0003\u0005[\u0001\u0001\u0007I\u0011\u0001\u0014\\\u0011!!\u0007\u00011A\u0005\u0002\u0019*\u0007BB6\u0001A\u0003&A\fC\u0004q\u0001\u0001\u0007I\u0011B9\t\u000fU\u0004\u0001\u0019!C\u0005m\"1\u0001\u0010\u0001Q!\nID\u0001B\u001f\u0001A\u0002\u0013\u0005ae\u001f\u0005\t}\u0002\u0001\r\u0011\"\u0001'\u007f\"9\u00111\u0001\u0001!B\u0013a\bBCA\u0004\u0001\u0001\u0007I\u0011\u0001\u0014\u0002\n!Q\u0011\u0011\u0003\u0001A\u0002\u0013\u0005a%a\u0005\t\u0011\u0005]\u0001\u0001)Q\u0005\u0003\u0017A\u0001\"!\u0007\u0001\u0001\u0004%Ia\u001f\u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0003;Aq!!\t\u0001A\u0003&A\u0010\u0003\u0004\u0002$\u0001!\ta\u001f\u0005\b\u0003K\u0001A\u0011CA\u0014\u0011\u001d\t9\u0006\u0001C!\u00033Bq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAN\u0001\u0011%\u0011QT\u0004\b\u0003K3\u0003\u0012AAT\r\u0019)c\u0005#\u0001\u0002*\"11+\bC\u0001\u0003WC\u0011\"!,\u001e\u0005\u0004%\t!a,\t\u000f\u0005EV\u0004)A\u0005!\"I\u00111W\u000fC\u0002\u0013\u0005\u0011Q\u0017\u0005\t\u0003{k\u0002\u0015!\u0003\u00028\"9\u00111E\u000f\u0005\u0002\u0005}\u0006\"CAe;E\u0005I\u0011AAf\u0005y\u0019VmZ7f]R$U\r\\3uS>tG\u000b\u001b:piRdWM]\"p]\u001aLwM\u0003\u0002(Q\u0005\u0019An\\4\u000b\u0003%\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001YIB\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024m5\tAG\u0003\u00026Q\u0005)Q\u000f^5mg&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h!\tID(D\u0001;\u0015\tY\u0004&\u0001\u0004tKJ4XM]\u0005\u0003{i\u0012AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017\u0001\u0002;j[\u0016\u0004\"\u0001Q%\u000e\u0003\u0005S!!\u000e\"\u000b\u0005\r#\u0015AB2p[6|gN\u0003\u0002*\u000b*\u0011aiR\u0001\u0007CB\f7\r[3\u000b\u0003!\u000b1a\u001c:h\u0013\tQ\u0015I\u0001\u0003US6,\u0017AB2p]\u001aLw\r\u0005\u0002:\u001b&\u0011aJ\u000f\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\teSN\\7\t[3dW\u0012+G.Y=NgB\u0011Q&U\u0005\u0003%:\u00121!\u00138u\u0003\u0019a\u0014N\\5u}Q!Qk\u0016-Z!\t1\u0006!D\u0001'\u0011\u0015qD\u00011\u0001@\u0011\u0015YE\u00011\u0001M\u0011\u001dyE\u0001%AA\u0002A\u000b1eY8oM&<WO]3e\t\u0016dW\r^5p]6\u000b\u0007pU3h[\u0016tGo\u001d)feJ+h.F\u0001]!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0003mC:<'\"A1\u0002\t)\fg/Y\u0005\u0003Gz\u0013q!\u00138uK\u001e,'/A\u0014d_:4\u0017nZ;sK\u0012$U\r\\3uS>tW*\u0019=TK\u001elWM\u001c;t!\u0016\u0014(+\u001e8`I\u0015\fHC\u00014j!\tis-\u0003\u0002i]\t!QK\\5u\u0011\u001dQg!!AA\u0002q\u000b1\u0001\u001f\u00132\u0003\u0011\u001awN\u001c4jOV\u0014X\r\u001a#fY\u0016$\u0018n\u001c8NCb\u001cVmZ7f]R\u001c\b+\u001a:Sk:\u0004\u0003FA\u0004n!\tic.\u0003\u0002p]\tAao\u001c7bi&dW-A\u0010d_:4\u0017nZ;sK\u0012$\u0015n]6Ge\u0016,\u0007*Z1ee>|WNQ=uKN,\u0012A\u001d\t\u0003;NL!\u0001\u001e0\u0003\t1{gnZ\u0001$G>tg-[4ve\u0016$G)[:l\rJ,W\rS3bIJ|w.\u001c\"zi\u0016\u001cx\fJ3r)\t1w\u000fC\u0004k\u0013\u0005\u0005\t\u0019\u0001:\u0002A\r|gNZ5hkJ,G\rR5tW\u001a\u0013X-\u001a%fC\u0012\u0014xn\\7CsR,7\u000f\t\u0015\u0003\u00155\fqc\u00183jg.4%/Z3UQJ,7\u000f[8mI\nKH/Z:\u0016\u0003q\u0004\"!L?\n\u0005Qt\u0013aG0eSN\\gI]3f)\"\u0014Xm\u001d5pY\u0012\u0014\u0015\u0010^3t?\u0012*\u0017\u000fF\u0002g\u0003\u0003AqA\u001b\u0007\u0002\u0002\u0003\u0007A0\u0001\r`I&\u001c8N\u0012:fKRC'/Z:i_2$')\u001f;fg\u0002B#!D7\u0002E%\u001cH)\u001a7fi&|g.T1y'\u0016<W.\u001a8ugB+'OU;o\u000b:\f'\r\\3e+\t\tY\u0001E\u0002.\u0003\u001bI1!a\u0004/\u0005\u001d\u0011un\u001c7fC:\fa%[:EK2,G/[8o\u001b\u0006D8+Z4nK:$8\u000fU3s%VtWI\\1cY\u0016$w\fJ3r)\r1\u0017Q\u0003\u0005\tU>\t\t\u00111\u0001\u0002\f\u0005\u0019\u0013n\u001d#fY\u0016$\u0018n\u001c8NCb\u001cVmZ7f]R\u001c\b+\u001a:Sk:,e.\u00192mK\u0012\u0004\u0013\u0001\u00077bgR$\u0015n]6Vg\u0006<Wm\u00115fG.$\u0016.\\3Ng\u0006aB.Y:u\t&\u001c8.V:bO\u0016\u001c\u0005.Z2l)&lW-T:`I\u0015\fHc\u00014\u0002 !9!NEA\u0001\u0002\u0004a\u0018!\u00077bgR$\u0015n]6Vg\u0006<Wm\u00115fG.$\u0016.\\3Ng\u0002\na\u0003Z5tW\u001a\u0013X-\u001a+ie\u0016\u001c\bn\u001c7e\u0005f$Xm]\u0001\u000bM&dWm\u0015;pe\u0016\u001cH\u0003BA\u0015\u0003\u000b\u0002b!a\u000b\u00022\u0005URBAA\u0017\u0015\r\tyCL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001a\u0003[\u00111aU3r!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tAAZ5mK*\u0019\u0011q\b1\u0002\u00079Lw.\u0003\u0003\u0002D\u0005e\"!\u0003$jY\u0016\u001cFo\u001c:f\u0011\u001d\t9%\u0006a\u0001\u0003\u0013\nq\u0001\\8h\t&\u00148\u000f\u0005\u0004\u0002,\u0005E\u00121\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b1\u0002\u0005%|\u0017\u0002BA+\u0003\u001f\u0012AAR5mK\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXCAA.!\u0019\tY#!\u0018\u0002b%!\u0011qLA\u0017\u0005\r\u0019V\r\u001e\t\u0005\u0003G\n\tH\u0004\u0003\u0002f\u00055\u0004cAA4]5\u0011\u0011\u0011\u000e\u0006\u0004\u0003WR\u0013A\u0002\u001fs_>$h(C\u0002\u0002p9\na\u0001\u0015:fI\u00164\u0017\u0002BA:\u0003k\u0012aa\u0015;sS:<'bAA8]\u00059b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0004M\u0006m\u0004BBA?/\u0001\u0007A*A\u0005oK^\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u00151\u00171QAD\u0011\u0019\t)\t\u0007a\u0001\u0019\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\u0007\u0003{B\u0002\u0019\u0001'\u0002C5\f\u0017PY3Va\u0012\fG/\u001a#jg.4%/Z3UQJ,7\u000f[8mI\nKH/Z:\u0015\u000b\u0019\fi)!%\t\u000f\u0005=\u0015\u00041\u0001\u0002\f\u0005IRM\\1cY\u0016$\u0015n]6CCN,G\r\u00165s_R$H.\u001b8h\u0011\u0019\t\u0019*\u0007a\u0001y\u0006q\"-Y2l!J,7o];sK\u0012K7o\u001b+ie\u0016\u001c\bn\u001c7e\u0005f$Xm]\u0001\u001aI\u0016dW\r^5p]6\u000b\u0007pU3h[\u0016tGo\u001d)feJ+h\u000eF\u0002Q\u00033Cq!a\u0012\u001b\u0001\u0004\tI%A\u0013nCf\u0014W\rR5tC\ndW\rR3mKRLwN\\'bqN+w-\\3oiN\u0004VM\u001d*v]R)a-a(\u0002\"\"9\u0011qI\u000eA\u0002\u0005%\u0003BBAR7\u0001\u0007A0A\u0007dkJ\u0014XM\u001c;US6,Wj]\u0001\u001f'\u0016<W.\u001a8u\t\u0016dW\r^5p]RC'o\u001c;uY\u0016\u00148i\u001c8gS\u001e\u0004\"AV\u000f\u0014\u0005uaCCAAT\u0003]!UMZ1vYR$\u0015n]6DQ\u0016\u001c7\u000eR3mCfl5/F\u0001Q\u0003a!UMZ1vYR$\u0015n]6DQ\u0016\u001c7\u000eR3mCfl5\u000fI\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\t9\f\u0005\u0004\u0002,\u0005u\u0013\u0011\u0018\t\u0004;\u0006m\u0016bAA:=\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\b\u0005F\u0004}\u0003\u0003\f)-a2\t\r\u0005\r7\u00051\u0001}\u0003U!\u0017n]6Ge\u0016,\u0007*Z1ee>|WNQ=uKNDq!a$$\u0001\u0004\tY\u0001\u0003\u0004\u0002\u0014\u000e\u0002\r\u0001`\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00055'f\u0001)\u0002P.\u0012\u0011\u0011\u001b\t\u0005\u0003'\fi.\u0004\u0002\u0002V*!\u0011q[Am\u0003%)hn\u00195fG.,GMC\u0002\u0002\\:\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty.!6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class SegmentDeletionThrottlerConfig
implements Logging,
BrokerReconfigurable {
    private final Time time;
    private final int diskCheckDelayMs;
    private volatile Integer configuredDeletionMaxSegmentsPerRun;
    private volatile Long configuredDiskFreeHeadroomBytes;
    private volatile long _diskFreeThresholdBytes;
    private boolean isDeletionMaxSegmentsPerRunEnabled;
    private long lastDiskUsageCheckTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return SegmentDeletionThrottlerConfig$.MODULE$.DefaultDiskCheckDelayMs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SegmentDeletionThrottlerConfig$.MODULE$.ReconfigurableConfigs();
    }

    public static int DefaultDiskCheckDelayMs() {
        return SegmentDeletionThrottlerConfig$.MODULE$.DefaultDiskCheckDelayMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Integer configuredDeletionMaxSegmentsPerRun() {
        return this.configuredDeletionMaxSegmentsPerRun;
    }

    public void configuredDeletionMaxSegmentsPerRun_$eq(Integer x$1) {
        this.configuredDeletionMaxSegmentsPerRun = x$1;
    }

    private Long configuredDiskFreeHeadroomBytes() {
        return this.configuredDiskFreeHeadroomBytes;
    }

    private void configuredDiskFreeHeadroomBytes_$eq(Long x$1) {
        this.configuredDiskFreeHeadroomBytes = x$1;
    }

    public long _diskFreeThresholdBytes() {
        return this._diskFreeThresholdBytes;
    }

    public void _diskFreeThresholdBytes_$eq(long x$1) {
        this._diskFreeThresholdBytes = x$1;
    }

    public boolean isDeletionMaxSegmentsPerRunEnabled() {
        return this.isDeletionMaxSegmentsPerRunEnabled;
    }

    public void isDeletionMaxSegmentsPerRunEnabled_$eq(boolean x$1) {
        this.isDeletionMaxSegmentsPerRunEnabled = x$1;
    }

    private long lastDiskUsageCheckTimeMs() {
        return this.lastDiskUsageCheckTimeMs;
    }

    private void lastDiskUsageCheckTimeMs_$eq(long x$1) {
        this.lastDiskUsageCheckTimeMs = x$1;
    }

    public long diskFreeThresholdBytes() {
        return this._diskFreeThresholdBytes();
    }

    public Seq<FileStore> fileStores(Seq<File> logDirs) {
        return (Seq)logDirs.map((Function1 & Serializable)logDir -> Files.getFileStore(logDir.toPath()));
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SegmentDeletionThrottlerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Integer2int(newConfig.logDeletionMaxSegmentsPerRun()) < 0) {
            throw new ConfigException(new StringBuilder(41).append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(" cannot be less than 0, current value is ").append(this.configuredDeletionMaxSegmentsPerRun()).toString());
        }
        if (Predef$.MODULE$.Long2long(newConfig.logDeletionThrottlerDiskFreeHeadroomBytes()) <= 0L) {
            throw new ConfigException(new StringBuilder(34).append(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp()).append(" cannot be <= 0, current value is ").append(this.configuredDiskFreeHeadroomBytes()).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer n = this.configuredDeletionMaxSegmentsPerRun();
        Integer n2 = newConfig.logDeletionMaxSegmentsPerRun();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Reconfigure ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(" from ").append(this.configuredDeletionMaxSegmentsPerRun()).append(" to ").append(newConfig.logDeletionMaxSegmentsPerRun()).toString());
            this.configuredDeletionMaxSegmentsPerRun_$eq(newConfig.logDeletionMaxSegmentsPerRun());
        }
        Long l = this.configuredDiskFreeHeadroomBytes();
        Long l2 = newConfig.logDeletionThrottlerDiskFreeHeadroomBytes();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Reconfigure ").append(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp()).append(" from ").append(this.configuredDiskFreeHeadroomBytes()).append(" to ").append(newConfig.logDeletionThrottlerDiskFreeHeadroomBytes()).toString());
            this.configuredDiskFreeHeadroomBytes_$eq(newConfig.logDeletionThrottlerDiskFreeHeadroomBytes());
            this.maybeUpdateDiskFreeThresholdBytes(Predef$.MODULE$.Boolean2boolean(newConfig.enableDiskBasedThrottling()), Predef$.MODULE$.Long2long(newConfig.backPressureDiskThresholdBytes()));
            return;
        }
    }

    public void maybeUpdateDiskFreeThresholdBytes(boolean enableDiskBasedThrottling, long backPressureDiskThresholdBytes) {
        long newDiskFreeThresholdBytes = SegmentDeletionThrottlerConfig$.MODULE$.diskFreeThresholdBytes(Predef$.MODULE$.Long2long(this.configuredDiskFreeHeadroomBytes()), enableDiskBasedThrottling, backPressureDiskThresholdBytes);
        if (this.diskFreeThresholdBytes() != newDiskFreeThresholdBytes) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Update disk free threshold bytes from ").append(this.diskFreeThresholdBytes()).append(" to ").append(newDiskFreeThresholdBytes).toString());
            this._diskFreeThresholdBytes_$eq(newDiskFreeThresholdBytes);
            return;
        }
    }

    public int deletionMaxSegmentsPerRun(Seq<File> logDirs) {
        long currentTimeMs = this.time.milliseconds();
        long nextDiskUsageCheckTimeMs = this.lastDiskUsageCheckTimeMs() + (long)this.diskCheckDelayMs;
        if (nextDiskUsageCheckTimeMs <= currentTimeMs) {
            this.maybeDisableDeletionMaxSegmentsPerRun(logDirs, currentTimeMs);
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Current time: ").append(currentTimeMs).append(" (ms), early to check disk usage for ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(",").append(" next allowed disk usage check at: ").append(nextDiskUsageCheckTimeMs).append(" (ms)").toString());
        }
        if (this.isDeletionMaxSegmentsPerRunEnabled()) {
            return Predef$.MODULE$.Integer2int(this.configuredDeletionMaxSegmentsPerRun());
        }
        return Integer.MAX_VALUE;
    }

    private void maybeDisableDeletionMaxSegmentsPerRun(Seq<File> logDirs, long currentTimeMs) {
        if (!BoxesRunTime.equalsNumObject((Number)this.configuredDeletionMaxSegmentsPerRun(), (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.LogDeletionMaxSegmentsPerRun()))) {
            this.lastDiskUsageCheckTimeMs_$eq(currentTimeMs);
            long minDiskUsableBytes = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.fileStores(logDirs).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$));
            long currentDiskFreeThresholdBytes = this.diskFreeThresholdBytes();
            if (minDiskUsableBytes < currentDiskFreeThresholdBytes) {
                if (this.isDeletionMaxSegmentsPerRunEnabled()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Free disk space: ").append(minDiskUsableBytes).append(" is lower than the threshold: ").append(currentDiskFreeThresholdBytes).append(",").append(" disabling ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).toString());
                    this.isDeletionMaxSegmentsPerRunEnabled_$eq(false);
                    return;
                }
                return;
            }
            if (!this.isDeletionMaxSegmentsPerRunEnabled()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Re-enabling ").append(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp()).append(" at ").append(this.configuredDeletionMaxSegmentsPerRun()).toString());
                this.isDeletionMaxSegmentsPerRunEnabled_$eq(true);
                return;
            }
            return;
        }
    }

    public SegmentDeletionThrottlerConfig(Time time, KafkaConfig config, int diskCheckDelayMs) {
        this.time = time;
        this.diskCheckDelayMs = diskCheckDelayMs;
        this.configuredDeletionMaxSegmentsPerRun = config.logDeletionMaxSegmentsPerRun();
        this.configuredDiskFreeHeadroomBytes = config.logDeletionThrottlerDiskFreeHeadroomBytes();
        this._diskFreeThresholdBytes = SegmentDeletionThrottlerConfig$.MODULE$.diskFreeThresholdBytes(Predef$.MODULE$.Long2long(this.configuredDiskFreeHeadroomBytes()), Predef$.MODULE$.Boolean2boolean(config.enableDiskBasedThrottling()), Predef$.MODULE$.Long2long(config.backPressureDiskThresholdBytes()));
        this.isDeletionMaxSegmentsPerRunEnabled = true;
        this.lastDiskUsageCheckTimeMs = time.milliseconds();
    }
}

