/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.common.TenantHelpers;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.ConsumerLagEmitterSummary;
import kafka.metrics.MemberTopicPartition;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rEq!B'O\u0011\u0003\u0019f!B+O\u0011\u00031\u0006\"B/\u0002\t\u0003q\u0006\"B0\u0002\t\u0003\u0001\u0007\"\u0003BR\u0003E\u0005I\u0011\u0001BS\u0011%\u0011Y,\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003D\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011)-\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003H\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011I-\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003L\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011i-\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003P\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011\t.\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003T\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011).\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003X\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011I.\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003\\\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011i.\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003`\u0006\u0001\u000b\u0011\u0002B`\u0011%\u0011\t/\u0001b\u0001\n\u0003\u0011i\f\u0003\u0005\u0003d\u0006\u0001\u000b\u0011\u0002B`\u0011)\u0011)/\u0001b\u0001\n\u0003q%q\u001d\u0005\t\u0005g\f\u0001\u0015!\u0003\u0003j\"I!Q_\u0001C\u0002\u0013%!q\u001d\u0005\t\u0005o\f\u0001\u0015!\u0003\u0003j\"I!\u0011`\u0001C\u0002\u0013%!1 \u0005\t\u0007\u0013\t\u0001\u0015!\u0003\u0003~\"I11B\u0001C\u0002\u0013%!1 \u0005\t\u0007\u001b\t\u0001\u0015!\u0003\u0003~\"I1qB\u0001\u0012\u0002\u0013\u0005!Q\u0015\u0004\u0005+:\u0003!\r\u0003\u0005PA\t\u0015\r\u0011\"\u0001d\u0011!\u0001\bE!A!\u0002\u0013!\u0007\u0002C9!\u0005\u000b\u0007I\u0011\u0001:\t\u0011m\u0004#\u0011!Q\u0001\nMD\u0001\u0002 \u0011\u0003\u0006\u0004%\t! \u0005\n\u0003\u001b\u0001#\u0011!Q\u0001\nyD!\"a\u0004!\u0005\u000b\u0007I\u0011AA\t\u0011)\tI\u0002\tB\u0001B\u0003%\u00111\u0003\u0005\u000b\u00037\u0001#Q1A\u0005\u0002\u0005u\u0001BCA\u0017A\t\u0005\t\u0015!\u0003\u0002 !1Q\f\tC\u0001\u0003_A!\"a\u000f!\u0005\u0004%\tATA\u001f\u0011!\t9\b\tQ\u0001\n\u0005}\u0002\"CA=A\u0001\u0007I\u0011BA>\u0011%\t\u0019\t\ta\u0001\n\u0013\t)\t\u0003\u0005\u0002\u0012\u0002\u0002\u000b\u0015BA?\u0011%\tY\n\ta\u0001\n\u0013\tY\bC\u0005\u0002\u001e\u0002\u0002\r\u0011\"\u0003\u0002 \"A\u00111\u0015\u0011!B\u0013\ti\bC\u0005\u0002(\u0002\u0002\r\u0011\"\u0003\u0002|!I\u0011\u0011\u0016\u0011A\u0002\u0013%\u00111\u0016\u0005\t\u0003_\u0003\u0003\u0015)\u0003\u0002~!I\u00111\u0017\u0011A\u0002\u0013%\u00111\u0010\u0005\n\u0003k\u0003\u0003\u0019!C\u0005\u0003oC\u0001\"a/!A\u0003&\u0011Q\u0010\u0005\n\u0003\u007f\u0003\u0003\u0019!C\u0005\u0003#A\u0011\"!1!\u0001\u0004%I!a1\t\u0011\u0005\u001d\u0007\u0005)Q\u0005\u0003'A\u0011\"a3!\u0001\u0004%I!!\u0005\t\u0013\u00055\u0007\u00051A\u0005\n\u0005=\u0007\u0002CAjA\u0001\u0006K!a\u0005\t\u0013\u0005]\u0007\u00051A\u0005\n\u0005E\u0001\"CAmA\u0001\u0007I\u0011BAn\u0011!\ty\u000e\tQ!\n\u0005M\u0001bBArA\u0011\u0005\u0011Q\u001d\u0005\b\u0003O\u0004C\u0011AAs\u0011\u001d\tI\u000f\tC\u0001\u0003KD\u0001\"a;!\t\u0003q\u0015Q\u001e\u0005\b\u0003k\u0004C\u0011BA|\u0011\u001d\u0011)\u0002\tC\u0005\u0005/AqA!\u0013!\t\u0013\u0011Y\u0005C\u0004\u0003j\u0001\"IAa\u001b\t\u000f\t=\u0004\u0005\"\u0003\u0003r!A!1\u000f\u0011\u0005\u00029\u0013)(\u0001\nD_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u0014(BA(Q\u0003\u001diW\r\u001e:jGNT\u0011!U\u0001\u0006W\u000647.Y\u0002\u0001!\t!\u0016!D\u0001O\u0005I\u0019uN\\:v[\u0016\u0014H*Y4F[&$H/\u001a:\u0014\u0005\u00059\u0006C\u0001-\\\u001b\u0005I&\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002'\u0006)\u0011\r\u001d9msRI\u0011M!!\u0003\u0004\n\u0015%q\u0011\t\u0003)\u0002\u001a\"\u0001I,\u0016\u0003\u0011\u0004\"!\u001a8\u000e\u0003\u0019T!aT4\u000b\u0005!L\u0017AB2p[6|gN\u0003\u0002RU*\u00111\u000e\\\u0001\u0007CB\f7\r[3\u000b\u00035\f1a\u001c:h\u0013\tygMA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\tU$\u0018\u000e\u001c\u0006\u0003q&\faa]3sm\u0016\u0014\u0018B\u0001>v\u0005%\u00196\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\n\u0001c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003y\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011!B4s_V\u0004(bAA\u0004S\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\tY!!\u0001\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018!E4s_V\u00048i\\8sI&t\u0017\r^8sA\u0005qQ-\\5u\u0013:$XM\u001d<bY6\u001bXCAA\n!\rA\u0016QC\u0005\u0004\u0003/I&\u0001\u0002'p]\u001e\fq\"Z7ji&sG/\u001a:wC2l5\u000fI\u0001\u0006C\u0012l\u0017N\\\u000b\u0003\u0003?\u0001B!!\t\u0002*5\u0011\u00111\u0005\u0006\u0005\u00037\t)CC\u0002\u0002(%\fqa\u00197jK:$8/\u0003\u0003\u0002,\u0005\r\"!B!e[&t\u0017AB1e[&t\u0007\u0005F\u0006b\u0003c\t\u0019$!\u000e\u00028\u0005e\u0002\"B(,\u0001\u0004!\u0007\"B9,\u0001\u0004\u0019\b\"\u0002?,\u0001\u0004q\b\"CA\bWA\u0005\t\u0019AA\n\u0011\u001d\tYb\u000ba\u0001\u0003?\t!cY8ogVlWM\u001d'bO6+GO]5dgV\u0011\u0011q\b\t\t\u0003\u0003\nY%a\u0014\u0002f5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0004nkR\f'\r\\3\u000b\u0007\u0005%\u0013,\u0001\u0006d_2dWm\u0019;j_:LA!!\u0014\u0002D\t\u0019Q*\u00199\u0011\t\u0005E\u0013q\f\b\u0005\u0003'\nY\u0006E\u0002\u0002Vek!!a\u0016\u000b\u0007\u0005e#+\u0001\u0004=e>|GOP\u0005\u0004\u0003;J\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002b\u0005\r$AB*ue&twMC\u0002\u0002^e\u0003\u0002\"a\u001a\u0002n\u0005E\u00141C\u0007\u0003\u0003SR1!a\u001bg\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u0002p\u0005%$AC$bk\u001e,7+^5uKB\u0019A+a\u001d\n\u0007\u0005UdJ\u0001\u000bNK6\u0014WM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0014G>t7/^7fe2\u000bw-T3ue&\u001c7\u000fI\u0001\u0011kB$\u0017\r^3e\u000fJ|W\u000f]*ju\u0016,\"!! \u0011\u0007a\u000by(C\u0002\u0002\u0002f\u00131!\u00138u\u0003Q)\b\u000fZ1uK\u0012<%o\\;q'&TXm\u0018\u0013fcR!\u0011qQAG!\rA\u0016\u0011R\u0005\u0004\u0003\u0017K&\u0001B+oSRD\u0011\"a$0\u0003\u0003\u0005\r!! \u0002\u0007a$\u0013'A\tva\u0012\fG/\u001a3He>,\boU5{K\u0002B3\u0001MAK!\rA\u0016qS\u0005\u0004\u00033K&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002)I,'-\u00197b]\u000eLgnZ$s_V\u00048+\u001b>f\u0003a\u0011XMY1mC:\u001c\u0017N\\4He>,\boU5{K~#S-\u001d\u000b\u0005\u0003\u000f\u000b\t\u000bC\u0005\u0002\u0010J\n\t\u00111\u0001\u0002~\u0005)\"/\u001a2bY\u0006t7-\u001b8h\u000fJ|W\u000f]*ju\u0016\u0004\u0003fA\u001a\u0002\u0016\u0006ya-Y5mK\u0012<%o\\;q'&TX-A\ngC&dW\rZ$s_V\u00048+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u00065\u0006\"CAHk\u0005\u0005\t\u0019AA?\u0003A1\u0017-\u001b7fI\u001e\u0013x.\u001e9TSj,\u0007\u0005K\u00027\u0003+\u000b\u0001#\u001a=qSJ,Gm\u0012:pkB\u001c\u0016N_3\u0002)\u0015D\b/\u001b:fI\u001e\u0013x.\u001e9TSj,w\fJ3r)\u0011\t9)!/\t\u0013\u0005=\u0005(!AA\u0002\u0005u\u0014!E3ya&\u0014X\rZ$s_V\u00048+\u001b>fA!\u001a\u0011(!&\u0002\u00175,GO]5dgNK'0Z\u0001\u0010[\u0016$(/[2t'&TXm\u0018\u0013fcR!\u0011qQAc\u0011%\tyiOA\u0001\u0002\u0004\t\u0019\"\u0001\u0007nKR\u0014\u0018nY:TSj,\u0007\u0005K\u0002=\u0003+\u000bQ\"\u001a=fGV$\u0018n\u001c8US6,\u0017!E3yK\u000e,H/[8o)&lWm\u0018\u0013fcR!\u0011qQAi\u0011%\tyIPA\u0001\u0002\u0004\t\u0019\"\u0001\bfq\u0016\u001cW\u000f^5p]RKW.\u001a\u0011)\u0007}\n)*A\nmCN$8+^2dKN\u001ch-\u001e7Sk:l5/A\fmCN$8+^2dKN\u001ch-\u001e7Sk:l5o\u0018\u0013fcR!\u0011qQAo\u0011%\ty)QA\u0001\u0002\u0004\t\u0019\"\u0001\u000bmCN$8+^2dKN\u001ch-\u001e7Sk:l5\u000f\t\u0015\u0004\u0005\u0006U\u0015!B:uCJ$HCAAD\u0003!\u0019\b.\u001e;e_^t\u0017aD3nSR\u001cuN\\:v[\u0016\u0014H*Y4\u00021\u0019,Go\u00195PM\u001a\u001cX\r^:B]\u0012\u0014VmY8sI2\u000bw\r\u0006\u0002\u0002pB\u0019A+!=\n\u0007\u0005MhJA\rD_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u00148+^7nCJL\u0018AE7bW\u0016\u0014V-];fgR\u001cuN\u001c;fqR$B!!?\u0003\u0006A!\u00111 B\u0001\u001b\t\tiPC\u0002\u0002\u0000\u001e\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005\u0007\tiP\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\t\u001dq\t1\u0001\u0003\n\u00051\u0011\r]5LKf\u0004BAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0004\u0005\u001f9\u0017\u0001\u00039s_R|7m\u001c7\n\t\tM!Q\u0002\u0002\b\u0003BL7*Z=t\u00039!Wm]2sS\n,wI]8vaN$BA!\u0007\u0003@A1!1\u0004B\u0013\u0005WqAA!\b\u0003\"9!\u0011Q\u000bB\u0010\u0013\u0005Q\u0016b\u0001B\u00123\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0014\u0005S\u0011A\u0001T5ti*\u0019!1E-\u0011\t\t5\"\u0011\b\b\u0005\u0005_\u0011)$\u0004\u0002\u00032)\u0019!1G4\u0002\u000f5,7o]1hK&!!q\u0007B\u0019\u0003i!Um]2sS\n,wI]8vaN\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011YD!\u0010\u0003\u001d\u0011+7o\u0019:jE\u0016$wI]8va*!!q\u0007B\u0019\u0011\u001d\u0011\t\u0005\u0013a\u0001\u0005\u0007\naa\u001d;bi\u0016\u001c\bCBA)\u0005\u000b\ny%\u0003\u0003\u0003H\u0005\r$aA*fi\u0006ya-\u001a;dQ\u0006cGn\u00144gg\u0016$8\u000f\u0006\u0003\u0003N\t\u0015\u0004\u0003CA!\u0003\u0017\u0012yEa\u0016\u0011\t\tE#1K\u0007\u0002O&\u0019!QK4\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!!\u0011\fB0\u001d\u0011\u0011yCa\u0017\n\t\tu#\u0011G\u0001\u0018\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/\u001a#bi\u0006LAA!\u0019\u0003d\tirJ\u001a4tKR4U\r^2i%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>t7O\u0003\u0003\u0003^\tE\u0002b\u0002B4\u0013\u0002\u0007\u0011qJ\u0001\bOJ|W\u000f]%e\u0003A\u0019'/Z1uK\u001e\u000bWoZ3Tk&$X\r\u0006\u0003\u0002f\t5\u0004b\u0002B4\u0015\u0002\u0007\u0011qJ\u0001\u0013GV\u0014(/\u001a8u\u001b\u0016$(/[2t'&TX\r\u0006\u0002\u0002\u0014\u0005aS.Y=cKB\u0013XMZ5y)>\u0004\u0018n\u0019)beRLG/[8og^KG\u000f\u001b+f]\u0006tGOR;oGRLwN\u001c\u000b\u0005\u0005o\u0012y\bE\u0004Y\u0005s\u0012iH! \n\u0007\tm\u0014LA\u0005Gk:\u001cG/[8ocA1!1\u0004B\u0013\u0005\u001fBqAa\u001aM\u0001\u0004\ty\u0005C\u0003P\u0007\u0001\u0007A\rC\u0003}\u0007\u0001\u0007a\u0010C\u0005\u0002\u0010\r\u0001\n\u00111\u0001\u0002\u0014!9!\u0011R\u0002A\u0002\t-\u0015AC1e[&t\u0007K]8qgBA!Q\u0012BK\u0003\u001f\u00129*\u0004\u0002\u0003\u0010*\u0019aO!%\u000b\u0005\tM\u0015\u0001\u00026bm\u0006LA!!\u0014\u0003\u0010B!!\u0011\u0014BP\u001b\t\u0011YJ\u0003\u0003\u0003\u001e\nE\u0015\u0001\u00027b]\u001eLAA!)\u0003\u001c\n1qJ\u00196fGR\fq\"\u00199qYf$C-\u001a4bk2$HeM\u000b\u0003\u0005OSC!a\u0005\u0003*.\u0012!1\u0016\t\u0005\u0005[\u00139,\u0004\u0002\u00030*!!\u0011\u0017BZ\u0003%)hn\u00195fG.,GMC\u0002\u00036f\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011ILa,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000bD_:\u001cX/\\3s\u0019\u0006<W*\u001a;sS\u000et\u0015-\\3\u0016\u0005\t}\u0006\u0003\u0002BM\u0005\u0003LA!!\u0019\u0003\u001c\u000612i\u001c8tk6,'\u000fT1h\u001b\u0016$(/[2OC6,\u0007%A\bNKR\u0014\u0018nY$s_V\u0004h*Y7f\u0003AiU\r\u001e:jG\u001e\u0013x.\u001e9OC6,\u0007%\u0001\u000eVa\u0012\fG/\u001a3He>,\boU5{K6+GO]5d\u001d\u0006lW-A\u000eVa\u0012\fG/\u001a3He>,\boU5{K6+GO]5d\u001d\u0006lW\rI\u0001\u001f%\u0016\u0014\u0017\r\\1oG&twm\u0012:pkB\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\fqDU3cC2\fgnY5oO\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003e1\u0015-\u001b7fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3\u00025\u0019\u000b\u0017\u000e\\3e\u000fJ|W\u000f]*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u00025\u0015C\b/\u001b:fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3\u00027\u0015C\b/\u001b:fI\u001e\u0013x.\u001e9TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003UiU\r\u001e:jGN\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\fa#T3ue&\u001c7oU5{K6+GO]5d\u001d\u0006lW\rI\u0001\u0018\u000bb,7-\u001e;j_:$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\f\u0001$\u0012=fGV$\u0018n\u001c8US6,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0019\"\u0016.\\3TS:\u001cW\rT1tiN+8mY3tg\u001a,HNU;o\u001bNlU\r\u001e:jG:\u000bW.Z\u0001()&lWmU5oG\u0016d\u0015m\u001d;Tk\u000e\u001cWm]:gk2\u0014VO\\'t\u001b\u0016$(/[2OC6,\u0007%A\u0006WC2LGm\u0015;bi\u0016\u001cXC\u0001Bu!\u0019\u0011YO!=\u0003@6\u0011!Q\u001e\u0006\u0005\u0005_\f9%A\u0005j[6,H/\u00192mK&!!q\tBw\u000311\u0016\r\\5e'R\fG/Z:!\u0003E\u0011VMY1mC:\u001c\u0017N\\4Ti\u0006$Xm]\u0001\u0013%\u0016\u0014\u0017\r\\1oG&twm\u0015;bi\u0016\u001c\b%A\u0002m_\u001e,\"A!@\u0011\t\t}8QA\u0007\u0003\u0007\u0003Q1aa\u0001m\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\u00199a!\u0001\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u001b\u001d\fWoZ3Tk&$X\rT8h\u000399\u0017-^4f'VLG/\u001a'pO\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class ConsumerLagEmitter {
    private final Metrics metrics;
    private final Scheduler scheduler;
    private final GroupCoordinator groupCoordinator;
    private final long emitIntervalMs;
    private final Admin admin;
    private final scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics;
    private volatile int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    private volatile int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$metricsSize;
    private volatile long kafka$metrics$ConsumerLagEmitter$$executionTime;
    private volatile long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;

    public static long $lessinit$greater$default$4() {
        return 60000L;
    }

    public static String TimeSinceLastSuccessfulRunMsMetricName() {
        return ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName();
    }

    public static String ExecutionTimeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName();
    }

    public static String MetricsSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName();
    }

    public static String ExpiredGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName();
    }

    public static String FailedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName();
    }

    public static String RebalancingGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName();
    }

    public static String UpdatedGroupSizeMetricName() {
        return ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName();
    }

    public static String MetricGroupName() {
        return ConsumerLagEmitter$.MODULE$.MetricGroupName();
    }

    public static String ConsumerLagMetricName() {
        return ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName();
    }

    public static long apply$default$3() {
        return 60000L;
    }

    public static ConsumerLagEmitter apply(Metrics metrics, GroupCoordinator groupCoordinator, long emitIntervalMs, Map<String, Object> adminProps) {
        return ConsumerLagEmitter$.MODULE$.apply(metrics, groupCoordinator, emitIntervalMs, adminProps);
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public long emitIntervalMs() {
        return this.emitIntervalMs;
    }

    public Admin admin() {
        return this.admin;
    }

    public scala.collection.mutable.Map<String, GaugeSuite<MemberTopicPartition, Object>> consumerLagMetrics() {
        return this.consumerLagMetrics;
    }

    public int kafka$metrics$ConsumerLagEmitter$$updatedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize;
    }

    private void updatedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize;
    }

    private void rebalancingGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$failedGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize;
    }

    private void failedGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = x$1;
    }

    public int kafka$metrics$ConsumerLagEmitter$$expiredGroupSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize;
    }

    private void expiredGroupSize_$eq(int x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$metricsSize() {
        return this.kafka$metrics$ConsumerLagEmitter$$metricsSize;
    }

    private void metricsSize_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$executionTime() {
        return this.kafka$metrics$ConsumerLagEmitter$$executionTime;
    }

    private void executionTime_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = x$1;
    }

    public long kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs() {
        return this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs;
    }

    private void lastSuccessfulRunMs_$eq(long x$1) {
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = x$1;
    }

    public void start() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter starting up.");
        this.scheduler().startup();
        this.scheduler().schedule("emit-consumer-lag-", () -> this.emitConsumerLag(), this.emitIntervalMs(), this.emitIntervalMs());
    }

    public void shutdown() {
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutting down.");
        this.consumerLagMetrics().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(x$1, gaugeSuite) -> {
            gaugeSuite.close();
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.metrics().removeMetric(this.metrics().metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        this.scheduler().shutdown();
        if (this.admin() != null) {
            this.admin().close();
        }
        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info("Consumer lag emitter shutdown complete.");
    }

    public void emitConsumerLag() {
        try {
            ConsumerLagEmitterSummary result = this.fetchOffsetsAndRecordLag();
            this.updatedGroupSize_$eq(result.updatedGroupSize());
            this.rebalancingGroupSize_$eq(result.rebalancingGroupSize());
            this.failedGroupSize_$eq(result.failedGroupSize());
            this.expiredGroupSize_$eq(result.expiredGroupSize());
            this.metricsSize_$eq(result.metricsSize());
            this.executionTime_$eq(result.executionTime());
            this.lastSuccessfulRunMs_$eq(System.currentTimeMillis());
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().info(new StringBuilder(113).append("Updated lag of ").append(this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize()).append(" groups, ").append("ignored ").append(this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize()).append(" rebalancing groups, ").append("failed to update ").append(this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize()).append(" groups due to errors, ").append("and expired ").append(this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize()).append(" groups.").toString());
            return;
        }
        catch (Throwable t) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().error("Could not update consumer lag metrics.", t);
            return;
        }
    }

    public ConsumerLagEmitterSummary fetchOffsetsAndRecordLag() {
        long startTime = System.currentTimeMillis();
        scala.collection.mutable.Map groupsToCurrentOffsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Set rebalancingGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.mutable.Set failedGroups = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.describeGroups(ConsumerLagEmitter$.MODULE$.ValidStates()).foreach((Function1 & Serializable)describedGroup -> {
            String groupId = describedGroup.groupId();
            if (describedGroup.errorCode() == Errors.NOT_COORDINATOR.code()) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                return BoxedUnit.UNIT;
            }
            if (describedGroup.errorCode() != Errors.NONE.code()) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(62).append("Could not describe group ").append(groupId).append(" due to ").append(Errors.forCode((short)describedGroup.errorCode())).append(". ").append("Will retry in the next run.").toString());
                return failedGroups.$plus$eq((Object)groupId);
            }
            String string = describedGroup.protocolType();
            String string2 = "consumer";
            if (string == null || !string.equals(string2)) {
                ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(44).append("Group ").append(groupId).append(" is not a consumer group. Ignoring it.").toString());
                return BoxedUnit.UNIT;
            }
            if (ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$RebalancingStates().contains((Object)describedGroup.groupState())) {
                return rebalancingGroups.$plus$eq((Object)groupId);
            }
            String string3 = describedGroup.groupState();
            String string4 = ConsumerGroupState.STABLE.toString();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Growable growable;
                try {
                    scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> currentOffsets = this.fetchAllOffsets(groupId);
                    scala.collection.mutable.Map memberTopicPartitions = (scala.collection.mutable.Map)groupsToCurrentOffsets.getOrElse((Object)groupId, (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.empty());
                    Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitions = this.maybePrefixTopicPartitionsWithTenantFunction(groupId);
                    CollectionConverters$.MODULE$.ListHasAsScala(describedGroup.members()).asScala().foreach((Function1 & Serializable)member -> {
                        ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$3(maybePrefixTopicPartitions, currentOffsets, groupId, memberTopicPartitions, member);
                        return BoxedUnit.UNIT;
                    });
                    if (!memberTopicPartitions.nonEmpty()) {
                        return BoxedUnit.UNIT;
                    }
                    growable = groupsToCurrentOffsets.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupId), (Object)memberTopicPartitions));
                }
                catch (NotCoordinatorException notCoordinatorException) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(69).append("Ignoring group ").append(groupId).append(" because it is not hosted on this coordinator anymore.").toString());
                    return BoxedUnit.UNIT;
                }
                catch (Throwable t) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(70).append("Could not fetch offsets of group ").append(groupId).append(" due to ").append(t.getMessage()).append(". Will retry in the next run.").toString());
                    growable = failedGroups.$plus$eq((Object)groupId);
                }
                return growable;
            }
            return BoxedUnit.UNIT;
        });
        if (groupsToCurrentOffsets.nonEmpty()) {
            Map latestOffsetSpec = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)groupsToCurrentOffsets.flatMap((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (scala.collection.mutable.Map)((scala.collection.mutable.Map)x0$1._2()).map((Function1 & Serializable)x0$2 -> {
                        if (x0$2 != null) {
                            MemberTopicPartition memberTopicPartition = (MemberTopicPartition)x0$2._1();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition.topicPartition()), (Object)new OffsetSpec.LatestSpec());
                        }
                        throw new MatchError(null);
                    });
                }
                throw new MatchError(null);
            })).asJava();
            ListOffsetsResult result = this.admin().listOffsets(latestOffsetSpec);
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(groupId, memberTopicPartitions) -> {
                GaugeSuite groupGaugeSuite = (GaugeSuite)this.consumerLagMetrics().getOrElse(groupId, (Function0 & Serializable)() -> this.createGaugeSuite((String)groupId));
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(memberTopicPartition, currentOffset) -> {
                    ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$9(result, groupGaugeSuite, memberTopicPartition, BoxesRunTime.unboxToLong((Object)currentOffset));
                    return BoxedUnit.UNIT;
                };
                memberTopicPartitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var5_5 = null;
                return (scala.collection.mutable.Map)this.consumerLagMetrics().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupId), (Object)groupGaugeSuite));
            };
            groupsToCurrentOffsets.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var11_7 = null;
        }
        scala.collection.immutable.Set expiredGroups = ((MapOps)this.consumerLagMetrics().filterNot((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$10(groupsToCurrentOffsets, rebalancingGroups, failedGroups, x0$3)))).keys().toSet();
        expiredGroups.foreach((Function1 & Serializable)groupId -> {
            ConsumerLagEmitter.$anonfun$fetchOffsetsAndRecordLag$12(this, groupId);
            return BoxedUnit.UNIT;
        });
        long executionTime = System.currentTimeMillis() - startTime;
        return new ConsumerLagEmitterSummary(groupsToCurrentOffsets.keySet().size(), rebalancingGroups.size(), failedGroups.size(), expiredGroups.size(), this.currentMetricsSize(), executionTime);
    }

    private RequestContext makeRequestContext(ApiKeys apiKey) {
        return new RequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), ConsumerLagEmitter$.MODULE$.MetricGroupName(), 0), "-1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
    }

    private List<DescribeGroupsResponseData.DescribedGroup> describeGroups(scala.collection.immutable.Set<String> states) {
        try {
            return (List)((CompletableFuture)this.groupCoordinator().listGroups(this.makeRequestContext(ApiKeys.LIST_GROUPS), new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)states.toList()).asJava())).thenCompose(listGroupsResult -> {
                if (listGroupsResult.errorCode() != Errors.NONE.code()) {
                    CompletableFuture future = new CompletableFuture();
                    future.completeExceptionally(Errors.forCode((short)listGroupsResult.errorCode()).exception());
                    return future;
                }
                if (listGroupsResult.groups().isEmpty()) {
                    CompletableFuture<List> future = new CompletableFuture<List>();
                    future.complete(package$.MODULE$.List().empty());
                    return future;
                }
                return this.groupCoordinator().describeGroups(this.makeRequestContext(ApiKeys.DESCRIBE_GROUPS), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(listGroupsResult.groups()).asScala().map((Function1 & Serializable)x$3 -> x$3.groupId())).asJava()).thenApply(x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toList());
            })).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
    }

    private scala.collection.mutable.Map<TopicPartition, OffsetFetchResponseData.OffsetFetchResponsePartitions> fetchAllOffsets(String groupId) {
        try {
            return (scala.collection.mutable.Map)((CompletableFuture)this.groupCoordinator().fetchAllOffsets(this.makeRequestContext(ApiKeys.OFFSET_FETCH), groupId, false).thenApply(response -> {
                HashMap byTopicPartitions = new HashMap();
                response.forEach(topic -> topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                    byTopicPartitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), partition));
                }));
                return byTopicPartitions;
            })).get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                throw executionException.getCause();
            }
            throw throwable;
        }
    }

    private GaugeSuite<MemberTopicPartition, Object> createGaugeSuite(String groupId) {
        return new GaugeSuite(ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$gaugeSuiteLog(), new StringBuilder(21).append("consumer-lag-emitter-").append(groupId).toString(), this.metrics(), memberTopicPartition -> this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", "The group member's consumer lag in offsets.", CollectionConverters$.MODULE$.MutableMapHasAsJava(memberTopicPartition.tags()).asJava()));
    }

    private long currentMetricsSize() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.consumerLagMetrics().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ConsumerLagEmitter.$anonfun$currentMetricsSize$1(x0$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Function1<List<TopicPartition>, List<TopicPartition>> maybePrefixTopicPartitionsWithTenantFunction(String groupId) {
        if (TenantHelpers.isTenantPrefixed(groupId)) {
            return arg_0 -> ConsumerLagEmitter.$anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(TenantHelpers.extractTenantPrefix(groupId), arg_0);
        }
        return (Function1 & Serializable)topicPartitions -> topicPartitions;
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$3(Function1 maybePrefixTopicPartitions$1, scala.collection.mutable.Map currentOffsets$1, String groupId$1, scala.collection.mutable.Map memberTopicPartitions$1, DescribeGroupsResponseData.DescribedGroupMember member) {
        try {
            ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.memberAssignment()));
            ((List)maybePrefixTopicPartitions$1.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(assignment.partitions()).asScala().toList())).foreach((Function1 & Serializable)topicPartition -> {
                Option option = currentOffsets$1.get(topicPartition);
                if (option instanceof Some) {
                    Errors error;
                    OffsetFetchResponseData.OffsetFetchResponsePartitions currentOffset = (OffsetFetchResponseData.OffsetFetchResponsePartitions)((Some)option).value();
                    Errors errors = error = Errors.forCode((short)currentOffset.errorCode());
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(93).append("Could not get committed offset for group ").append(groupId$1).append(" and partition ").append(topicPartition).append(" due to ").append(error).append(". Will retry in the next run.").toString());
                        return BoxedUnit.UNIT;
                    }
                    MemberTopicPartition memberTopicPartition = new MemberTopicPartition(groupId$1, (Option<String>)Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), (TopicPartition)topicPartition);
                    return memberTopicPartitions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberTopicPartition), (Object)BoxesRunTime.boxToLong((long)currentOffset.committedOffset())));
                }
                if (None$.MODULE$.equals(option)) {
                    ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(72).append("Group coordinator does not have offsets for group ").append(groupId$1).append(" and topic partition ").append(topicPartition).append(".").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
            return;
        }
        catch (SchemaException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(66).append("Failed to deserialize assignment(length=").append(member.memberAssignment().length).append(") for group ").append(groupId$1).append(" and member ").append(member.memberId()).append(": ").append(e.getMessage()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$9(ListOffsetsResult result$1, GaugeSuite groupGaugeSuite$1, MemberTopicPartition memberTopicPartition, long currentOffset) {
        try {
            long latestOffset = ((ListOffsetsResult.ListOffsetsResultInfo)result$1.partitionResult(memberTopicPartition.topicPartition()).get()).offset();
            long consumerLag = latestOffset - currentOffset;
            if (consumerLag >= 0L) {
                groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)consumerLag));
                return;
            }
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().warn(new StringBuilder(115).append("Consumer lag of member ").append(memberTopicPartition).append(" is negative. Latest offset is ").append(latestOffset).append(" ").append("and committed offset is ").append(currentOffset).append(". The topic may have been recreated.").toString());
            groupGaugeSuite$1.update((Object)memberTopicPartition, (Object)BoxesRunTime.boxToLong((long)0L));
        }
        catch (ExecutionException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Could not list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause().getMessage()).toString());
            return;
        }
        catch (InterruptedException e) {
            ConsumerLagEmitter$.MODULE$.kafka$metrics$ConsumerLagEmitter$$log().debug(new StringBuilder(45).append("Unable to list offsets for partition ").append(memberTopicPartition.topicPartition()).append(" due to ").append(e.getCause()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetsAndRecordLag$10(scala.collection.mutable.Map groupsToCurrentOffsets$1, scala.collection.mutable.Set rebalancingGroups$1, scala.collection.mutable.Set failedGroups$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String groupId = (String)x0$3._1();
            GaugeSuite groupGaugeSuite = (GaugeSuite)x0$3._2();
            if (groupsToCurrentOffsets$1.contains((Object)groupId)) {
                Set currentMemberTopicPartitions = ((MapOps)groupsToCurrentOffsets$1.apply((Object)groupId)).keySet();
                ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(groupGaugeSuite.keySet()).asScala().diff(currentMemberTopicPartitions)).foreach((Function1 & Serializable)x$1 -> {
                    groupGaugeSuite.remove((Object)x$1);
                    return BoxedUnit.UNIT;
                });
                groupGaugeSuite.flush();
                return groupGaugeSuite.keySet().size() != 0;
            }
            return rebalancingGroups$1.contains((Object)groupId) || failedGroups$1.contains((Object)groupId);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$fetchOffsetsAndRecordLag$12(ConsumerLagEmitter $this, String groupId) {
        $this.consumerLagMetrics().remove((Object)groupId).foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$currentMetricsSize$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((GaugeSuite)x0$1._2()).keySet().size();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ List $anonfun$maybePrefixTopicPartitionsWithTenantFunction$1(String prefix$1, List topicPartitions) {
        return topicPartitions.map((Function1 & Serializable)x$5 -> TenantHelpers.prefixWithTenant(prefix$1, x$5));
    }

    public ConsumerLagEmitter(Metrics metrics, Scheduler scheduler, GroupCoordinator groupCoordinator, long emitIntervalMs, Admin admin) {
        this.metrics = metrics;
        this.scheduler = scheduler;
        this.groupCoordinator = groupCoordinator;
        this.emitIntervalMs = emitIntervalMs;
        this.admin = admin;
        this.consumerLagMetrics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$updatedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$rebalancingGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$failedGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$failedGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize = 0;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public int value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$expiredGroupSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$metricsSize = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$metricsSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$executionTime = 0L;
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.ExecutionTimeMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return this.$outer.kafka$metrics$ConsumerLagEmitter$$executionTime();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs = System.currentTimeMillis();
        metrics.addMetric(metrics.metricName(ConsumerLagEmitter$.MODULE$.TimeSinceLastSuccessfulRunMsMetricName(), ConsumerLagEmitter$.MODULE$.MetricGroupName()), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ ConsumerLagEmitter $outer;

            public long value(MetricConfig config, long now) {
                return System.currentTimeMillis() - this.$outer.kafka$metrics$ConsumerLagEmitter$$lastSuccessfulRunMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

