/*
 * Decompiled with CFR 0.152.
 */
package kafka.migration;

import com.yammer.metrics.core.Gauge;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t-c\u0001B\u00193\u0001]B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0001\f\u0001B\u0001B\u0003%\u0011\fC\u0003g\u0001\u0011\u0005q\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\rM\u0004\u0001\u0015!\u0003p\u0011\u001d!\bA1A\u0005\nUDa\u0001 \u0001!\u0002\u00131\bbB?\u0001\u0005\u0004%IA \u0005\b\u0003'\u0001\u0001\u0015!\u0003\u0000\u0011!\t)\u0002\u0001b\u0001\n\u0013q\bbBA\f\u0001\u0001\u0006Ia \u0005\t\u00033\u0001!\u0019!C\u0005}\"9\u00111\u0004\u0001!\u0002\u0013y\b\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\t9\u0003\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\tY\u0005\u0001Q\u0001\n\u00055\u0002\u0002CA'\u0001\u0001\u0007I\u0011\u00028\t\u0013\u0005=\u0003\u00011A\u0005\n\u0005E\u0003bBA/\u0001\u0001\u0006Ka\u001c\u0005\f\u0003?\u0002\u0001\u0019!a\u0001\n\u0013\t\t\u0007C\u0006\u0002p\u0001\u0001\r\u00111A\u0005\n\u0005E\u0004bCA;\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GB1\"a\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002z!Y\u0011q\u0011\u0001A\u0002\u0003\u0007I\u0011BAE\u0011-\ti\t\u0001a\u0001\u0002\u0003\u0006K!a\u001f\t\u0017\u0005=\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0013\u0005\f\u0003_\u0003\u0001\u0019!a\u0001\n\u0013\t\t\fC\u0006\u00026\u0002\u0001\r\u0011!Q!\n\u0005M\u0005bCA\\\u0001\u0001\u0007\t\u0019!C\u0005\u0003sC1\"!1\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D\"Y\u0011q\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BA^\u0011%\tI\r\u0001b\u0001\n\u0013\tY\r\u0003\u0005\u0002\\\u0002\u0001\u000b\u0011BAg\u0011\u001d\ti\u000e\u0001C!\u0003?Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002l\u0002!\t!a9\t\u000f\u00055\b\u0001\"\u0001\u0002d\"1\u0011q\u001e\u0001\u0005\u00029Dq!!=\u0001\t\u0003\ty\u000eC\u0004\u0002t\u0002!\t!!>\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002`\"9!q\u0001\u0001\u0005\n\t%\u0001b\u0002B\u0015\u0001\u0011\u0005!1\u0006\u0005\b\u0005\u000b\u0002A\u0011AAp\u0011\u001d\u00119\u0005\u0001C\u0005\u0003?DqA!\u0013\u0001\t\u0013\tyN\u0001\u000eNS\u001e\u0014\u0018\r^5p]RKWM\u001d+pa&\u001c\u0007K]8ek\u000e,'O\u0003\u00024i\u0005IQ.[4sCRLwN\u001c\u0006\u0002k\u0005)1.\u00194lC\u000e\u00011c\u0001\u00019\u0001B\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$AB(cU\u0016\u001cG\u000f\u0005\u0002:\u0003&\u0011!I\u000f\u0002\t%Vtg.\u00192mK\u000611m\u001c8gS\u001e\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001b\u0002\rM,'O^3s\u0013\tIeIA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!C2mkN$XM]%e!\taUK\u0004\u0002N'B\u0011a*U\u0007\u0002\u001f*\u0011\u0001KN\u0001\u0007yI|w\u000e\u001e \u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)F\u000bA\u0001^5nKB\u0011!\fZ\u0007\u00027*\u0011A,X\u0001\u0006kRLGn\u001d\u0006\u0003=~\u000baaY8n[>t'BA\u001ba\u0015\t\t'-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0006\u0019qN]4\n\u0005\u0015\\&\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003\u00025kW2\u0004\"!\u001b\u0001\u000e\u0003IBQa\u0011\u0003A\u0002\u0011CQA\u0013\u0003A\u0002-CQ\u0001\u0017\u0003A\u0002e\u000b\u0011\"T!Y?J+EKU-\u0016\u0003=\u0004\"\u0001]9\u000e\u0003EK!A])\u0003\u0007%sG/\u0001\u0006N\u0003b{&+\u0012+S3\u0002\n1\u0001\\8h+\u00051\bCA<{\u001b\u0005A(BA=c\u0003\u0015\u0019HN\u001a\u001bk\u0013\tY\bP\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0006j]&$\u0018.\u00197ju\u0016$W#A@\u0011\t\u0005\u0005\u0011qB\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u00051\u0011\r^8nS\u000eTA!!\u0003\u0002\f\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u00055A(\u0001\u0003vi&d\u0017\u0002BA\t\u0003\u0007\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013aB:uCJ$X\rZ\u0001\tgR\f'\u000f^3eA\u000511\r\\8tK\u0012\fqa\u00197pg\u0016$\u0007%\u0001\bqe>$WoY3s)\"\u0014X-\u00193\u0016\u0005\u0005\u0005\u0002c\u0001.\u0002$%\u0019\u0011QE.\u0003\u0017-\u000bgm[1UQJ,\u0017\rZ\u0001\u0010aJ|G-^2feRC'/Z1eA\u0005q\u0011/^3vK\u0012lU\r^1eCR\fWCAA\u0017!\u0019\ty#!\r\u000265\u0011\u0011qA\u0005\u0005\u0003g\t9AA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0004q\u0003o\tYd\\\u0005\u0004\u0003s\t&A\u0002+va2,'\u0007\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\r\u0011|W.Y5o\u0015\r\t)\u0005N\u0001\u0005i&,'/\u0003\u0003\u0002J\u0005}\"\u0001F!cgR\u0014\u0018m\u0019;US\u0016\u0014X*\u001a;bI\u0006$\u0018-A\brk\u0016,X\rZ'fi\u0006$\u0017\r^1!\u0003M1\u0017-\u001b7fI6+G/\u00193bi\u0006\u001cu.\u001e8u\u0003]1\u0017-\u001b7fI6+G/\u00193bi\u0006\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0005e\u0003c\u00019\u0002V%\u0019\u0011qK)\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037\"\u0012\u0011!a\u0001_\u0006\u0019\u0001\u0010J\u0019\u0002)\u0019\f\u0017\u000e\\3e\u001b\u0016$\u0018\rZ1uC\u000e{WO\u001c;!\u0003Y!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<WCAA2!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$\u0002BA5\u0003\u0007\nQ\u0001^8qS\u000eLA!!\u001c\u0002h\t1B+[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw-\u0001\u000euS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0005M\u0004\"CA./\u0005\u0005\t\u0019AA2\u0003]!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<\u0007%A\ruS\u0016\u0014Hk\u001c9jGB\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAA>!\u0011\ti(a!\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\naa\u00197jK:$\u0018\u0002BAC\u0003\u007f\u0012\u0011\u0004V5feR{\u0007/[2Qe>$WoY3s'V\u0004\b\u000f\\5fe\u0006iB/[3s)>\u0004\u0018n\u0019)s_\u0012,8-\u001a:TkB\u0004H.[3s?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0005-\u0005\"CA.5\u0005\u0005\t\u0019AA>\u0003i!\u0018.\u001a:U_BL7\r\u0015:pIV\u001cWM]*vaBd\u0017.\u001a:!\u0003E!\u0018.\u001a:U_BL7\r\u0015:pIV\u001cWM]\u000b\u0003\u0003'\u0003\u0002\"!&\u0002 \u0006\r\u00161U\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006A\u0001O]8ek\u000e,'OC\u0002\u0002\u001e~\u000bqa\u00197jK:$8/\u0003\u0003\u0002\"\u0006]%\u0001\u0003)s_\u0012,8-\u001a:\u0011\u000bA\f)+!+\n\u0007\u0005\u001d\u0016KA\u0003BeJ\f\u0017\u0010E\u0002q\u0003WK1!!,R\u0005\u0011\u0011\u0015\u0010^3\u0002+QLWM\u001d+pa&\u001c\u0007K]8ek\u000e,'o\u0018\u0013fcR!\u00111KAZ\u0011%\tY&HA\u0001\u0002\u0004\t\u0019*\u0001\nuS\u0016\u0014Hk\u001c9jGB\u0013x\u000eZ;dKJ\u0004\u0013!\u0003;jKJ$v\u000e]5d+\t\tY\f\u0005\u0003\u0002f\u0005u\u0016\u0002BA`\u0003O\u0012\u0011\u0002V5feR{\u0007/[2\u0002\u001bQLWM\u001d+pa&\u001cw\fJ3r)\u0011\t\u0019&!2\t\u0013\u0005m\u0003%!AA\u0002\u0005m\u0016A\u0003;jKJ$v\u000e]5dA\u0005aQ.\u001a;sS\u000e\u001cxI]8vaV\u0011\u0011Q\u001a\t\u0005\u0003\u001f\f9.\u0004\u0002\u0002R*!\u00111[Ak\u0003\u001diW\r\u001e:jGNT!aR0\n\t\u0005e\u0017\u0011\u001b\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%A\u0002sk:$\"!a\u0015\u0002\u001b%\u001c\u0018J\\5uS\u0006d\u0017N_3e+\t\t)\u000fE\u0002q\u0003OL1!!;R\u0005\u001d\u0011un\u001c7fC:\f\u0011\"[:Ti\u0006\u0014H/\u001a3\u0002\u0015%\u001c8\u000b[;uI><h.A\nrk\u0016,X\rZ'fi\u0006$\u0017\r^1D_VtG/A\u0003ti\u0006\u0014H/\u0001\u0006j]&$\u0018.\u00197ju\u0016$B!a\u0015\u0002x\"9\u0011\u0011 \u0016A\u0002\u0005m\u0018!B5nC\u001e,\u0007\u0003BA\u007f\u0005\u0003i!!a@\u000b\u0007\u0005ex,\u0003\u0003\u0003\u0004\u0005}(!D'fi\u0006$\u0017\r^1J[\u0006<W-\u0001\u0004e_^{'o[\u0001\ne\u0016$(/_*f]\u0012$\u0002\"a\u0015\u0003\f\t=!1\u0003\u0005\b\u0005\u001ba\u0003\u0019AA\u001e\u0003!iW\r^1eCR\f\u0007B\u0002B\tY\u0001\u0007q.A\u0003sKR\u0014\u0018\u0010C\u0004\u0003\u00161\u0002\rAa\u0006\u0002\u0003\u0015\u0004BA!\u0007\u0003$9!!1\u0004B\u0010\u001d\rq%QD\u0005\u0002%&\u0019!\u0011E)\u0002\u000fA\f7m[1hK&!!Q\u0005B\u0014\u0005%)\u0005pY3qi&|gNC\u0002\u0003\"E\u000bA$];fk\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKR,\u0017J\\5uS\u0006$X\r\u0006\u0006\u0002T\t5\"\u0011\u0007B\u001f\u0005\u0003BaAa\f.\u0001\u0004Y\u0015\u0001\u00053fY\u0016$X\r\u001a+pa&\u001cg*Y7f\u0011\u001d\u0011\u0019$\fa\u0001\u0005k\ta\u0002Z3mKR,G\rV8qS\u000eLE\r\u0005\u0003\u00038\teR\"A/\n\u0007\tmRL\u0001\u0003Vk&$\u0007B\u0002B [\u0001\u0007q.A\u0005qCJ$\u0018\u000e^5p]\"1!1I\u0017A\u0002=\f\u0011C_6D_:$(o\u001c7mKJ,\u0005o\\2i\u0003!\u0019\b.\u001e;e_^t\u0017aB2mK\u0006tW\u000f]\u0001\u000ee\u0016lwN^3NKR\u0014\u0018nY:")
public class MigrationTierTopicProducer
implements Runnable {
    private final KafkaConfig config;
    private final String clusterId;
    private final Time time;
    private final int MAX_RETRY;
    private final Logger log;
    private final AtomicBoolean initialized;
    private final AtomicBoolean started;
    private final AtomicBoolean closed;
    private final KafkaThread producerThread;
    private final LinkedBlockingQueue<Tuple2<AbstractTierMetadata, Object>> queuedMetadata;
    private int failedMetadataCount;
    private TierTopicManagerConfig tierTopicManagerConfig;
    private TierTopicProducerSupplier tierTopicProducerSupplier;
    private Producer<byte[], byte[]> tierTopicProducer;
    private TierTopic tierTopic;
    private final KafkaMetricsGroup metricsGroup;

    private int MAX_RETRY() {
        return this.MAX_RETRY;
    }

    private Logger log() {
        return this.log;
    }

    private AtomicBoolean initialized() {
        return this.initialized;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    private KafkaThread producerThread() {
        return this.producerThread;
    }

    private LinkedBlockingQueue<Tuple2<AbstractTierMetadata, Object>> queuedMetadata() {
        return this.queuedMetadata;
    }

    private int failedMetadataCount() {
        return this.failedMetadataCount;
    }

    private void failedMetadataCount_$eq(int x$1) {
        this.failedMetadataCount = x$1;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private void tierTopicManagerConfig_$eq(TierTopicManagerConfig x$1) {
        this.tierTopicManagerConfig = x$1;
    }

    private TierTopicProducerSupplier tierTopicProducerSupplier() {
        return this.tierTopicProducerSupplier;
    }

    private void tierTopicProducerSupplier_$eq(TierTopicProducerSupplier x$1) {
        this.tierTopicProducerSupplier = x$1;
    }

    private Producer<byte[], byte[]> tierTopicProducer() {
        return this.tierTopicProducer;
    }

    private void tierTopicProducer_$eq(Producer<byte[], byte[]> x$1) {
        this.tierTopicProducer = x$1;
    }

    private TierTopic tierTopic() {
        return this.tierTopic;
    }

    private void tierTopic_$eq(TierTopic x$1) {
        this.tierTopic = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public void run() {
        try {
            while (!this.closed().get()) {
                this.doWork();
            }
        }
        catch (Exception e) {
            if (this.closed().get()) {
                this.log().debug("Exception caught during shutdown", (Throwable)e);
                return;
            }
            this.log().error("Fatal exception in MigrationTierTopicProducer", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized().get();
    }

    public boolean isStarted() {
        return this.started().get();
    }

    public boolean isShutdown() {
        return this.closed().get();
    }

    public int queuedMetadataCount() {
        return this.queuedMetadata().size();
    }

    public void start() {
        if (this.initialized().get() && !this.closed().get()) {
            this.started().set(true);
            this.producerThread().start();
            return;
        }
    }

    public void initialize(MetadataImage image) {
        if (!this.initialized().get() && !this.closed().get()) {
            try {
                this.tierTopicManagerConfig_$eq(new TierTopicManagerConfig(this.config, this.tieredStorageInterBrokerClientConfigsSupplier$1(image), this.clusterId));
                this.tierTopicProducerSupplier_$eq(new TierTopicProducerSupplier(this.tierTopicManagerConfig(), this.time));
                this.tierTopic_$eq(new TierTopic(this.tierTopicManagerConfig().tierNamespace));
                this.tierTopic().initialize(this.tierTopicManagerConfig().configuredNumPartitions);
                this.tierTopicProducer_$eq(this.tierTopicProducerSupplier().get());
                this.initialized().set(true);
                return;
            }
            catch (Exception e) {
                this.log().error("Error to initialize tier topic producer for ZK migration.", (Throwable)e);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doWork() {
        if (this.initialized().get() && !this.queuedMetadata().isEmpty()) {
            void var2_2;
            Tuple2<AbstractTierMetadata, Object> tuple2 = this.queuedMetadata().take();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            AbstractTierMetadata metadata = (AbstractTierMetadata)tuple2._1();
            int n = tuple2._2$mcI$sp();
            TopicPartition tierTopicPartition = this.tierTopic().toTierTopicPartition(var2_2.topicIdPartition());
            ProducerRecord producerRecord = new ProducerRecord(tierTopicPartition.topic(), Predef$.MODULE$.int2Integer(tierTopicPartition.partition()), (Object)var2_2.serializeKey(), (Object)var2_2.serializeValue());
            try {
                this.tierTopicProducer().send(producerRecord, (arg_0, arg_1) -> MigrationTierTopicProducer.$anonfun$doWork$1(this, (AbstractTierMetadata)var2_2, n, arg_0, arg_1));
                return;
            }
            catch (RetriableException e) {
                this.retrySend((AbstractTierMetadata)var2_2, n, (Exception)((Object)e));
                return;
            }
            catch (Throwable t) {
                this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
                this.log().error(new StringBuilder(55).append("Caught exception when sending ").append(var2_2).append(" to tier topic partition.").toString(), t);
                return;
            }
        }
    }

    private void retrySend(AbstractTierMetadata metadata, int retry, Exception e) {
        int newRetryCount = retry + 1;
        if (newRetryCount < this.MAX_RETRY()) {
            this.queuedMetadata().add((Tuple2<AbstractTierMetadata, Object>)new Tuple2((Object)metadata, (Object)BoxesRunTime.boxToInteger((int)newRetryCount)));
            this.log().warn(new StringBuilder(95).append("Caught retriable exception when sending ").append(metadata).append(" to tier topic partition. Will try again, retry count: ").append(newRetryCount).toString(), (Throwable)e);
            return;
        }
        this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
        this.log().error(new StringBuilder(85).append("Caught retriable exception when sending ").append(metadata).append(" to tier topic partition. No more retry left.").toString(), (Throwable)e);
    }

    public void queuePartitionDeleteInitiate(String deletedTopicName, Uuid deletedTopicId, int partition, int zkControllerEpoch) {
        TopicIdPartition deletedPartition = new TopicIdPartition(deletedTopicName, CoreUtils$.MODULE$.toJavaUUID(deletedTopicId), partition);
        TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(deletedPartition, zkControllerEpoch, UUID.randomUUID());
        this.queuedMetadata().add((Tuple2<AbstractTierMetadata, Object>)new Tuple2((Object)deleteInitiate, (Object)BoxesRunTime.boxToInteger((int)0)));
    }

    public void shutdown() {
        this.closed().set(true);
        this.removeMetrics();
        try {
            try {
                if (this.started().get()) {
                    this.producerThread().join();
                }
            }
            catch (InterruptedException e) {
                this.log().error("Shutdown interrupted", (Throwable)e);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            this.initialized().set(false);
            if (this.tierTopicProducer() != null) {
                this.tierTopicProducer().close(Duration.ofSeconds(1L));
            }
        }
        catch (Exception e) {
            this.log().error("Caught exception when closing tierTopicProducer.", (Throwable)e);
        }
    }

    private void removeMetrics() {
        this.metricsGroup().removeMetric("FailedMetadataCount");
        this.metricsGroup().removeMetric("QueuedMetadataCount");
    }

    public final /* synthetic */ int kafka$migration$MigrationTierTopicProducer$$$anonfun$new$1() {
        return this.failedMetadataCount();
    }

    public final /* synthetic */ int kafka$migration$MigrationTierTopicProducer$$$anonfun$new$2() {
        return this.queuedMetadataCount();
    }

    private final Supplier tieredStorageInterBrokerClientConfigsSupplier$1(MetadataImage image$1) {
        return () -> {
            if ($this.config.confluentConfig().tierMetadataBootstrapServers() != null) {
                return Collections.singletonMap("bootstrap.servers", $this.config.confluentConfig().tierMetadataBootstrapServers());
            }
            ListenerName listenerName = $this.config.interBrokerListenerName();
            SecurityProtocol securityProtocol = $this.config.interBrokerSecurityProtocol();
            List brokerNodes = image$1.cluster().brokers().values().stream().map(x$5 -> x$5.node(listenerName.value())).filter(x$6 -> x$6.isPresent()).limit(3L).map(x$7 -> (Node)x$7.get()).collect(Collectors.toList());
            if (brokerNodes.size() > 0) {
                Node node = (Node)brokerNodes.get(0);
                Endpoint endpoint = new Endpoint(listenerName.value(), securityProtocol, node.host(), node.port());
                Map clientConfig = ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)$this.config, (Endpoint)endpoint);
                String servers = brokerNodes.stream().map(n -> new StringBuilder(1).append(n.host()).append(":").append(n.port()).toString()).collect(Collectors.joining(","));
                clientConfig.put("bootstrap.servers", servers);
                return clientConfig;
            }
            return Collections.emptyMap();
        };
    }

    public static final /* synthetic */ void $anonfun$doWork$1(MigrationTierTopicProducer $this, AbstractTierMetadata metadata$1, int retryCount$1, RecordMetadata x$9, Exception exception) {
        if (exception != null) {
            if (exception instanceof RetriableException) {
                $this.retrySend(metadata$1, retryCount$1, exception);
                return;
            }
            $this.failedMetadataCount_$eq($this.failedMetadataCount() + 1);
            $this.log().error(new StringBuilder(55).append("Caught exception when sending ").append(metadata$1).append(" to tier topic partition.").toString(), (Throwable)exception);
            return;
        }
    }

    public MigrationTierTopicProducer(KafkaConfig config, String clusterId, Time time) {
        this.config = config;
        this.clusterId = clusterId;
        this.time = time;
        this.MAX_RETRY = 5;
        this.log = LoggerFactory.getLogger(MigrationTierTopicProducer.class);
        this.initialized = new AtomicBoolean(false);
        this.started = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.producerThread = new KafkaThread("MigrationTierTopicProducer", (Runnable)this, false);
        this.queuedMetadata = new LinkedBlockingQueue();
        this.failedMetadataCount = 0;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().newGauge("FailedMetadataCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ MigrationTierTopicProducer $outer;

            public final int value() {
                return this.$outer.kafka$migration$MigrationTierTopicProducer$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("QueuedMetadataCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ MigrationTierTopicProducer $outer;

            public final int value() {
                MigrationTierTopicProducer migrationTierTopicProducer = this.$outer;
                if (migrationTierTopicProducer == null) {
                    throw null;
                }
                return migrationTierTopicProducer.queuedMetadataCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

