/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kafka.restore.operators.SegmentStateIterator;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.SegmentState;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;

public class FtpsSegmentView {
    private long fromTimestamp;
    private TopicIdPartition topicIdPartition;
    private CheckedFileIO stateFileChannel;
    private long headerSize = 0L;
    private Header header;
    private Map<UUID, SegmentState> segmentStateMap = new HashMap<UUID, SegmentState>();
    private List<SegmentState> segmentStateList = new ArrayList<SegmentState>();

    public FtpsSegmentView(TopicPartition topicPartition, File stateFile, long fromTimestamp) throws IOException {
        this(topicPartition, stateFile, fromTimestamp, true);
    }

    public FtpsSegmentView(TopicPartition topicPartition, File stateFile, long fromTimestamp, boolean bOffsetConsecutive) throws IOException {
        this.fromTimestamp = fromTimestamp;
        this.stateFileChannel = CheckedFileIO.open(stateFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        Optional<Header> headerOpt = FileTierPartitionState.readHeader(this.stateFileChannel);
        if (!headerOpt.isPresent()) {
            throw new IllegalStateException("Input state file is not valid, file path: " + stateFile.getAbsolutePath());
        }
        this.header = headerOpt.get();
        this.headerSize = this.header.size();
        this.topicIdPartition = new TopicIdPartition(topicPartition.topic(), headerOpt.get().topicId(), topicPartition.partition());
        this.loadLogSegments(bOffsetConsecutive);
    }

    private void loadLogSegments(boolean bOffsetConsecutive) throws IOException {
        SegmentStateIterator it = new SegmentStateIterator(this.topicIdPartition, this.stateFileChannel, this.headerSize);
        ArrayList<SegmentState> allSegments = new ArrayList<SegmentState>();
        boolean foundFirstSegment = false;
        while (it.hasNext()) {
            SegmentState seg = (SegmentState)it.next();
            if (foundFirstSegment) {
                allSegments.add(seg);
                continue;
            }
            if (seg.maxTimestamp() < this.fromTimestamp) continue;
            foundFirstSegment = true;
            allSegments.add(seg);
        }
        this.segmentStateList = bOffsetConsecutive ? this.buildValidSegmentView(allSegments) : allSegments;
        this.segmentStateMap = this.segmentStateList.stream().collect(Collectors.toMap(SegmentState::objectId, Function.identity()));
    }

    private List<SegmentState> buildValidSegmentView(List<SegmentState> allSegments) {
        LinkedList<SegmentState> consecutiveList = new LinkedList<SegmentState>();
        SegmentState previousValidSegment = null;
        for (int i = allSegments.size() - 1; i >= 0; --i) {
            SegmentState current = allSegments.get(i);
            boolean isValid = false;
            if (previousValidSegment == null) {
                isValid = true;
            } else if (current.tierEpoch() == previousValidSegment.tierEpoch()) {
                if (current.endOffset() == previousValidSegment.baseOffset() - 1L) {
                    isValid = true;
                }
            } else if (current.tierEpoch() < previousValidSegment.tierEpoch() && current.baseOffset() < previousValidSegment.baseOffset() && current.endOffset() >= previousValidSegment.baseOffset() - 1L) {
                isValid = true;
            }
            if (!isValid) continue;
            consecutiveList.add(0, current);
            previousValidSegment = current;
        }
        return consecutiveList;
    }

    public int indexOf(UUID segmentObjectId) {
        for (int index = this.segmentStateList.size() - 1; index >= 0; --index) {
            if (!this.segmentStateList.get(index).objectId().equals(segmentObjectId)) continue;
            return index;
        }
        return -1;
    }

    public void updateFtpsHeaderLogStartOffset(Long newLogStartOffset) throws IOException {
        if (newLogStartOffset != null) {
            this.header.mutateStartOffset(newLogStartOffset);
            FileTierPartitionState.writeHeader(this.stateFileChannel, this.header);
        }
    }

    public void updateFtpsHeader(Header newHeader) throws IOException {
        if (newHeader.size() != this.headerSize) {
            throw new IllegalStateException(String.format("Header size mismatch. Old header size: %s, new header size: %s", this.headerSize, newHeader.size()));
        }
        this.header = newHeader;
        FileTierPartitionState.writeHeader(this.stateFileChannel, this.header);
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public List<SegmentState> segmentStateList() {
        return this.segmentStateList;
    }

    public Map<UUID, SegmentState> segmentStateMap() {
        return this.segmentStateMap;
    }

    public CheckedFileIO stateFileChannel() {
        return this.stateFileChannel;
    }

    public void close() throws IOException {
        this.stateFileChannel.flush();
        this.stateFileChannel.close();
    }

    public Header header() {
        return this.header;
    }

    public int segmentCountWithState(TierObjectMetadata.State state) {
        int count = 0;
        for (SegmentState segmentState : this.segmentStateList()) {
            if (segmentState.state() != state) continue;
            ++count;
        }
        return count;
    }
}

