/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.util.concurrent.ThreadPoolExecutor;
import kafka.restore.schedulers.SchedulerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolMonitor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolMonitor.class);
    private String name;
    private ThreadPoolExecutor executor;
    private int delayInSeconds;
    private volatile boolean run = true;

    public ThreadPoolMonitor(String name, ThreadPoolExecutor executor, int delayInSeconds) {
        this.name = name;
        this.executor = executor;
        this.delayInSeconds = delayInSeconds;
    }

    public void shutdown() {
        this.run = false;
    }

    @Override
    public void run() {
        while (this.run) {
            LOGGER.info(SchedulerUtil.getThreadPoolExecutorStatus(this.name, this.executor));
            try {
                Thread.sleep(this.delayInSeconds * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

