/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaFenceRequest;
import kafka.restore.messages.KafkaPreConditionCheckResponse;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class StartToPreConditionReadyTransition
extends AbstractTransition {
    public StartToPreConditionReadyTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.START;
    }

    @Override
    public State getTargetState() {
        return State.PRE_CONDITION_READY;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof KafkaPreConditionCheckResponse)) {
            return false;
        }
        String topic = (String)fsm.getMetadata("topic");
        int partition = (Integer)fsm.getMetadata("partition");
        NodeConfig partitionLeader = (NodeConfig)fsm.getMetadata("partition_leader");
        KafkaFenceRequest kafkaMessage = new KafkaFenceRequest(0, topic, partition, partitionLeader);
        this.messageEmitter.submitRequest(kafkaMessage);
        return true;
    }
}

