/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.BeginShutdownControllerStatus;
import java.io.Serializable;
import kafka.server.ControllerStatusHandleAdapter$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r4A!\u0004\b\u0001'!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u0003-\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011}\u0002!Q1A\u0005\u0002\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006\u001d\u0002!\t\u0001\u0016\u0005\b/\u0002\u0011\r\u0011\"\u0001A\u0011\u0019A\u0006\u0001)A\u0005\u0003\")\u0011\f\u0001C!5\")a\f\u0001C!?\n!#)Z4j]NCW\u000f\u001e3po:\u001cuN\u001c;s_2dWM\u001d%b]\u0012dW-\u00113baR,'O\u0003\u0002\u0010!\u000511/\u001a:wKJT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001AC\u0007\u0011\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tYb$D\u0001\u001d\u0015\ti\u0002#A\u0003vi&d7/\u0003\u0002 9\t9Aj\\4hS:<\u0007CA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u0011\u0011Xm\u001d;\u000b\u0005\u00152\u0013!C2p]\u001adW/\u001a8u\u0015\u00059\u0013AA5p\u0013\tI#EA\u000fCK\u001eLgn\u00155vi\u0012|wO\\\"p]R\u0014x\u000e\u001c7fe\"\u000bg\u000e\u001a7f\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148/F\u0001-!\tiCG\u0004\u0002/eA\u0011qFF\u0007\u0002a)\u0011\u0011GE\u0001\u0007yI|w\u000e\u001e \n\u0005M2\u0012A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!a\r\f\u0002#\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001c\b%\u0001\u0004d_:4\u0017nZ\u000b\u0002uA\u00111\bP\u0007\u0002\u001d%\u0011QH\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u000b\u0005$W.\u001b8\u0016\u0003\u0005\u0003\"AQ&\u000e\u0003\rS!a\u0010#\u000b\u0005\u00153\u0015aB2mS\u0016tGo\u001d\u0006\u0003#\u001dS!\u0001S%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0015aA8sO&\u0011Aj\u0011\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003\u0019\tG-\\5oA\u00051A(\u001b8jiz\"B\u0001U)S'B\u00111\b\u0001\u0005\u0006U\u001d\u0001\r\u0001\f\u0005\u0006q\u001d\u0001\rA\u000f\u0005\u0006\u007f\u001d\u0001\r!\u0011\u000b\u0004!V3\u0006\"\u0002\u0016\t\u0001\u0004a\u0003\"\u0002\u001d\t\u0001\u0004Q\u0014!D5oi\u0016\u0014h.\u00197BI6Lg.\u0001\bj]R,'O\\1m\u0003\u0012l\u0017N\u001c\u0011\u0002-\u001d,g.\u001a:bi\u0016\u0014v\u000e\u001c7bE2,7\u000b^1ukN$\u0012a\u0017\t\u0003CqK!!\u0018\u0012\u0003;\t+w-\u001b8TQV$Hm\\<o\u0007>tGO]8mY\u0016\u00148\u000b^1ukN\fQa\u00197pg\u0016$\u0012\u0001\u0019\t\u0003+\u0005L!A\u0019\f\u0003\tUs\u0017\u000e\u001e")
public class BeginShutdownControllerHandleAdapter
implements Logging,
BeginShutdownControllerHandle {
    private final String bootstrapServers;
    private final KafkaConfig config;
    private final ConfluentAdmin admin;
    private final ConfluentAdmin internalAdmin;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ConfluentAdmin admin() {
        return this.admin;
    }

    public ConfluentAdmin internalAdmin() {
        return this.internalAdmin;
    }

    public BeginShutdownControllerStatus generateRollableStatus() {
        Option<String> option = ControllerStatusHandleAdapter$.MODULE$.checkRollable(this.internalAdmin(), Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), this);
        if (option instanceof Some) {
            String reason = (String)((Some)option).value();
            return new BeginShutdownControllerStatus(false, reason);
        }
        return new BeginShutdownControllerStatus(true, "");
    }

    public void close() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down");
        this.internalAdmin().close();
    }

    public BeginShutdownControllerHandleAdapter(String bootstrapServers, KafkaConfig config, ConfluentAdmin admin) {
        this.bootstrapServers = bootstrapServers;
        this.config = config;
        this.admin = admin;
        this.internalAdmin = admin != null ? admin : ControllerStatusHandleAdapter$.MODULE$.createAdmin(bootstrapServers, "kraft-controller-local-rollable-admin", config);
    }

    public BeginShutdownControllerHandleAdapter(String bootstrapServers, KafkaConfig config) {
        this(bootstrapServers, config, null);
    }
}

