/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.AllRequests$;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QueueSizePercentiles;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=r!B\u001a5\u0011\u0003Id!B\u001e5\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005bB#\u0002\u0005\u0004%\tA\u0012\u0005\u0007\u0015\u0006\u0001\u000b\u0011B$\t\u000f-\u000b!\u0019!C\u0001\r\"1A*\u0001Q\u0001\n\u001dCq!T\u0001C\u0002\u0013\u0005a\n\u0003\u0004S\u0003\u0001\u0006Ia\u0014\u0005\b'\u0006\u0011\r\u0011\"\u0003U\u0011\u0019i\u0016\u0001)A\u0005+\u001a!1\b\u000e\u0001_\u0011!\u00117B!b\u0001\n\u0013\u0019\u0007\u0002C4\f\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\\!Q1A\u0005\n%D\u0001B^\u0006\u0003\u0002\u0003\u0006IA\u001b\u0005\no.\u0011\t\u0011)A\u0005qzD\u0011b`\u0006\u0003\u0006\u0004%I!!\u0001\t\u0015\u0005]1B!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u001a-\u0011)\u0019!C\u0005\u00037A!\"!\r\f\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t\u0019d\u0003B\u0001B\u0003%\u0011Q\u0007\u0005\u0007\u0007.!\t!!\u0010\t\u0013\u000553B1A\u0005\n\u0005=\u0003\u0002CA,\u0017\u0001\u0006I!!\u0015\t\u0011\u0005e3\u00021A\u0005\n\u0019C\u0011\"a\u0017\f\u0001\u0004%I!!\u0018\t\u000f\u0005%4\u0002)Q\u0005\u000f\"A\u00111N\u0006C\u0002\u0013Ec\nC\u0004\u0002n-\u0001\u000b\u0011B(\t\u0013\u0005=4B1A\u0005\n\u0005E\u0004\u0002CA>\u0017\u0001\u0006I!a\u001d\t\u0013\u0005u4B1A\u0005\u0002\u0005}\u0004\u0002CAD\u0017\u0001\u0006I!!!\t\u000f\u0005%5\u0002\"\u0001\u0002\u0000!9\u00111R\u0006\u0005\n\u00055\u0005bBAN\u0017\u0011%\u0011Q\u0014\u0005\b\u0003G[A\u0011AAS\u0011\u001d\tIk\u0003C\u0001\u0003WCq!a,\f\t\u0003\t\t\fC\u0004\u0002T.!\t!!6\t\u000f\u0005e7\u0002\"\u0011\u0002\\\"9\u00111]\u0006\u0005R\u0005\u0015\bbBAy\u0017\u0011%\u00111\u001f\u0005\u0007\u0003s\\A\u0011\t$\t\u000f\u0005m8\u0002\"\u0003\u0002~\"9!QB\u0006\u0005\n\t=\u0001\u0002\u0003B\r\u0017\u0011ECGa\u0007\t\u000f\t}1\u0002\"\u0001\u0003\"!9!qE\u0006\u0005B\t%\u0002\"\u0004B\u0016\u0017A\u0005\u0019\u0011!A\u0005\n\t5b0A\rDY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014(BA\u001b7\u0003\u0019\u0019XM\u001d<fe*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005i\nQ\"\u0001\u001b\u00033\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\n\u0003\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001:\u0003i\tVo\u001c;b%\u0016\fX/Z:u!\u0016\u00148-\u001a8u\t\u00164\u0017-\u001e7u+\u00059\u0005C\u0001 I\u0013\tIuH\u0001\u0004E_V\u0014G.Z\u0001\u001c#V|G/\u0019*fcV,7\u000f\u001e)fe\u000e,g\u000e\u001e#fM\u0006,H\u000e\u001e\u0011\u000259\u000bgn\\:U_B+'oY3oi\u0006<W\rU3s'\u0016\u001cwN\u001c3\u000279\u000bgn\\:U_B+'oY3oi\u0006<W\rU3s'\u0016\u001cwN\u001c3!\u0003A\"UMZ1vYRLe.Y2uSZ,W\t_3naR\u001cVM\\:pe\u0016C\b/\u001b:bi&|g\u000eV5nKN+7m\u001c8egV\tq\n\u0005\u0002?!&\u0011\u0011k\u0010\u0002\u0005\u0019>tw-A\u0019EK\u001a\fW\u000f\u001c;J]\u0006\u001cG/\u001b<f\u000bb,W\u000e\u001d;TK:\u001cxN]#ya&\u0014\u0018\r^5p]RKW.Z*fG>tGm\u001d\u0011\u0002!\u0015CX-\u001c9u'\u0016t7o\u001c:OC6,W#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n11\u000b\u001e:j]\u001e\f\u0011#\u0012=f[B$8+\u001a8t_Jt\u0015-\\3!'\tYq\f\u0005\u0002;A&\u0011\u0011\r\u000e\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'/\u0001\u0004d_:4\u0017nZ\u000b\u0002IB\u0011!(Z\u0005\u0003MR\u0012\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nq!\\3ue&\u001c7/F\u0001k!\tYG/D\u0001m\u0015\tAWN\u0003\u0002o_\u000611m\\7n_:T!a\u000e9\u000b\u0005E\u0014\u0018AB1qC\u000eDWMC\u0001t\u0003\ry'oZ\u0005\u0003k2\u0014q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0011!\u0018.\\3\u0011\u0005edX\"\u0001>\u000b\u0005ml\u0017!B;uS2\u001c\u0018BA?{\u0005\u0011!\u0016.\\3\n\u0005]\u0004\u0017\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005Ma\u0002BA\u0004\u0003\u001f\u00012!!\u0003@\u001b\t\tYAC\u0002\u0002\u000ea\na\u0001\u0010:p_Rt\u0014bAA\t\u007f\u00051\u0001K]3eK\u001aL1\u0001XA\u000b\u0015\r\t\tbP\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013aE2mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\WCAA\u000f!\u0015q\u0014qDA\u0012\u0013\r\t\tc\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u0012QF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005)\u0011/^8uC*\u0011Qg\\\u0005\u0005\u0003_\t9CA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.\u0001\u000bdY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7\u000eI\u0001\u0015C\u000e$\u0018N^3UK:\fg\u000e^:NC:\fw-\u001a:\u0011\u000by\ny\"a\u000e\u0011\u0007i\nI$C\u0002\u0002<Q\u0012A#Q2uSZ,G+\u001a8b]R\u001cX*\u00198bO\u0016\u0014HCDA \u0003\u0003\n\u0019%!\u0012\u0002H\u0005%\u00131\n\t\u0003u-AQA\u0019\fA\u0002\u0011DQ\u0001\u001b\fA\u0002)DQa\u001e\fA\u0002aDaa \fA\u0002\u0005\r\u0001bBA\r-\u0001\u0007\u0011Q\u0004\u0005\b\u0003g1\u0002\u0019AA\u001b\u0003I!\bN]3bIV\u001b\u0018mZ3TK:\u001cxN]:\u0016\u0005\u0005E\u0003c\u0001\u001e\u0002T%\u0019\u0011Q\u000b\u001b\u0003%QC'/Z1e+N\fw-Z*f]N|'o]\u0001\u0014i\"\u0014X-\u00193Vg\u0006<WmU3og>\u00148\u000fI\u0001\u0014Y\u0006\u001cH\u000fT5nSR\u001cuN\u001d:fGRLwN\\\u0001\u0018Y\u0006\u001cH\u000fT5nSR\u001cuN\u001d:fGRLwN\\0%KF$B!a\u0018\u0002fA\u0019a(!\u0019\n\u0007\u0005\rtH\u0001\u0003V]&$\b\u0002CA45\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'\u0001\u000bmCN$H*[7ji\u000e{'O]3di&|g\u000eI\u0001\u0012[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\u0018AE7bqRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0002\n\u0001#\u001a=f[B$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\u0005M\u0004\u0003BA;\u0003oj\u0011!\\\u0005\u0004\u0003sj'AC'fiJL7MT1nK\u0006\tR\r_3naRlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u0019\u0015DX-\u001c9u'\u0016t7o\u001c:\u0016\u0005\u0005\u0005\u0005cA6\u0002\u0004&\u0019\u0011Q\u00117\u0003\rM+gn]8s\u00035)\u00070Z7qiN+gn]8sA\u00059bn\u001c8Fq\u0016l\u0007\u000f^\"ba\u0006\u001c\u0017\u000e^=TK:\u001cxN]\u0001\u001ae\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e(fi^|'o\u001b+ie\u0016\fG\r\u0006\u0005\u0002`\u0005=\u00151SAL\u0011\u0019\t\tj\ta\u0001\u000f\u0006)a/\u00197vK\"9\u0011QS\u0012A\u0002\u0005\r\u0011\u0001\u00047jgR,g.\u001a:OC6,\u0007BBAMG\u0001\u0007q*\u0001\u0004uS6,Wj]\u0001\u0015e\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f^%p)\"\u0014X-\u00193\u0015\r\u0005}\u0013qTAQ\u0011\u0019\t\t\n\na\u0001\u000f\"1\u0011\u0011\u0014\u0013A\u0002=\u000b!#\u00193e\u0019&\u001cH/\u001a8fe6+GO]5dgR!\u0011qLAT\u0011\u001d\t)*\na\u0001\u0003\u0007\tQC]3n_Z,G*[:uK:,'/T3ue&\u001c7\u000f\u0006\u0003\u0002`\u00055\u0006bBAKM\u0001\u0007\u00111A\u0001 [\u0006L(-\u001a*fG>\u0014H-\u00118e\u000f\u0016$H\u000b\u001b:piRdW\rV5nK6\u001bHCBAZ\u0003s\u000b\t\u000eE\u0002?\u0003kK1!a.@\u0005\rIe\u000e\u001e\u0005\b\u0003w;\u0003\u0019AA_\u0003\u001d\u0011X-];fgR\u0004B!a0\u0002L:!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002FZ\nqA\\3uo>\u00148.\u0003\u0003\u0002J\u0006\r\u0017A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003\u001b\fyMA\u0004SKF,Xm\u001d;\u000b\t\u0005%\u00171\u0019\u0005\u0007\u00033;\u0003\u0019A(\u0002#5\f\u0017PY3SK\u000e|'\u000fZ#yK6\u0004H\u000f\u0006\u0003\u0002`\u0005]\u0007bBA^Q\u0001\u0007\u0011QX\u0001\u0014E\u0006\u001c7\u000e\u001d:fgN,(/Z#oC\ndW\rZ\u000b\u0003\u0003;\u00042APAp\u0013\r\t\to\u0010\u0002\b\u0005>|G.Z1o\u0003Q\u0019G.[3oiJ\u000bG/Z'fiJL7MT1nKR!\u00111OAt\u0011\u001d\tIO\u000ba\u0001\u0003W\fq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\t\u0003\u000b\ti/a\u0001\u0002\u0004%!\u0011q^A\u000b\u0005\ri\u0015\r]\u0001\u0012]\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,GcA$\u0002v\"1\u0011q_\u0016A\u0002=\u000bQA\\1o_N\f1cZ3u\u0005J|7.\u001a:Rk>$\u0018\rT5nSR\f1C]3d_J$\u0017j\u001c+ie\u0016\fG-V:bO\u0016$\u0002\"a\u0018\u0002\u0000\n\u0005!1\u0002\u0005\u0007\u0003#k\u0003\u0019A$\t\u000f\t\rQ\u00061\u0001\u0003\u0006\u0005Y!/Z9vKN$H+\u001f9f!\rQ$qA\u0005\u0004\u0005\u0013!$a\u0003*fcV,7\u000f\u001e+za\u0016Da!!'.\u0001\u0004y\u0015A\u0005:fG>\u0014HMT3uo>\u00148.V:bO\u0016$\"\"a\u0018\u0003\u0012\tM!Q\u0003B\f\u0011\u0019\t\tJ\fa\u0001\u000f\"9\u0011Q\u0013\u0018A\u0002\u0005\r\u0001b\u0002B\u0002]\u0001\u0007!Q\u0001\u0005\u0007\u00033s\u0003\u0019A(\u0002-U\u0004H-\u0019;f\u0005J|7.\u001a:Rk>$\u0018\rT5nSR$B!a\u0018\u0003\u001e!1\u0011\u0011T\u0018A\u0002=\u000ba#\u001e9eCR,\u0017\t\u001a6vgR,GmQ1qC\u000eLG/\u001f\u000b\u0004\u000f\n\r\u0002B\u0002B\u0013a\u0001\u0007q)\u0001\nce>\\WM\u001d*fcV,7\u000f\u001e'j[&$\u0018\u0001C:ikR$wn\u001e8\u0015\u0005\u0005}\u0013AC:va\u0016\u0014H\u0005^5nKV\t\u0001\u0010")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final long maxThrottleTimeMs;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static long DefaultInactiveExemptSensorExpirationTimeSeconds() {
        return ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds();
    }

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public static double QuotaRequestPercentDefault() {
        return ClientRequestQuotaManager$.MODULE$.QuotaRequestPercentDefault();
    }

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    private double lastLimitCorrection() {
        return this.lastLimitCorrection;
    }

    private void lastLimitCorrection_$eq(double x$1) {
        this.lastLimitCorrection = x$1;
    }

    @Override
    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
    }

    private void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    private void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor().record(value, timeMs, false);
        this.recordIoThreadUsage(value, ExemptRequest$.MODULE$, timeMs);
    }

    public void addListenerMetrics(String listenerName) {
        this.threadUsageSensors().addListenerMetrics(listenerName);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        double reqIoThreadPercentage = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        this.recordIoThreadUsage(reqIoThreadPercentage, NonExemptRequest$.MODULE$, timeMs);
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(request.session(), request.header().clientId());
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> {
                long timeMs = this.super$time().milliseconds();
                this.recordNoThrottle(clientSensors, (double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), timeMs);
                this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, timeMs);
            }));
            return this.recordAndGetThrottleTimeMs(clientSensors, reqIoThreadPercentage, timeMs);
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds())));
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = super.time().milliseconds();
        double reqIoThreadPercentage = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordExemptNetworkThread((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, this.super$time().milliseconds())));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
            return;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, ExemptRequest$.MODULE$, this.super$time().milliseconds())));
        this.recordIoThreadUsage(reqIoThreadPercentage, ExemptRequest$.MODULE$, currentTimeMs);
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig() && this.dynamicBackpressureConfig().tenantEndpointListenerNames().nonEmpty();
    }

    @Override
    public MetricName clientRateMetricName(scala.collection.immutable.Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", "Request", "Tracking request-time per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics())));
        if (metricOpt instanceof Some) {
            return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue());
        }
        return Double.MAX_VALUE;
    }

    private void recordIoThreadUsage(double value, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(value, timeMs, requestType);
            return;
        }
        this.threadUsageSensors().recordIoThreadUsage(value, timeMs, AllRequests$.MODULE$);
    }

    private void recordNetworkUsage(double value, String listenerName, RequestType requestType, long timeMs) {
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, requestType);
            return;
        }
        this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, AllRequests$.MODULE$);
    }

    @Override
    public void updateBrokerQuotaLimit(long timeMs) {
        Seq<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), NonExemptRequest$.MODULE$);
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), AllRequests$.MODULE$);
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, NonExemptRequest$.MODULE$);
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, AllRequests$.MODULE$);
            double nonExemptIoThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), tenantEndpointsListenerNames));
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptIoThreadLimit + nonExemptNetworkThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double updateAdjustedCapacity(double brokerRequestLimit) {
        double d;
        void dataPlaneQueueSize_tags;
        void dataPlaneQueueSize_percentileSuffix;
        void dataPlaneQueueSize_metrics;
        Map map = (Map)Map$.MODULE$.empty();
        String string = this.dynamicBackpressureConfig().queueSizePercentile();
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ dataPlaneQueueSize_this = RequestQueueSizePercentiles$.MODULE$;
        Object var9_5 = null;
        metrics = null;
        string = null;
        map = null;
        double queueSize = QueueSizePercentiles.dataPlaneQueueSize$(dataPlaneQueueSize_this, (Metrics)dataPlaneQueueSize_metrics, (String)dataPlaneQueueSize_percentileSuffix, (Map)dataPlaneQueueSize_tags);
        double minCap = this.dynamicBackpressureConfig().minBrokerRequestQuota();
        if (queueSize >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = this.lastLimitCorrection() < maxAdjustmentLimit ? this.lastLimitCorrection() + BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment() : this.lastLimitCorrection();
        } else {
            d = package$.MODULE$.max(0.0, this.lastLimitCorrection() - BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment());
        }
        this.lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("queueSize(p95)=").append(queueSize).append(",  lastLimitCorrection=").append(this.lastLimitCorrection()).toString());
        return package$.MODULE$.max(brokerRequestLimit - this.lastLimitCorrection(), minCap);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadUsageSensors().close();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$exemptSensor$1(ClientRequestQuotaManager $this, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = $this.exemptMetricName();
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    private static final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - exemptUsage;
        double minNonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager, (Option<AbstractQuotaChannelManager>)None$.MODULE$);
        this.threadUsageSensors = new ThreadUsageSensors(metrics);
        this.lastLimitCorrection = 0.0;
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptMetricName = metrics.metricName("exempt-request-time", "Request", "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable)sensor -> {
            ClientRequestQuotaManager.$anonfun$exemptSensor$1(this, sensor);
            return BoxedUnit.UNIT;
        });
    }
}

