/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Optional;
import kafka.cluster.PartitionListener;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rmb\u0001\u0002,X\u0001qC!\"!\u0001\u0001\u0005\u0003\u0007I\u0011AA\u0002\u0011)\ty\u0002\u0001BA\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003_\u0001!\u0011!Q!\n\u0005\u0015\u0001BCA\u0019\u0001\t\u0015\r\u0011\"\u0001\u00024!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\u0005}\u0002A!b\u0001\n\u0003\t\t\u0005\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0007Bq!a\u0013\u0001\t\u0003\ti\u0005C\u0005\u0002X\u0001\u0001\r\u0011\"\u0001\u0002B!I\u0011\u0011\f\u0001A\u0002\u0013\u0005\u00111\f\u0005\t\u0003?\u0002\u0001\u0015)\u0003\u0002D!I\u0011\u0011\r\u0001A\u0002\u0013\u0005\u00111\r\u0005\n\u0003W\u0002\u0001\u0019!C\u0001\u0003[B\u0001\"!\u001d\u0001A\u0003&\u0011Q\r\u0005\n\u0003g\u0002\u0001\u0019!C\u0001\u0003GB\u0011\"!\u001e\u0001\u0001\u0004%\t!a\u001e\t\u0011\u0005m\u0004\u0001)Q\u0005\u0003KB\u0011\"! \u0001\u0001\u0004%\t!!\u0011\t\u0013\u0005}\u0004\u00011A\u0005\u0002\u0005\u0005\u0005\u0002CAC\u0001\u0001\u0006K!a\u0011\t\u0013\u0005\u001d\u0005\u00011A\u0005\u0002\u0005%\u0005\"CAO\u0001\u0001\u0007I\u0011AAP\u0011!\t\u0019\u000b\u0001Q!\n\u0005-\u0005\"CAS\u0001\u0001\u0007I\u0011AAE\u0011%\t9\u000b\u0001a\u0001\n\u0003\tI\u000b\u0003\u0005\u0002.\u0002\u0001\u000b\u0015BAF\u0011%\ty\u000b\u0001a\u0001\n\u0003\t\t\fC\u0005\u0002:\u0002\u0001\r\u0011\"\u0001\u0002<\"A\u0011q\u0018\u0001!B\u0013\t\u0019\fC\u0005\u0002B\u0002\u0001\r\u0011\"\u0001\u00022\"I\u00111\u0019\u0001A\u0002\u0013\u0005\u0011Q\u0019\u0005\t\u0003\u0013\u0004\u0001\u0015)\u0003\u00024\"I\u00111\u001a\u0001A\u0002\u0013%\u00111\r\u0005\n\u0003\u001b\u0004\u0001\u0019!C\u0005\u0003\u001fD\u0001\"a5\u0001A\u0003&\u0011Q\r\u0005\n\u0003+\u0004\u0001\u0019!C\u0005\u0003GB\u0011\"a6\u0001\u0001\u0004%I!!7\t\u0011\u0005u\u0007\u0001)Q\u0005\u0003KB1\"a8\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002b\"Y\u0011\u0011\u001e\u0001A\u0002\u0003\u0007I\u0011BAv\u0011-\ty\u000f\u0001a\u0001\u0002\u0003\u0006K!a9\t\u0013\u0005e\b\u00011A\u0005\n\u0005\r\u0004\"CA~\u0001\u0001\u0007I\u0011BA\u007f\u0011!\u0011\t\u0001\u0001Q!\n\u0005\u0015\u0004\"\u0003B\u0003\u0001\u0001\u0007I\u0011BA2\u0011%\u00119\u0001\u0001a\u0001\n\u0013\u0011I\u0001\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0015BA3\u0011%\u0011\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0007C\u0005\u0003\u0014\u0001\u0001\r\u0011\"\u0003\u0003\u0016!A!\u0011\u0004\u0001!B\u0013\t)\u0007C\u0005\u0003\u001e\u0001\u0001\r\u0011\"\u0003\u00022\"I!q\u0004\u0001A\u0002\u0013%!\u0011\u0005\u0005\t\u0005K\u0001\u0001\u0015)\u0003\u00024\"I!\u0011\u0006\u0001A\u0002\u0013\u0005!1\u0006\u0005\n\u0005\u0003\u0002\u0001\u0019!C\u0001\u0005\u0007B\u0001Ba\u0012\u0001A\u0003&!Q\u0006\u0005\n\u0005\u0017\u0002\u0001\u0019!C\u0005\u0003\u0003B\u0011B!\u0014\u0001\u0001\u0004%IAa\u0014\t\u0011\tM\u0003\u0001)Q\u0005\u0003\u0007B\u0011B!\u0016\u0001\u0001\u0004%I!!\u0011\t\u0013\t]\u0003\u00011A\u0005\n\te\u0003\u0002\u0003B/\u0001\u0001\u0006K!a\u0011\t\u000f\t}\u0003\u0001\"\u0011\u0003b!9!1\r\u0001\u0005B\t\u0015\u0004b\u0002B5\u0001\u0011\u0005#\u0011\r\u0005\b\u0005W\u0002A\u0011\tB7\u0011\u001d\u0011\t\b\u0001C!\u0005gBqAa\u001e\u0001\t\u0003\u0012I\bC\u0004\u0002L\u0001!\tA!\"\t\u000f\u0005-\u0003\u0001\"\u0001\u0003\u0010\"9!q\u0013\u0001\u0005B\te\u0005b\u0002BT\u0001\u0011\u0005#\u0011\u0016\u0005\b\u0005_\u0003A\u0011\tBY\u0011\u001d\u00119\f\u0001C!\u0005sCqAa2\u0001\t\u0003\u0012I\rC\u0004\u0003N\u0002!\tEa4\t\u000f\tM\u0007\u0001\"\u0011\u0003V\"9!1\u001c\u0001\u0005B\tu\u0007b\u0002Bp\u0001\u0011\u0005#\u0011\u001d\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011y\u0010\u0001C\u0001\u0007\u0003Aqa!\u0006\u0001\t\u0003\u00199\u0002C\u0004\u00040\u0001!\tE!\u0019\t\u000f\rE\u0002\u0001\"\u0011\u00044!91q\u0007\u0001\u0005B\re\"!I%oGJ,W.\u001a8uC2\u0004\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\f'B\u0001-Z\u0003\u0019\u0019XM\u001d<fe*\t!,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001iVM\u001e>\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001\u00027b]\u001eT\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n1qJ\u00196fGR\u0004\"AZ:\u000f\u0005\u001d\fX\"\u00015\u000b\u0005%T\u0017!B;uS2\u001c(BA6m\u0003\u0019\u0019w.\\7p]*\u0011!,\u001c\u0006\u0003]>\fa!\u00199bG\",'\"\u00019\u0002\u0007=\u0014x-\u0003\u0002sQ\u0006a\u0012*\u001c9mS\u000eLG\u000fT5oW\u0016$\u0007*Y:i\u0007>dG.Z2uS>t\u0017B\u0001;v\u0005\u001d)E.Z7f]RT!A\u001d5\u0011\u0005]DX\"A,\n\u0005e<&A\u0006)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\u0011\u0005mtX\"\u0001?\u000b\u0005uL\u0016aB2mkN$XM]\u0005\u0003\u007fr\u0014\u0011\u0003U1si&$\u0018n\u001c8MSN$XM\\3s\u0003\u0015!x\u000e]5d+\t\t)\u0001\u0005\u0003\u0002\b\u0005ea\u0002BA\u0005\u0003+\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fY\u0016A\u0002\u001fs_>$hH\u0003\u0002\u0002\u0014\u0005)1oY1mC&!\u0011qCA\t\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*!\u0011qCA\t\u0003%!x\u000e]5d?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005-\u0002\u0003BA\u0013\u0003Oi!!!\u0005\n\t\u0005%\u0012\u0011\u0003\u0002\u0005+:LG\u000fC\u0005\u0002.\t\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0001\u0010J\u0019\u0002\rQ|\u0007/[2!\u0003\u001d!x\u000e]5d\u0013\u0012,\"!!\u000e\u0011\t\u0005]\u0012\u0011H\u0007\u0002U&\u0019\u00111\b6\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0003\u0007\u0002B!!\n\u0002F%!\u0011qIA\t\u0005\rIe\u000e^\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005\u0002P\u0005E\u00131KA+!\t9\b\u0001C\u0004\u0002\u0002!\u0001\r!!\u0002\t\u000f\u0005E\u0002\u00021\u0001\u00026!9\u0011q\b\u0005A\u0002\u0005\r\u0013!\u0003:fa2L7-Y%e\u00035\u0011X\r\u001d7jG\u0006LEm\u0018\u0013fcR!\u00111EA/\u0011%\tiCCA\u0001\u0002\u0004\t\u0019%\u0001\u0006sKBd\u0017nY1JI\u0002\n1BZ3uG\"|eMZ:fiV\u0011\u0011Q\r\t\u0005\u0003K\t9'\u0003\u0003\u0002j\u0005E!\u0001\u0002'p]\u001e\fqBZ3uG\"|eMZ:fi~#S-\u001d\u000b\u0005\u0003G\ty\u0007C\u0005\u0002.5\t\t\u00111\u0001\u0002f\u0005aa-\u001a;dQ>3gm]3uA\u0005Y1\u000f^1si>3gm]3u\u0003=\u0019H/\u0019:u\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u0012\u0003sB\u0011\"!\f\u0011\u0003\u0003\u0005\r!!\u001a\u0002\u0019M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\u00115\f\u0007PQ=uKN\fA\"\\1y\u0005f$Xm]0%KF$B!a\t\u0002\u0004\"I\u0011QF\n\u0002\u0002\u0003\u0007\u00111I\u0001\n[\u0006D()\u001f;fg\u0002\n!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQV\u0011\u00111\u0012\t\u0007\u0003\u001b\u000b\u0019*a&\u000e\u0005\u0005=%bAAIC\u0006!Q\u000f^5m\u0013\u0011\t)*a$\u0003\u0011=\u0003H/[8oC2\u00042AXAM\u0013\r\tYj\u0018\u0002\b\u0013:$XmZ3s\u0003Y\u0019WO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\u0012\u0003CC\u0011\"!\f\u0017\u0003\u0003\u0005\r!a#\u0002'\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002!1\f7\u000f\u001e$fi\u000eDW\rZ#q_\u000eD\u0017\u0001\u00067bgR4U\r^2iK\u0012,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005-\u0006\"CA\u00173\u0005\u0005\t\u0019AAF\u0003Ea\u0017m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007\u000eI\u0001\u0015M\u0016$8\r['fi\u0006$\u0017\r^1Va\u0012\fG/\u001a3\u0016\u0005\u0005M\u0006\u0003BA\u0013\u0003kKA!a.\u0002\u0012\t9!i\\8mK\u0006t\u0017\u0001\u00074fi\u000eDW*\u001a;bI\u0006$\u0018-\u00169eCR,Gm\u0018\u0013fcR!\u00111EA_\u0011%\ti\u0003HA\u0001\u0002\u0004\t\u0019,A\u000bgKR\u001c\u0007.T3uC\u0012\fG/Y+qI\u0006$X\r\u001a\u0011\u00023\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r[+qI\u0006$X\rZ\u0001\u001eGV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00169eCR,Gm\u0018\u0013fcR!\u00111EAd\u0011%\ticHA\u0001\u0002\u0004\t\u0019,\u0001\u000edkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eDW\u000b\u001d3bi\u0016$\u0007%A\u000bmCN$\b*[4i/\u0006$XM]7be.\u001cVM\u001c;\u000231\f7\u000f\u001e%jO\"<\u0016\r^3s[\u0006\u00148nU3oi~#S-\u001d\u000b\u0005\u0003G\t\t\u000eC\u0005\u0002.\t\n\t\u00111\u0001\u0002f\u00051B.Y:u\u0011&<\u0007nV1uKJl\u0017M]6TK:$\b%\u0001\fmCN$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8+\u001a8u\u0003ia\u0017m\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;TK:$x\fJ3r)\u0011\t\u0019#a7\t\u0013\u00055R%!AA\u0002\u0005\u0015\u0014a\u00067bgRdunZ*uCJ$xJ\u001a4tKR\u001cVM\u001c;!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!a9\u0011\u0007]\f)/C\u0002\u0002h^\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nsKBd\u0017nY1NC:\fw-\u001a:`I\u0015\fH\u0003BA\u0012\u0003[D\u0011\"!\f)\u0003\u0003\u0005\r!a9\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002B3!KAz!\u0011\t)#!>\n\t\u0005]\u0018\u0011\u0003\u0002\tm>d\u0017\r^5mK\u0006!\u0002/\u0019:uSRLwN\\*uCJ$xJ\u001a4tKR\f\u0001\u0004]1si&$\u0018n\u001c8Ti\u0006\u0014Ho\u00144gg\u0016$x\fJ3r)\u0011\t\u0019#a@\t\u0013\u000552&!AA\u0002\u0005\u0015\u0014!\u00069beRLG/[8o'R\f'\u000f^(gMN,G\u000f\t\u0015\u0004Y\u0005M\u0018A\u00059beRLG/[8o\u000b:$wJ\u001a4tKR\fa\u0003]1si&$\u0018n\u001c8F]\u0012|eMZ:fi~#S-\u001d\u000b\u0005\u0003G\u0011Y\u0001C\u0005\u0002.9\n\t\u00111\u0001\u0002f\u0005\u0019\u0002/\u0019:uSRLwN\\#oI>3gm]3uA!\u001aq&a=\u0002-A\f'\u000f^5uS>t\u0007*[4i/\u0006$XM]7be.\f!\u0004]1si&$\u0018n\u001c8IS\u001eDw+\u0019;fe6\f'o[0%KF$B!a\t\u0003\u0018!I\u0011QF\u0019\u0002\u0002\u0003\u0007\u0011QM\u0001\u0018a\u0006\u0014H/\u001b;j_:D\u0015n\u001a5XCR,'/\\1sW\u0002B3AMAz\u00039I7OU3qY&\u001c\u0017-\u00138JgJ\f!#[:SKBd\u0017nY1J]&\u001b(o\u0018\u0013fcR!\u00111\u0005B\u0012\u0011%\ti\u0003NA\u0001\u0002\u0004\t\u0019,A\bjgJ+\u0007\u000f\\5dC&s\u0017j\u001d:!Q\r)\u00141_\u0001\u0014M\u0016$8\r[(gMN,G/T3uC\u0012\fG/Y\u000b\u0003\u0005[\u0001BAa\f\u0003>5\u0011!\u0011\u0007\u0006\u0005\u0005g\u0011)$A\u0002m_\u001eTAAa\u000e\u0003:\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0005wa\u0017aB:u_J\fw-Z\u0005\u0005\u0005\u007f\u0011\tDA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006\fqCZ3uG\"|eMZ:fi6+G/\u00193bi\u0006|F%Z9\u0015\t\u0005\r\"Q\t\u0005\n\u0003[9\u0014\u0011!a\u0001\u0005[\tACZ3uG\"|eMZ:fi6+G/\u00193bi\u0006\u0004\u0003f\u0001\u001d\u0002t\u0006Q1-Y2iK\u0012tU\r\u001f;\u0002\u001d\r\f7\r[3e\u001d\u0016DHo\u0018\u0013fcR!\u00111\u0005B)\u0011%\tiCOA\u0001\u0002\u0004\t\u0019%A\u0006dC\u000eDW\r\u001a(fqR\u0004\u0013AC2bG\",G\r\u0015:fm\u0006q1-Y2iK\u0012\u0004&/\u001a<`I\u0015\fH\u0003BA\u0012\u00057B\u0011\"!\f>\u0003\u0003\u0005\r!a\u0011\u0002\u0017\r\f7\r[3e!J,g\u000fI\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002D\u000591/\u001a;OKb$H\u0003BA\u0012\u0005OBqAa\u0018A\u0001\u0004\t\u0019%\u0001\u0003qe\u00164\u0018aB:fiB\u0013XM\u001e\u000b\u0005\u0003G\u0011y\u0007C\u0004\u0003j\t\u0003\r!a\u0011\u0002-M,GOR3uG\"|eMZ:fi6+G/\u00193bi\u0006$B!a\t\u0003v!9!\u0011F\"A\u0002\t5\u0012aE3mK6,g\u000e^&fsN\f%/Z#rk\u0006dG\u0003BAZ\u0005wBqA! E\u0001\u0004\u0011y(\u0001\u0003uQ\u0006$\b\u0003BA\u0013\u0005\u0003KAAa!\u0002\u0012\t\u0019\u0011I\\=\u0015\t\u0005=#q\u0011\u0005\b\u0003\u007f)\u0005\u0019\u0001BE!\u0011\t9Da#\n\u0007\t5%N\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]R1\u0011q\nBI\u0005'Cq!a\u0010G\u0001\u0004\u0011I\t\u0003\u0004\u0003\u0016\u001a\u0003\rA^\u0001\u0016a\u0006\u0014H/\u001b;j_:4U\r^2i%\u0016\fX/Z:u\u0003Qygn\u0015;beR|eMZ:fiV\u0003H-\u0019;fIR1\u00111\u0005BN\u0005GCq!a\u0010H\u0001\u0004\u0011i\n\u0005\u0003\u00028\t}\u0015b\u0001BQU\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002BS\u000f\u0002\u0007\u0011QM\u0001\u0007_\u001a47/\u001a;\u0002%=tWI\u001c3PM\u001a\u001cX\r^+qI\u0006$X\r\u001a\u000b\u0007\u0003G\u0011YK!,\t\u000f\u0005}\u0002\n1\u0001\u0003\u001e\"9!Q\u0015%A\u0002\u0005\u0015\u0014AF8o\u0011&<\u0007nV1uKJl\u0017M]6Va\u0012\fG/\u001a3\u0015\r\u0005\r\"1\u0017B[\u0011\u001d\ty$\u0013a\u0001\u0005;CqA!*J\u0001\u0004\t)'\u0001\u0007p]&\u001b(/\u00169eCR,G\r\u0006\u0004\u0002$\tm&Q\u0018\u0005\b\u0003\u007fQ\u0005\u0019\u0001BO\u0011\u001d\u0011yL\u0013a\u0001\u0005\u0003\f1![:s!\u0019\t9Aa1\u0002D%!!QYA\u000f\u0005\r\u0019V\r^\u0001\t_:4\u0015-\u001b7fIR!\u00111\u0005Bf\u0011\u001d\tyd\u0013a\u0001\u0005;\u000b\u0011b\u001c8EK2,G/\u001a3\u0015\t\u0005\r\"\u0011\u001b\u0005\b\u0003\u007fa\u0005\u0019\u0001BO\u0003]i\u0017-\u001f2f%\u0016<\u0017n\u001d;fe\u0006\u001bH*[:uK:,'\u000f\u0006\u0004\u0002$\t]'\u0011\u001c\u0005\b\u0003/j\u0005\u0019AA\"\u0011\u001d\ty.\u0014a\u0001\u0003G\f!\"[:DCV<\u0007\u000e^+q)\t\t\u0019,A\u0003dY>\u001cX\r\u0006\u0002\u0002$\u0005\u0019R\u000f\u001d3bi\u0016\u0014V-];fgR\u0004\u0016M]1ngR!\u00111\u0005Bt\u0011\u001d\u0011I\u000f\u0015a\u0001\u0005W\faBZ3uG\"\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003n\neh\u0002\u0002Bx\u0005kl!A!=\u000b\u0007\tM(.A\u0004nKN\u001c\u0018mZ3\n\t\t](\u0011_\u0001\u0011\r\u0016$8\r\u001b*fcV,7\u000f\u001e#bi\u0006LAAa?\u0003~\nqa)\u001a;dQB\u000b'\u000f^5uS>t'\u0002\u0002B|\u0005c\fq#\\1zE\u0016\u0014Vm]8mm\u0016,fn\u001b8po:t\u0015-\\3\u0015\t\u0005\r21\u0001\u0005\b\u0007\u000b\t\u0006\u0019AB\u0004\u0003)!x\u000e]5d\u001d\u0006lWm\u001d\t\u0005\u0007\u0013\u0019yAD\u0002x\u0007\u0017I1a!\u0004X\u000311U\r^2i'\u0016\u001c8/[8o\u0013\u0011\u0019\tba\u0005\u0003\u001dQ{\u0005+S\"`\u001d\u0006kUiX'B!*\u00191QB,\u0002/5\f\u0017PY3Va\u0012\fG/\u001a*fgB|gn]3ECR\fGCBAZ\u00073\u0019Y\u0003C\u0004\u0004\u001cI\u0003\ra!\b\u0002\u0011I,7\u000f\u001d#bi\u0006\u0004Baa\b\u0004&9!!q^B\u0011\u0013\u0011\u0019\u0019C!=\u0002#\u0019+Go\u00195SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0004(\r%\"!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0004$\tE\bbBB\u0017%\u0002\u0007\u00111W\u0001\u0007kB$\u0017\r^3\u0002\u0011!\f7\u000f[\"pI\u0016\fa!Z9vC2\u001cH\u0003BAZ\u0007kAqA! U\u0001\u0004\u0011y(\u0001\u0005u_N#(/\u001b8h)\t\t)\u0001")
public class IncrementalPartitionFetchMetadata
implements ImplicitLinkedHashCollection.Element,
PartitionFetchMetadata,
PartitionListener {
    private String topic;
    private final Uuid topicId;
    private final int partition;
    private int replicaId;
    private long fetchOffset;
    private long startOffset;
    private int maxBytes;
    private Optional<Integer> currentLeaderEpoch;
    private Optional<Integer> lastFetchedEpoch;
    private boolean fetchMetadataUpdated;
    private boolean currentLeaderEpochUpdated;
    private long lastHighWatermarkSent;
    private long lastLogStartOffsetSent;
    private volatile ReplicaManager replicaManager;
    private volatile long partitionStartOffset;
    private volatile long partitionEndOffset;
    private volatile long partitionHighWatermark;
    private volatile boolean isReplicaInIsr;
    private volatile LogOffsetMetadata fetchOffsetMetadata;
    private int cachedNext;
    private int cachedPrev;

    @Override
    public void onLastStableOffsetUpdated(TopicPartition partition, long offset) {
        PartitionListener.onLastStableOffsetUpdated$(this, partition, offset);
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String x$1) {
        this.topic = x$1;
    }

    @Override
    public Uuid topicId() {
        return this.topicId;
    }

    public int partition() {
        return this.partition;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public void replicaId_$eq(int x$1) {
        this.replicaId = x$1;
    }

    @Override
    public long fetchOffset() {
        return this.fetchOffset;
    }

    public void fetchOffset_$eq(long x$1) {
        this.fetchOffset = x$1;
    }

    @Override
    public long startOffset() {
        return this.startOffset;
    }

    public void startOffset_$eq(long x$1) {
        this.startOffset = x$1;
    }

    @Override
    public int maxBytes() {
        return this.maxBytes;
    }

    public void maxBytes_$eq(int x$1) {
        this.maxBytes = x$1;
    }

    @Override
    public Optional<Integer> currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    public void currentLeaderEpoch_$eq(Optional<Integer> x$1) {
        this.currentLeaderEpoch = x$1;
    }

    @Override
    public Optional<Integer> lastFetchedEpoch() {
        return this.lastFetchedEpoch;
    }

    public void lastFetchedEpoch_$eq(Optional<Integer> x$1) {
        this.lastFetchedEpoch = x$1;
    }

    @Override
    public boolean fetchMetadataUpdated() {
        return this.fetchMetadataUpdated;
    }

    public void fetchMetadataUpdated_$eq(boolean x$1) {
        this.fetchMetadataUpdated = x$1;
    }

    public boolean currentLeaderEpochUpdated() {
        return this.currentLeaderEpochUpdated;
    }

    public void currentLeaderEpochUpdated_$eq(boolean x$1) {
        this.currentLeaderEpochUpdated = x$1;
    }

    private long lastHighWatermarkSent() {
        return this.lastHighWatermarkSent;
    }

    private void lastHighWatermarkSent_$eq(long x$1) {
        this.lastHighWatermarkSent = x$1;
    }

    private long lastLogStartOffsetSent() {
        return this.lastLogStartOffsetSent;
    }

    private void lastLogStartOffsetSent_$eq(long x$1) {
        this.lastLogStartOffsetSent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    private long partitionStartOffset() {
        return this.partitionStartOffset;
    }

    private void partitionStartOffset_$eq(long x$1) {
        this.partitionStartOffset = x$1;
    }

    private long partitionEndOffset() {
        return this.partitionEndOffset;
    }

    private void partitionEndOffset_$eq(long x$1) {
        this.partitionEndOffset = x$1;
    }

    private long partitionHighWatermark() {
        return this.partitionHighWatermark;
    }

    private void partitionHighWatermark_$eq(long x$1) {
        this.partitionHighWatermark = x$1;
    }

    private boolean isReplicaInIsr() {
        return this.isReplicaInIsr;
    }

    private void isReplicaInIsr_$eq(boolean x$1) {
        this.isReplicaInIsr = x$1;
    }

    @Override
    public LogOffsetMetadata fetchOffsetMetadata() {
        return this.fetchOffsetMetadata;
    }

    public void fetchOffsetMetadata_$eq(LogOffsetMetadata x$1) {
        this.fetchOffsetMetadata = x$1;
    }

    private int cachedNext() {
        return this.cachedNext;
    }

    private void cachedNext_$eq(int x$1) {
        this.cachedNext = x$1;
    }

    private int cachedPrev() {
        return this.cachedPrev;
    }

    private void cachedPrev_$eq(int x$1) {
        this.cachedPrev = x$1;
    }

    public int next() {
        return this.cachedNext();
    }

    public void setNext(int next) {
        this.cachedNext_$eq(next);
    }

    public int prev() {
        return this.cachedPrev();
    }

    public void setPrev(int prev) {
        this.cachedPrev_$eq(prev);
    }

    @Override
    public void setFetchOffsetMetadata(LogOffsetMetadata fetchOffsetMetadata) {
        this.fetchOffsetMetadata_$eq(fetchOffsetMetadata);
    }

    public boolean elementKeysAreEqual(Object that) {
        if (that instanceof IncrementalPartitionFetchMetadata) {
            IncrementalPartitionFetchMetadata incrementalPartitionFetchMetadata = (IncrementalPartitionFetchMetadata)that;
            Uuid uuid = this.topicId();
            Uuid uuid2 = Uuid.ZERO_UUID;
            if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                return ((Object)BoxesRunTime.boxToInteger((int)this.partition())).equals(BoxesRunTime.boxToInteger((int)incrementalPartitionFetchMetadata.partition())) && this.topicId().equals((Object)incrementalPartitionFetchMetadata.topicId());
            }
            return ((Object)BoxesRunTime.boxToInteger((int)this.partition())).equals(BoxesRunTime.boxToInteger((int)incrementalPartitionFetchMetadata.partition())) && this.topic().equals(incrementalPartitionFetchMetadata.topic());
        }
        return false;
    }

    @Override
    public void onStartOffsetUpdated(TopicPartition partition, long offset) {
        this.partitionStartOffset_$eq(offset);
    }

    @Override
    public void onEndOffsetUpdated(TopicPartition partition, long offset) {
        this.partitionEndOffset_$eq(offset);
    }

    @Override
    public void onHighWatermarkUpdated(TopicPartition partition, long offset) {
        this.partitionHighWatermark_$eq(offset);
    }

    @Override
    public void onIsrUpdated(TopicPartition partition, Set<Object> isr) {
        this.isReplicaInIsr_$eq(isr.contains((Object)BoxesRunTime.boxToInteger((int)this.replicaId())));
    }

    @Override
    public void onFailed(TopicPartition partition) {
        this.replicaManager_$eq(null);
    }

    @Override
    public void onDeleted(TopicPartition partition) {
        this.replicaManager_$eq(null);
    }

    @Override
    public void maybeRegisterAsListener(int replicaId, ReplicaManager replicaManager) {
        this.replicaId_$eq(replicaId);
        if (this.replicaManager() == null && replicaId > -1) {
            if (replicaManager.maybeAddListener(new TopicPartition(this.topic(), this.partition()), this)) {
                this.replicaManager_$eq(replicaManager);
                return;
            }
            return;
        }
    }

    @Override
    public boolean isCaughtUp() {
        return this.replicaManager() != null && this.fetchOffset() == this.partitionEndOffset() && this.lastHighWatermarkSent() == this.partitionHighWatermark() && this.lastLogStartOffsetSent() == this.partitionStartOffset() && this.isReplicaInIsr();
    }

    @Override
    public void close() {
        ReplicaManager localReplicaManager = this.replicaManager();
        if (localReplicaManager != null) {
            localReplicaManager.removeListener(new TopicPartition(this.topic(), this.partition()), this);
        }
        this.replicaManager_$eq(null);
    }

    public void updateRequestParams(FetchRequestData.FetchPartition fetchPartition) {
        if (this.fetchOffset() != fetchPartition.fetchOffset()) {
            this.fetchOffsetMetadata_$eq(new LogOffsetMetadata(fetchPartition.fetchOffset()));
            this.fetchOffset_$eq(fetchPartition.fetchOffset());
            this.fetchMetadataUpdated_$eq(true);
        }
        if (this.startOffset() != fetchPartition.logStartOffset()) {
            this.startOffset_$eq(fetchPartition.logStartOffset());
            this.fetchMetadataUpdated_$eq(true);
        }
        if (this.maxBytes() != fetchPartition.partitionMaxBytes()) {
            this.maxBytes_$eq(fetchPartition.partitionMaxBytes());
            this.fetchMetadataUpdated_$eq(true);
        }
        Optional newCurrentLeaderEpoch = RequestUtils.getLeaderEpoch((int)fetchPartition.currentLeaderEpoch());
        if (!this.currentLeaderEpoch().equals(newCurrentLeaderEpoch)) {
            this.currentLeaderEpoch_$eq(newCurrentLeaderEpoch);
            this.currentLeaderEpochUpdated_$eq(true);
            this.fetchMetadataUpdated_$eq(true);
        }
        Optional newLastFetchedEpoch = RequestUtils.getLeaderEpoch((int)fetchPartition.lastFetchedEpoch());
        if (!this.lastFetchedEpoch().equals(newLastFetchedEpoch)) {
            this.lastFetchedEpoch_$eq(newLastFetchedEpoch);
            this.fetchMetadataUpdated_$eq(true);
            return;
        }
    }

    public void maybeResolveUnknownName(Map<Uuid, String> topicNames) {
        if (this.topic() == null) {
            this.topic_$eq(topicNames.get(this.topicId()));
            return;
        }
    }

    public boolean maybeUpdateResponseData(FetchResponseData.PartitionData respData, boolean update) {
        boolean mustRespond = false;
        if (FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) > 0) {
            mustRespond = true;
        }
        if (this.lastHighWatermarkSent() != respData.highWatermark()) {
            mustRespond = true;
            if (update) {
                this.lastHighWatermarkSent_$eq(respData.highWatermark());
            }
        }
        if (this.lastLogStartOffsetSent() != respData.logStartOffset()) {
            mustRespond = true;
            if (update) {
                this.lastLogStartOffsetSent_$eq(respData.logStartOffset());
            }
        }
        if (FetchResponse.isPreferredReplica((FetchResponseData.PartitionData)respData)) {
            mustRespond = true;
        }
        if (respData.errorCode() != Errors.NONE.code()) {
            if (update) {
                this.lastHighWatermarkSent_$eq(-1L);
                this.lastLogStartOffsetSent_$eq(-1L);
            }
            mustRespond = true;
        }
        if (FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)respData)) {
            mustRespond = true;
        }
        if (this.currentLeaderEpochUpdated()) {
            mustRespond = true;
        }
        if (update) {
            this.fetchMetadataUpdated_$eq(false);
            this.currentLeaderEpochUpdated_$eq(false);
        }
        return mustRespond;
    }

    public int hashCode() {
        Uuid uuid = this.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            return 31 * this.partition() + this.topicId().hashCode();
        }
        return 31 * this.partition() + this.topic().hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof IncrementalPartitionFetchMetadata) {
            IncrementalPartitionFetchMetadata incrementalPartitionFetchMetadata = (IncrementalPartitionFetchMetadata)that;
            return this == incrementalPartitionFetchMetadata;
        }
        return false;
    }

    public synchronized String toString() {
        return new StringBuilder(298).append("IncrementalPartitionFetchMetadata(topic=").append(this.topic()).append(", topicId=").append(this.topicId()).append(", partition=").append(this.partition()).append(", fetchOffset=").append(this.fetchOffset()).append(", startOffset=").append(this.startOffset()).append(", maxBytes=").append(this.maxBytes()).append(", currentLeaderEpoch=").append(this.currentLeaderEpoch()).append(", lastFetchedEpoch=").append(this.lastFetchedEpoch()).append(", lastSentHighWatermark=").append(this.lastHighWatermarkSent()).append(", lastSentLogStartOffset=").append(this.lastLogStartOffsetSent()).append(", isRegistered=").append(this.replicaManager() != null).append(", partitionStartOffset=").append(this.partitionStartOffset()).append(", partitionEndOffset=").append(this.partitionEndOffset()).append(", partitionHighWatermark=").append(this.partitionHighWatermark()).append(", fetchMetadataUpdated=").append(this.fetchMetadataUpdated()).append(")").toString();
    }

    public IncrementalPartitionFetchMetadata(String topic, Uuid topicId, int partition) {
        this.topic = topic;
        this.topicId = topicId;
        this.partition = partition;
        this.replicaId = -1;
        this.fetchOffset = -1L;
        this.startOffset = -1L;
        this.maxBytes = -1;
        this.currentLeaderEpoch = Optional.empty();
        this.lastFetchedEpoch = Optional.empty();
        this.fetchMetadataUpdated = false;
        this.currentLeaderEpochUpdated = false;
        this.lastHighWatermarkSent = -1L;
        this.lastLogStartOffsetSent = -1L;
        this.partitionStartOffset = -1L;
        this.partitionEndOffset = -1L;
        this.partitionHighWatermark = -1L;
        this.isReplicaInIsr = false;
        this.fetchOffsetMetadata = new LogOffsetMetadata(this.fetchOffset());
        this.cachedNext = -2;
        this.cachedPrev = -2;
    }

    public IncrementalPartitionFetchMetadata(TopicIdPartition partition) {
        this(partition.topic(), partition.topicId(), partition.partition());
    }

    public IncrementalPartitionFetchMetadata(TopicIdPartition partition, PartitionFetchMetadata partitionFetchRequest) {
        this(partition.topic(), partition.topicId(), partition.partition());
        this.fetchOffset_$eq(partitionFetchRequest.fetchOffset());
        this.startOffset_$eq(partitionFetchRequest.startOffset());
        this.maxBytes_$eq(partitionFetchRequest.maxBytes());
        this.currentLeaderEpoch_$eq(partitionFetchRequest.currentLeaderEpoch());
        this.lastFetchedEpoch_$eq(partitionFetchRequest.lastFetchedEpoch());
    }
}

