/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u000f\u001e\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011)\u0019!C\u0001k!A\u0011\t\u0001B\u0001B\u0003%a\u0007\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0001D\u0011!9\u0005A!A!\u0002\u0013!\u0005\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\t\u0011A\u0003!\u0011!Q\u0001\n)C\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005'\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003E\u0011!)\u0007A!A!\u0002\u00131\u0004\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011\u001d\u0004!Q1A\u0005\n!D\u0001B\u001c\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t_\u0002\u0011)\u0019!C\u0001a\"AA\u0010\u0001B\u0001B\u0003%\u0011\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a!A\u00111\u0007\u0001!\u0002\u0013\tY\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011Q\t\u0001!\u0002\u0013\tI\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0001\u0002J!A\u0011\u0011\r\u0001!\u0002\u0013\tY\u0005C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m$aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014\bk\\8m\u0015\tqr$\u0001\u0004tKJ4XM\u001d\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u0010\u0002\u000bU$\u0018\u000e\\:\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0011\u0005E\u0012T\"A\u000f\n\u0005Mj\"aC&bM.\f7i\u001c8gS\u001e\f\u0011b\u00197vgR,'/\u00133\u0016\u0003Y\u0002\"a\u000e \u000f\u0005ab\u0004CA\u001d&\u001b\u0005Q$BA\u001e\"\u0003\u0019a$o\\8u}%\u0011Q(J\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>K\u0005Q1\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u0012\t\u0003I\u0015K!AR\u0013\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005q!/Z9vKN$8\t[1o]\u0016dW#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055{\u0012a\u00028fi^|'o[\u0005\u0003\u001f2\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003\u0011\t\u0007/[:\u0016\u0003M\u0003\"!\r+\n\u0005Uk\"!E!qSJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe\u0006)\u0011\r]5tA\u0005!A/[7f!\tI&-D\u0001[\u0015\ta3L\u0003\u0002];\u000611m\\7n_:T!\u0001\t0\u000b\u0005}\u0003\u0017AB1qC\u000eDWMC\u0001b\u0003\ry'oZ\u0005\u0003Gj\u0013A\u0001V5nK\u0006Qa.^7UQJ,\u0017\rZ:\u0002?I,\u0017/^3ti\"\u000bg\u000e\u001a7fe\u00063x-\u00133mK6+GO]5d\u001d\u0006lW-\u0001\fm_\u001e\fe\u000e\u001a+ie\u0016\fGMT1nKB\u0013XMZ5y\u0003\u001diW\r\u001e:jGN,\u0012!\u001b\t\u0003U2l\u0011a\u001b\u0006\u0003OnK!!\\6\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014X#A9\u0011\u0005ITX\"A:\u000b\u0005Q,\u0018\u0001B2pe\u0016T!a\u001a<\u000b\u0005]D\u0018AB=b[6,'OC\u0001z\u0003\r\u0019w.\\\u0005\u0003wN\u0014Q!T3uKJ\f1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002\na\u0001P5oSRtDcF@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u00111CA\u000b!\t\t\u0004\u0001C\u00030%\u0001\u0007\u0001\u0007C\u00035%\u0001\u0007a\u0007C\u0003C%\u0001\u0007A\tC\u0003I%\u0001\u0007!\nC\u0003R%\u0001\u00071\u000bC\u0003X%\u0001\u0007\u0001\fC\u0003e%\u0001\u0007A\tC\u0003f%\u0001\u0007a\u0007C\u0003g%\u0001\u0007a\u0007C\u0003h%\u0001\u0007\u0011\u000eC\u0003p%\u0001\u0007\u0011/\u0001\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003_i!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0007CR|W.[2\u000b\t\u0005\u0015\u0012qE\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0015\u0003W\tA!\u001e;jY*\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005}!!D!u_6L7-\u00138uK\u001e,'/A\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3!\u0003m!\bN]3bIB|w\u000e\\\"ba\u0006\u001c\u0017\u000e^=TK:\u001cxN](qiV\u0011\u0011\u0011\b\t\u0006I\u0005m\u0012qH\u0005\u0004\u0003{)#AB(qi&|g\u000eE\u0002k\u0003\u0003J1!a\u0011l\u0005\u0019\u0019VM\\:pe\u0006aB\u000f\u001b:fC\u0012\u0004xn\u001c7DCB\f7-\u001b;z'\u0016t7o\u001c:PaR\u0004\u0013!\u0003:v]:\f'\r\\3t+\t\tY\u0005\u0005\u0004\u0002N\u0005]\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u00059Q.\u001e;bE2,'bAA+K\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0013q\n\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u00022\u0003;J1!a\u0018\u001e\u0005MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003)\u0011XO\u001c8bE2,7\u000fI\u0001\u000eGJ,\u0017\r^3IC:$G.\u001a:\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004I\u0005%\u0014bAA6K\t!QK\\5u\u0011\u0019\ty'\u0007a\u0001\t\u0006\u0011\u0011\u000eZ\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$B!a\u001a\u0002v!1\u0011q\u000f\u000eA\u0002\u0011\u000bqA\\3x'&TX-\u0001\u0005tQV$Hm\\<o)\t\t9\u0007")
public class KafkaRequestHandlerPool
implements Logging {
    private final KafkaConfig config;
    private final String clusterId;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final Metrics metrics;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger threadPoolSize;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.config, this.clusterId(), this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time));
        Runnable daemon_runnable = (Runnable)this.runnables().apply(id);
        String daemon_name = new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString();
        Object var2_3 = null;
        Object var3_2 = null;
        new KafkaThread(daemon_name, daemon_runnable, true).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
        this.threadpoolCapacitySensorOpt().foreach((Function1 & Serializable)sensor -> {
            sensor.record(100.0 * (double)newSize);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "shut down completely");
    }

    /*
     * WARNING - void declaration
     */
    public KafkaRequestHandlerPool(KafkaConfig config, String clusterId, int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, Metrics metrics, Meter aggregateIdleMeter) {
        None$ none$;
        this.config = config;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.metrics = metrics;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.threadPoolSize = new AtomicInteger(numThreads);
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (string != null && string.equals(string2)) {
            void add_stat;
            void add_metricName;
            Sensor sensor = metrics.sensor("TotalIoThreadsPercentage");
            Value value = new Value();
            MetricName metricName = ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics);
            if (sensor == null) {
                throw null;
            }
            sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
            metricName = null;
            value = null;
            sensor.record(100.0 * (double)numThreads);
            none$ = new Some((Object)sensor);
        } else {
            none$ = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = none$;
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
    }
}

