/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.rest.KafkaRestoreRestApiReturnStatus;
import io.confluent.rest.TierPartitionStateResponse;
import io.confluent.rest.TierRecordMetadataResponse;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.EndPoint;
import kafka.log.AbstractLog;
import kafka.log.MergedLog$;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.tools.RecoveryUtils;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\f\u0019\u0001uA\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!\n\u0005\tU\u0001\u0011\t\u0011)A\u0005M!A1\u0006\u0001BC\u0002\u0013\u0005A\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d1\u0004A1A\u0005\u0002]Ba\u0001\u0011\u0001!\u0002\u0013A\u0004bB!\u0001\u0001\u0004%\tA\u0011\u0005\b\r\u0002\u0001\r\u0011\"\u0001H\u0011\u0019i\u0005\u0001)Q\u0005\u0007\"9a\n\u0001b\u0001\n\u0003y\u0005B\u0002/\u0001A\u0003%\u0001\u000bC\u0003^\u0001\u0011\u0005a\fC\u0003o\u0001\u0011\u0005q\u000eC\u0003}\u0001\u0011\u0005Q\u0010C\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!a&\u0001\t\u0003\tIJA\u0011LC\u001a\\\u0017\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNU3ti>\u0014X-T1oC\u001e,'O\u0003\u0002\u001a5\u000511/\u001a:wKJT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u00051\u0003CA\u0014)\u001b\u0005A\u0012BA\u0015\u0019\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\fW\u000647.Y\"p]\u001aLw-F\u0001.!\t9c&\u0003\u000201\tY1*\u00194lC\u000e{gNZ5h\u00031Y\u0017MZ6b\u0007>tg-[4!\u0003\u0019a\u0014N\\5u}Q\u00191\u0007N\u001b\u0011\u0005\u001d\u0002\u0001\"\u0002\u0013\u0006\u0001\u00041\u0003\"B\u0016\u0006\u0001\u0004i\u0013A\u00027pO\u001e,'/F\u00019!\tId(D\u0001;\u0015\tYD(A\u0003tY\u001a$$NC\u0001>\u0003\ry'oZ\u0005\u0003\u007fi\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0005a>\u0014H/F\u0001D!\tyB)\u0003\u0002FA\t\u0019\u0011J\u001c;\u0002\u0011A|'\u000f^0%KF$\"\u0001S&\u0011\u0005}I\u0015B\u0001&!\u0005\u0011)f.\u001b;\t\u000f1K\u0011\u0011!a\u0001\u0007\u0006\u0019\u0001\u0010J\u0019\u0002\u000bA|'\u000f\u001e\u0011\u0002!%tG/\u001a:bY\u0016sG\r]8j]R\u001cX#\u0001)\u0011\u0007E#f+D\u0001S\u0015\t\u0019\u0006%\u0001\u0006d_2dWm\u0019;j_:L!!\u0016*\u0003\u0007M+\u0017\u000f\u0005\u0002X56\t\u0001L\u0003\u0002Z5\u000591\r\\;ti\u0016\u0014\u0018BA.Y\u0005!)e\u000e\u001a)pS:$\u0018!E5oi\u0016\u0014\u0018\r\\#oIB|\u0017N\u001c;tA\u0005Iq-\u001a;MK\u0006$WM\u001d\u000b\u0004\u0007~c\u0007\"\u00021\u000e\u0001\u0004\t\u0017!\u0002;pa&\u001c\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002eA5\tQM\u0003\u0002g9\u00051AH]8pizJ!\u0001\u001b\u0011\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003Q\u0002BQ!\\\u0007A\u0002\r\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0002-\u001d,G\u000fV5feB\u000b'\u000f^5uS>t7\u000b^1ukN$2\u0001\u001d>|!\t\t\b0D\u0001s\u0015\t\u0019H/\u0001\u0003sKN$(BA;w\u0003%\u0019wN\u001c4mk\u0016tGOC\u0001x\u0003\tIw.\u0003\u0002ze\nQB+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f%\u0016\u001c\bo\u001c8tK\")\u0001M\u0004a\u0001C\")QN\u0004a\u0001\u0007\u0006Yq-\u001a;GiB\u001ch)\u001b7f)\u0015q\u0018qCA\r!\u0015y\u0018\u0011BA\u0007\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B;uS2T!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tA\u0001\u0005PaRLwN\\1m!\u0011\ty!a\u0005\u000e\u0005\u0005E!bA<\u0002\u0006%!\u0011QCA\t\u0005\u00111\u0015\u000e\\3\t\u000b\u0001|\u0001\u0019A1\t\u000b5|\u0001\u0019A\"\u0002\u0017%t'.Z2u\u000bZ,g\u000e\u001e\u000b\u0005\u0003?\t)\u0003E\u0002r\u0003CI1!a\ts\u0005i!\u0016.\u001a:SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0011\u001d\t9\u0003\u0005a\u0001\u0003S\tQ!\u001a<f]R\u0004B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0004e_6\f\u0017N\u001c\u0006\u0004\u0003gQ\u0012\u0001\u0002;jKJLA!a\u000e\u0002.\t!\u0012IY:ue\u0006\u001cG\u000fV5fe6+G/\u00193bi\u0006\faaZ3u\u0019><GCBA\u001f\u0003\u001f\n\t\u0006E\u0003 \u0003\u007f\t\u0019%C\u0002\u0002B\u0001\u0012aa\u00149uS>t\u0007\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%#$A\u0002m_\u001eLA!!\u0014\u0002H\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u0015\u0001\u0017\u00031\u0001b\u0011\u0015i\u0017\u00031\u0001D\u0003i\u0019X\r\u001e$f]\u000e,G+[3s)>\u0004\u0018n\u0019)beRLG/[8o)\u0019\ty\"a\u0016\u0002Z!)\u0001M\u0005a\u0001C\")QN\u0005a\u0001\u0007\u0006a2/\u001a;G_J\u001cWMU3ti>\u0014X\rV5feB\u000b'\u000f^5uS>tGCDA\u0010\u0003?\n\t'a\u0019\u0002n\u0005E\u0014Q\u000f\u0005\u0006AN\u0001\r!\u0019\u0005\u0006[N\u0001\ra\u0011\u0005\b\u0003K\u001a\u0002\u0019AA4\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0011\u0007}\tI'C\u0002\u0002l\u0001\u0012A\u0001T8oO\"9\u0011qN\nA\u0002\u0005\u001d\u0014!C3oI>3gm]3u\u0011\u0019\t\u0019h\u0005a\u0001C\u0006Y1m\u001c8uK:$\b*Y:i\u0011\u001d\t9h\u0005a\u0001\u0003s\n\u0011c\u00195fG.\u001cX/\\!mO>\u0014\u0018\u000e\u001e5n!\ry\u00121P\u0005\u0004\u0003{\u0002#\u0001\u0002\"zi\u0016\f\u0011d]3u+:4'/Z3{K2{wm\u0015;beR|eMZ:fiR1\u0011qDAB\u0003\u000bCQ\u0001\u0019\u000bA\u0002\u0005DQ!\u001c\u000bA\u0002\r\u000b\u0001C^1mS\u0012\fG/\u001a'pOJ\u000bgnZ3\u0015\u0013\r\u000bY)!$\u0002\u0010\u0006M\u0005\"\u00021\u0016\u0001\u0004\t\u0007\"B7\u0016\u0001\u0004\u0019\u0005bBAI+\u0001\u0007\u0011qM\u0001\u000fY><7\u000b^1si>3gm]3u\u0011\u001d\t)*\u0006a\u0001\u0003O\nA\u0002\\8h\u000b:$wJ\u001a4tKR\fqbY1o'R\f'\u000f\u001e*fgR|'/\u001a\u000b\u0006\u0007\u0006m\u0015Q\u0014\u0005\u0006AZ\u0001\r!\u0019\u0005\u0006[Z\u0001\ra\u0011")
public class KafkaTopicPartitionRestoreManager {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final Logger logger;
    private int port;
    private final Seq<EndPoint> interalEndpoints;

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Logger logger() {
        return this.logger;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public Seq<EndPoint> interalEndpoints() {
        return this.interalEndpoints;
    }

    public int getLeader(String topic, int partition) {
        HostedPartition hostedPartition = this.replicaManager().getPartition(new TopicPartition(topic, partition));
        if (hostedPartition instanceof HostedPartition.Online) {
            Option<Object> option = ((HostedPartition.Online)hostedPartition).partition().leaderReplicaIdOpt();
            if (option instanceof Some) {
                return BoxesRunTime.unboxToInt((Object)((Some)option).value());
            }
            return KafkaRestoreRestApiReturnStatus.success;
        }
        return KafkaRestoreRestApiReturnStatus.invalid;
    }

    public TierPartitionStateResponse getTierPartitionStatus(String topic, int partition) {
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            TierPartitionStateResponse partitionStateResponse = new TierPartitionStateResponse(topic, partition, (long)log.tierPartitionState().status().ordinal(), log.tierPartitionState().status().name());
            this.logger().info(new StringBuilder(30).append("[").append(topic).append("-").append(partition).append("]: tier partition status as ").append(partitionStateResponse).toString());
            return partitionStateResponse;
        }
        return null;
    }

    public Optional<File> getFtpsFile(String topic, int partition) {
        Object object = new Object();
        try {
            this.kafkaConfig().logDirs().foreach((Function1 & Serializable)logDir -> {
                File dir = new File(new StringBuilder(3).append((String)logDir).append("/").append(topic).append("-").append(partition).append("/").toString());
                throw new NonLocalReturnControl(object, Optional.of(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)KafkaTopicPartitionRestoreManager.$anonfun$getFtpsFile$2(f)))))));
            });
            return Optional.empty();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Optional)ex.value();
            }
            throw ex;
        }
    }

    private TierRecordMetadataResponse injectEvent(AbstractTierMetadata event) {
        TierRecordMetadataResponse response = null;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(this.port()).toString());
        Some maybeProducer = new Some(RecoveryUtils.createTierTopicProducer(properties, "restore-rest-server"));
        String tierTopicName = "_confluent-tier-state";
        Short partitions = this.kafkaConfig().confluentConfig().tierMetadataNumPartitions();
        try {
            try {
                RecordMetadata recordMetadata = RecoveryUtils.injectTierTopicEvent((Producer<byte[], byte[]>)((Producer)maybeProducer.get()), event, tierTopicName, Predef$.MODULE$.Short2short(partitions));
                response = new TierRecordMetadataResponse(event.topicIdPartition().topicPartition().toString(), recordMetadata.timestamp(), recordMetadata.offset(), recordMetadata.partition());
            }
            catch (Exception e) {
                this.logger().error(new StringBuilder(23).append("Exception in injecting ").append(event).toString(), (Throwable)e);
            }
        }
        finally {
            maybeProducer.foreach((Function1 & Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
        return response;
    }

    public Option<AbstractLog> getLog(String topic, int partition) {
        return this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
    }

    public TierRecordMetadataResponse setFenceTierTopicPartition(String topic, int partition) {
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1 & Serializable)log -> {
            Option<TopicIdPartition> option = log.topicIdPartition();
            if (option instanceof Some) {
                TopicIdPartition topicId = (TopicIdPartition)((Some)option).value();
                return new Some((Object)new TierPartitionFence(topicId, UUID.randomUUID(), true));
            }
            return None$.MODULE$;
        });
        if (eventOpt instanceof Some) {
            TierPartitionFence event = (TierPartitionFence)((Some)eventOpt).value();
            return this.injectEvent(event);
        }
        return null;
    }

    public TierRecordMetadataResponse setForceRestoreTierPartition(String topic, int partition, long startOffset, long endOffset, String contentHash, byte checksumAlgorithm) {
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1 & Serializable)log -> {
            Option<TopicIdPartition> option = log.topicIdPartition();
            if (option instanceof Some) {
                TopicIdPartition topicId = (TopicIdPartition)((Some)option).value();
                return new Some((Object)new TierPartitionForceRestore(topicId, UUID.randomUUID(), startOffset, endOffset, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), contentHash, Predef$.MODULE$.boolean2Boolean(true), checksumAlgorithm));
            }
            return None$.MODULE$;
        });
        if (eventOpt instanceof Some) {
            TierPartitionForceRestore event = (TierPartitionForceRestore)((Some)eventOpt).value();
            return this.injectEvent(event);
        }
        return null;
    }

    public TierRecordMetadataResponse setUnfreezeLogStartOffset(String topic, int partition) {
        Option eventOpt = this.getLog(topic, partition).flatMap((Function1 & Serializable)log -> {
            Option<TopicIdPartition> option = log.topicIdPartition();
            if (option instanceof Some) {
                TopicIdPartition topicId = (TopicIdPartition)((Some)option).value();
                return new Some((Object)new TierPartitionUnfreezeLogStartOffset(topicId, UUID.randomUUID()));
            }
            return None$.MODULE$;
        });
        if (eventOpt instanceof Some) {
            TierPartitionUnfreezeLogStartOffset event = (TierPartitionUnfreezeLogStartOffset)((Some)eventOpt).value();
            return this.injectEvent(event);
        }
        return null;
    }

    public int validateLogRange(String topic, int partition, long logStartOffset, long logEndOffset) {
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(new TopicPartition(topic, partition), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            if (logStartOffset >= log.logStartOffset() && logEndOffset <= log.logEndOffset()) {
                return KafkaRestoreRestApiReturnStatus.success;
            }
            this.logger().warn(new StringBuilder(88).append("[").append(topic).append("-").append(partition).append("]: validate log range fail, log range to be validated (").append(logStartOffset).append(" - ").append(logEndOffset).append("), log range on broker (").append(log.logStartOffset()).append(" - ").append(log.logEndOffset()).append(")").toString());
            return KafkaRestoreRestApiReturnStatus.failure;
        }
        this.logger().warn(new StringBuilder(41).append("[").append(topic).append("-").append(partition).append("]: logManager doesn't contain log for ").append(topic).append("-").append(partition).toString());
        return KafkaRestoreRestApiReturnStatus.failure;
    }

    public int canStartRestore(String topic, int partition) {
        Option<AbstractLog> option = this.getLog(topic, partition);
        if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            if (log.tierPartitionState().fencedSegments().isEmpty()) {
                return KafkaRestoreRestApiReturnStatus.success;
            }
            this.logger().warn(new StringBuilder(30).append("[").append(topic).append("-").append(partition).append("]: contains ").append(log.tierPartitionState().fencedSegments().size()).append(" fenced segments").toString());
            return KafkaRestoreRestApiReturnStatus.failure;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().warn(new StringBuilder(41).append("[").append(topic).append("-").append(partition).append("]: logManager doesn't contain log for ").append(topic).append("-").append(partition).toString());
            return KafkaRestoreRestApiReturnStatus.invalid;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$interalEndpoints$1(EndPoint endpoint) {
        return endpoint.listenerName().value().equalsIgnoreCase("INTERNAL") || endpoint.listenerName().value().equalsIgnoreCase("REPLICATION");
    }

    public static final /* synthetic */ boolean $anonfun$getFtpsFile$2(File f) {
        return f.isFile() && MergedLog$.MODULE$.isTierStateFile(f);
    }

    public KafkaTopicPartitionRestoreManager(ReplicaManager replicaManager, KafkaConfig kafkaConfig) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.logger = LoggerFactory.getLogger((String)"KafkaTopicPartitionRestoreManager");
        this.port = ((EndPoint)kafkaConfig.listeners().last()).port();
        this.interalEndpoints = (Seq)kafkaConfig.listeners().filter((Function1 & Serializable)endpoint -> BoxesRunTime.boxToBoolean((boolean)KafkaTopicPartitionRestoreManager.$anonfun$interalEndpoints$1(endpoint)));
        if (this.interalEndpoints().size() > 0) {
            this.port_$eq(((EndPoint)this.interalEndpoints().apply(0)).port());
        }
    }
}

